/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.rinpn;

import com.rinearn.rinpn.Model;
import com.rinearn.rinpn.RINPnFatalException;
import com.rinearn.rinpn.View;
import com.rinearn.rinpn.util.MessageManager;
import com.rinearn.rinpn.util.SettingContainer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class Presenter {
    public final void link(View view, Model model, SettingContainer settingContainer) {
        WindowMouseListener windowMouseListener = new WindowMouseListener(view);
        view.frame.addMouseListener(windowMouseListener);
        view.frame.addMouseMotionListener(windowMouseListener);
        BasePanelMouseListener basePanelMouseListener = new BasePanelMouseListener(view, settingContainer);
        view.basePanel.addMouseListener(basePanelMouseListener);
        view.basePanel.addMouseMotionListener(basePanelMouseListener);
        view.inputField.addKeyListener(new InputFieldKeyListener(view, model, settingContainer));
        view.inputField.addMouseListener(new InputFieldMouseListener(view));
        view.outputField.addMouseListener(new OutputFieldMouseListener(view));
        view.runButton.addActionListener(new RunButtonListener(view, model, settingContainer));
        view.exitButton.addActionListener(new ExitButtonListener(view, model, settingContainer));
        KeyRetractorMouseListener keyRetractorMouseListener = new KeyRetractorMouseListener(view, settingContainer);
        view.keyRetractorLabel.addMouseListener(keyRetractorMouseListener);
        view.keyRetractorLabel.addMouseMotionListener(keyRetractorMouseListener);
        FunctionKeyActionListener functionKeyActionListener = new FunctionKeyActionListener(view);
        for (JButton object2 : view.functionKeyList) {
            object2.addActionListener(functionKeyActionListener);
        }
        NumberKeyActionListener numberKeyActionListener = new NumberKeyActionListener(view);
        for (JButton jButton : view.numberKeyList) {
            jButton.addActionListener(numberKeyActionListener);
        }
        BehaviorKeyActionListener behaviorKeyActionListener = new BehaviorKeyActionListener(view, model, settingContainer);
        for (JButton jButton : view.behaviorKeyList) {
            jButton.addActionListener(behaviorKeyActionListener);
        }
    }

    private static final class WindowMouseListener
    extends MouseAdapter {
        private View view = null;
        private int mousePressedX = -1;
        private int mousePressedY = -1;

        protected WindowMouseListener(View view) {
            this.view = view;
        }

        @Override
        public final void mousePressed(MouseEvent mouseEvent) {
            this.mousePressedX = mouseEvent.getX();
            this.mousePressedY = mouseEvent.getY();
        }

        @Override
        public final void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.mousePressedX;
            int n4 = n2 - this.mousePressedY;
            int n5 = this.view.frame.getLocation().x;
            int n6 = this.view.frame.getLocation().y;
            this.view.frame.setLocation(n5 + n3, n6 + n4);
        }
    }

    private static final class BasePanelMouseListener
    extends MouseAdapter {
        private View view = null;
        private SettingContainer settingContainer = null;
        private int pressedMouseAbsoluteX = -1;
        private int pressedMouseAbsoluteY = -1;
        int pressedWindowX = -1;
        int pressedWindowY = -1;
        int pressedWindowWidth = -1;
        int pressedWindowHeight = -1;
        WindowEdge pressedWindowEdge = WindowEdge.NONE;

        protected BasePanelMouseListener(View view, SettingContainer settingContainer) {
            this.view = view;
            this.settingContainer = settingContainer;
        }

        private WindowEdge detectWindowEdge(int n, int n2, int n3, int n4) {
            WindowEdge windowEdge = WindowEdge.NONE;
            int n5 = 5;
            if (0 <= n && n < n5 && n5 < n2 && n2 < n4 - n5) {
                windowEdge = WindowEdge.LEFT;
            }
            if (n3 - n5 < n && n <= n3 && n5 < n2 && n2 < n4 - n5) {
                windowEdge = WindowEdge.RIGHT;
            }
            if (n5 < n && n < n3 - n5 && 0 <= n2 && n2 < n5) {
                windowEdge = WindowEdge.TOP;
            }
            if (n5 < n && n < n3 - n5 && n4 - n5 < n2 && n2 <= n4) {
                windowEdge = WindowEdge.BOTTOM;
            }
            if (n <= n5 && n2 <= n5) {
                windowEdge = WindowEdge.TOP_LEFT;
            }
            if (n3 - n5 <= n && n2 <= n5) {
                windowEdge = WindowEdge.TOP_RIGHT;
            }
            if (n <= n5 && n4 - n5 <= n2) {
                windowEdge = WindowEdge.BOTTOM_LEFT;
            }
            if (n3 - n5 <= n && n4 - n5 <= n2) {
                windowEdge = WindowEdge.BOTTOM_RIGHT;
            }
            return windowEdge;
        }

        @Override
        public final void mousePressed(MouseEvent mouseEvent) {
            this.pressedMouseAbsoluteX = mouseEvent.getX() + this.view.frame.getLocation().x;
            this.pressedMouseAbsoluteY = mouseEvent.getY() + this.view.frame.getLocation().y;
            this.pressedWindowX = this.view.frame.getLocation().x;
            this.pressedWindowY = this.view.frame.getLocation().y;
            this.pressedWindowWidth = this.view.frame.getSize().width;
            this.pressedWindowHeight = this.view.frame.getSize().height;
            this.pressedWindowEdge = this.detectWindowEdge(mouseEvent.getX(), mouseEvent.getY(), this.pressedWindowWidth, this.pressedWindowHeight);
        }

        @Override
        public final void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.view.frame.getSize().width;
            int n4 = this.view.frame.getSize().height;
            WindowEdge windowEdge = this.detectWindowEdge(n, n2, n3, n4);
            switch (windowEdge.ordinal()) {
                case 0: {
                    this.view.basePanel.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 1: {
                    this.view.basePanel.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 3: {
                    this.view.basePanel.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 2: {
                    this.view.basePanel.setCursor(Cursor.getPredefinedCursor(10));
                    break;
                }
                case 4: {
                    this.view.basePanel.setCursor(Cursor.getPredefinedCursor(7));
                    break;
                }
                case 5: {
                    this.view.basePanel.setCursor(Cursor.getPredefinedCursor(6));
                    break;
                }
                case 6: {
                    this.view.basePanel.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                case 7: {
                    this.view.basePanel.setCursor(Cursor.getPredefinedCursor(4));
                    break;
                }
                case 8: {
                    this.view.basePanel.setCursor(Cursor.getDefaultCursor());
                    break;
                }
                default: {
                    throw new RINPnFatalException("Unexpected window edge: " + (Object)((Object)windowEdge));
                }
            }
        }

        @Override
        public final void mouseDragged(MouseEvent mouseEvent) {
            boolean bl;
            int n = mouseEvent.getX() + this.view.frame.getLocation().x;
            int n2 = mouseEvent.getY() + this.view.frame.getLocation().y;
            int n3 = n - this.pressedMouseAbsoluteX;
            int n4 = n2 - this.pressedMouseAbsoluteY;
            int n5 = this.pressedWindowX;
            int n6 = this.pressedWindowY;
            int n7 = this.pressedWindowWidth;
            int n8 = this.pressedWindowHeight;
            if (this.pressedWindowEdge == WindowEdge.TOP || this.pressedWindowEdge == WindowEdge.TOP_RIGHT || this.pressedWindowEdge == WindowEdge.TOP_LEFT) {
                n6 += n4;
                n8 -= n4;
            }
            if (this.pressedWindowEdge == WindowEdge.BOTTOM || this.pressedWindowEdge == WindowEdge.BOTTOM_RIGHT || this.pressedWindowEdge == WindowEdge.BOTTOM_LEFT) {
                n8 += n4;
            }
            if (this.pressedWindowEdge == WindowEdge.RIGHT || this.pressedWindowEdge == WindowEdge.TOP_RIGHT || this.pressedWindowEdge == WindowEdge.BOTTOM_RIGHT) {
                n7 += n3;
            }
            if (this.pressedWindowEdge == WindowEdge.LEFT || this.pressedWindowEdge == WindowEdge.TOP_LEFT || this.pressedWindowEdge == WindowEdge.BOTTOM_LEFT) {
                n5 += n3;
                n7 -= n3;
            }
            if (this.pressedWindowEdge == WindowEdge.NONE) {
                n5 = this.pressedWindowX + n3;
                n6 = this.pressedWindowY + n4;
            }
            if (n8 < this.settingContainer.retractedWindowHeight) {
                n8 = this.settingContainer.retractedWindowHeight;
            }
            if (n7 < 200) {
                n7 = 200;
            }
            this.view.frame.setBounds(n5, n6, n7, n8);
            try {
                this.view.resizePanels(this.settingContainer);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
            boolean bl2 = bl = this.view.frame.getSize().height == this.settingContainer.retractedWindowHeight;
            if (bl) {
                this.view.keyRetractorLabel.setText("\u25bcKEY-PANEL");
            } else {
                this.view.keyRetractorLabel.setText("\u25b2KEY-PANEL");
            }
        }

        private static enum WindowEdge {
            TOP,
            BOTTOM,
            LEFT,
            RIGHT,
            TOP_RIGHT,
            TOP_LEFT,
            BOTTOM_RIGHT,
            BOTTOM_LEFT,
            NONE;

        }
    }

    private static final class InputFieldKeyListener
    extends KeyAdapter {
        private Model model;
        private View view;
        private SettingContainer settingContainer;

        protected InputFieldKeyListener(View view, Model model, SettingContainer settingContainer) {
            this.model = model;
            this.view = view;
            this.settingContainer = settingContainer;
        }

        @Override
        public final void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                RunButtonListener.handleEvent(this.view, this.model, this.settingContainer);
            }
            if (n == 27) {
                this.view.inputField.setText("");
            }
        }
    }

    private static final class InputFieldMouseListener
    extends MouseAdapter {
        private View view = null;

        protected InputFieldMouseListener(View view) {
            this.view = view;
        }

        @Override
        public final void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.view.textFieldPopupMenu.show(this.view.inputField, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private static final class OutputFieldMouseListener
    extends MouseAdapter {
        private View view = null;

        protected OutputFieldMouseListener(View view) {
            this.view = view;
        }

        @Override
        public final void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.view.textFieldPopupMenu.show(this.view.outputField, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private static final class RunButtonListener
    implements ActionListener {
        private Model model = null;
        private View view = null;
        private SettingContainer settingContainer = null;

        protected RunButtonListener(View view, Model model, SettingContainer settingContainer) {
            this.model = model;
            this.view = view;
            this.settingContainer = settingContainer;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            RunButtonListener.handleEvent(this.view, this.model, this.settingContainer);
        }

        protected static void handleEvent(final View view, Model model, SettingContainer settingContainer) {
            view.outputField.setText("RUNNING...");
            Model.AsyncCalculationListener asyncCalculationListener = new Model.AsyncCalculationListener(){

                @Override
                public void calculationFinished(String string) {
                    SwingUtilities.invokeLater(new OutputFieldUpdater(view, string));
                }
            };
            model.calculateAsynchronously(view.inputField.getText(), asyncCalculationListener, settingContainer);
        }
    }

    private static final class ExitButtonListener
    implements ActionListener {
        private Model model = null;
        private View view = null;
        private SettingContainer settingContainer = null;

        protected ExitButtonListener(View view, Model model, SettingContainer settingContainer) {
            this.model = model;
            this.view = view;
            this.settingContainer = settingContainer;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            if (this.model.isCalculating()) {
                int n;
                String string = "";
                if (this.settingContainer.localeCode.equals("ja-jp")) {
                    string = "\u8a08\u7b97\u51e6\u7406\u3092\u5b9f\u884c\u4e2d\u3067\u3059\u304c\u3001\u3053\u306e\u30bd\u30d5\u30c8\u3092\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3059\u304b ?";
                }
                if (this.settingContainer.localeCode.equals("en-us")) {
                    string = "The calculation is running. Do you want to force-quit this software ?";
                }
                if ((n = JOptionPane.showConfirmDialog(null, string, "!", 0, 3)) == 0) {
                    System.exit(0);
                } else {
                    return;
                }
            }
            try {
                this.view.dispose();
            }
            catch (InterruptedException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
            this.model.shutdown(this.settingContainer);
        }
    }

    private static final class KeyRetractorMouseListener
    extends MouseAdapter {
        private View view = null;
        private SettingContainer settingContainer = null;
        private int windowHeightBeforeRetracted = -1;

        protected KeyRetractorMouseListener(View view, SettingContainer settingContainer) {
            this.view = view;
            this.settingContainer = settingContainer;
            this.windowHeightBeforeRetracted = this.settingContainer.windowHeight;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.view.keyRetractorLabel.setForeground(Color.RED);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Color color = new Color(this.settingContainer.keyRetractorForegroundColorR, this.settingContainer.keyRetractorForegroundColorG, this.settingContainer.keyRetractorForegroundColorB);
            this.view.keyRetractorLabel.setForeground(color);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2 = bl = this.view.frame.getSize().height == this.settingContainer.retractedWindowHeight;
            if (bl) {
                this.view.frame.setBounds(this.view.frame.getLocation().x, this.view.frame.getLocation().y, this.view.frame.getSize().width, this.windowHeightBeforeRetracted);
                this.view.keyRetractorLabel.setText("\u25b2KEY-PANEL");
            } else {
                this.windowHeightBeforeRetracted = this.view.frame.getSize().height;
                this.view.frame.setBounds(this.view.frame.getLocation().x, this.view.frame.getLocation().y, this.view.frame.getSize().width, this.settingContainer.retractedWindowHeight);
                this.view.keyRetractorLabel.setText("\u25bcKEY-PANEL");
            }
            try {
                this.view.resizePanels(this.settingContainer);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
    }

    private static final class FunctionKeyActionListener
    implements ActionListener {
        private View view = null;

        protected FunctionKeyActionListener(View view) {
            this.view = view;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)JButton.class.cast(actionEvent.getSource());
            String string = jButton.getText();
            String string2 = null;
            switch (string) {
                case "_": {
                    string2 = " ";
                    break;
                }
                case "(": 
                case ")": 
                case "PI": {
                    string2 = string;
                    break;
                }
                default: {
                    string2 = string + "(";
                }
            }
            int n = this.view.inputField.getCaretPosition();
            StringBuilder stringBuilder = new StringBuilder(this.view.inputField.getText());
            stringBuilder.insert(n, string2);
            this.view.inputField.setText(stringBuilder.toString());
            this.view.inputField.setCaretPosition(n + string2.length());
            this.view.inputField.requestFocus(true);
        }
    }

    private static final class NumberKeyActionListener
    implements ActionListener {
        private View view = null;

        protected NumberKeyActionListener(View view) {
            this.view = view;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)JButton.class.cast(actionEvent.getSource());
            int n = this.view.inputField.getCaretPosition();
            StringBuilder stringBuilder = new StringBuilder(this.view.inputField.getText());
            stringBuilder.insert(n, jButton.getText());
            this.view.inputField.setText(stringBuilder.toString());
            this.view.inputField.setCaretPosition(n + jButton.getText().length());
            this.view.inputField.requestFocus(true);
        }
    }

    private static final class BehaviorKeyActionListener
    implements ActionListener {
        private View view = null;
        private Model model = null;
        private SettingContainer settingContainer = null;

        protected BehaviorKeyActionListener(View view, Model model, SettingContainer settingContainer) {
            this.model = model;
            this.view = view;
            this.settingContainer = settingContainer;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            String string;
            JButton jButton = (JButton)JButton.class.cast(actionEvent.getSource());
            switch (string = jButton.getText()) {
                case "=": {
                    RunButtonListener.handleEvent(this.view, this.model, this.settingContainer);
                    break;
                }
                case "C": {
                    this.view.inputField.setText("");
                    break;
                }
                case "BS": {
                    String string2 = this.view.inputField.getText();
                    int n = this.view.inputField.getCaretPosition();
                    if (1 > n) break;
                    this.view.inputField.setText(string2.substring(0, n - 1) + string2.substring(n, string2.length()));
                    this.view.inputField.setCaretPosition(n - 1);
                    this.view.inputField.requestFocus(true);
                    break;
                }
                case "Script": {
                    JFileChooser jFileChooser = new JFileChooser(".");
                    FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Vnano Script File", "vnano");
                    jFileChooser.setFileFilter(fileNameExtensionFilter);
                    jFileChooser.showOpenDialog(this.view.frame);
                    File file = jFileChooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    if (!file.getName().endsWith(".vnano") || file.isDirectory()) {
                        String string3 = this.settingContainer.localeCode.equals("ja-jp") ? "\u9078\u629e\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u306f\u3001Vnano \u306e\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" : "The selected file is not a Vnano script file.";
                        MessageManager.showErrorMessage(string3, "!", this.settingContainer.localeCode, this.settingContainer.alwaysPrintError);
                        return;
                    }
                    this.view.inputField.setText(file.getPath());
                    RunButtonListener.handleEvent(this.view, this.model, this.settingContainer);
                    break;
                }
                default: {
                    throw new RINPnFatalException("Unexpected behavior key: " + string);
                }
            }
            this.view.inputField.requestFocus(true);
        }
    }

    public static final class OutputFieldUpdater
    implements Runnable {
        private View view = null;
        private String outputText = null;

        protected OutputFieldUpdater(View view, String string) {
            this.view = view;
            this.outputText = string;
        }

        @Override
        public final void run() {
            this.view.outputField.setText(this.outputText);
        }
    }
}

