/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class IfElseStatementCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testIfStatements();
            this.testIfElseStatements();
            this.testElseIfStatements();
            this.testMultipleIfStatements();
            this.testMultipleIfElseStatements();
            this.testMultipleElseIfStatements();
            this.testDeepBlockDepthCases();
            this.testVeryComplicatedCases();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testIfStatements() throws VnanoException {
        String string = " int a = 1;   \n if (true) {  \n     a = 2;   \n }            \n a;           \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "if(true){...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 1L, "if(false){...}", string);
    }

    private void testIfElseStatements() throws VnanoException {
        String string = " int a = 1;  \n if (true) { \n     a = 2;  \n } else {    \n     a = 3;  \n }           \n a;          \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "if(true){...} else{...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n } else {     \n     a = 3;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "if(false){...} else{...}", string);
    }

    private void testElseIfStatements() throws VnanoException {
        String string = " int a = 1;          \n if (true) {         \n     a = 2;          \n } else if (false) { \n     a = 3;          \n }                   \n a;                  \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "if(true){...} else if(false){...}", string);
        string = " int a = 1;          \n if (false) {        \n     a = 2;          \n } else if (false) { \n     a = 3;          \n }                   \n a;                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 1L, "if(false){...} else if(false){...}", string);
        string = " int a = 1;          \n if (false) {        \n     a = 2;          \n } else if (true) {  \n     a = 3;          \n }                   \n a;                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "if(false){...} else if(true){...}", string);
    }

    private void testMultipleIfStatements() throws VnanoException {
        String string = " int a = 1;   \n if (false) { \n     a = 2;   \n }            \n if (false) { \n     a = 3;   \n }            \n if (false) { \n     a = 4;   \n }            \n if (false) { \n     a = 5;   \n }            \n a;           \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 1L, "if(false){...} if(false){...} if(false){...} if(false){...}", string);
        string = " int a = 1;   \n if (true)  { \n     a = 2;   \n }            \n if (false) { \n     a = 3;   \n }            \n if (false) { \n     a = 4;   \n }            \n if (false) { \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "if(true){...} if(false){...} if(false){...} if(false){...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n }            \n if (true)  { \n     a = 3;   \n }            \n if (false) { \n     a = 4;   \n }            \n if (false) { \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "if(false){...} if(true){...} if(false){...} if(false){...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n }            \n if (false) { \n     a = 3;   \n }            \n if (true)  { \n     a = 4;   \n }            \n if (false) { \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 4L, "if(false){...} if(false){...} if(true){...} if(false){...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n }            \n if (false) { \n     a = 3;   \n }            \n if (false) { \n     a = 4;   \n }            \n if (true) {  \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "if(false){...} if(false){...} if(false){...} if(true){...}", string);
        string = " int a = 1;   \n if (true) {  \n     a = 2;   \n }            \n if (false) { \n     a = 3;   \n }            \n if (true) {  \n     a = 4;   \n }            \n if (false) { \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 4L, "if(true){...} if(false){...} if(true){...} if(false){...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n }            \n if (true) {  \n     a = 3;   \n }            \n if (true) {  \n     a = 4;   \n }            \n if (false) { \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 4L, "if(false){...} if(true){...} if(true){...} if(false){...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n }            \n if (false) { \n     a = 3;   \n }            \n if (true) {  \n     a = 4;   \n }            \n if (true) {  \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "if(false){...} if(false){...} if(true){...} if(true){...}", string);
        string = " int a = 1;   \n if (true) {  \n     a = 2;   \n }            \n if (false) { \n     a = 3;   \n }            \n if (false) { \n     a = 4;   \n }            \n if (true) {  \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "if(true){...} if(false){...} if(false){...} if(true){...}", string);
        string = " int a = 1;   \n if (true) {  \n     a = 2;   \n }            \n if (true) {  \n     a = 3;   \n }            \n if (true) {  \n     a = 4;   \n }            \n if (true) {  \n     a = 5;   \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "if(true){...} if(true){...} if(true){...} if(true){...}", string);
    }

    private void testMultipleIfElseStatements() throws VnanoException {
        String string = " int a = 1;   \n if (false) { \n     a = 2;   \n } else {     \n     a = 3;   \n }            \n if (false) { \n     a = 4;   \n } else {     \n     a = 5;   \n }            \n if (false) { \n     a = 6;   \n } else {     \n     a = 7;   \n }            \n if (false) { \n     a = 8;   \n } else {     \n     a = 9;   \n }            \n if (false) { \n     a = 10;  \n } else {     \n     a = 11;  \n }            \n a;           \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 11L, "if(false){...} else{...} if(false){...} else{...} if(false){...} else{...} if(false){...} else{...} if(false){...} else{...}", string);
        string = " int a = 1;   \n if (true) {  \n     a = 2;   \n } else {     \n     a = 3;   \n }            \n if (false) { \n     a = 4;   \n } else {     \n     a = 5;   \n }            \n if (false) { \n     a = 6;   \n } else {     \n     a = 7;   \n }            \n if (false) { \n     a = 8;   \n } else {     \n     a = 9;   \n }            \n if (false) { \n     a = 10;  \n } else {     \n     a = 11;  \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 11L, "if(true){...} else{...} if(false){...} else{...} if(false){...} else{...} if(false){...} else{...} if(false){...} else{...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n } else {     \n     a = 3;   \n }            \n if (true) {  \n     a = 4;   \n } else {     \n     a = 5;   \n }            \n if (false) { \n     a = 6;   \n } else {     \n     a = 7;   \n }            \n if (false) { \n     a = 8;   \n } else {     \n     a = 9;   \n }            \n if (true) {  \n     a = 10;  \n } else {     \n     a = 11;  \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "if(false){...} else{...} if(true){...} else{...} if(false){...} else{...} if(false){...} else{...} if(false){...} else{...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n } else {     \n     a = 3;   \n }            \n if (true) {  \n     a = 4;   \n } else {     \n     a = 5;   \n }            \n if (false) { \n     a = 6;   \n } else {     \n     a = 7;   \n }            \n if (false) { \n     a = 8;   \n } else {     \n     a = 9;   \n }            \n if (true) {  \n     a = 10;  \n } else {     \n     a = 11;  \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "if(false){...} else{...} if(true){...} else{...} if(false){...} else{...} if(false){...} else{...} if(true){...} else{...}", string);
        string = " int a = 1;   \n if (false) { \n     a = 2;   \n } else {     \n     a = 3;   \n }            \n if (false) { \n     a = 4;   \n } else {     \n     a = 5;   \n }            \n if (false) { \n     a = 6;   \n } else {     \n     a = 7;   \n }            \n if (false) { \n     a = 8;   \n } else {     \n     a = 9;   \n }            \n if (true) {  \n     a = 10;  \n } else {     \n     a = 11;  \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "if(false){...} else{...} if(false){...} else{...} if(false){...} else{...} if(false){...} else{...} if(true){...} else{...}", string);
        string = " int a = 1;   \n if (true) {  \n     a = 2;   \n } else {     \n     a = 3;   \n }            \n if (true) {  \n     a = 4;   \n } else {     \n     a = 5;   \n }            \n if (true) {  \n     a = 6;   \n } else {     \n     a = 7;   \n }            \n if (true) {  \n     a = 8;   \n } else {     \n     a = 9;   \n }            \n if (true) {  \n     a = 10;  \n } else {     \n     a = 11;  \n }            \n a;           \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "if(false){...} else{...} if(false){...} else{...} if(false){...} else{...} if(false){...} else{...} if(false){...} else{...}", string);
    }

    private void testMultipleElseIfStatements() throws VnanoException {
        String string = " int a = 1;          \n if (false) {        \n     a = 2;          \n } else if (false) { \n     a = 3;          \n } else if (false) { \n     a = 4;          \n } else if (true)  { \n     a = 5;          \n } else if (false) { \n     a = 6;          \n } else if (false) { \n     a = 7;          \n } else if (false) { \n     a = 8;          \n } else if (false) { \n     a = 9;          \n } else {            \n     a = 10;         \n }                   \n a;                  \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "if(false){...} else if(false){...} x2 else if(true){...} else if(false){...} x4 else{...}", string);
        string = " int a = 1;          \n if (false) {        \n     a = 2;          \n } else if (false) { \n     a = 3;          \n } else if (false) { \n     a = 4;          \n } else if (true)  { \n     a = 5;          \n } else if (false) { \n     a = 6;          \n } else if (false) { \n     a = 7;          \n } else if (true) {  \n     a = 8;          \n } else if (false) { \n     a = 9;          \n } else {            \n     a = 10;         \n }                   \n a;                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "if(false){...} else if(false){...} x2 else if(true){...} else if(false){...} x2 else if(true){...} else if(false){...} else{...}", string);
        string = " int a = 1;          \n if (false) {        \n     a = 2;          \n } else if (false) { \n     a = 3;          \n } else if (false) { \n     a = 4;          \n } else if (false) { \n     a = 5;          \n } else if (false) { \n     a = 6;          \n } else if (false) { \n     a = 7;          \n } else if (true) {  \n     a = 8;          \n } else if (false) { \n     a = 9;          \n } else {            \n     a = 10;         \n }                   \n a;                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 8L, "if(false){...} else if(false){...} x5 if(true){...} else if(false){...} else{...}", string);
        string = " int a = 1;          \n if (false) {        \n     a = 2;          \n } else if (false) { \n     a = 3;          \n } else if (false) { \n     a = 4;          \n } else if (false) { \n     a = 5;          \n } else if (false) { \n     a = 6;          \n } else if (false) { \n     a = 7;          \n } else if (false) { \n     a = 8;          \n } else if (false) { \n     a = 9;          \n } else {            \n     a = 10;         \n }                   \n a;                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "if(false){...} else if(false){...} x7 else{...}", string);
    }

    private void testDeepBlockDepthCases() throws VnanoException {
        String string = " int a = 1;       \n if (false) {     \n     a = 2;       \n     if (false) { \n         a = 3;   \n     }            \n }                \n a;               \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 1L, "if(false){... if(false) {...} }", string);
        string = " int a = 1;       \n if (true) {      \n     a = 2;       \n     if (true) {  \n         a = 3;   \n     }            \n }                \n a;               \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "if(true){... if(true) {...} }", string);
        string = " int a = 1;       \n if (true) {      \n     a = 2;       \n     if (false) { \n         a = 3;   \n     }            \n }                \n a;               \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "if(true){... if(true) {...} }", string);
        string = " int a = 1;       \n if (false) {     \n     a = 2;       \n     if (true) {  \n         a = 3;   \n     }            \n }                \n a;               \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 1L, "if(false){... if(true) {...} }", string);
        string = " int a = 1;       \n if (true) {      \n     a = 2;       \n     if (false) { \n         a = 3;   \n     } else {     \n         a = 4;   \n     }            \n }                \n a;               \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 4L, "if(true){... if(false) {...} else {...} }", string);
        string = " int a = 1;       \n if (true) {      \n     a = 2;       \n     if (true)  { \n         a = 3;   \n     } else {     \n         a = 4;   \n     }            \n }                \n a;               \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "if(true){... if(true) {...} else {...} }", string);
        string = " int a = 1;       \n if (true) {      \n     a = 2;       \n     if (true)  { \n         a = 3;   \n     } else {     \n         a = 4;   \n     }            \n } else {         \n     a = 5;       \n }                \n a;               \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "if(true){... if(true) {...} else {...} } else {...}", string);
        string = " int a = 1;       \n if (false) {     \n     a = 2;       \n     if (true)  { \n         a = 3;   \n     } else {     \n         a = 4;   \n     }            \n } else {         \n     a = 5;       \n }                \n a;               \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "if(false){... if(true) {...} else {...} } else {...}", string);
        string = " int a = 1;               \n if (true) {              \n     a = 2;               \n     if (true)  {         \n         a = 3;           \n         if (true)  {     \n             a = 4;       \n             if (true)  { \n                 a = 5;   \n             }            \n         }                \n     } else {             \n         a = 6;           \n     }                    \n } else {                 \n     a = 7;               \n }                        \n a;                       \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "if(true){... if(true){... if(true){... if(false){...} } } else{...} } else{...}", string);
        string = " int a = 1;               \n if (true) {              \n     a = 2;               \n     if (true)  {         \n         a = 3;           \n         if (true)  {     \n             a = 4;       \n             if (false) { \n                 a = 5;   \n             }            \n         }                \n     } else {             \n         a = 6;           \n     }                    \n } else {                 \n     a = 7;               \n }                        \n a;                       \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 4L, "if(true){... if(false){... if(true){... if(false){...} } } else{...} } else{...}", string);
        string = " int a = 1;               \n if (true) {              \n     a = 2;               \n     if (false)  {        \n         a = 3;           \n         if (true)  {     \n             a = 4;       \n             if (false) { \n                 a = 5;   \n             }            \n         }                \n     } else {             \n         a = 6;           \n     }                    \n } else {                 \n     a = 7;               \n }                        \n a;                       \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 6L, "if(true){... if(false){... if(true){... if(false){...} } } else{...} } else{...}", string);
        string = " int a = 1;               \n if (false) {             \n     a = 2;               \n     if (false)  {        \n         a = 3;           \n         if (true)  {     \n             a = 4;       \n             if (false) { \n                 a = 5;   \n             }            \n         }                \n     } else {             \n         a = 6;           \n     }                    \n } else {                 \n     a = 7;               \n }                        \n a;                       \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 7L, "if(false){... if(false){... if(true){... if(false){...} } } else{...} } else{...}", string);
    }

    private void testVeryComplicatedCases() throws VnanoException {
        String string = " int a = 1;              \n if (false) {            \n     a = 2;              \n     if (true)  {        \n         a = 3;          \n     } else {            \n         a = 4;          \n     }                   \n } else if (true) {      \n     a = 5;              \n     if (false)  {       \n         a = 6;          \n     } else if (false) { \n         a = 7;          \n     } else if (false) { \n         a = 8;          \n     } else if (true) {  \n         a = 9;          \n         if (false) {    \n             a = 10;     \n         } else {        \n             a = 11;     \n         }               \n     } else if (false) { \n         a = 10;         \n     } else {            \n         a = 7;          \n     }                   \n } else {                \n     a = 5;              \n }                       \n a;                      \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 11L, "very complicated case 1", string);
        string = " int a = 1;                          \n if (false) {                        \n     a = 2;                          \n     if (true)  {                    \n         a = 3;                      \n     } else {                        \n         a = 4;                      \n     }                               \n } else if (true) {                  \n     a = 5;                          \n     if (false)  {                   \n         a = 6;                      \n     } else if (false) {             \n         a = 7;                      \n     } else if (false) {             \n         a = 8;                      \n     } else if (true) {              \n         a = 9;                      \n         if (false) {                \n             a = 10;                 \n         } else {                    \n             if (false) {            \n                 a = 11;             \n             } else {                \n                 if(true) {          \n                    a = 12;          \n                 } else if (false) { \n                    a = 13;          \n                 } else if (false) { \n                    a = 14;          \n                 } else {            \n                    a = 15;          \n                 }                   \n             }                       \n         }                           \n     } else if (false) {             \n         a = 16;                     \n     } else {                        \n         a = 17;                     \n     }                               \n } else {                            \n     a = 18;                         \n }                                   \n a;                                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 12L, "very complicated case 2", string);
        string = " int a = 1;                          \n if (false) {                        \n     a = 2;                          \n     if (true)  {                    \n         a = 3;                      \n     } else {                        \n         a = 4;                      \n     }                               \n } else if (true) {                  \n     a = 5;                          \n     if (false)  {                   \n         a = 6;                      \n     } else if (false) {             \n         a = 7;                      \n     } else if (false) {             \n         a = 8;                      \n     } else if (false) {             \n         a = 9;                      \n         if (false) {                \n             a = 10;                 \n         } else {                    \n             if (false) {            \n                 a = 11;             \n             } else {                \n                 if(true) {          \n                    a = 12;          \n                 } else if (false) { \n                    a = 13;          \n                 } else if (false) { \n                    a = 14;          \n                 } else {            \n                    a = 15;          \n                 }                   \n             }                       \n         }                           \n     } else if (true) {              \n         a = 16;                     \n     } else {                        \n         a = 17;                     \n     }                               \n } else {                            \n     a = 18;                         \n }                                   \n a;                                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 16L, "very complicated case 3", string);
        string = " int a = 1;                          \n if (false) {                        \n     a = 2;                          \n     if (true)  {                    \n         a = 3;                      \n     } else {                        \n         a = 4;                      \n     }                               \n } else if (true) {                  \n     a = 5;                          \n     if (false)  {                   \n         a = 6;                      \n     } else if (false) {             \n         a = 7;                      \n     } else if (false) {             \n         a = 8;                      \n     } else if (false) {             \n         a = 9;                      \n         if (false) {                \n             a = 10;                 \n         } else {                    \n             if (false) {            \n                 a = 11;             \n             } else {                \n                 if(true) {          \n                    a = 12;          \n                 } else if (false) { \n                    a = 13;          \n                 } else if (false) { \n                    a = 14;          \n                 } else {            \n                    a = 15;          \n                 }                   \n             }                       \n         }                           \n     } else if (false) {             \n         a = 16;                     \n     } else {                        \n         a = 17;                     \n     }                               \n } else {                            \n     a = 18;                         \n }                                   \n a;                                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 17L, "very complicated case 4", string);
        string = " int a = 1;                          \n if (true) {                         \n     a = 2;                          \n     if (true)  {                    \n         a = 3;                      \n     } else {                        \n         a = 4;                      \n     }                               \n } else if (true) {                  \n     a = 5;                          \n     if (false)  {                   \n         a = 6;                      \n     } else if (false) {             \n         a = 7;                      \n     } else if (false) {             \n         a = 8;                      \n     } else if (false) {             \n         a = 9;                      \n         if (false) {                \n             a = 10;                 \n         } else {                    \n             if (false) {            \n                 a = 11;             \n             } else {                \n                 if(true) {          \n                    a = 12;          \n                 } else if (false) { \n                    a = 13;          \n                 } else if (false) { \n                    a = 14;          \n                 } else {            \n                    a = 15;          \n                 }                   \n             }                       \n         }                           \n     } else if (true) {              \n         a = 16;                     \n     } else {                        \n         a = 17;                     \n     }                               \n } else {                            \n     a = 18;                         \n }                                   \n a;                                  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "very complicated case 5", string);
    }
}

