/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.vcssl.nano.compiler.AttributeKey;

public class Token
implements Cloneable {
    private String value;
    private Type type;
    private int precedence;
    private int lineNumber;
    private String fileName;
    private Map<AttributeKey, String> attributeMap;

    public Token(String string, int n, String string2) {
        this.value = string;
        this.type = null;
        this.precedence = 0;
        this.lineNumber = n;
        this.fileName = string2;
        this.attributeMap = new LinkedHashMap<AttributeKey, String>();
    }

    public Token clone() {
        Token token = new Token(this.value, this.lineNumber, this.fileName);
        token.type = this.type;
        token.precedence = this.precedence;
        token.attributeMap = (Map)((LinkedHashMap)this.attributeMap).clone();
        return token;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setAttribute(AttributeKey attributeKey, String string) {
        if (this.attributeMap.containsKey((Object)attributeKey)) {
            this.attributeMap.remove((Object)attributeKey);
        }
        this.attributeMap.put(attributeKey, string);
    }

    public String getAttribute(AttributeKey attributeKey) {
        return this.attributeMap.get((Object)attributeKey);
    }

    public boolean hasAttribute(AttributeKey attributeKey) {
        return this.attributeMap.containsKey((Object)attributeKey);
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public static int getIndexOf(Token[] tokenArray, String string, int n) {
        int n2 = tokenArray.length;
        for (int i = n; i < n2; ++i) {
            if (!tokenArray[i].getValue().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Token word=\"" + this.value + "\", lineNumber=" + this.lineNumber + ", fileName=\"" + this.fileName + "\", type=" + (Object)((Object)this.type) + ", precedence=" + this.precedence);
        Set<Map.Entry<AttributeKey, String>> set = this.attributeMap.entrySet();
        for (Map.Entry<AttributeKey, String> entry : set) {
            stringBuilder.append(", " + (Object)((Object)entry.getKey()) + "=\"" + entry.getValue() + "\"");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static enum Type {
        DATA_TYPE,
        LEAF,
        PARENTHESIS,
        BLOCK,
        CONTROL,
        END_OF_STATEMENT,
        OPERATOR,
        DEPENDENCY_DECLARATOR,
        MODIFIER;

    }
}

