/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.AbstractVariable;
import org.vcssl.nano.interconnect.IdentifierMapManager;
import org.vcssl.nano.spec.IdentifierSyntax;

public class VariableTable
implements Cloneable {
    LinkedList<AbstractVariable> variableList = new LinkedList();
    Map<String, LinkedList<AbstractVariable>> nameVariableMap = new LinkedHashMap<String, LinkedList<AbstractVariable>>();
    Map<String, LinkedList<AbstractVariable>> fullNameVariableMap = new LinkedHashMap<String, LinkedList<AbstractVariable>>();
    Map<String, LinkedList<AbstractVariable>> assemblyIdentifierVariableMap = new LinkedHashMap<String, LinkedList<AbstractVariable>>();
    Map<String, LinkedList<AbstractVariable>> fullAssemblyIdentifierVariableMap = new LinkedHashMap<String, LinkedList<AbstractVariable>>();
    Map<Integer, AbstractVariable> indexVariableMap = new LinkedHashMap<Integer, AbstractVariable>();
    Map<String, LinkedList<Integer>> assemblyIdentifierIndexMap = new LinkedHashMap<String, LinkedList<Integer>>();
    Map<String, LinkedList<Integer>> fullAssemblyIdentifierIndexMap = new LinkedHashMap<String, LinkedList<Integer>>();
    int size = 0;

    public void addVariable(AbstractVariable abstractVariable) {
        int n = this.size++;
        String string = abstractVariable.hasNamespaceName() ? abstractVariable.getNamespaceName() + "." : "";
        String string2 = abstractVariable.getVariableName();
        String string3 = IdentifierSyntax.getAssemblyIdentifierOf(abstractVariable);
        String string4 = IdentifierSyntax.getAssemblyIdentifierOf(abstractVariable, string);
        this.variableList.add(abstractVariable);
        IdentifierMapManager.putToMap(this.nameVariableMap, string2, abstractVariable);
        IdentifierMapManager.putToMap(this.fullNameVariableMap, string + string2, abstractVariable);
        IdentifierMapManager.putToMap(this.assemblyIdentifierVariableMap, string3, abstractVariable);
        IdentifierMapManager.putToMap(this.fullAssemblyIdentifierVariableMap, string4, abstractVariable);
        this.indexVariableMap.put(n, abstractVariable);
        IdentifierMapManager.putToMap(this.assemblyIdentifierIndexMap, string3, n);
        IdentifierMapManager.putToMap(this.fullAssemblyIdentifierIndexMap, string4, n);
    }

    public void removeLastVariable() {
        --this.size;
        int n = this.size;
        AbstractVariable abstractVariable = this.variableList.getLast();
        String string = abstractVariable.hasNamespaceName() ? abstractVariable.getNamespaceName() + "." : "";
        String string2 = abstractVariable.getVariableName();
        String string3 = IdentifierSyntax.getAssemblyIdentifierOf(abstractVariable);
        String string4 = IdentifierSyntax.getAssemblyIdentifierOf(abstractVariable, string);
        this.variableList.removeLast();
        IdentifierMapManager.removeLastFromMap(this.nameVariableMap, string2);
        IdentifierMapManager.removeLastFromMap(this.fullNameVariableMap, string + string2);
        IdentifierMapManager.removeLastFromMap(this.assemblyIdentifierVariableMap, string3);
        IdentifierMapManager.removeLastFromMap(this.fullAssemblyIdentifierVariableMap, string4);
        this.indexVariableMap.remove(n, abstractVariable);
        IdentifierMapManager.removeLastFromMap(this.assemblyIdentifierIndexMap, string3);
        IdentifierMapManager.removeLastFromMap(this.fullAssemblyIdentifierIndexMap, string4);
    }

    public AbstractVariable[] getVariables() {
        ArrayList arrayList = new ArrayList();
        Set<Map.Entry<String, LinkedList<AbstractVariable>>> set = this.nameVariableMap.entrySet();
        for (Map.Entry<String, LinkedList<AbstractVariable>> entry : set) {
            arrayList.addAll(entry.getValue());
        }
        return arrayList.toArray(new AbstractVariable[0]);
    }

    public boolean containsVariableWithName(String string) {
        return this.nameVariableMap.containsKey(string) || this.fullNameVariableMap.containsKey(string);
    }

    public AbstractVariable getVariableByName(String string) {
        if (this.nameVariableMap.containsKey(string)) {
            return IdentifierMapManager.getLastFromMap(this.nameVariableMap, string);
        }
        if (this.fullNameVariableMap.containsKey(string)) {
            return IdentifierMapManager.getLastFromMap(this.fullNameVariableMap, string);
        }
        throw new VnanoFatalException("Variable not found: " + string);
    }

    public boolean containsVariableWithAssemblyIdentifier(String string) {
        return this.assemblyIdentifierVariableMap.containsKey(string) || this.fullAssemblyIdentifierVariableMap.containsKey(string);
    }

    public AbstractVariable getVariableByAssemblyIdentifier(String string) {
        if (this.assemblyIdentifierVariableMap.containsKey(string)) {
            return IdentifierMapManager.getLastFromMap(this.assemblyIdentifierVariableMap, string);
        }
        if (this.fullAssemblyIdentifierVariableMap.containsKey(string)) {
            return IdentifierMapManager.getLastFromMap(this.fullAssemblyIdentifierVariableMap, string);
        }
        throw new VnanoFatalException("Variable not found: " + string);
    }

    public AbstractVariable getVariableByIndex(int n) {
        return this.indexVariableMap.get(n);
    }

    public int getIndexOf(AbstractVariable abstractVariable) {
        String string = abstractVariable.hasNamespaceName() ? abstractVariable.getNamespaceName() + "." : "";
        String string2 = IdentifierSyntax.getAssemblyIdentifierOf(abstractVariable);
        String string3 = IdentifierSyntax.getAssemblyIdentifierOf(abstractVariable, string);
        if (this.assemblyIdentifierIndexMap.containsKey(string2)) {
            return IdentifierMapManager.getLastFromMap(this.assemblyIdentifierIndexMap, string2);
        }
        if (this.fullAssemblyIdentifierIndexMap.containsKey(string3)) {
            return IdentifierMapManager.getLastFromMap(this.fullAssemblyIdentifierIndexMap, string3);
        }
        throw new VnanoFatalException("Variable index not found: " + string3);
    }

    public int getSize() {
        return this.size;
    }
}

