/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.main;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.vcssl.connect.ConnectorException;
import org.vcssl.connect.ConnectorImplementationContainer;
import org.vcssl.connect.ConnectorImplementationLoader;
import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestException;
import org.vcssl.nano.combinedtest.CombinedTestExecutor;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.interconnect.PluginLoader;
import org.vcssl.nano.interconnect.ScriptLoader;
import org.vcssl.nano.main.PerformanceValuePrinter;
import org.vcssl.nano.spec.OptionValue;
import org.vcssl.nano.vm.VirtualMachine;

public final class VnanoCommandLineApplication {
    private Locale locale = Locale.getDefault();
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_LIBRARY_LIST_FILE_PATH = "lib/VnanoLibraryList.txt";
    private static final String DEFAULT_PLUGIN_LIST_FILE_PATH = "plugin/VnanoPluginList.txt";
    private static final String DEFAULT_LIBRARY_DIR = "lib/";
    private static final String DEFAULT_PLUGIN_DIR = "plugin/";
    private static final String EXTENSION_VNANO = ".vnano";
    private static final String EXTENSION_VRIL = ".vril";
    private static final String COMMAND_OPTNAME_PREFIX = "--";
    private static final String COMMAND_OPTNAME_FILE = "file";
    private static final String COMMAND_OPTNAME_HELP = "help";
    private static final String COMMAND_OPTNAME_DUMP = "dump";
    private static final String COMMAND_OPTNAME_RUN = "run";
    private static final String COMMAND_OPTNAME_LOCALE = "locale";
    private static final String COMMAND_OPTNAME_VERSION = "version";
    private static final String COMMAND_OPTNAME_ACCELERATOR = "accelerator";
    private static final String COMMAND_OPTNAME_TERMINATOR = "terminator";
    private static final String COMMAND_OPTNAME_PERF = "perf";
    private static final String COMMAND_OPTNAME_OPTLEVEL = "optLevel";
    private static final String COMMAND_OPTNAME_ENCODING = "encoding";
    private static final String COMMAND_OPTNAME_PLUGIN_DIR = "pluginDir";
    private static final String COMMAND_OPTNAME_PLUGIN = "plugin";
    private static final String COMMAND_OPTNAME_PLUGIN_LIST = "pluginList";
    private static final String COMMAND_OPTNAME_LIBRARY_LIST = "libList";
    private static final String COMMAND_OPTNAME_PERMISSION = "permission";
    private static final String COMMAND_OPTNAME_TEST = "test";
    private static final String COMMAND_OPTNAME_DEFAULT = "file";
    private static final String DUMP_TARGET_INPUTTED_CODE = "inputtedCode";
    private static final String DUMP_TARGET_PREPROCESSED_CODE = "preprocessedCode";
    private static final String DUMP_TARGET_TOKEN = "token";
    private static final String DUMP_TARGET_PARSED_AST = "parsedAst";
    private static final String DUMP_TARGET_ANALYZED_AST = "analyzedAst";
    private static final String DUMP_TARGET_ASSEMBLY_CODE = "assemblyCode";
    private static final String DUMP_TARGET_OBJECT_CODE = "objectCode";
    private static final String DUMP_TARGET_ACCELERATOR_CODE = "acceleratorCode";
    private static final String DUMP_TARGET_ACCELERATOR_STATE = "acceleratorState";
    private static final String DUMP_TARGET_ALL = "all";
    private static final String DUMP_TARGET_DEFAULT = "all";
    private static final Map<String, String> DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP = new HashMap<String, String>();
    private static final String PERF_TARGET_SPEED = "speed";
    private static final String PERF_TARGET_RAM = "ram";
    private static final String PERF_TARGET_INSTRUCTION_FREQ = "instructionFreq";
    private static final String PERF_TARGET_ALL = "all";
    private static final String PERF_TARGET_DEFAULT = "all";
    private static final Set<String> PERF_TARGET_SET;
    private boolean perfEnabled = false;
    private String perfTarget = null;
    private static final String PERMISSION_VALUE_DENY_ALL = "denyAll";
    private static final String PERMISSION_VALUE_ALLOW_ALL = "allowAll";
    private static final String PERMISSION_VALUE_ASK_ALL = "askAll";
    private static final String PERMISSION_VALUE_BALANCED = "balanced";
    private Map<String, String> permissionMap = PERMISSION_MAP_DENY_ALL;
    private static final Map<String, String> PERMISSION_MAP_DENY_ALL;
    private static final Map<String, String> PERMISSION_MAP_ALLOW_ALL;
    private static final Map<String, String> PERMISSION_MAP_ASK_ALL;
    private static final Map<String, String> PERMISSION_MAP_BALANCED;
    private Map<String, Object> engineOptionMap = new HashMap<String, Object>();
    private List<String> optPluginDirList = new ArrayList<String>();
    private List<Object> optPluginList = new ArrayList<Object>();
    private String optPluginListFilePath = null;
    private String optLibraryListFilePath = null;
    private boolean optCombinedTestRequired = false;

    public void help() {
        if (this.locale.getLanguage() != null && this.locale.getLanguage().toLowerCase().equals("ja") || this.locale.getCountry() != null && this.locale.getCountry().toLowerCase().equals("jp")) {
            this.helpInJapanese();
        } else {
            this.helpInEnglish();
        }
    }

    public void helpInEnglish() {
        System.out.print("Vnano 1.1.4");
        System.out.println("  (Command-Line Mode)");
        System.out.println("");
        System.out.println("[ Usage ]");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar fileName");
        System.out.println("");
        System.out.println("        or,");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar fileName --option1 value1 --option2 value2 ...");
        System.out.println("");
        System.out.println("[ Options ]");
        System.out.println("");
        System.out.println("  --help");
        System.out.println("");
        System.out.println("    Show this help messages.");
        System.out.println("");
        System.out.println("");
        System.out.println("  --file <filePath>");
        System.out.println("");
        System.out.println("    Load the script code (.vnano) or the VRIL code (.vril) from the file.");
        System.out.println("    This is the default option for 1-argument.");
        System.out.println("    You can skip to describe this option name for simplicity of the commands.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar --file Example.vnano");
        System.out.println("      java -jar Vnano.jar --file Example.vril");
        System.out.println("      java -jar Vnano.jar Example.vnano");
        System.out.println("      java -jar Vnano.jar Example.vril");
        System.out.println("");
        System.out.println("");
        System.out.println("  --encoding <encodingName>");
        System.out.println("");
        System.out.println("      Specify the text-encoding of the script file.");
        System.out.println("      The default text-encoding on this mode is UTF-8.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --encoding UTF-8");
        System.out.println("      java -jar Vnano.jar Example.vnano --encoding Shift_JIS");
        System.out.println("");
        System.out.println("");
        System.out.println("  --locale <localeCode>");
        System.out.println("");
        System.out.println("      Specify the locale to determine the language of error messages.");
        System.out.println("      The default locale depends on your environment.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --locale En-US");
        System.out.println("      java -jar Vnano.jar Example.vnano --locale Ja-JP");
        System.out.println("");
        System.out.println("");
        System.out.println("  --dump <dumpTarget>");
        System.out.println("");
        System.out.println("      Dump the intermediate information to the standard output, for debugging.");
        System.out.println("      You can choose and specify the <dumpTarget> from the following list:");
        System.out.println("");
        System.out.println("        inputtedCode     : Content of the script code loaded from the file.");
        System.out.println("        preprocessedCode : Comment-removed script code generated by the preprocessor.");
        System.out.println("        token            : Tokens generated by the lexical analyzer.");
        System.out.println("        parsedAst        : Abstract Syntax Tree (AST) generated by the parser.");
        System.out.println("        analyzedAst      : Information-appended AST generated by the semantic analyzer.");
        System.out.println("        assemblyCode     : Virtual assembly code written in the VRIL, generated by the code generator.");
        System.out.println("        objectCode       : Virtual object code running on the VM, generated by the assembler.");
        System.out.println("        acceleratorCode  : Optimized instruction code running on the VM when the accelerator is enabled.");
        System.out.println("        acceleratorState : Internal state of the accelerator.");
        System.out.println("        all (default)    : All of the above dump targets.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --dump");
        System.out.println("      java -jar Vnano.jar Example.vnano --dump all");
        System.out.println("      java -jar Vnano.jar Example.vnano --dump assemblyCode");
        System.out.println("");
        System.out.println("");
        System.out.println("  --run <runOrNot>");
        System.out.println("");
        System.out.println("      Specify whether you want to run the code loaded from the file or not.");
        System.out.println("      This option is specified by default, and the default value is true.");
        System.out.println("      You can choose and specify the value of <runOrNot> from the followings:");
        System.out.println("");
        System.out.println("        true (default) : Run the code.");
        System.out.println("        false          : Don't run the code.");
        System.out.println("");
        System.out.println("      This option is useful for the combination usage with the --dump option.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --run false");
        System.out.println("      java -jar Vnano.jar Example.vnano --run false --dump assemblyCode");
        System.out.println("      java -jar Vnano.jar Example.vnano --run false --dump assemblyCode > debug.txt");
        System.out.println("");
        System.out.println("");
        System.out.println("  --accelerator <enableOrDisable>");
        System.out.println("");
        System.out.println("      Specify whether you want to enable the accelerator.");
        System.out.println("      This option is specified by default, and the default value is true.");
        System.out.println("      You can choose and specify the value of <enableOrDisable> from the followings:");
        System.out.println("");
        System.out.println("        true (default) : Enable the accelerator.");
        System.out.println("        false          : Disable the accelerator.");
        System.out.println("");
        System.out.println("      The accelerator enables high-speed processing, but it has very complex implementation.");
        System.out.println("      When you feel that there is some bug for interpretation of a script,");
        System.out.println("      sometimes you may avoid it by disabling the accelerator.");
        System.out.println("      Please note that, if you disable it, significant slow-down occurs on processing.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --accelerator true");
        System.out.println("      java -jar Vnano.jar Example.vnano --accelerator false");
        System.out.println("");
        System.out.println("");
        System.out.println("  --optLevel <optimizationLevel>");
        System.out.println("");
        System.out.println("      Specify the value of the optimization level.");
        System.out.println("      This option is specified by default, and the default value is 3.");
        System.out.println("      The value of <optimizationLevel> is an integer grater than or equals to 0,");
        System.out.println("      and the maximum level currently supported is 3.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --optLevel 0");
        System.out.println("      java -jar Vnano.jar Example.vnano --optLevel 3");
        System.out.println("");
        System.out.println("");
        System.out.println("  --terminator <enableOrDisable>");
        System.out.println("");
        System.out.println("      Specify whether you want to enable the terminator.");
        System.out.println("      This option is specified by default, and the default value is false.");
        System.out.println("      You can choose and specify the value of <enableOrDisable> from the followings:");
        System.out.println("");
        System.out.println("        true            : Enable the terminator.");
        System.out.println("        false (default) : Disable the terminator.");
        System.out.println("");
        System.out.println("      Note that, the terminator is the feature for terminating scripts from application-side equipped");
        System.out.println("      with the Vnano Engine, so there is no situation to use the terminator on the command-line mode.");
        System.out.println("      However, this option is useful for measuring (a little) slow-down in processing speed,");
        System.out.println("      occurred when the terminator is enabled.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --terminator true");
        System.out.println("      java -jar Vnano.jar Example.vnano --terminator false");
        System.out.println("");
        System.out.println("");
        System.out.println("  --perf <perfTarget>");
        System.out.println("");
        System.out.println("      Enable the performance monitor.");
        System.out.println("      You can choose and specify the <perfTarget> from the following list:");
        System.out.println("");
        System.out.println("        speed            : VM drive speed (Number of executed instructions per second).");
        System.out.println("        ram              : Memory usage.");
        System.out.println("        instructionFreq  : Frequencies of that each instruction is being executed at periodic sampling moments.");
        System.out.println("        all (default)    : All of the above performance monitoring targets.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --perf");
        System.out.println("      java -jar Vnano.jar Example.vnano --perf all");
        System.out.println("      java -jar Vnano.jar Example.vnano --perf speed");
        System.out.println("");
        System.out.println("");
        System.out.println("  --plugin <pluginPath>");
        System.out.println("");
        System.out.println("      Specify the class path of the plug-in to be connected.");
        System.out.println("      Multiple paths can be specified by separating with \":\" or \";\"");
        System.out.println("      (depends on the environment).");
        System.out.println("      If the root hierarchy of the class path of the plug-in is not \"plugin/\" directory,");
        System.out.println("      specify that directory by --pluginDir option BEFORE this option.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --plugin ExamplePlugin");
        System.out.println("      java -jar Vnano.jar Example.vnano --plugin examplepackage.ExamplePlugin");
        System.out.println("      java -jar Vnano.jar Example.vnano --plugin \"Plugin1;Plugin2;Plugin3\"");
        System.out.println("      java -jar Vnano.jar Example.vnano --plugin \"Plugin1:Plugin2:Plugin3\"");
        System.out.println("      java -jar Vnano.jar Example.vnano --pluginDir \"./exampleDir/\" --plugin \"ExamplePlugin\"");
        System.out.println("");
        System.out.println("");
        System.out.println("  --pluginDir <pluginDirectoryPath>");
        System.out.println("");
        System.out.println("      Specify the file path of the directory at the root hierarchy of class paths of plug-ins.");
        System.out.println("      Multiple file paths can be specified by separating with \":\" or \";\"");
        System.out.println("      (depends on the environment).");
        System.out.println("      The default value is \"plugin/\".");
        System.out.println("");
        System.out.println("");
        System.out.println("  --pluginList <pluginListFilePath>");
        System.out.println("");
        System.out.println("      Specify the file path of the plugin-list file in which file paths of plug-ins ");
        System.out.println("      to be loaded are described.");
        System.out.println("      The default value is \"plugin/VnanoPluginList.txt\".");
        System.out.println("");
        System.out.println("");
        System.out.println("  --libList <libraryListFilePath>");
        System.out.println("");
        System.out.println("      Specify the file path of the library-list file in which file paths of library-scripts ");
        System.out.println("      to be loaded are described.");
        System.out.println("      The default value is \"lib/VnanoLibraryList.txt\".");
        System.out.println("");
        System.out.println("");
        System.out.println("  --permission <permissionSettingsName>");
        System.out.println("");
        System.out.println("      Specify the name of the permission settings.");
        System.out.println("      This option is specified by default, and the default value is \"denyAll\"");
        System.out.println("      You can choose and specify the value of <permissionSettingsName> from the followings:");
        System.out.println("");
        System.out.println("          denyAll   : Denies all permission requests.");
        System.out.println("          allowAll  : Allows all permission requests.");
        System.out.println("          askAll    : Asks users whether allow or deny each permission request, for all permission items.");
        System.out.println("");
        System.out.println("          balanced  : The settings considering the balance between usability and protectivity, as follows:");
        System.out.println("");
        System.out.println("                        * DEFAULT:          ASK");
        System.out.println("                        * FILE_CREATE:      ALLOW");
        System.out.println("                        * FILE_WRITE:       ALLOW");
        System.out.println("                      ( * FILE_OVERWRITE:   ASK   )");
        System.out.println("                        * FILE_READ:        ALLOW");
        System.out.println("                        * DIRECTORY_CREATE: ALLOW");
        System.out.println("                        * DIRECTORY_LIST:   ALLOW");
        System.out.println("                        * PROGRAM_EXIT:     ALLOW");
        System.out.println("                        * PROGRAM_RESET:    ALLOW");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --permission denyAll");
        System.out.println("      java -jar Vnano.jar Example.vnano --permission askAll");
        System.out.println("      java -jar Vnano.jar Example.vnano --permission balanced");
        System.out.println("");
        System.out.println("");
        System.out.println("  --test");
        System.out.println("");
        System.out.println("      Execute combined tests of the script engine of the Vnano.");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar --test");
        System.out.println("");
        System.out.println("");
        System.out.println("[ Default Supported Functions ]");
        System.out.println("");
        System.out.println("    For development and debugging, following functions are available");
        System.out.println("    in the script code running on this mode:");
        System.out.println("");
        System.out.println("      void output(int)");
        System.out.println("      void output(long)");
        System.out.println("      void output(float)");
        System.out.println("      void output(double)");
        System.out.println("      void output(bool)");
        System.out.println("      void output(string)");
        System.out.println("      int  time()");
        System.out.println("");
        System.out.println("    Please note that these functions are supported by default ONLY ON THIS MODE.");
        System.out.println("    No default functions are supported when the script engine is embedded in ");
        System.out.println("    other applications, so it is necessary to implement and connect ");
        System.out.println("    functions(methods) you want to use in the other application to the script engine.");
        System.out.println("");
        System.out.println("    When you want to use the above functions, and other fundamental functions,");
        System.out.println("    intdocude Vnano Standard Plug-ins, and connect them to the engine.");
        System.out.println("    For details, see documents of the Vnano Engine.");
        System.out.println("");
    }

    public void helpInJapanese() {
        System.out.print("Vnano 1.1.4");
        System.out.println(" \uff08\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\uff09");
        System.out.println("");
        System.out.println("[ \u4f7f\u7528\u65b9\u6cd5 ]");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar \u30b9\u30af\u30ea\u30d7\u30c8\u540d");
        System.out.println("");
        System.out.println("        \u307e\u305f\u306f");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar \u30b9\u30af\u30ea\u30d7\u30c8\u540d --\u30aa\u30d7\u30b7\u30e7\u30f3\u540d1 \u30aa\u30d7\u30b7\u30e7\u30f3\u50241 --\u30aa\u30d7\u30b7\u30e7\u30f3\u540d2 \u30aa\u30d7\u30b7\u30e7\u30f3\u50242 ...");
        System.out.println("");
        System.out.println("[ \u30aa\u30d7\u30b7\u30e7\u30f3 ]");
        System.out.println("");
        System.out.println("  --help");
        System.out.println("");
        System.out.println("    \u73fe\u5728\u8868\u793a\u3055\u308c\u3066\u3044\u308b\u3001\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("");
        System.out.println("  --file \u30d5\u30a1\u30a4\u30eb\u30d1\u30b9");
        System.out.println("");
        System.out.println("    \u30d5\u30a1\u30a4\u30eb\u304b\u3089\u3001\u5b9f\u884c\u3059\u308b\u30b9\u30af\u30ea\u30d7\u30c8\u30b3\u30fc\u30c9 (.vnano) \u307e\u305f\u306f VRIL \u30b3\u30fc\u30c9 (.vril) \u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002");
        System.out.println("    \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306e --file \u306e\u90e8\u5206\u306f\u306f\u7701\u7565\u53ef\u80fd\u3067\u3059\u3002");
        System.out.println("    \u307e\u305f\u3001\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u5f15\u6570\u304c\u4e00\u500b\u3060\u3051\u306e\u5834\u5408\u3001\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306e\u5024\u3068\u89e3\u91c8\u3055\u308c\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b\uff1a");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar --file Example.vnano");
        System.out.println("      java -jar Vnano.jar --file Example.vril");
        System.out.println("      java -jar Vnano.jar Example.vnano");
        System.out.println("      java -jar Vnano.jar Example.vril");
        System.out.println("");
        System.out.println("");
        System.out.println("  --encoding \u6587\u5b57\u30b3\u30fc\u30c9\u540d");
        System.out.println("");
        System.out.println("      \u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u3067\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u306f\u300c UTF-8 \u300d\u3067\u3059\u3002");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b\uff1a");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --encoding UTF-8");
        System.out.println("      java -jar Vnano.jar Example.vnano --encoding Shift_JIS");
        System.out.println("");
        System.out.println("");
        System.out.println("  --locale \u30ed\u30b1\u30fc\u30eb\u540d");
        System.out.println("");
        System.out.println("      \u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u7b49\u306e\u8a00\u8a9e\u3092\u6c7a\u3081\u308b\u305f\u3081\u306e\u3001\u30ed\u30b1\u30fc\u30eb\uff08\u2252\u5730\u57df/\u8a00\u8a9e\u306e\u533a\u5206\u30b3\u30fc\u30c9\uff09\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30ed\u30b1\u30fc\u30eb\u306f\u3001\u5b9f\u884c\u3055\u308c\u3066\u3044\u308b\u74b0\u5883\u306b\u5408\u308f\u305b\u3066\u81ea\u52d5\u8a2d\u5b9a\u3055\u308c\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("    e.g.");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --locale En-US");
        System.out.println("      java -jar Vnano.jar Example.vnano --locale Ja-JP");
        System.out.println("");
        System.out.println("");
        System.out.println("  --dump \u30c0\u30f3\u30d7\u5bfe\u8c61");
        System.out.println("");
        System.out.println("      \u30a8\u30f3\u30b8\u30f3\u5185\u90e8\u3067\u306e\u3001\u30b9\u30af\u30ea\u30d7\u30c8\u51e6\u7406\u306b\u95a2\u3059\u308b\u4e2d\u9593\u8868\u73fe\u3092\u3001\u6a19\u6e96\u51fa\u529b\u306b\u30c0\u30f3\u30d7\u3057\u307e\u3059\uff08\u30c7\u30d0\u30c3\u30b0\u7528\uff09\u3002");
        System.out.println("      \u30c0\u30f3\u30d7\u5bfe\u8c61\u306e\u5024\u306f\u3001\u4ee5\u4e0b\u306e\u4e00\u89a7\u304b\u3089\u6307\u5b9a\u3067\u304d\u307e\u3059\uff1a");
        System.out.println("");
        System.out.println("        inputtedCode     : \u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u307f\u8fbc\u307e\u308c\u305f\u307e\u307e\u306e\u5185\u5bb9");
        System.out.println("        preprocessedCode : \u30d7\u30ea\u30d7\u30ed\u30bb\u30c3\u30b5\u3067\u3001\u30b3\u30e1\u30f3\u30c8\u7b49\u304c\u9664\u53bb\u3055\u308c\u305f\u30b3\u30fc\u30c9");
        System.out.println("        token            : \u30b3\u30fc\u30c9\u304b\u3089\u3001\u5b57\u53e5\u89e3\u6790\u5668\u306b\u3088\u3063\u3066\u5206\u5272\u3055\u308c\u305f\u30c8\u30fc\u30af\u30f3\u5217");
        System.out.println("        parsedAst        : \u69cb\u6587\u89e3\u6790\u5668\u3067\u751f\u6210\u3055\u308c\u305f\u76f4\u5f8c\u306e\u62bd\u8c61\u69cb\u6587\u6728\uff08AST\uff09");
        System.out.println("        analyzedAst      : \u610f\u5473\u89e3\u6790\u5668\u306b\u3088\u3063\u3066\u3001\u578b\u60c5\u5831\u306a\u3069\u304c\u88dc\u5b8c\u3055\u308c\u305f\u62bd\u8c61\u69cb\u6587\u6728\uff08AST\uff09");
        System.out.println("        assemblyCode     : \u30b3\u30fc\u30c9\u751f\u6210\u5668\u3067\u751f\u6210\u3055\u308c\u305f\u3001VRIL\u3067\u8a18\u8ff0\u3055\u308c\u305f\u4eee\u60f3\u7684\u306a\u30a2\u30bb\u30f3\u30d6\u30ea\u30b3\u30fc\u30c9");
        System.out.println("        objectCode       : \u30a2\u30bb\u30f3\u30d6\u30e9\u3067\u751f\u6210\u3055\u308c\u305f\u3001\u4eee\u60f3\u30de\u30b7\u30f3\uff08VM\uff09\u4e0a\u3067\u5b9f\u884c\u53ef\u80fd\u306a\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30b3\u30fc\u30c9");
        System.out.println("        acceleratorCode  : \u6700\u9069\u5316\u3055\u308c\u305f\u547d\u4ee4\u5217\uff08\u30a2\u30af\u30bb\u30e9\u30ec\u30fc\u30bf\u30fc\u6709\u52b9\u6642\u306e\u307f\u4f7f\u7528\u53ef\u80fd\uff09");
        System.out.println("        acceleratorState : \u30a2\u30af\u30bb\u30e9\u30ec\u30fc\u30bf\u30fc\u306e\u5185\u90e8\u72b6\u614b\uff08\u30a2\u30af\u30bb\u30e9\u30ec\u30fc\u30bf\u30fc\u6709\u52b9\u6642\u306e\u307f\u4f7f\u7528\u53ef\u80fd\uff09");
        System.out.println("        all (\u30c7\u30d5\u30a9\u30eb\u30c8) : \u4e0a\u8a18\u306e\u5168\u3066");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b\uff1a");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --dump");
        System.out.println("      java -jar Vnano.jar Example.vnano --dump all");
        System.out.println("      java -jar Vnano.jar Example.vnano --dump assemblyCode");
        System.out.println("");
        System.out.println("");
        System.out.println("  --run \u5b9f\u884c\u3059\u308b\u304b\u3069\u3046\u304b");
        System.out.println("");
        System.out.println("      \u8aad\u307f\u8fbc\u3093\u3060\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u3001\u5b9f\u884c\u3059\u308b\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u306f true\uff08\u5b9f\u884c\u3059\u308b\uff09\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        System.out.println("      \u4ee5\u4e0b\u306e\u3088\u3046\u306b\u3001true \u304b false \u306e\u5024\u3092\u6307\u5b9a\u3057\u307e\u3059\uff1a");
        System.out.println("");
        System.out.println("        true (\u30c7\u30d5\u30a9\u30eb\u30c8) : \u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3059\u308b");
        System.out.println("        false             : \u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3057\u306a\u3044");
        System.out.println("");
        System.out.println("      \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3001\u4f8b\u3048\u3070 --dump \u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u69cb\u6587\u89e3\u6790\u51e6\u7406\u306e\u30c7\u30d0\u30c3\u30b0\u306a\u3069\u3092\u884c\u3063\u3066\u3044\u3066\u3001");
        System.out.println("      \u30b9\u30af\u30ea\u30d7\u30c8\u306e\u5b9f\u884c\u306f\u3055\u305b\u305f\u304f\u306a\u3044\u5834\u5408\u306a\u3069\u306b\u6709\u7528\u3067\u3059\u3002");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --run false");
        System.out.println("      java -jar Vnano.jar Example.vnano --run false --dump assemblyCode");
        System.out.println("      java -jar Vnano.jar Example.vnano --run false --dump assemblyCode > debug.txt");
        System.out.println("");
        System.out.println("");
        System.out.println("  --accelerator \u6709\u52b9\u5316\u3059\u308b\u304b\u3069\u3046\u304b");
        System.out.println("");
        System.out.println("      \u4eee\u60f3\u30de\u30b7\u30f3\uff08VM\uff09\u306e\u9ad8\u901f\u7248\u5b9f\u88c5\u3067\u3042\u308b\u3001\u30a2\u30af\u30bb\u30e9\u30ec\u30fc\u30bf\u30fc\u3092\u6709\u52b9\u5316\u3059\u308b\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u306f true\uff08\u6709\u52b9\u5316\u3059\u308b\uff09\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        System.out.println("      \u4ee5\u4e0b\u306e\u3088\u3046\u306b\u3001true \u304b false \u306e\u5024\u3092\u6307\u5b9a\u3057\u307e\u3059\uff1a");
        System.out.println("");
        System.out.println("        true (\u30c7\u30d5\u30a9\u30eb\u30c8) : \u30a2\u30af\u30bb\u30e9\u30ec\u30fc\u30bf\u3092\u6709\u52b9\u5316\u3059\u308b");
        System.out.println("        false             : \u30a2\u30af\u30bb\u30e9\u30ec\u30fc\u30bf\u3092\u7121\u52b9\u5316\u3059\u308b");
        System.out.println("");
        System.out.println("      \u30a2\u30af\u30bb\u30e9\u30ec\u30fc\u30bf\u30fc\u306f\u3001\u51e6\u7406\u901f\u5ea6\u304c\u9ad8\u3044\u534a\u9762\u3001\u5b9f\u88c5\u3082\u975e\u5e38\u306b\u8907\u96d1\u3067\u3059\u3002");
        System.out.println("      \u30b9\u30af\u30ea\u30d7\u30c8\u306e\u89e3\u91c8\u304c\u4f55\u304b\u304a\u304b\u3057\u3044\u3068\u611f\u3058\u305f\u969b\u306a\u3069\u306b\u3001\u7121\u52b9\u5316\u3059\u308b\u3068\u56de\u907f\u3067\u304d\u308b\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002");
        System.out.println("      \u305f\u3060\u3057\u3001\u7121\u52b9\u5316\u3059\u308b\u3068\u51e6\u7406\u901f\u5ea6\u304c\u5927\u5e45\u306b\uff08\u6587\u5b57\u901a\u308a\u6841\u9055\u3044\u306b\uff09\u4f4e\u4e0b\u3057\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --accelerator true");
        System.out.println("      java -jar Vnano.jar Example.vnano --accelerator false");
        System.out.println("");
        System.out.println("");
        System.out.println("  --optLevel \u6700\u9069\u5316\u30ec\u30d9\u30eb");
        System.out.println("");
        System.out.println("      \u6700\u9069\u5316\u30ec\u30d9\u30eb\u3092\u30010 \u304b\u3089 3 \u306e\u7bc4\u56f2\u3067\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u30c7\u30d5\u30a9\u30eb\u30c8\u3067\u306f\u3001\u6700\u9069\u5316\u30ec\u30d9\u30eb\u306f 3\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --optLevel 0");
        System.out.println("      java -jar Vnano.jar Example.vnano --optLevel 3");
        System.out.println("");
        System.out.println("");
        System.out.println("  --terminator \u6709\u52b9\u5316\u3059\u308b\u304b\u3069\u3046\u304b");
        System.out.println("");
        System.out.println("      \u30b9\u30af\u30ea\u30d7\u30c8\u3092\u9014\u4e2d\u7d42\u4e86\u3055\u305b\u308b\u305f\u3081\u306e\u6a5f\u80fd\u3067\u3042\u308b\u3001\u30bf\u30fc\u30df\u30cd\u30fc\u30bf\u30fc\u3092\u6709\u52b9\u5316\u3059\u308b\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u3067 false\uff08\u7121\u52b9\u5316\u3059\u308b\uff09\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        System.out.println("      \u4ee5\u4e0b\u306e\u3088\u3046\u306b\u3001true \u304b false \u306e\u5024\u3092\u6307\u5b9a\u3057\u307e\u3059\uff1a");
        System.out.println("");
        System.out.println("        true               : \u30bf\u30fc\u30df\u30cd\u30fc\u30bf\u30fc\u3092\u6709\u52b9\u5316\u3059\u308b");
        System.out.println("        false (\u30c7\u30d5\u30a9\u30eb\u30c8) : \u30bf\u30fc\u30df\u30cd\u30fc\u30bf\u30fc\u3092\u7121\u52b9\u5316\u3059\u308b");
        System.out.println("");
        System.out.println("      \u306a\u304a\u3001\u30bf\u30fc\u30df\u30cd\u30fc\u30bf\u30fc\u306f\u3001\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306b\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u3092\u7d44\u307f\u8fbc\u3093\u3060\u969b\u306e\u305f\u3081\u306e\u6a5f\u80fd\u3067\u3042\u308a\u3001");
        System.out.println("      \u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u3067\u306f\u4f5c\u52d5\u3055\u305b\u308b\u6a5f\u4f1a\u306f\u3042\u308a\u307e\u305b\u3093\uff08\u305d\u306e\u305f\u3081\u30c7\u30d5\u30a9\u30eb\u30c8\u3067 false \u306b\u306a\u3063\u3066\u3044\u307e\u3059\uff09\u3002");
        System.out.println("      \u4e00\u65b9\u3067\u3001\u6709\u52b9\u5316\u3059\u308b\u3068\u82e5\u5e72\u306e\u901f\u5ea6\u4f4e\u4e0b\u304c\u751f\u3058\u308b\u305f\u3081\u3001\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u305d\u306e\u5ea6\u5408\u306e\u628a\u63e1\u306e\u305f\u3081\u306b\u7528\u3044\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b\uff1a");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --terminator true");
        System.out.println("      java -jar Vnano.jar Example.vnano --terminator false");
        System.out.println("");
        System.out.println("");
        System.out.println("  --perf \u8a08\u6e2c\u5bfe\u8c61");
        System.out.println("");
        System.out.println("      \u6027\u80fd\u8a08\u6e2c\u3092\u6709\u52b9\u5316\u3059\u308b\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u8a08\u6e2c\u5bfe\u8c61\u306e\u5024\u306f\u3001\u4ee5\u4e0b\u306e\u4e00\u89a7\u304b\u3089\u6307\u5b9a\u3067\u304d\u307e\u3059\uff1a");
        System.out.println("");
        System.out.println("        speed            : \u4eee\u60f3\uff08VM\uff09\u30de\u30b7\u30f3\u306e\u52d5\u4f5c\u901f\u5ea6\uff08\u79d2\u9593\u3042\u305f\u308a\u547d\u4ee4\u5b9f\u884c\u6570\uff09");
        System.out.println("        ram              : \u30e1\u30e2\u30ea\u30fc\u4f7f\u7528\u91cf");
        System.out.println("        instructionFreq  : \u5404\u547d\u4ee4\u7a2e\u985e\u3054\u3068\u306e\u5b9f\u884c\u983b\u5ea6\uff08\u30b5\u30f3\u30d7\u30ea\u30f3\u30b0\u306b\u3088\u308a\u8a08\u6e2c\uff09");
        System.out.println("        all (default)    : \u4e0a\u8a18\u306e\u5168\u3066");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --perf");
        System.out.println("      java -jar Vnano.jar Example.vnano --perf all");
        System.out.println("      java -jar Vnano.jar Example.vnano --perf speed");
        System.out.println("");
        System.out.println("");
        System.out.println("  --plugin \u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30d1\u30b9");
        System.out.println("");
        System.out.println("      \u63a5\u7d9a\u3059\u308b\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30af\u30e9\u30b9\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u30d1\u30b9\u306f\u3001\u300c:\u300d\u307e\u305f\u306f\u300c;\u300d\u533a\u5207\u308a\uff08\u74b0\u5883\u4f9d\u5b58\uff09\u3067\u8907\u6570\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002");
        System.out.println("      \u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30af\u30e9\u30b9\u30d1\u30b9\u306e\u30eb\u30fc\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u300c plugin/ \u300d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u306a\u3044\u5834\u5408\u3001");
        System.out.println("      --pluginDir \u3092\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u3088\u308a\u3082\u524d\u306b\u4ed8\u3051\u3066\u3001\u305d\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b\uff1a");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --plugin ExamplePlugin");
        System.out.println("      java -jar Vnano.jar Example.vnano --plugin examplepackage.ExamplePlugin");
        System.out.println("      java -jar Vnano.jar Example.vnano --plugin \"Plugin1;Plugin2;Plugin3\"");
        System.out.println("      java -jar Vnano.jar Example.vnano --plugin \"Plugin1:Plugin2:Plugin3\"");
        System.out.println("      java -jar Vnano.jar Example.vnano --pluginDir \"./exampleDir/\" --plugin \"ExamplePlugin\"");
        System.out.println("");
        System.out.println("");
        System.out.println("  --pluginDir \u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30af\u30e9\u30b9\u30d1\u30b9\u306b\u304a\u3051\u308b\u30eb\u30fc\u30c8\u968e\u5c64\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30d1\u30b9");
        System.out.println("");
        System.out.println("      \u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30af\u30e9\u30b9\u30d1\u30b9\u306b\u304a\u3044\u3066\u3001\u30eb\u30fc\u30c8\u968e\u5c64\u306b\u4f4d\u7f6e\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u306f\u3001\u300c:\u300d\u307e\u305f\u306f\u300c;\u300d\u533a\u5207\u308a\uff08\u74b0\u5883\u4f9d\u5b58\uff09\u3067\u8907\u6570\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002");
        System.out.println("      \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u3067\u300c plugin/ \u300d\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("");
        System.out.println("  --pluginList \u30d7\u30e9\u30b0\u30a4\u30f3\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9");
        System.out.println("");
        System.out.println("      \u8aad\u307f\u8fbc\u307f\u5bfe\u51e6\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u5217\u6319\u3055\u308c\u3066\u3044\u308b\u3001\u300c\u30d7\u30e9\u30b0\u30a4\u30f3 \u30ea\u30b9\u30c8 \u30d5\u30a1\u30a4\u30eb\u300d\u306e\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u30c7\u30d5\u30a9\u30eb\u30c8\u3067\u300c plugin/VnanoPluginList.txt \u300d\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("");
        System.out.println("  --libList \u30e9\u30a4\u30d6\u30e9\u30ea\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9");
        System.out.println("");
        System.out.println("      \u8aad\u307f\u8fbc\u307f\u5bfe\u51e6\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u5217\u6319\u3055\u308c\u3066\u3044\u308b\u3001\u300c\u30e9\u30a4\u30d6\u30e9\u30ea \u30ea\u30b9\u30c8 \u30d5\u30a1\u30a4\u30eb\u300d\u306e\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u30c7\u30d5\u30a9\u30eb\u30c8\u3067\u300c lib/VnanoLibraryList.txt \u300d\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("");
        System.out.println("  --permission \u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u8a2d\u5b9a\u540d");
        System.out.println("");
        System.out.println("      \u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u8a2d\u5b9a\u3092\u9078\u629e\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("      \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u30c7\u30d5\u30a9\u30eb\u30c8\u3067\u300c denyAll \u300d\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        System.out.println("      \u4e0b\u8a18\u306e\u4e00\u89a7\u304b\u3089\u9078\u3093\u3067\u6307\u5b9a\u3067\u304d\u307e\u3059\uff1a");
        System.out.println("");
        System.out.println("          denyAll   : \u5168\u3066\u306e\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u8981\u6c42\u3092\u62d2\u5426\u3057\u307e\u3059\u3002");
        System.out.println("          allowAll  : \u5168\u3066\u306e\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u8981\u6c42\u3092\u8a31\u53ef\u3057\u307e\u3059\u3002");
        System.out.println("          askAll    : \u5404\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u306e\u30ea\u30af\u30a8\u30b9\u30c8\u6642\u306b\u3001\u30e6\u30fc\u30b6\u30fc\u306b\u5c0b\u306d\u3066\u6c7a\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("          balanced  : \u4e00\u822c\u7684\u306a\u7528\u9014\u3092\u60f3\u5b9a\u3057\u3001\u5229\u4fbf\u6027\u3068\u4fdd\u8b77\u306e\u30d0\u30e9\u30f3\u30b9\u3092\u8003\u616e\u3057\u305f\u8a2d\u5b9a\uff08\u4e0b\u8a18\uff09\u3092\u4f7f\u7528\u3057\u307e\u3059\uff1a");
        System.out.println("");
        System.out.println("                        * DEFAULT:          ASK");
        System.out.println("                        * FILE_CREATE:      ALLOW");
        System.out.println("                        * FILE_WRITE:       ALLOW");
        System.out.println("                      ( * FILE_OVERWRITE:   ASK   )");
        System.out.println("                        * FILE_READ:        ALLOW");
        System.out.println("                        * DIRECTORY_CREATE: ALLOW");
        System.out.println("                        * DIRECTORY_LIST:   ALLOW");
        System.out.println("                        * PROGRAM_EXIT:     ALLOW");
        System.out.println("                        * PROGRAM_RESET:    ALLOW");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar Example.vnano --permission denyAll");
        System.out.println("      java -jar Vnano.jar Example.vnano --permission askAll");
        System.out.println("      java -jar Vnano.jar Example.vnano --permission balanced");
        System.out.println("");
        System.out.println("");
        System.out.println("  --test");
        System.out.println("");
        System.out.println("      Vnano \u306e\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u306e\u5168\u4f53\u30c6\u30b9\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("    \u4f7f\u7528\u4f8b");
        System.out.println("");
        System.out.println("      java -jar Vnano.jar --test");
        System.out.println("");
        System.out.println("");
        System.out.println("[ \u6a19\u6e96\u3067\u4f7f\u7528\u3067\u304d\u308b\u95a2\u6570 ]");
        System.out.println("");
        System.out.println("    \u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u3067\u306f\u3001\u958b\u767a\u3084\u30c7\u30d0\u30c3\u30b0\u6642\u306e\u5229\u4fbf\u6027\u306e\u305f\u3081\u3001\u4ee5\u4e0b\u306e\u95a2\u6570\u304c\u6a19\u6e96\u3067\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("      void output(int)");
        System.out.println("      void output(long)");
        System.out.println("      void output(float)");
        System.out.println("      void output(double)");
        System.out.println("      void output(bool)");
        System.out.println("      void output(string)");
        System.out.println("      int  time()");
        System.out.println("");
        System.out.println("    \u4e00\u65b9\u3067\u3053\u308c\u3089\u306f\u3001\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u3092\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306b\u7d44\u307f\u8fbc\u3093\u3060\u969b\u306a\u3069\u306b\u306f\u3001");
        System.out.println("    \u6a19\u6e96\u3067\u306f\u4f7f\u3048\u306a\u3044\u4e8b\u306b\u7559\u610f\u304c\u5fc5\u8981\u3067\u3059\u3002\u6a19\u6e96\u3067\u4f7f\u3048\u308b\u306e\u306f\u3001\u3042\u304f\u307e\u3067\u3082\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u3067\u306e\u307f\u3067\u3059\u3002");
        System.out.println("");
        System.out.println("    \u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3078\u306e\u7d44\u307f\u8fbc\u307f\u6642\u306b\u3001\u4e0a\u8a18\u306e\u95a2\u6570\u3084\u3001\u305d\u306e\u4ed6\u306e\u57fa\u672c\u7684\u306a\u95a2\u6570\u3092\u4f7f\u7528\u53ef\u80fd\u306b\u3059\u308b\u306b\u306f\u3001");
        System.out.println("    Vnano\u6a19\u6e96\u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u5c0e\u5165\u3057\u3001\u8aad\u307f\u8fbc\u307f\u8a2d\u5b9a\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
        System.out.println("    \u8a73\u7d30\u306f\u3000Vnano Engine \u306e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u3054\u53c2\u7167\u304f\u3060\u3055\u3044\u3002");
        System.out.println("");
    }

    public static void main(String[] stringArray) {
        VnanoCommandLineApplication vnanoCommandLineApplication = new VnanoCommandLineApplication();
        vnanoCommandLineApplication.dispatch(stringArray);
    }

    public void dispatch(String[] stringArray) {
        String string;
        String string2;
        String string3;
        int n = stringArray.length;
        if (n == 0) {
            this.help();
            return;
        }
        if (n == 1 && stringArray[0].equals("--help")) {
            this.help();
            return;
        }
        Map<String, String> map = this.parseArguments(stringArray);
        boolean bl = true;
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> object2 : set) {
            if (!bl) break;
            string3 = object2.getKey();
            string2 = object2.getValue();
            bl &= this.dispatchOptionProcessing(string3, string2);
        }
        boolean bl2 = this.isScriptFileNecessary(map);
        if (this.optCombinedTestRequired) {
            bl &= this.executeCombinedTest();
        }
        if (!bl) {
            System.exit(1);
        }
        if (bl2 && !map.containsKey("file")) {
            System.err.println("No script file is specified.");
            System.exit(1);
        }
        if ((string = map.get("file")) != null) {
            string3 = null;
            if (this.optLibraryListFilePath != null) {
                string3 = this.optLibraryListFilePath;
            } else if (new File(DEFAULT_LIBRARY_LIST_FILE_PATH).exists()) {
                string3 = DEFAULT_LIBRARY_LIST_FILE_PATH;
            }
            string2 = null;
            if (this.optPluginListFilePath != null) {
                string2 = this.optPluginListFilePath;
            } else if (new File(DEFAULT_PLUGIN_LIST_FILE_PATH).exists()) {
                string2 = DEFAULT_PLUGIN_LIST_FILE_PATH;
            }
            String string4 = map.containsKey(COMMAND_OPTNAME_ENCODING) ? map.get(COMMAND_OPTNAME_ENCODING) : DEFAULT_ENCODING;
            try {
                this.executeFile(string, string3, string2, string4);
            }
            catch (VnanoException vnanoException) {
                this.dumpException(vnanoException);
                if (!this.engineOptionMap.containsKey("DUMPER_ENABLED")) {
                    System.err.println("For more debug information, re-execute the script with \"--dump\" option.");
                }
                System.exit(1);
            }
        }
    }

    private boolean isScriptFileNecessary(Map<String, String> map) {
        if (map.containsKey(COMMAND_OPTNAME_HELP)) {
            return false;
        }
        if (map.containsKey(COMMAND_OPTNAME_TEST)) {
            return false;
        }
        return !map.containsKey(COMMAND_OPTNAME_VERSION);
    }

    public boolean dispatchOptionProcessing(String string, String string2) {
        if (string == null) {
            System.err.println("Fatal error: option name is null.");
            return false;
        }
        switch (string) {
            case "file": {
                return true;
            }
            case "help": {
                this.help();
                return true;
            }
            case "run": {
                this.engineOptionMap.put("RUNNING_ENABLED", Boolean.valueOf(string2));
                return true;
            }
            case "version": {
                System.out.println("RINEARN Vnano Engine 1.1.4");
                return true;
            }
            case "accelerator": {
                if (!string2.equals("true") && !string2.equals("false")) {
                    System.err.println("Invalid value for --acceleratoroption: " + string2);
                    return false;
                }
                this.engineOptionMap.put("ACCELERATOR_ENABLED", Boolean.valueOf(string2));
                return true;
            }
            case "optLevel": {
                int n = -1;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("The value for --accelerator should be an integer: " + string2);
                    return false;
                }
                this.engineOptionMap.put("ACCELERATOR_OPTIMIZATION_LEVEL", n);
                return true;
            }
            case "terminator": {
                if (!string2.equals("true") && !string2.equals("false")) {
                    System.err.println("Invalid value for --terminatoroption: " + string2);
                    return false;
                }
                this.engineOptionMap.put("TERMINATOR_ENABLED", Boolean.valueOf(string2));
                return true;
            }
            case "locale": {
                this.locale = 0 < string2.indexOf("-") && string2.indexOf("-") < string2.length() - 1 ? (string2.toLowerCase().equals("ja-jp") ? Locale.JAPANESE : Locale.ENGLISH) : (string2.toLowerCase().equals("ja") || string2.toLowerCase().equals("jp") ? Locale.JAPANESE : Locale.ENGLISH);
                this.engineOptionMap.put("LOCALE", this.locale);
                return true;
            }
            case "encoding": {
                return true;
            }
            case "dump": {
                if (string2 == null) {
                    string2 = "all";
                }
                String string3 = null;
                if (!DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.containsKey(string2)) {
                    System.err.println("Invalid value for --dump option: " + string2);
                    return false;
                }
                string3 = DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.get(string2);
                this.engineOptionMap.put("DUMPER_TARGET", string3);
                this.engineOptionMap.put("DUMPER_ENABLED", Boolean.TRUE);
                return true;
            }
            case "perf": {
                this.perfEnabled = true;
                if (string2 == null) {
                    string2 = "all";
                }
                if (!PERF_TARGET_SET.contains(string2)) {
                    System.err.println("Invalid value for --perfoption: " + string2);
                    return false;
                }
                this.perfTarget = string2;
                this.engineOptionMap.put("PERFORMANCE_MONITOR_ENABLED", Boolean.TRUE);
                return true;
            }
            case "pluginDir": {
                String[] stringArray = new String[]{};
                if (string2 != null) {
                    stringArray = string2.split(System.getProperty("path.separator"));
                }
                for (String string4 : stringArray) {
                    this.optPluginDirList.add(string4);
                }
                return true;
            }
            case "plugin": {
                String[] stringArray = new String[]{};
                if (string2 != null) {
                    stringArray = string2.split(System.getProperty("path.separator"));
                }
                String[] stringArray2 = new String[]{DEFAULT_PLUGIN_DIR};
                if (0 < this.optPluginDirList.size()) {
                    stringArray2 = this.optPluginDirList.toArray(new String[0]);
                }
                int n = stringArray2.length;
                URL[] uRLArray = new URL[n];
                for (int i = 0; i < n; ++i) {
                    try {
                        uRLArray[i] = new File(stringArray2[i]).toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.print("Invalid plugin directory: " + stringArray2[i]);
                        return false;
                    }
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                ConnectorImplementationLoader connectorImplementationLoader = new ConnectorImplementationLoader(uRLClassLoader);
                for (String string5 : stringArray) {
                    try {
                        ConnectorImplementationContainer connectorImplementationContainer = connectorImplementationLoader.load(string5);
                        Object object = connectorImplementationContainer.getConnectorImplementation();
                        this.optPluginList.add(object);
                    }
                    catch (ConnectorException connectorException) {
                        System.err.println("Plug-in connection failed: " + string5);
                        connectorException.printStackTrace();
                    }
                }
                return true;
            }
            case "pluginList": {
                this.optPluginListFilePath = string2;
                return true;
            }
            case "libList": {
                this.optLibraryListFilePath = string2;
                return true;
            }
            case "permission": {
                if (string2 == null) {
                    System.err.println("No value is specified for --permission option.");
                    return false;
                }
                switch (string2) {
                    case "denyAll": {
                        this.permissionMap = PERMISSION_MAP_DENY_ALL;
                        return true;
                    }
                    case "allowAll": {
                        this.permissionMap = PERMISSION_MAP_ALLOW_ALL;
                        return true;
                    }
                    case "askAll": {
                        this.permissionMap = PERMISSION_MAP_ASK_ALL;
                        return true;
                    }
                    case "balanced": {
                        this.permissionMap = PERMISSION_MAP_BALANCED;
                        return true;
                    }
                }
                System.err.println("Invalid value for --permission option: " + string2);
                return false;
            }
            case "test": {
                this.optCombinedTestRequired = true;
                return true;
            }
        }
        System.err.println("Unknown option name: " + string);
        return false;
    }

    private Map<String, String> parseArguments(String[] stringArray) {
        int n = stringArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        boolean bl = false;
        String string = null;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].startsWith(COMMAND_OPTNAME_PREFIX)) {
                bl = true;
                string = stringArray[i].substring(COMMAND_OPTNAME_PREFIX.length(), stringArray[i].length());
                arrayList.add(string);
                continue;
            }
            if (bl) {
                linkedHashMap.put(string, stringArray[i]);
            } else {
                linkedHashMap.put("file", stringArray[i]);
            }
            bl = false;
            string = null;
        }
        for (String string2 : arrayList) {
            if (linkedHashMap.containsKey(string2)) continue;
            linkedHashMap.put(string2, null);
        }
        return linkedHashMap;
    }

    private VnanoEngine createInitializedVnanoEngine(Map<String, Object> map, Map<String, String> map2, PluginLoader pluginLoader) {
        String[] stringArray;
        VnanoEngine vnanoEngine = new VnanoEngine();
        try {
            vnanoEngine.setOptionMap(map);
            vnanoEngine.setPermissionMap(map2);
        }
        catch (VnanoException vnanoException) {
            System.out.println("Invalid option/permission settings have been detected.");
            vnanoException.printStackTrace();
            return null;
        }
        try {
            stringArray = new ScriptIO();
            vnanoEngine.connectPlugin("___VNANO_AUTO_KEY", new Object[]{ScriptIO.class.getMethod("output", Long.TYPE), stringArray});
            vnanoEngine.connectPlugin("___VNANO_AUTO_KEY", new Object[]{ScriptIO.class.getMethod("output", Double.TYPE), stringArray});
            vnanoEngine.connectPlugin("___VNANO_AUTO_KEY", new Object[]{ScriptIO.class.getMethod("output", Boolean.TYPE), stringArray});
            vnanoEngine.connectPlugin("___VNANO_AUTO_KEY", new Object[]{ScriptIO.class.getMethod("output", String.class), stringArray});
            vnanoEngine.connectPlugin("___VNANO_AUTO_KEY", new Object[]{ScriptIO.class.getMethod("time", new Class[0]), stringArray});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Method/field not found.");
            noSuchMethodException.printStackTrace();
            return null;
        }
        catch (VnanoException vnanoException) {
            System.err.println("Plug-in connection failed.");
            vnanoException.printStackTrace();
            return null;
        }
        try {
            pluginLoader.load();
            if (pluginLoader.hasPlugins()) {
                stringArray = pluginLoader.getPluginNames();
                Object[] objectArray = pluginLoader.getPluginInstances();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    vnanoEngine.connectPlugin("___VNANO_AUTO_KEY", objectArray[i]);
                }
            }
        }
        catch (VnanoException vnanoException) {
            System.err.println("Plug-in load failed.");
            vnanoException.printStackTrace();
        }
        return vnanoEngine;
    }

    private Interconnect createInitializedInterconnect(Map<String, Object> map, Map<String, String> map2, PluginLoader pluginLoader) {
        String[] stringArray;
        Interconnect interconnect = new Interconnect();
        try {
            interconnect.setOptionMap(map);
            interconnect.setPermissionMap(map2);
        }
        catch (VnanoException vnanoException) {
            System.out.println("Invalid option/permission settings have been detected.");
            vnanoException.printStackTrace();
        }
        try {
            stringArray = new ScriptIO();
            interconnect.connectPlugin("output(int)", new Object[]{ScriptIO.class.getMethod("output", Long.TYPE), stringArray});
            interconnect.connectPlugin("output(float)", new Object[]{ScriptIO.class.getMethod("output", Double.TYPE), stringArray});
            interconnect.connectPlugin("output(bool)", new Object[]{ScriptIO.class.getMethod("output", Boolean.TYPE), stringArray});
            interconnect.connectPlugin("output(string)", new Object[]{ScriptIO.class.getMethod("output", String.class), stringArray});
            interconnect.connectPlugin("time()", new Object[]{ScriptIO.class.getMethod("time", new Class[0]), stringArray});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Method/field not found.");
            noSuchMethodException.printStackTrace();
            return null;
        }
        catch (VnanoException vnanoException) {
            System.err.println("Method/field could not be connected.");
            vnanoException.printStackTrace();
        }
        try {
            pluginLoader.load();
            if (pluginLoader.hasPlugins()) {
                stringArray = pluginLoader.getPluginNames();
                Object[] objectArray = pluginLoader.getPluginInstances();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    interconnect.connectPlugin(stringArray[i], objectArray[i]);
                }
            }
        }
        catch (VnanoException vnanoException) {
            System.err.println("Plug-in load failed.");
            vnanoException.printStackTrace();
        }
        return interconnect;
    }

    private boolean executeCombinedTest() {
        VnanoEngine vnanoEngine = this.createInitializedVnanoEngine(this.engineOptionMap, this.permissionMap, new PluginLoader(DEFAULT_ENCODING));
        try {
            CombinedTestExecutor combinedTestExecutor = new CombinedTestExecutor();
            combinedTestExecutor.test(vnanoEngine);
            return true;
        }
        catch (CombinedTestException combinedTestException) {
            System.err.println("Combined test failed.");
            System.err.println("");
            System.err.println("[ Stack Trace ]");
            combinedTestException.printStackTrace();
            System.err.println("");
            if (!this.engineOptionMap.containsKey("DUMPER_ENABLED")) {
                System.err.println("For more debug information, re-execute combined tests with \"--dump\" option.");
            }
            return false;
        }
    }

    private void executeFile(String string, String string2, String string3, String string4) throws VnanoException {
        ScriptLoader scriptLoader = new ScriptLoader(string4);
        scriptLoader.setMainScriptPath(string);
        if (string2 != null) {
            scriptLoader.setLibraryScriptListPath(string2);
        }
        scriptLoader.load();
        PluginLoader pluginLoader = new PluginLoader(string4);
        if (string3 != null) {
            pluginLoader.setPluginListPath(string3);
        }
        pluginLoader.load();
        if (string.endsWith(EXTENSION_VNANO)) {
            this.executeVnanoScriptFile(scriptLoader, pluginLoader);
        } else if (string.endsWith(EXTENSION_VRIL)) {
            this.executeVrilCodeFile(scriptLoader, pluginLoader);
        } else {
            System.err.println("Unknown file type (extension): " + string);
        }
    }

    public void executeVnanoScriptFile(ScriptLoader scriptLoader, PluginLoader pluginLoader) throws VnanoException {
        int n;
        int n2;
        Object object;
        this.engineOptionMap.put("MAIN_SCRIPT_NAME", scriptLoader.getMainScriptName());
        this.engineOptionMap.put("UI_MODE", "CUI");
        this.engineOptionMap = OptionValue.normalizeValuesOf(this.engineOptionMap);
        VnanoEngine vnanoEngine = this.createInitializedVnanoEngine(this.engineOptionMap, this.permissionMap, pluginLoader);
        if (scriptLoader.hasLibraryScripts()) {
            object = scriptLoader.getLibraryScriptPaths(true);
            String[] stringArray = scriptLoader.getLibraryScriptContents();
            n2 = ((String[])object).length;
            for (n = 0; n < n2; n += 1) {
                vnanoEngine.registerLibraryScript(object[n], stringArray[n]);
            }
        }
        object = null;
        if (this.perfEnabled) {
            boolean bl = this.perfTarget.equals("all") || this.perfTarget.equals(PERF_TARGET_SPEED);
            n2 = this.perfTarget.equals("all") || this.perfTarget.equals(PERF_TARGET_RAM) ? 1 : 0;
            n = this.perfTarget.equals("all") || this.perfTarget.equals(PERF_TARGET_INSTRUCTION_FREQ) ? 1 : 0;
            object = new PerformanceValuePrinter(vnanoEngine, bl, n2 != 0, n != 0);
            Thread thread = new Thread((Runnable)object);
            thread.start();
        }
        vnanoEngine.executeScript(scriptLoader.getMainScriptContent());
        if (this.perfEnabled) {
            object.terminate();
        }
        vnanoEngine.disconnectAllPlugins();
    }

    public void executeVrilCodeFile(ScriptLoader scriptLoader, PluginLoader pluginLoader) throws VnanoException {
        this.engineOptionMap.put("MAIN_SCRIPT_NAME", scriptLoader.getMainScriptName());
        this.engineOptionMap.put("UI_MODE", "CUI");
        this.engineOptionMap = OptionValue.normalizeValuesOf(this.engineOptionMap);
        Interconnect interconnect = this.createInitializedInterconnect(this.engineOptionMap, this.permissionMap, pluginLoader);
        if (interconnect == null) {
            return;
        }
        interconnect.activate();
        VirtualMachine virtualMachine = new VirtualMachine();
        PerformanceValuePrinter performanceValuePrinter = null;
        if (this.perfEnabled) {
            boolean bl = this.perfTarget.equals("all") || this.perfTarget.equals(PERF_TARGET_SPEED);
            boolean bl2 = this.perfTarget.equals("all") || this.perfTarget.equals(PERF_TARGET_RAM);
            boolean bl3 = this.perfTarget.equals("all") || this.perfTarget.equals(PERF_TARGET_INSTRUCTION_FREQ);
            performanceValuePrinter = new PerformanceValuePrinter(virtualMachine, bl, bl2, bl3);
            Thread thread = new Thread(performanceValuePrinter);
            thread.start();
        }
        virtualMachine.executeAssemblyCode(scriptLoader.getMainScriptContent(), interconnect);
        if (this.perfEnabled) {
            performanceValuePrinter.terminate();
        }
        interconnect.deactivate();
        interconnect.disconnectAllPlugins();
    }

    public void dumpException(Exception exception) {
        exception.printStackTrace();
        System.err.println("");
    }

    static {
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_INPUTTED_CODE, "INPUTTED_CODE");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_PREPROCESSED_CODE, "PREPROCESSED_CODE");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_TOKEN, "TOKEN");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_PARSED_AST, "PARSED_AST");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_ANALYZED_AST, "ANALYZED_AST");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_ASSEMBLY_CODE, "ASSEMBLY_CODE");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_OBJECT_CODE, "OBJECT_CODE");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_ACCELERATOR_CODE, "ACCELERATOR_CODE");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put(DUMP_TARGET_ACCELERATOR_STATE, "ACCELERATOR_STATE");
        DUMP_TARGET_COMMANDOPT_ENGINEOPT_MAP.put("all", "ALL");
        PERF_TARGET_SET = new HashSet<String>();
        PERF_TARGET_SET.add(PERF_TARGET_SPEED);
        PERF_TARGET_SET.add(PERF_TARGET_RAM);
        PERF_TARGET_SET.add(PERF_TARGET_INSTRUCTION_FREQ);
        PERF_TARGET_SET.add("all");
        PERMISSION_MAP_DENY_ALL = new HashMap<String, String>(){
            {
                this.put("DEFAULT", "DENY");
            }
        };
        PERMISSION_MAP_ALLOW_ALL = new HashMap<String, String>(){
            {
                this.put("DEFAULT", "ALLOW");
            }
        };
        PERMISSION_MAP_ASK_ALL = new HashMap<String, String>(){
            {
                this.put("DEFAULT", "ASK");
            }
        };
        PERMISSION_MAP_BALANCED = new HashMap<String, String>(){
            {
                this.put("DEFAULT", "ASK");
                this.put("PROGRAM_EXIT", "ALLOW");
                this.put("PROGRAM_RESET", "ALLOW");
                this.put("DIRECTORY_CREATE", "ALLOW");
                this.put("DIRECTORY_LIST", "ALLOW");
                this.put("FILE_CREATE", "ALLOW");
                this.put("FILE_WRITE", "ALLOW");
                this.put("FILE_READ", "ALLOW");
            }
        };
    }

    public class ScriptIO {
        private long launchedTime = System.nanoTime() / 1000000L;

        public void output(long l) {
            System.out.println(l);
        }

        public void output(double d) {
            System.out.println(d);
        }

        public void output(boolean bl) {
            System.out.println(bl);
        }

        public void output(String string) {
            System.out.println(string);
        }

        public long time() {
            return System.nanoTime() / 1000000L - this.launchedTime;
        }
    }
}

