/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.BoolScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolCachedScalarLogicalUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        BoolCachedScalarLogicalNode boolCachedScalarLogicalNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ANDM: {
                boolCachedScalarLogicalNode = new BoolCachedScalarAndNode((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], acceleratorExecutionNode);
                break;
            }
            case ORM: {
                boolCachedScalarLogicalNode = new BoolCachedScalarOrNode((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], acceleratorExecutionNode);
                break;
            }
            case NOT: {
                boolCachedScalarLogicalNode = new BoolCachedScalarNotNode((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return boolCachedScalarLogicalNode;
    }

    private final class BoolCachedScalarAndNode
    extends BoolCachedScalarLogicalNode {
        public BoolCachedScalarAndNode(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(boolScalarCache, boolScalarCache2, boolScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data && this.cache2.data;
            return this.nextNode;
        }
    }

    private final class BoolCachedScalarOrNode
    extends BoolCachedScalarLogicalNode {
        public BoolCachedScalarOrNode(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(boolScalarCache, boolScalarCache2, boolScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data || this.cache2.data;
            return this.nextNode;
        }
    }

    private final class BoolCachedScalarNotNode
    extends BoolCachedScalarLogicalNode {
        public BoolCachedScalarNotNode(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(boolScalarCache, boolScalarCache2, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = !this.cache1.data;
            return this.nextNode;
        }
    }

    private abstract class BoolCachedScalarLogicalNode
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache cache0;
        protected final BoolScalarCache cache1;
        protected final BoolScalarCache cache2;

        public BoolCachedScalarLogicalNode(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = boolScalarCache;
            this.cache1 = boolScalarCache2;
            this.cache2 = boolScalarCache3;
        }

        public BoolCachedScalarLogicalNode(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = boolScalarCache;
            this.cache1 = boolScalarCache2;
            this.cache2 = null;
        }
    }
}

