/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Boolx1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolScalarBranchUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<boolean[]> dataContainer = dataContainerArray[2];
        Boolx1ScalarCacheSynchronizer boolx1ScalarCacheSynchronizer = new Boolx1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray, 2);
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case JMP: {
                acceleratorExecutionNode2 = new ScalarJmpNode(dataContainer, boolx1ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case JMPN: {
                acceleratorExecutionNode2 = new ScalarJmpnNode(dataContainer, boolx1ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return acceleratorExecutionNode2;
    }

    private final class ScalarJmpNode
    extends AcceleratorExecutionNode {
        private final DataContainer<boolean[]> conditionContainer;
        private final Boolx1ScalarCacheSynchronizer synchronizer;
        private AcceleratorExecutionNode branchedNode;

        public ScalarJmpNode(DataContainer<boolean[]> dataContainer, Boolx1ScalarCacheSynchronizer boolx1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.branchedNode = null;
            this.conditionContainer = dataContainer;
            this.synchronizer = boolx1ScalarCacheSynchronizer;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            if (this.conditionContainer.getArrayData()[this.conditionContainer.getArrayOffset()]) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class ScalarJmpnNode
    extends AcceleratorExecutionNode {
        private final DataContainer<boolean[]> conditionContainer;
        private final Boolx1ScalarCacheSynchronizer synchronizer;
        private AcceleratorExecutionNode branchedNode;

        public ScalarJmpnNode(DataContainer<boolean[]> dataContainer, Boolx1ScalarCacheSynchronizer boolx1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.branchedNode = null;
            this.conditionContainer = dataContainer;
            this.synchronizer = boolx1ScalarCacheSynchronizer;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            if (this.conditionContainer.getArrayData()[this.conditionContainer.getArrayOffset()]) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }
}

