/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64x1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64ScalarVectorTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        Float64ScalarVectorMovNode float64ScalarVectorMovNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: {
                Float64x1ScalarCacheSynchronizer float64x1ScalarCacheSynchronizer = new Float64x1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray, 0);
                float64ScalarVectorMovNode = new Float64ScalarVectorMovNode(dataContainerArray[0], dataContainerArray[1], float64x1ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return float64ScalarVectorMovNode;
    }

    private final class Float64ScalarVectorMovNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container0;
        protected final DataContainer<double[]> container1;
        protected final Float64x1ScalarCacheSynchronizer synchronizer;

        public Float64ScalarVectorMovNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Float64x1ScalarCacheSynchronizer float64x1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = float64x1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() throws VnanoException {
            if (this.container1.getArraySize() != 1) {
                throw new VnanoException(ErrorType.ARRAY_SIZE_IS_TOO_LARGE_TO_BE_ASSIGNED_TO_SCALAR_VARIABLE);
            }
            double[] dArray = this.container0.getArrayData();
            double[] dArray2 = this.container1.getArrayData();
            dArray[this.container0.getArrayOffset()] = dArray2[0];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

