/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64ScalarVectorTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        Int64ScalarVectorMovNode int64ScalarVectorMovNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: {
                Int64x1ScalarCacheSynchronizer int64x1ScalarCacheSynchronizer = new Int64x1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray, 0);
                int64ScalarVectorMovNode = new Int64ScalarVectorMovNode(dataContainerArray[0], dataContainerArray[1], int64x1ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return int64ScalarVectorMovNode;
    }

    private final class Int64ScalarVectorMovNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<long[]> container1;
        protected final Int64x1ScalarCacheSynchronizer synchronizer;

        public Int64ScalarVectorMovNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x1ScalarCacheSynchronizer int64x1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = int64x1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() throws VnanoException {
            if (this.container1.getArraySize() != 1) {
                throw new VnanoException(ErrorType.ARRAY_SIZE_IS_TOO_LARGE_TO_BE_ASSIGNED_TO_SCALAR_VARIABLE);
            }
            long[] lArray = this.container0.getArrayData();
            long[] lArray2 = this.container1.getArrayData();
            lArray[this.container0.getArrayOffset()] = lArray2[0];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

