/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.Arrays;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x1Float64x1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64x2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64VectorTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: {
                Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                acceleratorExecutionNode2 = new Int64VectorMovNode(dataContainerArray[0], dataContainerArray[1], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case CAST: {
                if (acceleratorInstruction.getDataTypes()[1] == DataType.INT64) {
                    Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                    acceleratorExecutionNode2 = new Int64VectorMovNode(dataContainerArray[0], dataContainerArray[1], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                if (acceleratorInstruction.getDataTypes()[1] == DataType.FLOAT64) {
                    Int64x1Float64x1ScalarCacheSynchronizer int64x1Float64x1ScalarCacheSynchronizer = new Int64x1Float64x1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                    acceleratorExecutionNode2 = new Int64FromFloat64VectorCastNode(dataContainerArray[0], dataContainerArray[1], int64x1Float64x1ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException((Object)((Object)acceleratorInstruction.getDataTypes()[1]) + "-type operand of " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " instruction is invalid for " + this.getClass().getCanonicalName());
            }
            case FILL: {
                Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                acceleratorExecutionNode2 = new Int64VectorFillNode(dataContainerArray[0], dataContainerArray[1], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return acceleratorExecutionNode2;
    }

    private final class Int64VectorMovNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<long[]> container1;
        protected final Int64x2ScalarCacheSynchronizer synchronizer;

        public Int64VectorMovNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = int64x2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            long[] lArray = this.container0.getArrayData();
            long[] lArray2 = this.container1.getArrayData();
            int n = this.container0.getArraySize();
            System.arraycopy(lArray2, 0, lArray, 0, n);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64FromFloat64VectorCastNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<double[]> container1;
        protected final Int64x1Float64x1ScalarCacheSynchronizer synchronizer;

        public Int64FromFloat64VectorCastNode(DataContainer<long[]> dataContainer, DataContainer<double[]> dataContainer2, Int64x1Float64x1ScalarCacheSynchronizer int64x1Float64x1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = int64x1Float64x1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            long[] lArray = this.container0.getArrayData();
            double[] dArray = this.container1.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                lArray[i] = (long)dArray[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorFillNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<long[]> container1;
        protected final Int64x2ScalarCacheSynchronizer synchronizer;

        public Int64VectorFillNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = int64x2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            long[] lArray = this.container0.getArrayData();
            long l = this.container1.getArrayData()[this.container1.getArrayOffset()];
            Arrays.fill(lArray, l);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

