/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.assembler;

import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.AbstractFunction;
import org.vcssl.nano.interconnect.AbstractVariable;
import org.vcssl.nano.interconnect.FunctionTable;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.interconnect.VariableTable;
import org.vcssl.nano.spec.AssemblyWord;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.LiteralSyntax;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.VirtualMachineObjectCode;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;

public class Assembler {
    public VirtualMachineObjectCode assemble(String string, Interconnect interconnect) throws VnanoException {
        String[] stringArray = LiteralSyntax.extractStringLiterals(string);
        string = stringArray[0];
        string = this.appendLabelInstructions(string);
        VariableTable variableTable = interconnect.getExternalVariableTable();
        FunctionTable functionTable = interconnect.getExternalFunctionTable();
        VirtualMachineObjectCode virtualMachineObjectCode = this.preprocessDirectives(string, variableTable, functionTable);
        int n = 0;
        int n2 = 0;
        String[] stringArray2 = string.split(";");
        int n3 = stringArray2.length;
        int n4 = -1;
        String string2 = "(none)";
        int n5 = -1;
        for (int i = 0; i < n3; ++i) {
            int n6;
            DataType[] dataTypeArray;
            String[] stringArray3;
            String string3 = stringArray2[i].trim();
            if (string3.length() == 0) continue;
            String[] stringArray4 = string3.split("\t| ");
            int n7 = stringArray4.length;
            if (string3.startsWith("#META")) {
                int n8 = LiteralSyntax.getIndexOfNumberedStringLiteral(stringArray4[1].trim());
                stringArray3 = stringArray[n8];
                String string4 = Character.toString('~') + DataTypeName.getDataTypeNameOf(DataType.STRING) + ":" + (String)stringArray3;
                dataTypeArray = this.parseImmediateValue(string4);
                virtualMachineObjectCode.addConstantData(string4, (DataContainer<?>)dataTypeArray, n2);
                n4 = n2++;
                continue;
            }
            if (string3.startsWith(Character.toString('#'))) continue;
            OperationCode operationCode = OperationCode.valueOf(stringArray4[0]);
            stringArray3 = stringArray4[1].split(":");
            int n9 = stringArray3.length;
            dataTypeArray = new DataType[n9];
            for (n6 = 0; n6 < n9; ++n6) {
                try {
                    dataTypeArray[n6] = DataTypeName.getDataTypeOf(stringArray3[n6]);
                    continue;
                }
                catch (VnanoException vnanoException) {
                    vnanoException.setFileName(string2);
                    vnanoException.setLineNumber(n5);
                    throw vnanoException;
                }
            }
            n6 = n7 - 2;
            Memory.Partition[] partitionArray = new Memory.Partition[n6];
            int[] nArray = new int[n6];
            for (int j = 0; j < n6; ++j) {
                DataContainer<?> dataContainer;
                int n10 = j + 2;
                String string5 = stringArray4[n10].trim();
                char c = string5.charAt(0);
                if (c == '~') {
                    if (virtualMachineObjectCode.containsConstantData(string5)) {
                        nArray[j] = virtualMachineObjectCode.getConstantDataAddress(string5);
                    } else {
                        Object object;
                        if (this.getDataTypeOfImmediateValueLiteral(string5) == DataType.STRING) {
                            object = this.getValuePartOfImmediateValueLiteral(string5);
                            int n11 = LiteralSyntax.getIndexOfNumberedStringLiteral((String)object);
                            object = stringArray[n11];
                            object = LiteralSyntax.decodeEscapeSequences((String)object);
                            string5 = this.replaceImmediateValue(string5, (String)object);
                        }
                        nArray[j] = n2;
                        object = this.parseImmediateValue(string5);
                        virtualMachineObjectCode.addConstantData(string5, (DataContainer<?>)object, n2);
                        ++n2;
                    }
                    partitionArray[j] = Memory.Partition.CONSTANT;
                    continue;
                }
                if (c == 'R') {
                    int n12;
                    String string6 = string5.substring(1, string5.length());
                    nArray[j] = n12 = Integer.parseInt(string6);
                    if (!virtualMachineObjectCode.containsRegister(n12)) {
                        virtualMachineObjectCode.addRegister(n12);
                    }
                    partitionArray[j] = Memory.Partition.REGISTER;
                    if (n >= nArray[j]) continue;
                    n = nArray[j];
                    continue;
                }
                if (c == '_') {
                    if (virtualMachineObjectCode.containsLocalVariable(string5)) {
                        nArray[j] = virtualMachineObjectCode.getLocalVariableAddress(string5);
                        partitionArray[j] = Memory.Partition.LOCAL;
                        continue;
                    }
                    if (virtualMachineObjectCode.containsGlobalVariable(string5)) {
                        nArray[j] = virtualMachineObjectCode.getGlobalVariableAddress(string5);
                        partitionArray[j] = Memory.Partition.GLOBAL;
                        continue;
                    }
                    if (virtualMachineObjectCode.containsFunction(string5)) {
                        int n13 = virtualMachineObjectCode.getFunctionAddress(string5);
                        String string7 = Character.toString('~') + DataTypeName.getDataTypeNameOf(DataType.INT64) + ":" + Integer.toString(n13);
                        partitionArray[j] = Memory.Partition.CONSTANT;
                        nArray[j] = n2;
                        dataContainer = this.parseImmediateValue(string7);
                        virtualMachineObjectCode.addConstantData(string7, dataContainer, n2);
                        ++n2;
                        continue;
                    }
                    throw new VnanoFatalException("Undefined identifier has detected in operands: " + string5);
                }
                if (c == '&') {
                    int n14 = virtualMachineObjectCode.getLabelAddress(string5);
                    String string8 = Character.toString('~') + DataTypeName.getDataTypeNameOf(DataType.INT64) + ":" + Integer.toString(n14);
                    partitionArray[j] = Memory.Partition.CONSTANT;
                    nArray[j] = n2;
                    dataContainer = this.parseImmediateValue(string8);
                    virtualMachineObjectCode.addConstantData(string8, dataContainer, n2);
                    ++n2;
                    continue;
                }
                if (c != '-') continue;
                nArray[j] = 0;
                partitionArray[j] = Memory.Partition.NONE;
            }
            virtualMachineObjectCode.addInstruction(new Instruction(operationCode, dataTypeArray, partitionArray, nArray, Memory.Partition.CONSTANT, n4));
        }
        return virtualMachineObjectCode;
    }

    private String appendLabelInstructions(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split(";")) {
            stringBuilder.append(string2);
            stringBuilder.append(";");
            string2 = string2.trim();
            String string3 = AssemblyWord.LINE_SEPARATOR + "\t" + OperationCode.LABEL.name() + "\t" + "void" + "\t" + '-' + ";";
            if (string2.length() == 0) continue;
            if (string2.startsWith("#LABEL")) {
                stringBuilder.append(string3);
                continue;
            }
            String[] stringArray = string2.split("\t| ");
            String string4 = stringArray[0];
            if (!string4.equals(OperationCode.CALL.name())) continue;
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private DataContainer<?> parseImmediateValue(String string) throws VnanoException {
        int n = string.indexOf(":");
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1, string.length());
        DataType dataType = DataTypeName.getDataTypeOf(string2);
        switch (dataType) {
            case INT64: {
                DataContainer dataContainer = new DataContainer();
                try {
                    if (string3.startsWith("0x")) {
                        string3 = string3.substring("0x".length());
                        dataContainer.setInt64ScalarData(Long.parseLong(string3, 16));
                    } else if (string3.startsWith("0o")) {
                        string3 = string3.substring("0o".length());
                        dataContainer.setInt64ScalarData(Long.parseLong(string3, 8));
                    } else if (string3.startsWith("0b")) {
                        string3 = string3.substring("0b".length());
                        dataContainer.setInt64ScalarData(Long.parseLong(string3, 2));
                    } else {
                        dataContainer.setInt64ScalarData(Long.parseLong(string3));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    VnanoException vnanoException = new VnanoException(ErrorType.INVALID_IMMEDIATE_VALUE, new String[]{string3});
                    throw vnanoException;
                }
                return dataContainer;
            }
            case FLOAT64: {
                DataContainer dataContainer = new DataContainer();
                try {
                    dataContainer.setFloat64ScalarData(Double.parseDouble(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    VnanoException vnanoException = new VnanoException(ErrorType.INVALID_IMMEDIATE_VALUE, new String[]{string3});
                    throw vnanoException;
                }
                return dataContainer;
            }
            case BOOL: {
                DataContainer dataContainer = new DataContainer();
                if (string3.equals("true")) {
                    dataContainer.setBoolScalarData(true);
                } else if (string3.equals("false")) {
                    dataContainer.setBoolScalarData(false);
                } else {
                    VnanoException vnanoException = new VnanoException(ErrorType.INVALID_IMMEDIATE_VALUE, new String[]{string3});
                    throw vnanoException;
                }
                return dataContainer;
            }
            case STRING: {
                DataContainer dataContainer = new DataContainer();
                string3 = string3.substring(1, string3.length() - 1);
                dataContainer.setStringScalarData(string3);
                return dataContainer;
            }
        }
        throw new VnanoFatalException("Unknown literal data type: " + (Object)((Object)dataType));
    }

    private DataType getDataTypeOfImmediateValueLiteral(String string) throws VnanoException {
        int n = string.indexOf(":");
        String string2 = string.substring(1, n);
        DataType dataType = DataTypeName.getDataTypeOf(string2);
        return dataType;
    }

    private String getValuePartOfImmediateValueLiteral(String string) {
        int n = string.indexOf(":");
        String string2 = string.substring(n + 1, string.length());
        return string2;
    }

    private String replaceImmediateValue(String string, String string2) {
        int n = string.indexOf(":");
        String string3 = string.substring(0, n);
        String string4 = string3 + ":" + string2;
        return string4;
    }

    private VirtualMachineObjectCode preprocessDirectives(String string, VariableTable variableTable, FunctionTable functionTable) {
        VirtualMachineObjectCode virtualMachineObjectCode = new VirtualMachineObjectCode();
        int n = 0;
        String[] stringArray = string.split(";");
        int n2 = stringArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Object object;
            String string2;
            String string3 = stringArray[i].trim();
            if (string3.length() == 0) continue;
            String[] stringArray2 = string3.split("\t| ");
            if (string3.startsWith("#LOCAL_VARIABLE")) {
                string2 = stringArray2[1];
                virtualMachineObjectCode.addLocalVariable(string2, n);
                ++n;
            }
            if (string3.startsWith("#GLOBAL_VARIABLE")) {
                string2 = stringArray2[1];
                object = variableTable.getVariableByAssemblyIdentifier(string2);
                int n4 = variableTable.getIndexOf((AbstractVariable)object);
                virtualMachineObjectCode.addGlobalVariable(string2, n4);
            }
            if (string3.startsWith("#GLOBAL_FUNCTION")) {
                string2 = stringArray2[1];
                object = string2.substring(1, string2.length());
                AbstractFunction abstractFunction = functionTable.getFunctionBySignature((String)object);
                int n5 = functionTable.getIndexOf(abstractFunction);
                virtualMachineObjectCode.addFunction(string2, n5);
            }
            if (string3.startsWith("#LABEL")) {
                string2 = stringArray2[1];
                virtualMachineObjectCode.addLabel(string2, n3);
            }
            if (string3.startsWith(Character.toString('#'))) continue;
            ++n3;
        }
        return virtualMachineObjectCode;
    }
}

