/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.memory;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.AbstractVariable;
import org.vcssl.nano.interconnect.VariableTable;
import org.vcssl.nano.vm.VirtualMachineObjectCode;
import org.vcssl.nano.vm.memory.DataContainer;

public final class Memory {
    private List<DataContainer<?>> globalList;
    private List<DataContainer<?>> localList;
    private List<DataContainer<?>> constantList;
    private List<DataContainer<?>> registerList = new ArrayList();
    private Deque<DataContainer<?>> stack;
    private DataContainer<?> resultContainer;
    private DataContainer<Void> voidContainer;
    private HashMap<Partition, List<DataContainer<?>>> containerListMap;

    public Memory() {
        this.localList = new ArrayList();
        this.globalList = new ArrayList();
        this.constantList = new ArrayList();
        this.stack = new ArrayDeque();
        this.containerListMap = new HashMap();
        this.containerListMap.put(Partition.REGISTER, this.registerList);
        this.containerListMap.put(Partition.LOCAL, this.localList);
        this.containerListMap.put(Partition.GLOBAL, this.globalList);
        this.containerListMap.put(Partition.CONSTANT, this.constantList);
        this.voidContainer = new DataContainer();
    }

    public final int getSize(Partition partition) {
        if (partition == Partition.STACK) {
            return this.stack.size();
        }
        return this.containerListMap.get((Object)partition).size();
    }

    public final DataContainer<?> getDataContainer(Partition partition, int n) {
        if (partition == Partition.NONE) {
            return this.voidContainer;
        }
        if (!this.containerListMap.containsKey((Object)partition)) {
            throw new VnanoFatalException("Unsupported operation for " + (Object)((Object)partition) + " partition.");
        }
        List<DataContainer<?>> list = this.containerListMap.get((Object)partition);
        try {
            return list.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new VnanoFatalException("Address " + n + " is out of bounds of the " + (Object)((Object)partition) + " partition.");
        }
    }

    public final void setDataContainer(Partition partition, int n, DataContainer<?> dataContainer) {
        if (!this.containerListMap.containsKey((Object)partition)) {
            throw new VnanoFatalException("Unsupported operation for " + (Object)((Object)partition) + " partition.");
        }
        List<DataContainer<?>> list = this.containerListMap.get((Object)partition);
        if (n < list.size()) {
            list.set(n, dataContainer);
        } else if (n == list.size()) {
            list.add(dataContainer);
        } else {
            this.paddList(list, n - list.size());
            list.add(dataContainer);
        }
    }

    public final void setDataContainers(Partition partition, DataContainer<?>[] dataContainerArray) {
        if (!this.containerListMap.containsKey((Object)partition)) {
            throw new VnanoFatalException("Unsupported operation for " + (Object)((Object)partition) + " partition.");
        }
        List<DataContainer<?>> list = this.containerListMap.get((Object)partition);
        list.clear();
        for (DataContainer<?> dataContainer : dataContainerArray) {
            list.add(dataContainer);
        }
    }

    public final DataContainer<?>[] getDataContainers(Partition partition) {
        if (!this.containerListMap.containsKey((Object)partition)) {
            throw new VnanoFatalException("Unsupported operation for " + (Object)((Object)partition) + " partition.");
        }
        List<DataContainer<?>> list = this.containerListMap.get((Object)partition);
        return list.toArray(new DataContainer[0]);
    }

    private final void paddList(List<DataContainer<?>> list, int n) {
        for (int i = 0; i < n; ++i) {
            list.add(new DataContainer());
        }
    }

    public final void push(DataContainer<?> dataContainer) {
        this.stack.push(dataContainer);
    }

    public final DataContainer<?> pop() {
        return this.stack.pop();
    }

    public final DataContainer<?> peek() {
        return this.stack.peek();
    }

    public final boolean hasResultDataContainer() {
        return this.resultContainer != null;
    }

    public final void setResultDataContainer(DataContainer<?> dataContainer) {
        this.resultContainer = dataContainer;
    }

    public final DataContainer<?> getResultDataContainer() {
        return this.resultContainer;
    }

    public final void allocate(VirtualMachineObjectCode virtualMachineObjectCode, VariableTable variableTable) throws VnanoException {
        DataContainer<?>[] dataContainerArray;
        int n;
        int n2;
        int n3;
        this.registerList.clear();
        int n4 = virtualMachineObjectCode.getMaximumRegisterAddress();
        for (n3 = 0; n3 <= n4; ++n3) {
            this.registerList.add(new DataContainer());
        }
        this.localList.clear();
        n3 = virtualMachineObjectCode.getMaximumLocalAddress();
        for (n2 = 0; n2 <= n3; ++n2) {
            this.localList.add(new DataContainer());
        }
        this.globalList.clear();
        n2 = variableTable.getSize();
        for (n = 0; n < n2; ++n) {
            dataContainerArray = variableTable.getVariableByIndex(n);
            this.globalList.add(dataContainerArray.getDataContainer());
        }
        this.constantList.clear();
        n = virtualMachineObjectCode.getMaximumConstantAddress();
        dataContainerArray = virtualMachineObjectCode.getConstantDataContainers();
        for (int i = 0; i <= n; ++i) {
            this.constantList.add(dataContainerArray[i]);
        }
    }

    public final void updateGlobalPartitionData(VirtualMachineObjectCode virtualMachineObjectCode, VariableTable variableTable) throws VnanoException {
        int n = variableTable.getSize();
        for (int i = 0; i < n; ++i) {
            AbstractVariable abstractVariable = variableTable.getVariableByIndex(i);
            DataContainer<?> dataContainer = abstractVariable.getDataContainer();
            DataContainer<?> dataContainer2 = this.globalList.get(i);
            dataContainer2.setArrayData(dataContainer.getArrayData(), dataContainer.getArrayRank(), dataContainer.getArrayLengths());
        }
    }

    public static enum Partition {
        GLOBAL,
        LOCAL,
        CONSTANT,
        REGISTER,
        STACK,
        NONE;

    }
}

