/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.processor;

import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.DataConverter;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.vm.memory.DataContainer;

public class ExecutionUnit {
    public void add(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                long[] lArray3 = (long[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    lArray3[n + i] = lArray[n2 + i] + lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                double[] dArray3 = (double[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    dArray3[n + i] = dArray[n2 + i] + dArray2[n3 + i];
                }
                return;
            }
            case STRING: {
                String[] stringArray = (String[])dataContainer2.getArrayData();
                String[] stringArray2 = (String[])dataContainer3.getArrayData();
                String[] stringArray3 = (String[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    stringArray3[n + i] = stringArray[n2 + i] + stringArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void sub(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                long[] lArray3 = (long[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    lArray3[n + i] = lArray[n2 + i] - lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                double[] dArray3 = (double[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    dArray3[n + i] = dArray[n2 + i] - dArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void mul(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                long[] lArray3 = (long[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    lArray3[n + i] = lArray[n2 + i] * lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                double[] dArray3 = (double[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    dArray3[n + i] = dArray[n2 + i] * dArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void div(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                long[] lArray3 = (long[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    lArray3[n + i] = lArray[n2 + i] / lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                double[] dArray3 = (double[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    dArray3[n + i] = dArray[n2 + i] / dArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void rem(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                long[] lArray3 = (long[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    lArray3[n + i] = lArray[n2 + i] % lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                double[] dArray3 = (double[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    dArray3[n + i] = dArray[n2 + i] % dArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void neg(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer.getArrayData();
                for (int i = 0; i < n3; ++i) {
                    lArray2[n + i] = -lArray[n2 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer.getArrayData();
                for (int i = 0; i < n3; ++i) {
                    dArray2[n + i] = -dArray[n2 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void eq(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, DataType.BOOL);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = lArray[n2 + i] == lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = dArray[n2 + i] == dArray2[n3 + i];
                }
                return;
            }
            case BOOL: {
                boolean[] blArray = (boolean[])dataContainer2.getArrayData();
                boolean[] blArray2 = (boolean[])dataContainer3.getArrayData();
                boolean[] blArray3 = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray3[n + i] = blArray[n2 + i] == blArray2[n3 + i];
                }
                return;
            }
            case STRING: {
                String[] stringArray = (String[])dataContainer2.getArrayData();
                String[] stringArray2 = (String[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = stringArray[n2 + i].equals(stringArray2[n3 + i]);
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void neq(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, DataType.BOOL);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = lArray[n2 + i] != lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = dArray[n2 + i] != dArray2[n3 + i];
                }
                return;
            }
            case BOOL: {
                boolean[] blArray = (boolean[])dataContainer2.getArrayData();
                boolean[] blArray2 = (boolean[])dataContainer3.getArrayData();
                boolean[] blArray3 = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray3[n + i] = blArray[n2 + i] != blArray2[n3 + i];
                }
                return;
            }
            case STRING: {
                String[] stringArray = (String[])dataContainer2.getArrayData();
                String[] stringArray2 = (String[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = !stringArray[n2 + i].equals(stringArray2[n3 + i]);
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void geq(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, DataType.BOOL);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = lArray[n2 + i] >= lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = dArray[n2 + i] >= dArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void leq(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, DataType.BOOL);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = lArray[n2 + i] <= lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = dArray[n2 + i] <= dArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void gt(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, DataType.BOOL);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = lArray[n2 + i] > lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = dArray[n2 + i] > dArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void lt(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, DataType.BOOL);
        this.checkDataType(dataContainer2, dataType);
        this.checkDataType(dataContainer3, dataType);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer2.getArrayData();
                long[] lArray2 = (long[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = lArray[n2 + i] < lArray2[n3 + i];
                }
                return;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer2.getArrayData();
                double[] dArray2 = (double[])dataContainer3.getArrayData();
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n4; ++i) {
                    blArray[n + i] = dArray[n2 + i] < dArray2[n3 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void and(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        if (dataType != DataType.BOOL) {
            throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
        }
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        boolean bl = true;
        boolean[] blArray = (boolean[])dataContainer2.getArrayData();
        boolean[] blArray2 = (boolean[])dataContainer.getArrayData();
        for (int i = 0; i < n4; ++i) {
            blArray2[n + i] = blArray[n2 + i];
            bl &= !blArray[n2 + i];
        }
        if (bl) {
            return;
        }
        boolean[] blArray3 = (boolean[])dataContainer3.getArrayData();
        this.checkDataType(dataContainer3, dataType);
        for (int i = 0; i < n4; ++i) {
            blArray2[n + i] = blArray2[n + i] && blArray3[n3 + i];
        }
    }

    public void or(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?> dataContainer3) {
        if (dataType != DataType.BOOL) {
            throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
        }
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer3.getArrayOffset();
        int n4 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        boolean bl = true;
        boolean[] blArray = (boolean[])dataContainer2.getArrayData();
        boolean[] blArray2 = (boolean[])dataContainer.getArrayData();
        for (int i = 0; i < n4; ++i) {
            blArray2[n + i] = blArray[n2 + i];
            bl &= blArray[n2 + i];
        }
        if (bl) {
            return;
        }
        boolean[] blArray3 = (boolean[])dataContainer3.getArrayData();
        this.checkDataType(dataContainer3, dataType);
        for (int i = 0; i < n4; ++i) {
            blArray2[n + i] = blArray2[n + i] || blArray3[n3 + i];
        }
    }

    public void not(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        switch (dataType) {
            case BOOL: {
                boolean[] blArray = (boolean[])dataContainer2.getArrayData();
                boolean[] blArray2 = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n3; ++i) {
                    blArray2[n + i] = !blArray[n2 + i];
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void alloc(DataType dataType, DataContainer<?> dataContainer, int n, int[] nArray) {
        Object obj = dataContainer.getArrayData();
        int n2 = dataContainer.getArraySize();
        switch (dataType) {
            case INT64: {
                if (!(obj instanceof long[]) || n2 != n) {
                    dataContainer.setArrayData(new long[n], 0, nArray);
                }
                return;
            }
            case FLOAT64: {
                if (!(obj instanceof double[]) || n2 != n) {
                    dataContainer.setArrayData(new double[n], 0, nArray);
                }
                return;
            }
            case BOOL: {
                if (!(obj instanceof boolean[]) || n2 != n) {
                    dataContainer.setArrayData(new boolean[n], 0, nArray);
                }
                return;
            }
            case STRING: {
                if (!(obj instanceof String[]) || n2 != n) {
                    dataContainer.setArrayData(new String[n], 0, nArray);
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void allocScalar(DataType dataType, DataContainer<?> dataContainer) {
        switch (dataType) {
            case INT64: {
                dataContainer.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                return;
            }
            case FLOAT64: {
                dataContainer.setArrayData(new double[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                return;
            }
            case BOOL: {
                dataContainer.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                return;
            }
            case STRING: {
                dataContainer.setArrayData(new String[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void allocVector(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> ... dataContainerArray) {
        int n = 1;
        int n2 = dataContainerArray.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            long[] lArray = (long[])dataContainerArray[i].getArrayData();
            nArray[i] = (int)lArray[dataContainerArray[i].getArrayOffset()];
            n *= nArray[i];
        }
        this.alloc(dataType, dataContainer, n, nArray);
    }

    public void allocSameLengths(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2) {
        int n = dataContainer2.getArraySize();
        int n2 = dataContainer2.getArrayRank();
        int[] nArray = dataContainer2.getArrayLengths();
        int[] nArray2 = new int[n2];
        if (0 < n2) {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        this.alloc(dataType, dataContainer, n, nArray2);
    }

    public void mov(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2) throws VnanoException {
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        if (dataContainer.getArraySize() != dataContainer2.getArraySize()) {
            if (dataContainer.getArrayRank() == 0 && dataContainer2.getArraySize() != 1) {
                throw new VnanoException(ErrorType.ARRAY_SIZE_IS_TOO_LARGE_TO_BE_ASSIGNED_TO_SCALAR_VARIABLE);
            }
            throw new VnanoFatalException("Array sizes of operands of the MOV instruction should be the same");
        }
        try {
            System.arraycopy(dataContainer2.getArrayData(), dataContainer2.getArrayOffset(), dataContainer.getArrayData(), dataContainer.getArrayOffset(), dataContainer.getArraySize());
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new VnanoFatalException(arrayStoreException);
        }
    }

    public void ref(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2) {
        this.checkDataType(dataContainer2, dataType);
        dataContainer.refer(dataContainer2);
    }

    public void reord(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2) throws VnanoException {
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        int[] nArray = dataContainer2.getArrayLengths();
        int[] nArray2 = dataContainer.getArrayLengths();
        int n = dataContainer2.getArrayRank();
        int n2 = dataContainer.getArrayRank();
        if (n != n2) {
            // empty if block
        }
        int n3 = dataContainer2.getArraySize();
        int[] nArray3 = new int[n];
        nArray3[0] = 1;
        int n4 = 1;
        for (int i = n - 1; 1 <= i; --i) {
            nArray3[i] = n4 *= nArray[i];
        }
        int[] nArray4 = new int[n];
        for (int i = 0; i < n3; ++i) {
            int n5;
            int n6 = i;
            for (n5 = n - 1; 0 <= n5; --n5) {
                nArray4[n - 1 - n5] = n6 / nArray3[n5];
                n6 %= nArray3[n5];
            }
            for (n5 = 0; n5 < n; ++n5) {
                if (nArray2[n5] - 1 >= nArray4[n5]) continue;
            }
            n5 = 1;
            int n7 = 0;
            for (int j = n - 1; 0 <= j; --j) {
                n7 += n5 * nArray4[j];
                n5 *= nArray2[j];
            }
            System.arraycopy(dataContainer2.getArrayData(), i, dataContainer.getArrayData(), n7, 1);
        }
    }

    public void fill(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2) {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType);
        switch (dataType) {
            case INT64: {
                long l = ((long[])dataContainer2.getArrayData())[n2];
                long[] lArray = (long[])dataContainer.getArrayData();
                for (int i = 0; i < n3; ++i) {
                    lArray[n + i] = l;
                }
                return;
            }
            case FLOAT64: {
                double d = ((double[])dataContainer2.getArrayData())[n2];
                double[] dArray = (double[])dataContainer.getArrayData();
                for (int i = 0; i < n3; ++i) {
                    dArray[n + i] = d;
                }
                return;
            }
            case BOOL: {
                boolean bl = ((boolean[])dataContainer2.getArrayData())[n2];
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                for (int i = 0; i < n3; ++i) {
                    blArray[n + i] = bl;
                }
                return;
            }
            case STRING: {
                String string = ((String[])dataContainer2.getArrayData())[n2];
                String[] stringArray = (String[])dataContainer.getArrayData();
                for (int i = 0; i < n3; ++i) {
                    stringArray[n + i] = string;
                }
                return;
            }
        }
        throw new VnanoFatalException("Unoperatable data type: " + (Object)((Object)dataType));
    }

    public void refelm(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?>[] dataContainerArray, int n) throws VnanoException {
        this.checkDataType(dataContainer2, dataType);
        int n2 = dataContainerArray.length - n;
        int[] nArray = dataContainer2.getArrayLengths();
        int n3 = this.compute1DIndexFromIndicesOperands(dataContainerArray, n, nArray, n2);
        switch (dataType) {
            case INT64: {
                dataContainer.setArrayData((long[])dataContainer2.getArrayData(), n3 + dataContainer2.getArrayOffset(), DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                break;
            }
            case FLOAT64: {
                dataContainer.setArrayData((double[])dataContainer2.getArrayData(), n3 + dataContainer2.getArrayOffset(), DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                break;
            }
            case BOOL: {
                dataContainer.setArrayData((boolean[])dataContainer2.getArrayData(), n3 + dataContainer2.getArrayOffset(), DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                break;
            }
            case STRING: {
                dataContainer.setArrayData((String[])dataContainer2.getArrayData(), n3 + dataContainer2.getArrayOffset(), DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                break;
            }
            default: {
                throw new VnanoFatalException("Unknown data type: " + (Object)((Object)dataType));
            }
        }
    }

    public void movelm(DataType dataType, DataContainer<?> dataContainer, DataContainer<?> dataContainer2, DataContainer<?>[] dataContainerArray, int n) throws VnanoException {
        this.checkDataType(dataContainer2, dataType);
        int n2 = dataContainerArray.length - n;
        int[] nArray = dataContainer2.getArrayLengths();
        int n3 = this.compute1DIndexFromIndicesOperands(dataContainerArray, n, nArray, n2);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer.getArrayData();
                long[] lArray2 = (long[])dataContainer2.getArrayData();
                lArray[dataContainer.getArrayOffset()] = lArray2[n3 + dataContainer2.getArrayOffset()];
                break;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer.getArrayData();
                double[] dArray2 = (double[])dataContainer2.getArrayData();
                dArray[dataContainer.getArrayOffset()] = dArray2[n3 + dataContainer2.getArrayOffset()];
                break;
            }
            case BOOL: {
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                boolean[] blArray2 = (boolean[])dataContainer2.getArrayData();
                blArray[dataContainer.getArrayOffset()] = blArray2[n3 + dataContainer2.getArrayOffset()];
                break;
            }
            case STRING: {
                String[] stringArray = (String[])dataContainer.getArrayData();
                String[] stringArray2 = (String[])dataContainer2.getArrayData();
                stringArray[dataContainer.getArrayOffset()] = stringArray2[n3 + dataContainer2.getArrayOffset()];
                break;
            }
            default: {
                throw new VnanoFatalException("Unknown data type: " + (Object)((Object)dataType));
            }
        }
    }

    public void cast(DataType dataType, DataType dataType2, DataContainer<?> dataContainer, DataContainer<?> dataContainer2) throws VnanoException {
        int n = dataContainer.getArrayOffset();
        int n2 = dataContainer2.getArrayOffset();
        int n3 = dataContainer.getArraySize();
        this.checkDataType(dataContainer, dataType);
        this.checkDataType(dataContainer2, dataType2);
        switch (dataType) {
            case INT64: {
                long[] lArray = (long[])dataContainer.getArrayData();
                switch (dataType2) {
                    case INT64: {
                        long[] lArray2 = (long[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            lArray[n + i] = lArray2[n2 + i];
                        }
                        return;
                    }
                    case FLOAT64: {
                        double[] dArray = (double[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            lArray[n + i] = (long)dArray[n2 + i];
                        }
                        return;
                    }
                    case STRING: {
                        String[] stringArray = (String[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            try {
                                lArray[n + i] = Long.parseLong(stringArray[n2 + i]);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                try {
                                    double d = Double.parseDouble(stringArray[n2 + i]);
                                    lArray[n + i] = (long)d;
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    VnanoException vnanoException = new VnanoException(ErrorType.CAST_FAILED_DUE_TO_VALUE, new String[]{stringArray[n2 + i], dataType.name()});
                                    throw vnanoException;
                                }
                            }
                        }
                        return;
                    }
                }
                VnanoException vnanoException = new VnanoException(ErrorType.CAST_FAILED_DUE_TO_TYPE, new String[]{dataType2.name(), dataType.name()});
                throw vnanoException;
            }
            case FLOAT64: {
                double[] dArray = (double[])dataContainer.getArrayData();
                switch (dataType2) {
                    case INT64: {
                        long[] lArray = (long[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            dArray[n + i] = lArray[n2 + i];
                        }
                        return;
                    }
                    case FLOAT64: {
                        double[] dArray2 = (double[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            dArray[n + i] = dArray2[n2 + i];
                        }
                        return;
                    }
                    case STRING: {
                        String[] stringArray = (String[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            try {
                                dArray[n + i] = Double.parseDouble(stringArray[n2 + i]);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                VnanoException vnanoException = new VnanoException(ErrorType.CAST_FAILED_DUE_TO_VALUE, new String[]{stringArray[n2 + i], dataType.name()});
                                throw vnanoException;
                            }
                        }
                        return;
                    }
                }
                VnanoException vnanoException = new VnanoException(ErrorType.CAST_FAILED_DUE_TO_TYPE, new String[]{dataType2.name(), dataType.name()});
                throw vnanoException;
            }
            case BOOL: {
                boolean[] blArray = (boolean[])dataContainer.getArrayData();
                switch (dataType2) {
                    case BOOL: {
                        boolean[] blArray2 = (boolean[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            blArray[n + i] = blArray2[n2 + i];
                        }
                        return;
                    }
                    case STRING: {
                        String[] stringArray = (String[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            if (stringArray[n2 + i].equals("true")) {
                                blArray[n + i] = true;
                                continue;
                            }
                            if (stringArray[n2 + i].equals("false")) {
                                blArray[n + i] = false;
                                continue;
                            }
                            VnanoException vnanoException = new VnanoException(ErrorType.CAST_FAILED_DUE_TO_VALUE, new String[]{stringArray[n2 + i], dataType.name()});
                            throw vnanoException;
                        }
                        return;
                    }
                }
                VnanoException vnanoException = new VnanoException(ErrorType.CAST_FAILED_DUE_TO_TYPE, new String[]{dataType2.name(), dataType.name()});
                throw vnanoException;
            }
            case STRING: {
                String[] stringArray = (String[])dataContainer.getArrayData();
                switch (dataType2) {
                    case INT64: {
                        long[] lArray = (long[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            stringArray[n + i] = Long.toString(lArray[n2 + i]);
                        }
                        return;
                    }
                    case FLOAT64: {
                        double[] dArray = (double[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            stringArray[n + i] = Double.toString(dArray[n2 + i]);
                        }
                        return;
                    }
                    case BOOL: {
                        boolean[] blArray = (boolean[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            stringArray[n + i] = Boolean.toString(blArray[n2 + i]);
                        }
                        return;
                    }
                    case STRING: {
                        String[] stringArray2 = (String[])dataContainer2.getArrayData();
                        for (int i = 0; i < n3; ++i) {
                            stringArray[n + i] = stringArray2[n2 + i];
                        }
                        return;
                    }
                }
                VnanoException vnanoException = new VnanoException(ErrorType.CAST_FAILED_DUE_TO_TYPE, new String[]{dataType2.name(), dataType.name()});
                throw vnanoException;
            }
        }
        VnanoException vnanoException = new VnanoException(ErrorType.CAST_FAILED_DUE_TO_TYPE, new String[]{dataType2.name(), dataType.name()});
        throw vnanoException;
    }

    private int compute1DIndexFromIndicesOperands(DataContainer<?>[] dataContainerArray, int n, int[] nArray, int n2) throws VnanoException {
        int n3 = 0;
        int n4 = 1;
        for (int i = n2 - 1; 0 <= i; --i) {
            DataContainer<?> dataContainer = dataContainerArray[i + n];
            long l = ((long[])dataContainer.getArrayData())[dataContainer.getArrayOffset()];
            if ((long)nArray[i] <= l) {
                String[] stringArray = new String[]{Long.toString(l), Integer.toString(nArray[i] - 1)};
                throw new VnanoException(ErrorType.INVALID_ARRAY_INDEX, stringArray);
            }
            n3 += (int)l * n4;
            n4 *= nArray[i];
        }
        return n3;
    }

    private void checkDataType(DataContainer<?> dataContainer, DataType dataType) {
        switch (dataType) {
            case INT64: {
                if (!(dataContainer.getArrayData() instanceof long[])) break;
                return;
            }
            case FLOAT64: {
                if (!(dataContainer.getArrayData() instanceof double[])) break;
                return;
            }
            case BOOL: {
                if (!(dataContainer.getArrayData() instanceof boolean[])) break;
                return;
            }
            case STRING: {
                if (!(dataContainer.getArrayData() instanceof String[])) break;
                return;
            }
            case ANY: {
                break;
            }
            case VOID: {
                return;
            }
            default: {
                throw new VnanoFatalException("Unexpected data type: " + (Object)((Object)dataType));
            }
        }
        if (dataContainer.getArrayData() == null) {
            throw new VnanoFatalException("Data of the operand is null.");
        }
        throw new VnanoFatalException("Data of the operand is unexpected type: " + (Object)((Object)DataConverter.getDataTypeOf(dataContainer.getArrayData().getClass())) + " (expected: " + (Object)((Object)dataType) + ")");
    }
}

