/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.processor;

import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.memory.Memory;

public class Instruction
implements Cloneable {
    private final OperationCode operationCode;
    private final DataType[] dataTypes;
    private final Memory.Partition[] operandPartitions;
    private final int[] operandAddresses;
    private final Memory.Partition metaPartition;
    private final int metaAddress;
    private final Object extension;

    public Instruction(OperationCode operationCode, DataType[] dataTypeArray, Memory.Partition[] partitionArray, int[] nArray, Memory.Partition partition, int n) {
        this(operationCode, dataTypeArray, partitionArray, nArray, partition, n, null);
    }

    public Instruction(OperationCode operationCode, DataType[] dataTypeArray, Memory.Partition[] partitionArray, int[] nArray, Memory.Partition partition, int n, Object object) {
        this.operationCode = operationCode;
        this.dataTypes = dataTypeArray;
        this.operandPartitions = partitionArray;
        this.operandAddresses = nArray;
        this.metaPartition = partition;
        this.metaAddress = n;
        this.extension = object;
    }

    public DataType[] getDataTypes() {
        return this.dataTypes;
    }

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    public int getOperandLength() {
        return this.operandPartitions.length;
    }

    public Memory.Partition[] getOperandPartitions() {
        return this.operandPartitions;
    }

    public int[] getOperandAddresses() {
        return this.operandAddresses;
    }

    public Memory.Partition getMetaPartition() {
        return this.metaPartition;
    }

    public int getMetaAddress() {
        return this.metaAddress;
    }

    public boolean hasExtention() {
        return this.extension != null;
    }

    public Object getExtension() {
        return this.extension;
    }

    public Instruction clone() {
        DataType[] dataTypeArray = new DataType[this.dataTypes.length];
        System.arraycopy(this.dataTypes, 0, dataTypeArray, 0, this.dataTypes.length);
        Memory.Partition[] partitionArray = new Memory.Partition[this.operandPartitions.length];
        System.arraycopy(this.operandPartitions, 0, partitionArray, 0, this.operandPartitions.length);
        int[] nArray = new int[this.operandAddresses.length];
        System.arraycopy(this.operandAddresses, 0, nArray, 0, this.operandAddresses.length);
        Instruction instruction = new Instruction(this.operationCode, dataTypeArray, partitionArray, nArray, this.metaPartition, this.metaAddress, this.extension);
        return instruction;
    }

    public Instruction clone(Object object) {
        DataType[] dataTypeArray = new DataType[this.dataTypes.length];
        System.arraycopy(this.dataTypes, 0, dataTypeArray, 0, this.dataTypes.length);
        Memory.Partition[] partitionArray = new Memory.Partition[this.operandPartitions.length];
        System.arraycopy(this.operandPartitions, 0, partitionArray, 0, this.operandPartitions.length);
        int[] nArray = new int[this.operandAddresses.length];
        System.arraycopy(this.operandAddresses, 0, nArray, 0, this.operandAddresses.length);
        Instruction instruction = new Instruction(this.operationCode, dataTypeArray, partitionArray, nArray, this.metaPartition, this.metaAddress, object);
        return instruction;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        stringBuilder.append((Object)this.operationCode);
        stringBuilder.append("\t");
        int n2 = this.dataTypes.length;
        for (n = 0; n < n2; ++n) {
            stringBuilder.append((Object)this.dataTypes[n]);
            if (n == n2 - 1) continue;
            stringBuilder.append(":");
        }
        stringBuilder.append("\t");
        n = this.operandAddresses.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.operandPartitions[i].toString().charAt(0));
            stringBuilder.append(this.operandAddresses[i]);
            stringBuilder.append("\t");
        }
        stringBuilder.append(this.metaPartition.toString().charAt(0));
        stringBuilder.append(this.metaAddress);
        if (this.extension != null) {
            stringBuilder.append("\t extension={ ");
            stringBuilder.append(this.extension.toString());
            stringBuilder.append(" }");
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

