/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.processor;

import java.io.PrintStream;
import java.util.Arrays;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.MetaInformationSyntax;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.DispatchUnit;
import org.vcssl.nano.vm.processor.ExecutionUnit;
import org.vcssl.nano.vm.processor.Instruction;
import org.vcssl.nano.vm.processor.Processable;

public class Processor
implements Processable {
    private volatile boolean continuable = true;
    private int executedInstructionCount = 0;
    private OperationCode currentOperationCode = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Instruction[] instructionArray, Memory memory, Interconnect interconnect) throws VnanoException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        Object object;
        PrintStream printStream = null;
        Object object2 = this;
        synchronized (object2) {
            object = interconnect.getOptionMap();
            bl5 = (Boolean)object.get("DUMPER_ENABLED");
            String string = (String)object.get("DUMPER_TARGET");
            bl4 = string.equals("ALL");
            printStream = (PrintStream)object.get("DUMPER_OUTPUT_STREAM");
            bl3 = (Boolean)object.get("RUNNING_ENABLED");
            bl2 = (Boolean)object.get("TERMINATOR_ENABLED");
            bl = (Boolean)object.get("PERFORMANCE_MONITOR_ENABLED");
        }
        object2 = new ExecutionUnit();
        object = new DispatchUnit();
        int n = 0;
        int n2 = instructionArray.length;
        boolean[] blArray = new boolean[n2];
        Arrays.fill(blArray, false);
        if (!bl3) {
            return;
        }
        if (bl5 && bl4) {
            printStream.println("================================================================================");
            printStream.println("= Run");
            printStream.println("================================================================================");
        }
        while (0 <= n && n < n2 && (!bl2 || this.continuable)) {
            try {
                n = ((DispatchUnit)object).dispatch(instructionArray[n], memory, interconnect, (ExecutionUnit)object2, blArray, n);
                if (!bl) continue;
                this.currentOperationCode = instructionArray[n].getOperationCode();
                ++this.executedInstructionCount;
            }
            catch (Exception exception) {
                VnanoException vnanoException = null;
                vnanoException = exception instanceof VnanoException ? (VnanoException)exception : new VnanoException(ErrorType.UNEXPECTED_PROCESSOR_CRASH, new String[]{Integer.toString(n)}, (Throwable)exception);
                int n3 = MetaInformationSyntax.extractLineNumber(instructionArray[n], memory);
                String string = MetaInformationSyntax.extractFileName(instructionArray[n], memory);
                vnanoException.setFileName(string);
                vnanoException.setLineNumber(n3);
                throw vnanoException;
            }
        }
        this.currentOperationCode = null;
        if (bl5 && bl4) {
            printStream.println("");
            printStream.println("================================================================================");
            printStream.println("= End");
            printStream.println("================================================================================");
        }
    }

    @Override
    public int process(Instruction instruction, Memory memory, Interconnect interconnect, int n) throws VnanoException {
        ExecutionUnit executionUnit = new ExecutionUnit();
        DispatchUnit dispatchUnit = new DispatchUnit();
        return dispatchUnit.dispatch(instruction, memory, interconnect, executionUnit, null, n);
    }

    public void terminate() {
        this.continuable = false;
    }

    public void resetTerminator() {
        this.continuable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExecutedInstructionCountIntValue() {
        Processor processor = this;
        synchronized (processor) {
            return this.executedInstructionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationCode[] getCurrentlyExecutedOperationCodes() {
        Processor processor = this;
        synchronized (processor) {
            if (this.currentOperationCode == null) {
                return new OperationCode[0];
            }
            return new OperationCode[]{this.currentOperationCode};
        }
    }
}

