@echo off


rem ====================================================================================================
rem Jar Application Launcher Script - v28-en for rinpn / RINEARN 2022
rem ====================================================================================================


setlocal

if "%2" == "" (
	rem
) else (
	echo Error:    Too many arguments.
	echo Solution: Enclose the expression by double-quotations, e.g.  "1+2".
	exit /b
)

set JAR_FILE_NAME=RINPn.jar
set DEFAULT_OPTIONS=--dir "%CD:\=\\%"
set MEMORY_FILE_NAME=etc\RINPnMemory.ini
set ENCODING_FILE_NAME=etc\RINPnEncoding.ini
set SOFTWARE_NAME=RINPn
set SOFTWARE_DIR="%~dp0"
set JRE_PATH_FILE=.\jre\JRE_Path_Setting.txt
set JRE_DOWNLOADER=.\jre\JRE_Downloader.bat
set HANDLES_ARGS_AS_FILEPATHS=FALSE


set ARGUMENTS_PREFIX=
set ARGUMENTS_PREFIX_TARGET=NONE
set ARGUMENTS_BUFFER=

if "%HANDLES_ARGS_AS_FILEPATHS%" == "TRUE" (
	for %%a in ( %* ) do (
		setlocal enabledelayedexpansion
		echo "%%~a" | findstr "%% ! | ^ > < & $" >nul
		if !ERRORLEVEL! == 0 (
			echo Error: The argument or the file name contains unusable characters.
			goto END
		)
		endlocal
	)
	for %%a in ( %* ) do call :REGISTER_ARG %%a
	goto REGISTER_ARGS_BREAK
)

:REGISTER_NEXT_ARG
if "%~1" == "" goto REGISTER_ARGS_BREAK
echo "%~1" | findstr "%% ! | ^ > < & $" >nul
if %ERRORLEVEL% == 0 (
	echo Error: The argument contains unusable characters.
	goto END
)
call :REGISTER_ARG %1
shift
goto REGISTER_NEXT_ARG

:REGISTER_ARGS_BREAK


cd /d %SOFTWARE_DIR%
cd ..


goto LOAD_MEMORY


rem --------------------------------------------------------------------------------
rem --------------------------------------------------------------------------------
:LOAD_MEMORY
set MEMORY_LINE=
if exist %MEMORY_FILE_NAME% (
	for /F "delims=" %%a in (%MEMORY_FILE_NAME%) do (
		set MEMORY_LINE=%%a
		goto MEMORY_READ_END
	)
) else (
	echo.
	echo  - %SOFTWARE_NAME% -
	echo.
	echo ----------------------------------------------------------------------
	echo.
	echo   - Welcome -
	echo.
	echo   Please input the memory allocation size [ MB ],
	echo   ande press Enter key.
	echo.
	echo   If you want to use the default setting,
	echo.  press Enter key without inputting anything.
	echo.
	echo ======================================================================
	echo.
	set /P MEMORY_LINE="Memory allocation size [ MB ] = "
	echo.
	echo The memory allocation size have set as the above.
	echo This setting is stored in the file folling file: %MEMORYFILE%
	echo.
	echo.
)

:MEMORY_READ_END

set /A MEMORY_LINE_NUM = MEMORY_LINE + 0
if not "%MEMORY_LINE%"=="%MEMORY_LINE_NUM%" (
	set MEMORY_LINE=DEFAULT
)

set /A MEMORY_LINE_NUM = MEMORY_LINE + 0
if "%MEMORY_LINE%"=="%MEMORY_LINE_NUM%" (
	set MEMORY_LINE= -Xmx%MEMORY_LINE%m 
) else (
	set MEMORY_LINE=  
)

goto LOAD_ENCODING


rem --------------------------------------------------------------------------------
rem --------------------------------------------------------------------------------
:LOAD_ENCODING

set ENCODING_LINE=
if exist %ENCODING_FILE_NAME% (
	for /F "delims=" %%a in (%ENCODING_FILE_NAME%) do (
		set ENCODING_LINE=%%a
	)
)

goto JRE_TEST


rem --------------------------------------------------------------------------------
rem --------------------------------------------------------------------------------
:JRE_TEST

java -version 2> NUL
if %ERRORLEVEL%==0 (
	goto JRE_ADD_PATH
) else (
	goto :JRE_DOWNLOAD
)

:JRE_DOWNLOAD
if exist %JRE_DOWNLOADER% (
	call %JRE_DOWNLOADER%
	@echo off
)
goto JRE_ADD_PATH


rem --------------------------------------------------------------------------------
rem --------------------------------------------------------------------------------
:JRE_ADD_PATH
if exist %JRE_PATH_FILE% (
	for /F %%a in (%JRE_PATH_FILE%) do (
		set JRE_PATH=.\jre\%%a
	)
) else (
	goto RUN
)
set "PATH=%JRE_PATH%;%PATH%"
goto RUN


rem --------------------------------------------------------------------------------
rem --------------------------------------------------------------------------------
:RUN
java %MEMORY_LINE% %ENCODING_LINE% -jar %JAR_FILE_NAME% %DEFAULT_OPTIONS% %ARGUMENTS_BUFFER%
goto SAVE


rem --------------------------------------------------------------------------------
rem --------------------------------------------------------------------------------
:SAVE
if %ERRORLEVEL%==0 (
	if not exist "%MEMORY_FILE_NAME%" (
		if %MEMORY_LINE_NUM%==0 (
			echo. >>"%MEMORY_FILE_NAME%"
		) else (
			echo %MEMORY_LINE_NUM%>>"%MEMORY_FILE_NAME%"
		)
	)
) else (
	echo.
	echo ======================================================================
	echo.
	echo - The software has exited with errors, or has failed to start.
	echo   The common causes are the followings:
	echo.
	echo * If this software has suddenly exited with memory-related errors,
	echo   the memory size allocated for this software might be deficient.
	echo.
	echo   For this case,
	echo   execute "SetMemorySize.bat" to set the sufficient memory size.
	echo.
	echo * Some additional permissions might be necessary.
	echo.
	echo   For this case,
	echo   you might solve the problem by right clicking this batch file 
	echo   and choosing "Run as administrator" from the menu.
	echo.
	echo * There is no Java^(R^) Runtime Environment ^(JRE^) in your environment,
	echo   or the version of the JRE is too old.
	echo.
	echo   For this case,
	echo   you can download and use the appropriate version of the JRE 
	echo   by double-clicking "UpdateJRE.bat" to execute.
	echo.
	echo ^( Oracle and Java are registered trademarks of Oracle and/or its affiliates. ^)
	echo.
	echo * For other problems, see the following pages:
	echo.
	echo    [ For RINEARN's software, excluding VCSSL ]
	echo      https://www.rinearn.com/en-us/info/other/help
	echo.
	echo    [ For VCSSL ]
	echo      https://www.vcssl.org/en-us/info/help
	echo.
	echo - We are sorry for the inconvenience.
	echo   Please feel free to ask us to solve the problem:
	echo.
	echo      https://www.rinearn.com/en-us/
	echo.

	if exist "%MEMORY_FILE_NAME%" (
		del "%MEMORY_FILE_NAME%"
	)

	echo ======================================================================
	echo.
	pause
)
goto END


:END
exit /b


rem --------------------------------------------------------------------------------
rem --------------------------------------------------------------------------------
:REGISTER_ARG

	if "%ARGUMENTS_PREFIX_TARGET%"=="NONE" (
		set ARGUMENTS_PREFIX=
	)

	set PROCESSED_ARG="%ARGUMENTS_PREFIX%%~1"
	set PROCESSED_ARG=%PROCESSED_ARG:\=\\%

	if "%ARGUMENTS_PREFIX_TARGET%"=="ONLY_FIRST" (
		set ARGUMENTS_PREFIX=
	)

	set APPENDED_BUFFER=%ARGUMENTS_BUFFER% %PROCESSED_ARG%
	set ARGUMENTS_BUFFER=%APPENDED_BUFFER%

