/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano;

import java.util.Locale;
import org.vcssl.nano.spec.ErrorMessage;
import org.vcssl.nano.spec.ErrorType;

public class VnanoException
extends Exception
implements Cloneable {
    private static final int LINE_NUMBER_DEFAULT_VALUE = -1;
    private ErrorType errorType = null;
    private String fileName = null;
    private int lineNumber = -1;
    private String[] errorWords = null;
    private String errorMessage = null;
    private Locale locale = Locale.getDefault();

    public VnanoException clone() {
        VnanoException vnanoException = new VnanoException(this.getMessage(), this.getCause());
        vnanoException.errorType = this.errorType;
        vnanoException.fileName = this.fileName;
        vnanoException.lineNumber = this.lineNumber;
        vnanoException.errorMessage = this.errorMessage;
        vnanoException.errorWords = new String[this.errorWords.length];
        System.arraycopy(this.errorWords, 0, vnanoException.errorWords, 0, this.errorWords.length);
        vnanoException.locale = this.locale;
        return vnanoException;
    }

    private VnanoException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public VnanoException(Throwable throwable) {
        super(throwable);
        this.errorType = ErrorType.UNEXPECTED;
    }

    public VnanoException(ErrorType errorType) {
        this(errorType, (String)null, -1);
    }

    public VnanoException(ErrorType errorType, Throwable throwable) {
        this(errorType, (String)null, throwable);
    }

    public VnanoException(ErrorType errorType, String string, int n) {
        this(errorType, (String)null, string, n);
    }

    public VnanoException(ErrorType errorType, String string, String string2, int n) {
        this(errorType, new String[]{string}, string2, n);
    }

    public VnanoException(ErrorType errorType, String string) {
        this(errorType, new String[]{string}, (String)null, -1);
    }

    public VnanoException(ErrorType errorType, String[] stringArray) {
        this(errorType, stringArray, (String)null, -1);
    }

    public VnanoException(ErrorType errorType, String[] stringArray, String string, int n) {
        super(ErrorMessage.generateErrorMessage(errorType, stringArray, Locale.getDefault()));
        this.errorType = errorType;
        this.errorWords = stringArray;
        this.fileName = string;
        this.lineNumber = n;
    }

    public VnanoException(ErrorType errorType, String string, Throwable throwable) {
        this(errorType, new String[]{string}, throwable);
    }

    public VnanoException(ErrorType errorType, String[] stringArray, Throwable throwable) {
        this(errorType, stringArray, throwable, null, -1);
    }

    public VnanoException(ErrorType errorType, Throwable throwable, String string, int n) {
        this(errorType, (String[])null, throwable);
    }

    public VnanoException(ErrorType errorType, String[] stringArray, Throwable throwable, String string, int n) {
        super(ErrorMessage.generateErrorMessage(errorType, stringArray, Locale.getDefault()), throwable);
        this.errorType = errorType;
        this.errorWords = stringArray;
        this.fileName = string;
        this.lineNumber = n;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String[] getErrorWords() {
        return this.errorWords;
    }

    public void setErrorWords(String[] stringArray) {
        this.errorWords = stringArray;
    }

    public boolean hasFileName() {
        return this.fileName != null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public boolean hasLineNumber() {
        return this.lineNumber != -1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMessage(String string) {
        this.errorMessage = string;
    }

    @Override
    public String getMessage() {
        String string = this.getMessageWithoutLocation();
        if (this.hasFileName() && this.hasLineNumber()) {
            string = this.locale.getLanguage() != null && this.locale.getLanguage().equals("ja") || this.locale.getCountry() != null && this.locale.getCountry().equals("JP") ? string + " (\u30d5\u30a1\u30a4\u30eb: " + this.getFileName() + ", \u884c\u756a\u53f7: " + this.getLineNumber() + ")" : string + " (file: " + this.getFileName() + ", line: " + this.getLineNumber() + ")";
        }
        return string;
    }

    public String getMessageWithoutLocation() {
        String string = null;
        if (this.errorMessage != null) {
            string = this.errorMessage;
        }
        if (this.errorType != null) {
            string = ErrorMessage.generateErrorMessage(this.errorType, this.errorWords, this.locale);
        }
        return string;
    }
}

