/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class FunctionCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testVoidArgVoidRetFunction();
            this.testSingleScalarArgFunctions();
            this.testDualScalarArgFunctions();
            this.testSingleVectorArgFunctions();
            this.testDualVectorArgFunctions();
            this.testScalarReturnFunctions();
            this.testVectorReturnFunctions();
            this.testMultiReturnFunctions();
            this.testFunctionCallsByScalarReferences();
            this.testFunctionCallsByVectorReferences();
            this.testFunctionCallsBySubscriptReferences();
            this.testSequentialFunctionCalls();
            this.testNestedFunctionCalls();
            this.testArgumentScopes();
            this.testFunctionRanges();
            this.testDuplicateFunctionDeclarations();
            this.testPassingConstants();
            this.testMultipleCallsOfFunctionsHavingBranchings();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testVoidArgVoidRetFunction() throws VnanoException {
        String string = " int a = 0;             \n                        \n void fun() {           \n     a = 2;             \n }                      \n                        \n fun();                 \n a;                     \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "int a; int fun() { a=2; } ", string);
        string = " int a = 0;             \n                        \n void fun() {           \n     a = 2;             \n     return;            \n }                      \n                        \n fun();                 \n a;                     \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "int a; int fun() { a=2; return; } ", string);
        string = " int a = 0;             \n                        \n void fun() {           \n     return;            \n     a = 2;             \n }                      \n                        \n fun();                 \n a;                     \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 0L, "int a; int fun() { return; a=2; } ", string);
    }

    private void testSingleScalarArgFunctions() throws VnanoException {
        String string = " int a = 0;             \n                        \n void fun(int x) {      \n     a = x;             \n }                      \n                        \n fun(5);                \n a;                     \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "int a; void fun(int x) { a=x; } ", string);
        string = " float a = 0.0;         \n                        \n void fun(float x) {    \n     a = x;             \n }                      \n                        \n fun(32.25);            \n a;                     \n";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 32.25, "float a; void fun(float x) { a=x; } ", string);
        string = " bool a = false;        \n                        \n void fun(bool x) {     \n     a = x;             \n }                      \n                        \n fun(true);             \n a;                     \n";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool a; void fun(bool x) { a=x; } ", string);
        string = " string a = \"\";           \n                            \n void fun(string x) {       \n     a = x;                 \n }                          \n                            \n fun(\"abc\");              \n a;                         \n";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "abc", "string a; fun(string x) { a=x; } ", string);
    }

    private void testDualScalarArgFunctions() throws VnanoException {
        String string = " int a = 0;                \n                           \n void fun(int x, int y) {  \n     a = x + y;            \n }                         \n                           \n fun(5, 22);               \n a;                        \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 27L, "int a; void fun(int x, int y) { a=x+y; } ", string);
        string = " float a = 0.0;                \n                               \n void fun(float x, float y) {  \n     a = x + y;                \n }                             \n                               \n fun(32.25, 64.125);           \n a;                            \n";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 96.375, "float a; void fun(float x, float y) { a=x+y; } ", string);
        string = " bool a = false;             \n                             \n void fun(bool x, bool y) {  \n     a = x && y;             \n }                           \n                             \n fun(true, false);           \n a;                          \n";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool a; void fun(bool x, bool y) { a=x&&y; } ", string);
        string = " bool a = false;             \n                             \n void fun(bool x, bool y) {  \n     a = x || y;             \n }                           \n                             \n fun(true, false);           \n a;                          \n";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool a; void fun(bool x, bool y) { a=x||y; } ", string);
        string = " string a = \"\";                \n                                 \n void fun(string x, string y) {  \n     a = x+y;                    \n }                               \n                                 \n fun(\"abc\", \"def\");          \n a;                              \n";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "abcdef", "string a; fun(string x, string y) { a=x+y; } ", string);
    }

    private void testSingleVectorArgFunctions() throws VnanoException {
        String string = " int a[3];            \n int b[3];            \n                      \n a[0] = 0;            \n a[1] = 0;            \n a[2] = 0;            \n                      \n b[0] = 1;            \n b[1] = 2;            \n b[2] = 3;            \n                      \n void fun(int x[]) {  \n     a = x;           \n }                    \n                      \n fun(b);              \n a;                   \n";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{1L, 2L, 3L};
        super.evaluateResult(lArray, lArray2, "int a[3]; int b[3]; ... void fun(int x[]){ a=x; }  fun(b); ", string);
        string = " float a[3];            \n float b[3];            \n                        \n a[0] = 0.0;            \n a[1] = 0.0;            \n a[2] = 0.0;            \n                        \n b[0] = 1.25;           \n b[1] = 2.25;           \n b[2] = 3.25;           \n                        \n void fun(float x[]) {  \n     a = x;             \n }                      \n                        \n fun(b);                \n a;                     \n";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{1.25, 2.25, 3.25};
        super.evaluateResult(dArray, dArray2, "float a[3]; float b[3]; ... void fun(float x[]){ a=x; }  fun(b); ", string);
        string = " bool a[3];            \n bool b[3];            \n                       \n a[0] = false;         \n a[1] = false;         \n a[2] = false;         \n                       \n b[0] = true;          \n b[1] = false;         \n b[2] = true;          \n                       \n void fun(bool x[]) {  \n     a = x;            \n }                     \n                       \n fun(b);               \n a;                    \n";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, true};
        super.evaluateResult(blArray, blArray2, "bool a[3]; bool b[3]; ... void fun(bool x[]){ a=x; }  fun(b); ", string);
        string = " string a[3];            \n string b[3];            \n                         \n a[0] = \"\";            \n a[1] = \"\";            \n a[2] = \"\";            \n                         \n b[0] = \"abc\";         \n b[1] = \"def\";         \n b[2] = \"ghi\";         \n                         \n void fun(string x[]) {  \n     a = x;              \n }                       \n                         \n fun(b);                 \n a;                      \n";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abc", "def", "ghi"};
        super.evaluateResult(stringArray, stringArray2, "string a[3]; string b[3]; ... string fun(string x[]){ a=x; }  a = fun(b); ", string);
    }

    private void testDualVectorArgFunctions() throws VnanoException {
        String string = " int a[3];                     \n int b[3];                     \n int c[3];                     \n                               \n a[0] = 0;                     \n a[1] = 0;                     \n a[2] = 0;                     \n                               \n b[0] = 1;                     \n b[1] = 2;                     \n b[2] = 3;                     \n                               \n c[0] = 4;                     \n c[1] = 5;                     \n c[2] = 6;                     \n                               \n void fun(int x[], int y[]) {  \n     a = x + y;                \n }                             \n                               \n fun(b, c);                    \n a;                            \n";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{5L, 7L, 9L};
        super.evaluateResult(lArray, lArray2, "int a[3]; int b[3]; int c[3]; ... void fun(int x[], int y[]){ a=x+y; }  fun(b,c); ", string);
        string = " float a[3];                       \n float b[3];                       \n float c[3];                       \n                                   \n a[0] = 0.0;                       \n a[1] = 0.0;                       \n a[2] = 0.0;                       \n                                   \n b[0] = 1.25;                      \n b[1] = 2.25;                      \n b[2] = 3.25;                      \n                                   \n c[0] = 4.25;                      \n c[1] = 5.25;                      \n c[2] = 6.25;                      \n                                   \n void fun(float x[], float y[]) {  \n     a = x + y;                    \n }                                 \n                                   \n fun(b, c);                        \n a;                                \n";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{5.5, 7.5, 9.5};
        super.evaluateResult(dArray, dArray2, "float a[3]; float b[3]; float c[3]; ... void fun(float x[], float y[]){ a=x+y; }  fun(b,c); ", string);
        string = " bool a[3];                      \n bool b[3];                      \n bool c[3];                      \n                                 \n a[0] = false;                   \n a[1] = false;                   \n a[2] = false;                   \n                                 \n b[0] = true;                    \n b[1] = true;                    \n b[2] = false;                   \n                                 \n c[0] = false;                   \n c[1] = true;                    \n c[2] = true;                    \n                                 \n void fun(bool x[], bool y[]) {  \n     a = x && y;                 \n }                               \n                                 \n fun(b, c);                      \n a;                              \n";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{false, true, false};
        super.evaluateResult(blArray, blArray2, "bool a[3]; bool b[3]; bool c[3]; ... void fun(bool x[], bool y[]){ a=x&&y; }  fun(b,c); ", string);
        string = " string a[3];                        \n string b[3];                        \n string c[3];                        \n                                     \n a[0] = \"\";                        \n a[1] = \"\";                        \n a[2] = \"\";                        \n                                     \n b[0] = \"abc\";                     \n b[1] = \"def\";                     \n b[2] = \"ghi\";                     \n                                     \n c[0] = \"aiueo\";                   \n c[1] = \"kakikukeko\";              \n c[2] = \"sasisuseso\";              \n                                     \n void fun(string x[], string y[]) {  \n     a = x + y;                      \n }                                   \n                                     \n fun(b, c);                          \n a;                                  \n";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abcaiueo", "defkakikukeko", "ghisasisuseso"};
        super.evaluateResult(stringArray, stringArray2, "string a[3]; string b[3]; string c[3]; ... string fun(string x[], string y[]){ a=x+y; }  a = fun(b,c); ", string);
    }

    private void testScalarReturnFunctions() throws VnanoException {
        String string = " int fun() {            \n     return 2;          \n }                      \n fun();                 \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "int fun() { return 2; } ", string);
        string = " float fun() {          \n     return 2.5;        \n }                      \n fun();                 \n";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 2.5, "float fun() { return 2.5; } ", string);
        string = " bool fun() {           \n     return true;       \n }                      \n fun();                 \n";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool fun() { return true; } ", string);
        string = " string fun() {         \n     return \"abc\";    \n }                      \n fun();                 \n";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "abc", "string fun() { return \"abc\"; } ", string);
    }

    private void testVectorReturnFunctions() throws VnanoException {
        String string = " int[] fun() {          \n     int a[3];          \n     a[0] = 1;          \n     a[1] = 2;          \n     a[2] = 3;          \n     return a;          \n }                      \n fun();                 \n";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{1L, 2L, 3L};
        super.evaluateResult(lArray, lArray2, "int[] fun() { int a[3]; ... return a; } ", string);
        string = " float[] fun() {        \n     float a[3];        \n     a[0] = 1.25;       \n     a[1] = 2.5;        \n     a[2] = 3.125;      \n     return a;          \n }                      \n fun();                 \n";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{1.25, 2.5, 3.125};
        super.evaluateResult(dArray, dArray2, "float[] fun() { float a[3]; ... return a; } ", string);
        string = " bool[] fun() {         \n     bool a[3];         \n     a[0] = true;       \n     a[1] = false;      \n     a[2] = true;       \n     return a;          \n }                      \n fun();                 \n";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, true};
        super.evaluateResult(blArray, blArray2, "bool[] fun() { bool a[3]; ... return a; } ", string);
        string = " string[] fun() {       \n     string a[3];       \n     a[0] = \"abc\";    \n     a[1] = \"def\";    \n     a[2] = \"ghi\";    \n     return a;          \n }                      \n fun();                 \n";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abc", "def", "ghi"};
        super.evaluateResult(stringArray, stringArray2, "string[] fun() { string s[3]; ... return a; } ", string);
    }

    private void testMultiReturnFunctions() throws VnanoException {
        String string = " string fun(int x) {       \n     if (x == 1) {         \n         return \"abc\";   \n     } else if (x == 2) {  \n         return \"def\";   \n     } else {              \n         return \"ghi\";   \n     }                     \n }                         \n";
        String string2 = string + "fun(1);";
        String string3 = (String)this.engine.executeScript(string2);
        super.evaluateResult(string3, "abc", "string fun() { if(...){return ...} else if(...){return ...} else{return ...} }   (case 1) ", string2);
        string2 = string + "fun(2);";
        string3 = (String)this.engine.executeScript(string2);
        super.evaluateResult(string3, "def", "string fun() { if(...){return ...} else if(...){return ...} else{return ...} }   (case 2) ", string2);
        string2 = string + "fun(3);";
        string3 = (String)this.engine.executeScript(string2);
        super.evaluateResult(string3, "ghi", "string fun() { if(...){return ...} else if(...){return ...} else{return ...} }   (case 3) ", string2);
    }

    private void testFunctionCallsByScalarReferences() throws VnanoException {
        String string = " void fun(int x) {         \n     x = 2;                \n }                         \n int a = 0;                \n fun(a);                   \n a;                        \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 0L, "void fun(int x) { x=2; } int a=0; fun(a);", string);
        string = " void fun(int &x) {        \n     x = 2;                \n }                         \n int a = 0;                \n fun(a);                   \n a;                        \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "void fun(int &x) { x=2; } int a=0; fun(a);", string);
        string = " void fun(int &x, int &y, int &z) {  \n     x = 2;                          \n     y = 3;                          \n     z = 4;                          \n }                                   \n                                     \n int a = 0;                          \n int b = 0;                          \n int c = 0;                          \n                                     \n fun(a, b, c);                       \n                                     \n int result[3];                      \n result[0] = a;                      \n result[1] = b;                      \n result[2] = c;                        \n                                     \n result;                             \n";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{2L, 3L, 4L};
        super.evaluateResult(lArray, lArray2, "void fun(int &x, int &y, int &z) { x=2; y=3; z=4; } int a=0; int b=0; int c=0; fun(a,b,c);", string);
        string = " int a;                    \n                           \n bool fun(int &x) {        \n     a = 2;                \n     return a == x;        \n }                         \n                           \n a = 1;                    \n bool b = fun(a);          \n b;                        \n";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int a=0; bool fun(int &x) { a=2; return a==x; } bool b=fun(a);", string);
        string = " int a = 0;                \n                           \n bool fun(int &x) {        \n     a = 2;                \n     int xs = x;           \n     int as = a;           \n     return as == xs;      \n }                         \n                           \n bool r = fun(a);          \n r;                        \n";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int a=0; bool fun(int &x) { a=2; int xs=x; int as=a; return as==xs; } bool r=fun(a);", string);
        string = " int a = 0;                            \n int b = 0;                            \n int c = 0;                            \n                                       \n bool[] fun(int &x, int &y, int &z) {  \n     a = 2;                            \n     b = 3;                            \n     c = 4;                            \n                                       \n     int xs = x;                       \n     int ys = y;                       \n     int zs = z;                       \n                                       \n     int as = a;                       \n     int bs = b;                       \n     int cs = c;                       \n                                       \n     bool result[3];                   \n     result[0] = (as == xs);           \n     result[1] = (bs == ys);           \n     result[2] = (cs == zs);           \n                                       \n     return result;                    \n }                                     \n                                       \n bool r[] = fun(a, b, c);              \n r;                                    \n";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, true, true};
        super.evaluateResult(blArray, blArray2, "int a=0; ... int c=0; string fun(int &x, ... int &z) { a=2; ... int xs=x; ... int as=a; ... int xs=x; bool result[3]; result[0]=(as==xs); ... result[2]=(cs==zs); return result;} bool r[]=fun(a,b,c);", string);
    }

    private void testFunctionCallsByVectorReferences() throws VnanoException {
        String string = " void fun(int x[]) {       \n     x[0] = 1;             \n     x[1] = 2;             \n     x[2] = 3;             \n }                         \n                           \n int a[3];                 \n a[0] = 0;                 \n a[1] = 0;                 \n a[2] = 0;                 \n fun(a);                   \n a;                        \n";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{0L, 0L, 0L};
        super.evaluateResult(lArray, lArray2, "void fun(int x[]) { x[0]=1; x[1]=2; x[2]=3; } int a[3]; ... fun(a); ", string);
        string = " void fun(int &x[]) {      \n     x[0] = 1;             \n     x[1] = 2;             \n     x[2] = 3;             \n }                         \n                           \n int a[3];                 \n a[0] = 0;                 \n a[1] = 0;                 \n a[2] = 0;                 \n fun(a);                   \n a;                        \n";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{1L, 2L, 3L};
        super.evaluateResult(lArray, lArray2, "void fun(int &x[]) { x[0]=1; x[1]=2; x[2]=3; } int a[3]; ... fun(a); ", string);
        string = " int a[3];                        \n                                  \n bool[] fun(int &x[]) {           \n     a[0] = 1;                    \n     a[1] = 2;                    \n     a[2] = 3;                    \n                                  \n     bool result[] = (a==x);      \n     return result;               \n }                                \n                                  \n a[0] = 0;                        \n a[1] = 0;                        \n a[2] = 0;                        \n bool r[] = fun(a);               \n r;                               \n";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, true, true};
        super.evaluateResult(blArray, blArray2, "int a[3]; bool[] fun(int &x[]) { x[0]=1; ... x[2]=3; bool result[] = (a==x); return result; } bool r[]=fun(a); ", string);
        string = " void fun(int &x[]) {             \n     int y[4];                    \n     y[0] = 1;                    \n     y[1] = 2;                    \n     y[2] = 3;                    \n     y[3] = 4;                    \n     x = y;                       \n }                                \n                                  \n int a[3];                        \n a[0] = 0;                        \n a[1] = 0;                        \n a[2] = 0;                        \n fun(a);                          \n a;                               \n";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{1L, 2L, 3L, 4L};
        super.evaluateResult(lArray, lArray2, "void fun(int &x[]) { int y[4]; y[0]=1; ... y[3]=4; x=y; } int a[3]; a[0]=0; ... a[2]=0; fun(a); ", string);
        string = " int a[3];                        \n                                  \n bool[] fun(int &x[]) {           \n     int y[4];                    \n     y[0] = 1;                    \n     y[1] = 2;                    \n     y[2] = 3;                    \n     y[3] = 4;                    \n     a = y;                       \n                                  \n     bool result[] = (a == x);    \n     return result;               \n }                                \n                                  \n a[0] = 0;                        \n a[1] = 0;                        \n a[2] = 0;                        \n bool r[] = fun(a);               \n r;                               \n";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true};
        super.evaluateResult(lArray, lArray2, "int a[3]; bool[] fun(int &x[]) { int y[4]; y[0]=1; ... y[3]=4; a=y; bool result[]=(a==y); return result; } a[0]=0; ... a[2]=0; bool r[]=fun(a); ", string);
    }

    private void testFunctionCallsBySubscriptReferences() throws VnanoException {
        String string = " void fun(int x) {         \n     x = 2;                \n }                         \n                           \n int a[3];                 \n a[0] = 0;                 \n a[1] = 0;                 \n a[2] = 0;                 \n fun(a[1]);                \n a[1];                     \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 0L, "void fun(int x) { x=2; } int a[3]; ... fun(a[1]); ", string);
        string = " void fun(int &x) {        \n     x = 2;                \n }                         \n                           \n int a[3];                 \n a[0] = 0;                 \n a[1] = 0;                 \n a[2] = 0;                 \n fun(a[1]);                \n a[1];                     \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "void fun(int &x) { x=2; } int a[3]; ... fun(a[1]); ", string);
    }

    private void testSequentialFunctionCalls() throws VnanoException {
        String string = " int fun1() {                                 \n     return 1;                                \n }                                            \n int fun2() {                                 \n     return 2;                                \n }                                            \n int fun3() {                                 \n     return 3;                                \n }                                            \n int fun4() {                                 \n     return 4;                                \n }                                            \n int fun5() {                                 \n     return 5;                                \n }                                            \n fun1() + fun2() + fun3() + fun4() + fun5();  \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 15L, "int fun1(){...} int fun2(){...} ... int fun5(){...}  fun1()+fun2()+fun3()+fun4()+fun5(); ", string);
        string = " int fun1(int x) {                                         \n     return x + 1;                                         \n }                                                         \n int fun2(int x) {                                         \n     return x * 2 - 32;                                    \n }                                                         \n int fun3(int x) {                                         \n     return x * x * x;                                     \n }                                                         \n int fun4(int x) {                                         \n     return x * x - x / 2;                                 \n }                                                         \n int fun5(int x) {                                         \n     return x % 7;                                         \n }                                                         \n fun1(123) + fun2(456) + fun3(789) + fun4(10) + fun5(20);  \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 491170174L, "int fun1(int x){...} int fun2(int x){...} ... int fun5(int x){...}  fun1(...)+fun2(...)+fun3(...)+fun4(...)+fun5(...); ", string);
        string = " int[] fun1() {                               \n     int a[3];                                \n     a[0] = 1;                                \n     a[1] = 2;                                \n     a[2] = 3;                                \n     return a;                                \n }                                            \n int[] fun2() {                               \n     int a[3];                                \n     a[0] = 10;                               \n     a[1] = 20;                               \n     a[2] = 30;                               \n     return a;                                \n }                                            \n int[] fun3() {                               \n     int a[3];                                \n     a[0] = 100;                              \n     a[1] = 200;                              \n     a[2] = 300;                              \n     return a;                                \n }                                            \n int[] fun4() {                               \n     int a[3];                                \n     a[0] = 1000;                             \n     a[1] = 2000;                             \n     a[2] = 3000;                             \n     return a;                                \n }                                            \n int[] fun5() {                               \n     int a[3];                                \n     a[0] = 10000;                            \n     a[1] = 20000;                            \n     a[2] = 30000;                            \n     return a;                                \n }                                            \n fun1() + fun2() + fun3() + fun4() + fun5();  \n";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{11111L, 22222L, 33333L};
        super.evaluateResult(lArray, lArray2, "int[] fun1(){...} int[] fun2(){...} ... int[] fun5(){...}  fun1()+fun2()+fun3()+fun4()+fun5(); ", string);
    }

    private void testNestedFunctionCalls() throws VnanoException {
        String string = " int fun0() {                         \n     return fun1();                   \n }                                    \n int fun1() {                         \n     return fun2();                   \n }                                    \n int fun2() {                         \n     return fun3();                   \n }                                    \n int fun3() {                         \n     return fun4();                   \n }                                    \n int fun4() {                         \n     return fun5();                   \n }                                    \n int fun5() {                         \n     return fun6();                   \n }                                    \n int fun6() {                         \n     return fun7();                   \n }                                    \n int fun7() {                         \n     return fun8();                   \n }                                    \n int fun8() {                         \n     return fun9();                   \n }                                    \n int fun9() {                         \n     return fun10();                  \n }                                    \n int fun10() {                        \n     return fun11();                  \n }                                    \n int fun11() {                        \n     return fun12();                  \n }                                    \n int fun12() {                        \n     return fun13();                  \n }                                    \n int fun13() {                        \n     return fun14();                  \n }                                    \n int fun14() {                        \n     return fun15();                  \n }                                    \n int fun15() {                        \n     return fun16();                  \n }                                    \n int fun16() {                        \n     return fun17();                  \n }                                    \n int fun17() {                        \n     return fun18();                  \n }                                    \n int fun18() {                        \n     return fun19();                  \n }                                    \n int fun19() {                        \n     return fun20();                  \n }                                    \n int fun20() {                        \n     return 123;                      \n }                                    \n fun0();                              \n";
        long l = (Long)this.engine.executeScript(string);
        long l2 = 123L;
        super.evaluateResult(l, l2, "Nested functin calls (case 1) ", string);
        string = " int fun0() {                         \n     return fun1() + fun2();          \n }                                    \n                                      \n int fun1() {                         \n     return fun11() + fun12();        \n }                                    \n                                      \n int fun11() {                        \n     return fun111() + fun112();      \n }                                    \n int fun12() {                        \n     return fun121() + fun122();      \n }                                    \n                                      \n int fun111() {                       \n     return fun1111() + fun1112();    \n }                                    \n int fun112() {                       \n     return fun1121() + fun1122();    \n }                                    \n int fun121() {                       \n     return fun1211() + fun1212();    \n }                                    \n int fun122() {                       \n     return fun1221() + fun1222();    \n }                                    \n                                      \n int fun1111() {                      \n     return 1111;                     \n }                                    \n int fun1112() {                      \n     return 1112;                     \n }                                    \n int fun1121() {                      \n     return 1121;                     \n }                                    \n int fun1122() {                      \n     return 1122;                     \n }                                    \n int fun1211() {                      \n     return 1211;                     \n }                                    \n int fun1212() {                      \n     return 1212;                     \n }                                    \n int fun1221() {                      \n     return 1221;                     \n }                                    \n int fun1222() {                      \n     return 1222;                     \n }                                    \n                                      \n int fun2() {                         \n     return fun21() + fun22();        \n }                                    \n                                      \n int fun21() {                        \n     return fun211() + fun212();      \n }                                    \n int fun22() {                        \n     return fun221() + fun222();      \n }                                    \n                                      \n int fun211() {                       \n     return fun2111() + fun2112();    \n }                                    \n int fun212() {                       \n     return fun2121() + fun2122();    \n }                                    \n int fun221() {                       \n     return fun2211() + fun2212();    \n }                                    \n int fun222() {                       \n     return fun2221() + fun2222();    \n }                                    \n                                      \n int fun2111() {                      \n     return 2111;                     \n }                                    \n int fun2112() {                      \n     return 2112;                     \n }                                    \n int fun2121() {                      \n     return 2121;                     \n }                                    \n int fun2122() {                      \n     return 2122;                     \n }                                    \n int fun2211() {                      \n     return 2211;                     \n }                                    \n int fun2212() {                      \n     return 2212;                     \n }                                    \n int fun2221() {                      \n     return 2221;                     \n }                                    \n int fun2222() {                      \n     return 2222;                     \n }                                    \n                                      \n fun0();                              \n";
        l = (Long)this.engine.executeScript(string);
        l2 = 26664L;
        super.evaluateResult(l, l2, "Nested functin calls (case 2) ", string);
    }

    private void testArgumentScopes() throws VnanoException {
        String string = " void fun(int x) {  \n }                  \n                    \n fun(0);            \n x = 123;           \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("void fun(int x){ } fun(0); x=123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("void fun(int x){ } fun(0); x=123; (should be failed) ");
        }
        string = " int x;             \n                    \n void fun(int x) {  \n }                  \n";
        this.engine.executeScript(string);
        this.succeeded("int x; void fun(int x){ } ");
    }

    private void testFunctionRanges() throws VnanoException {
        String string = " void fun() {       \n     return;        \n }                  \n";
        this.engine.executeScript(string);
        this.succeeded("void fun(){ return; } ");
        string = " void fun() {       \n }                  \n return;            \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("void fun(){ } return; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("void fun(){ } return; (should be failed) ");
        }
        string = " void fun() {       \n }                  \n {                  \n     return;        \n }                  \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("void fun(int x){ } { return; } (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("void fun(){ } { return; } (should be failed) ");
        }
    }

    private void testDuplicateFunctionDeclarations() throws VnanoException {
        String string = " void fun(int x) {  \n }                  \n void fun(int x) {  \n }                  \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("void fun(int x){ } void fun(int x){ } (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("void fun(int x){ } void fun(int x){ } (should be failed) ");
        }
        string = " void fun(int x) {    \n }                    \n void fun(float x) {  \n }                    \n";
        this.engine.executeScript(string);
        this.succeeded("void fun(int x){ } void fun(float x){ } ");
    }

    private void testPassingConstants() throws VnanoException {
        String string = " void fun(int x) {  \n }                  \n fun(123);          \n";
        this.engine.executeScript(string);
        this.succeeded("void fun(int x){ } fun(123); ");
        string = " void fun(int &x) {  \n }                   \n fun(123);           \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("void fun(int &x){ } fun(123); (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("void fun(int &x){ } fun(123); (should be failed) ");
        }
        string = " void fun(const int &x) {  \n }                         \n fun(123);                 \n";
        this.engine.executeScript(string);
        this.succeeded("void fun(const int &x){ } fun(123); ");
        string = " void fun(const int x) {  \n     x = 456;             \n }                        \n fun(123);                \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("void fun(const int x){ x=456; } fun(123); (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("void fun(const int x){ x=456; } fun(123); (should be failed) ");
        }
        string = " void fun(const int &x) {  \n     x = 456;              \n }                         \n fun(123);                 \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("void fun(const int &x){ x=456; } fun(123); (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("void fun(const int &x){ x=456; } fun(123); (should be failed) ");
        }
    }

    private void testMultipleCallsOfFunctionsHavingBranchings() throws VnanoException {
        String string = " void fun() {       \n     int x = 0;     \n     if (true) {    \n         x = 1;     \n     } else {       \n         x = 2;     \n     }              \n }                  \n                    \n string s = \"\";   \n s += \"0\";        \n s += \"1\";        \n s += \"2\";        \n s += \"3\";        \n s += \"4\";        \n fun();             \n s += \"5\";        \n s += \"6\";        \n s += \"7\";        \n s += \"8\";        \n s += \"9\";        \n s;                 \n";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "0123456789", "Multiple calls of functions having branchings (case 1) ", string);
        string = " void fun() {       \n     int x = 0;     \n     if (true) {    \n         x = 1;     \n     } else {       \n         x = 2;     \n     }              \n }                  \n                    \n string s = \"\";   \n s += \"0\";        \n s += \"1\";        \n s += \"2\";        \n fun();             \n s += \"3\";        \n s += \"4\";        \n s += \"5\";        \n fun();             \n s += \"6\";        \n s += \"7\";        \n s += \"8\";        \n s += \"9\";        \n s;                 \n";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "0123456789", "Multiple calls of functions having branchings (case 2) ", string);
        string = " void fun() {       \n     int x = 0;     \n     if (true) {    \n         x = 1;     \n     } else {       \n         x = 2;     \n     }              \n }                  \n                    \n string s = \"\";   \n s += \"0\";        \n s += \"1\";        \n s += \"2\";        \n fun();             \n s += \"3\";        \n s += \"4\";        \n fun();             \n s += \"5\";        \n s += \"6\";        \n s += \"7\";        \n fun();             \n s += \"8\";        \n s += \"9\";        \n s;                 \n";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "0123456789", "Multiple calls of functions having branchings (case 3) ", string);
        string = " void fun() {       \n     int x = 0;     \n     if (true) {    \n         x = 1;     \n     } else {       \n         x = 2;     \n     }              \n }                  \n                    \n string s = \"\";   \n s += \"0\";        \n s += \"1\";        \n fun();             \n s += \"2\";        \n s += \"3\";        \n fun();             \n s += \"4\";        \n s += \"5\";        \n fun();             \n s += \"6\";        \n s += \"7\";        \n fun();             \n s += \"8\";        \n s += \"9\";        \n s;                 \n";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "0123456789", "Multiple calls of functions having branchings (case 4) ", string);
        string = " void fun() {       \n     int x = 0;     \n     if (true) {    \n         x = 1;     \n     } else {       \n         x = 2;     \n     }              \n }                  \n                    \n string s = \"\";   \n s += \"0\";        \n s += \"1\";        \n fun();             \n s += \"2\";        \n fun();             \n s += \"3\";        \n s += \"4\";        \n fun();             \n s += \"5\";        \n fun();             \n s += \"6\";        \n s += \"7\";        \n fun();             \n s += \"8\";        \n s += \"9\";        \n s;                 \n";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "0123456789", "Multiple calls of functions having branchings (case 5) ", string);
    }
}

