/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class ScalarAssignmentOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAssignmentOperations();
            this.testMultipleAssignmentOperations();
            this.testAssignmentOperationsWithTypeConversions();
            this.testAssignmentOperationsToConstants();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAssignmentOperations() throws VnanoException {
        String string = " int x; x = 123; x; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 123L, "int = int", string);
        string = " float x; x = 1.25; x; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1.25, "float = float", string);
        string = " bool x; x = true; x; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool = bool", string);
        string = " string x; x = \"abc\"; x; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "abc", "string = string", string);
        string = " int x = 123; x; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 123L, "int = int (init in variable declaration)", string);
        string = " float x = 1.25; x; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1.25, "float = float (init in variable declaration)", string);
        string = " bool x = true; x; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool = bool (init in variable declaration)", string);
        string = " string x; x = \"abc\"; x; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "abc", "string = string (init in variable declaration)", string);
    }

    private void testAssignmentOperationsWithTypeConversions() throws VnanoException {
        String string = " int x; x = 1.25; x; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 1L, "int = float", string);
        string = " int x; x = \"123\"; x; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 123L, "int = string", string);
        string = " float x; x = 123; x; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 123.0, "float = int", string);
        string = " float x; x = \"1.25\"; x; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1.25, "float = string", string);
        string = " bool x=false; x = \"true\"; x; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool = string (\"true\")", string);
        string = " bool x=true; x = \"false\"; x; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool = string (\"false\")", string);
        string = " string x; x = 123; x; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "123", "string = int", string);
        string = " string x; x = 1.25; x; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, Double.toString(1.25), "string = float", string);
        string = " string x; x = true; x; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "true", "string = bool (true)", string);
        string = " string x; x = false; x; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "false", "string = bool (false)", string);
    }

    private void testMultipleAssignmentOperations() throws VnanoException {
        String string = " int x; int a=123; int b=456; int c=789; x = a = b = c; x; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 789L, "int = int = int = int", string);
        string = " float x; float a=1.23; float b=4.56; float c=7.89; x = a = b = c; x; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 7.89, "float = float = float = float", string);
        string = " bool x; bool a=false; bool b=false; bool c=true; x = a = b = c; x; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool = bool = bool = bool", string);
        string = " string x; string a=\"abc\"; string b=\"def\"; string c=\"ghi\"; x = a = b = c; x; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "ghi", "string = string = string = string", string);
    }

    private void testAssignmentOperationsToConstants() throws VnanoException {
        String string = "const int x = 123;";
        this.engine.executeScript(string);
        this.succeeded("const int x = 123; ");
        string = "const int x; x = 123;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int x; x = 123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int x; x = 123; (should be failed) ");
        }
    }
}

