/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class ScalarComparisonOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testEqualOperations();
            this.testNotEqualOperations();
            this.testLessThanOperations();
            this.testLessEqualOperations();
            this.testGreaterThanOperations();
            this.testGreaterEqualOperations();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testEqualOperations() throws VnanoException {
        String string = " 1 == 1 ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int == int (same values)", string);
        string = " 1 == 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int == int (different values)", string);
        string = " 1 == 1.0 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int == float (same values)", string);
        string = " 1 == 1.25 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int == float (different values)", string);
        string = " 1 == \"1\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int == string (same values)", string);
        string = " 1 == \"2\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int == string (different values)", string);
        string = " 1.5 == 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float == float (same values)", string);
        string = " 1.5 == 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float == float (different values)", string);
        string = " 1.0 == 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float == int (same values)", string);
        string = " 1.25 == 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float == int (different values)", string);
        string = " 1.5 == \"1.5\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float == string (same values)", string);
        string = " 1.5 == \"2.5\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float == string (different values)", string);
        string = " true == true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool == bool (same values)", string);
        string = " true == false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool == bool (different values)", string);
        string = " true == \"true\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool == string (same values)", string);
        string = " true == \"false\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool == string (different values)", string);
        string = " \"abc\" == \"abc\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string == string (same values)", string);
        string = " \"abc\" == \"def\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string == string (different values)", string);
        string = " \"1\" == 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string == int (same values)", string);
        string = " \"2\" == 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string == int (different values)", string);
        string = " \"1.5\" == 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string == float (same values)", string);
        string = " \"2.5\" == 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string == int (different values)", string);
        string = " \"true\" == true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string == bool (same values)", string);
        string = " \"false\" == true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string == bool (different values)", string);
    }

    private void testNotEqualOperations() throws VnanoException {
        String string = " 1 != 1 ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int != int (same values)", string);
        string = " 1 != 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int != int (different values)", string);
        string = " 1 != 1.0 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int != float (same values)", string);
        string = " 1 != 1.25 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int != float (different values)", string);
        string = " 1 != \"1\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int != string (same values)", string);
        string = " 1 != \"2\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int != string (different values)", string);
        string = " 1.5 != 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float != float (same values)", string);
        string = " 1.5 != 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float != float (different values)", string);
        string = " 1.0 != 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float != int (same values)", string);
        string = " 1.25 != 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float != int (different values)", string);
        string = " 1.5 != \"1.5\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float != string (same values)", string);
        string = " 1.5 != \"2.5\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float != string (different values)", string);
        string = " true != true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool != bool (same values)", string);
        string = " true != false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool != bool (different values)", string);
        string = " true != \"true\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool != string (same values)", string);
        string = " true != \"false\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool != string (different values)", string);
        string = " \"abc\" != \"abc\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string != string (same values)", string);
        string = " \"abc\" != \"def\" ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string != string (different values)", string);
        string = " \"1\" != 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string != int (same values)", string);
        string = " \"2\" != 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string != int (different values)", string);
        string = " \"1.5\" != 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string != float (same values)", string);
        string = " \"2.5\" != 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string != int (different values)", string);
        string = " \"true\" != true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string != bool (same values)", string);
        string = " \"false\" != true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string != bool (different values)", string);
    }

    private void testLessThanOperations() throws VnanoException {
        String string = " 1 < 1 ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int < int (same values)", string);
        string = " 1 < 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int < int (different values, right is greater)", string);
        string = " 2 < 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int < int (different values, left is greater)", string);
        string = " 1.5 < 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float < float (same values)", string);
        string = " 1.5 < 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float < float (different values, right is greater)", string);
        string = " 2.5 < 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float < float (different values, left is greater)", string);
        string = " 1 < 1.0 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int < float (same values)", string);
        string = " 1 < 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int < float (different values, right is greater)", string);
        string = " 2 < 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int < float (different values, left is greater)", string);
        string = " 1.0 < 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float < int (same values)", string);
        string = " 1.5 < 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float < int (different values, right is greater)", string);
        string = " 2.5 < 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float < int (different values, left is greater)", string);
    }

    private void testLessEqualOperations() throws VnanoException {
        String string = " 1 <= 1 ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int <= int (same values)", string);
        string = " 1 <= 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int <= int (different values, right is greater)", string);
        string = " 2 <= 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int <= int (different values, left is greater)", string);
        string = " 1.5 <= 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float <= float (same values)", string);
        string = " 1.5 <= 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float <= float (different values, right is greater)", string);
        string = " 2.5 <= 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float <= float (different values, left is greater)", string);
        string = " 1 <= 1.0 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int <= float (same values)", string);
        string = " 1 <= 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int <= float (different values, right is greater)", string);
        string = " 2 <= 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int <= float (different values, left is greater)", string);
        string = " 1.0 <= 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float <= int (same values)", string);
        string = " 1.5 <= 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float <= int (different values, right is greater)", string);
        string = " 2.5 <= 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float <= int (different values, left is greater)", string);
    }

    private void testGreaterThanOperations() throws VnanoException {
        String string = " 1 > 1 ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int > int (same values)", string);
        string = " 1 > 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int > int (different values, right is greater)", string);
        string = " 2 > 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int > int (different values, left is greater)", string);
        string = " 1.5 > 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float > float (same values)", string);
        string = " 1.5 > 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float > float (different values, right is greater)", string);
        string = " 2.5 > 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float > float (different values, left is greater)", string);
        string = " 1 > 1.0 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int > float (same values)", string);
        string = " 1 > 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int > float (different values, right is greater)", string);
        string = " 2 > 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int > float (different values, left is greater)", string);
        string = " 1.0 > 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float > int (same values)", string);
        string = " 1.5 > 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float > int (different values, right is greater)", string);
        string = " 2.5 > 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float > int (different values, left is greater)", string);
    }

    private void testGreaterEqualOperations() throws VnanoException {
        String string = " 1 >= 1 ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int > int (same values)", string);
        string = " 1 >= 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int > int (different values, right is greater)", string);
        string = " 2 >= 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int > int (different values, left is greater)", string);
        string = " 1.5 >= 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float > float (same values)", string);
        string = " 1.5 >= 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float > float (different values, right is greater)", string);
        string = " 2.5 >= 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float > float (different values, left is greater)", string);
        string = " 1 >= 1.0 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int > float (same values)", string);
        string = " 1 >= 2.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int > float (different values, right is greater)", string);
        string = " 2 >= 1.5 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int > float (different values, left is greater)", string);
        string = " 1.0 >= 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float > int (same values)", string);
        string = " 1.5 >= 2 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float > int (different values, right is greater)", string);
        string = " 2.5 >= 1 ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float > int (different values, left is greater)", string);
    }
}

