/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class SubscriptedAssignmentOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_INT_A = "int a[3]; a[0]=10; a[1]=50; a[2]=30; ";
    private static final String DECLVEC_INT_B = "int b[3]; b[0]=5; b[1]=50; b[2]=10; ";
    private static final String DECLVEC_INT_C = "int c[3]; c[0]=2; c[1]=20; c[2]=32; ";
    private static final String DECLVEC_INT_D = "int d[3]; d[0]=1; d[1]=82; d[2]=64; ";
    private static final String DECLVEC_FLOAT_A = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125; ";
    private static final String DECLVEC_FLOAT_B = "float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.125; ";
    private static final String DECLVEC_FLOAT_C = "float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; ";
    private static final String DECLVEC_FLOAT_D = "float d[3]; d[0]=8.25; d[1]=22.8; d[2]=64.25; ";
    private static final String DECLVEC_BOOL_A = "bool a[3]; a[0]=true; a[1]=false; a[2]=false; ";
    private static final String DECLVEC_BOOL_B = "bool b[3]; b[0]=false; b[1]=true; b[2]=false; ";
    private static final String DECLVEC_BOOL_C = "bool c[3]; c[0]=false; c[1]=false; c[2]=true; ";
    private static final String DECLVEC_BOOL_D = "bool d[3]; d[0]=false; d[1]=true; d[2]=true; ";
    private static final String DECLVEC_STRING_A = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; ";
    private static final String DECLVEC_STRING_B = "string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; ";
    private static final String DECLVEC_STRING_C = "string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; ";
    private static final String DECLVEC_STRING_D = "string d[3]; d[0]=\"123\"; d[1]=\"456\"; d[2]=\"789\"; ";
    private static final String DECLVEC_STRING_E = "string e[3]; e[0]=\"2.125\"; e[1]=\"2.25\"; e[2]=\"2.5\"; ";
    private static final String DECLVEC_STRING_F = "string f[3]; f[0]=\"true\"; f[1]=\"false\"; f[2]=\"true\"; ";

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAssignmentOperations();
            this.testMultipleAssignmentOperations();
            this.testAssignmentOperationsWithTypeConversions();
            this.testAssignmentOperationsToConstants();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[2] = b[2]; a[2]; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "int[i] = int[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.125;  a[2] = b[2]; a[2]; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 12.125, "float[i] = float[i]", string);
        string = "bool a[3]; a[0]=true; a[1]=false; a[2]=false; bool b[3]; b[0]=false; b[1]=true; b[2]=false;  a[1] = b[1]; a[1]; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] = bool[i]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\";  a[2] = b[2]; a[2]; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "sasisuseso", "string[i] = string[i]", string);
    }

    private void testAssignmentOperationsWithTypeConversions() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.125;  a[2] = b[2]; a[2]; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 12L, "int[i] = float[j]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; string d[3]; d[0]=\"123\"; d[1]=\"456\"; d[2]=\"789\";  a[2] = d[2]; a[2]; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 789L, "int[i] = string[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[2] = b[2]; a[2]; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 10.0, "float[i] = int[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125; string e[3]; e[0]=\"2.125\"; e[1]=\"2.25\"; e[2]=\"2.5\";  a[2] = e[2]; a[2]; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 2.5, "float[i] = string[i]", string);
        string = "bool a[3]; a[0]=true; a[1]=false; a[2]=false; string f[3]; f[0]=\"true\"; f[1]=\"false\"; f[2]=\"true\";  a[2] = f[2]; a[2]; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] = string[i] (\"true\")", string);
        string = "bool a[3]; a[0]=true; a[1]=false; a[2]=false; string f[3]; f[0]=\"true\"; f[1]=\"false\"; f[2]=\"true\";  a[1] = f[0]; a[1]; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] = string[j] (\"false\")", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[2] = b[2]; a[2]; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "10", "string = int", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.125;  a[2] = b[2]; a[2]; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, Double.toString(12.125), "string[i] = float[i]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; bool b[3]; b[0]=false; b[1]=true; b[2]=false;  a[2] = b[1]; a[2]; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "true", "string[i] = bool[j] (true)", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; bool b[3]; b[0]=false; b[1]=true; b[2]=false;  a[2] = b[0]; a[2]; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "false", "string[i] = bool[j] (false)", string);
    }

    private void testMultipleAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=82; d[2]=64;  a[2] = b[2] = c[2] = d[2]; a[2]; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 64L, "int[i] = int[i] = int[i] = int[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.125; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=8.25; d[1]=22.8; d[2]=64.25;  a[2] = b[2] = c[2] = d[2]; a[2]; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 64.25, "float[i] = float[i] = float[i] = float[i]", string);
        string = "bool a[3]; a[0]=true; a[1]=false; a[2]=false; bool b[3]; b[0]=false; b[1]=true; b[2]=false; bool c[3]; c[0]=false; c[1]=false; c[2]=true; bool d[3]; d[0]=false; d[1]=true; d[2]=true;  a[2] = b[2] = c[2] = d[2]; a[2]; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] = bool[i] = bool[i] = bool[i] (true)", string);
        string = "bool a[3]; a[0]=true; a[1]=false; a[2]=false; bool b[3]; b[0]=false; b[1]=true; b[2]=false; bool c[3]; c[0]=false; c[1]=false; c[2]=true; bool d[3]; d[0]=false; d[1]=true; d[2]=true;  a[0] = b[0] = c[0] = d[0]; a[0]; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool[i] = bool[i] = bool[i] = bool[i] (false)", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"123\"; d[1]=\"456\"; d[2]=\"789\";  a[2] = b[2] = c[2] = d[2]; a[2]; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "789", "string[i] = string[i] = string[i] = string[i]", string);
    }

    private void testAssignmentOperationsToConstants() throws VnanoException {
        String string = "const int a[3]; a[1] = 2;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; a[1] = 2; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; a[1] = 2; (should be failed) ");
        }
    }
}

