/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class SubscriptedComparisonOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_INT_A = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; ";
    private static final String DECLVEC_INT_B = "int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200; ";
    private static final String DECLVEC_FLOAT_A = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; ";
    private static final String DECLVEC_FLOAT_B = "float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2; ";
    private static final String DECLVEC_BOOL_A = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; ";
    private static final String DECLVEC_BOOL_B = "bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true; ";
    private static final String DECLVEC_STRING_A = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; ";
    private static final String DECLVEC_STRING_B = "string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\"; ";

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testEqualOperations();
            this.testNotEqualOperations();
            this.testLessThanOperations();
            this.testLessEqualOperations();
            this.testGreaterThanOperations();
            this.testGreaterEqualOperations();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testEqualOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[1] == b[1] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] == int[i]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] == b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] == int[i]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[1] == b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] == float[i]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] == b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] == float[i]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[1] == b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] == int[i]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] == b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] == int[i]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[1] == b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] == int[i]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] == b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] == int[i]   (case 2)", string);
        string = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true;  a[0] == b[0] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool[i] == bool[i]   (case 1)", string);
        string = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true;  a[2] == b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] == bool[i]   (case 2)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a[0] == b[0] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string[i] == string[i]   (case 1)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a[1] == b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string[i] == string[i]   (case 2)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[1] == b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string[i] == int[i]   (case 1)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] == b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string[i] == int[i]   (case 2)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[1] == b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string[i] == float[i]   (case 1)", string);
        string = "string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\"; float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2;  b[2] == a[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string[i] == float[i]   (case 2)", string);
    }

    private void testNotEqualOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[1] != b[1] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] != int[i]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] != b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] != int[i]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[1] != b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] != float[i]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] != b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] != float[i]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[1] != b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] != int[i]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] != b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] != int[i]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[1] != b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] != int[i]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] != b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] != int[i]   (case 2)", string);
        string = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true;  a[0] != b[0] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] != bool[i]   (case 1)", string);
        string = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true;  a[2] != b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool[i] != bool[i]   (case 2)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a[0] != b[0] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string[i] != string[i]   (case 1)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a[1] != b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string[i] != string[i]   (case 2)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[1] != b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string[i] != int[i]   (case 1)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] != b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string[i] != int[i]   (case 2)", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[1] != b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "string[i] != float[i]   (case 1)", string);
        string = "string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\"; float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2;  b[2] != a[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "string[i] != float[i]   (case 2)", string);
    }

    private void testLessThanOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] < b[3] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] < int[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] < b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] < int[j]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[3] < b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] < int[j]   (case 3)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] < b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] < float[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] < b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] < float[j]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[3] < b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] < float[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] < b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] < float[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] < b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] < float[j]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[3] < b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] < float[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] < b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] < int[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] < b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] < int[j]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[3] < b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] < int[j]   (case 1)", string);
    }

    private void testLessEqualOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] <= b[3] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] <= int[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] <= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] <= int[j]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[3] <= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] <= int[j]   (case 3)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] <= b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] <= float[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] <= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] <= float[j]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[3] <= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] <= float[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] <= b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] <= float[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] <= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] <= float[j]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[3] <= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] <= float[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] <= b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] <= int[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] <= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] <= int[j]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[3] <= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] <= int[j]   (case 1)", string);
    }

    private void testGreaterThanOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] > b[3] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] > int[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] > b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] > int[j]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[3] > b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] > int[j]   (case 3)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] > b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] > float[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] > b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] > float[j]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[3] > b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] > float[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] > b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] > float[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] > b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] > float[j]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[3] > b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] > float[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] > b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] > int[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] > b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] > int[j]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[3] > b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] > int[j]   (case 1)", string);
    }

    private void testGreaterEqualOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] >= b[3] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] >= int[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] >= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] >= int[j]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[3] >= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] >= int[j]   (case 3)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] >= b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] >= float[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] >= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] >= float[j]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[3] >= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] >= float[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] >= b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "int[i] >= float[j]   (case 1)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[2] >= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] >= float[j]   (case 2)", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a[3] >= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "int[i] >= float[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] >= b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "float[i] >= int[j]   (case 1)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[2] >= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] >= int[j]   (case 2)", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a[3] >= b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "float[i] >= int[j]   (case 1)", string);
    }
}

