/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class SubscriptedLogicalOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_A = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; ";
    private static final String DECLVEC_B = "bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; ";
    private static final boolean T = true;
    private static final boolean F = false;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAndOperations();
            this.testOrOperations();
            this.testNotOperations();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAndOperations() throws VnanoException {
        String string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a[0] && b[0] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] && bool[i]   (case 1)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a[1] && b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool[i] && bool[i]   (case 2)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a[2] && b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool[i] && bool[i]   (case 3)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a[3] && b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool[i] && bool[i]   (case 4)", string);
    }

    private void testOrOperations() throws VnanoException {
        String string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a[0] || b[0] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] || bool[i]   (case 1)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a[1] || b[1] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] || bool[i]   (case 2)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a[2] || b[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool[i] || bool[i]   (case 3)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a[3] || b[3] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool[i] || bool[i]   (case 4)", string);
    }

    private void testNotOperations() throws VnanoException {
        String string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  ! a[1] ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "! bool[i]   (case 1)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  ! a[2] ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "! bool[i]   (case 2)", string);
    }
}

