/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class VectorArithmeticOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_INT_A = "int a[3]; a[0]=10; a[1]=50; a[2]=30; ";
    private static final String DECLVEC_INT_B = "int b[3]; b[0]=5; b[1]=50; b[2]=10; ";
    private static final String DECLVEC_INT_C = "int c[3]; c[0]=2; c[1]=20; c[2]=32; ";
    private static final String DECLVEC_INT_D = "int d[3]; d[0]=1; d[1]=2; d[2]=3; ";
    private static final String DECLVEC_FLOAT_A = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; ";
    private static final String DECLVEC_FLOAT_B = "float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; ";
    private static final String DECLVEC_FLOAT_C = "float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; ";
    private static final String DECLVEC_FLOAT_D = "float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125; ";
    private static final String DECLVEC_STRING_A = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; ";
    private static final String DECLVEC_STRING_B = "string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; ";
    private static final String DECLVEC_STRING_C = "string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; ";
    private static final String DECLVEC_STRING_D = "string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\"; ";

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAdditions();
            this.testSubtractions();
            this.testMultiplications();
            this.testDivisions();
            this.testRemainders();
            this.testDualOperations();
            this.testTripleOperations();
            this.testVectorScalarMixedOperations();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAdditions() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a + b ; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{15L, 100L, 40L};
        super.evaluateResult(lArray, lArray2, "int[] + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a + b ; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{14.25, 52.8, 42.8};
        super.evaluateResult(dArray, dArray2, "int[] + float[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\";  a + b ; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"10aiueo", "50kakikukeko", "30sasisuseso"};
        super.evaluateResult(stringArray, stringArray2, "int[] + string[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a + b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{7.2, 51.4, 18.2};
        super.evaluateResult(dArray, dArray2, "float[] + int[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a + b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{6.45, 4.199999999999999, 21.0};
        super.evaluateResult(dArray, dArray2, "float[] + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\";  a + b ; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"2.2aiueo", "1.4kakikukeko", "8.2sasisuseso"};
        super.evaluateResult(stringArray, stringArray2, "float[] + string[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a + b ; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abc5", "def50", "ghi10"};
        super.evaluateResult(stringArray, stringArray2, "string[] + int[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a + b ; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abc4.25", "def2.8", "ghi12.8"};
        super.evaluateResult(stringArray, stringArray2, "string[] + float[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\";  a + b ; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abcaiueo", "defkakikukeko", "ghisasisuseso"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string[]", string);
    }

    private void testSubtractions() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a - b ; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{5L, 0L, 20L};
        super.evaluateResult(lArray, lArray2, "int[] - int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a - b ; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{5.75, 47.2, 17.2};
        super.evaluateResult(dArray, dArray2, "int[] - float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a - b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{-2.8, -48.6, -1.8000000000000007};
        super.evaluateResult(dArray, dArray2, "float[] - int[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a - b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{-2.05, -1.4, -4.600000000000001};
        super.evaluateResult(dArray, dArray2, "float[] - int[]", string);
    }

    private void testMultiplications() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a * b ; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{50L, 2500L, 300L};
        super.evaluateResult(lArray, lArray2, "int[] * int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a * b ; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{42.5, 140.0, 384.0};
        super.evaluateResult(dArray, dArray2, "int[] * float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a * b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{11.0, 70.0, 82.0};
        super.evaluateResult(dArray, dArray2, "float[] + int[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a * b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{9.350000000000001, 3.9199999999999995, 104.96};
        super.evaluateResult(dArray, dArray2, "float[] * int[]", string);
    }

    private void testDivisions() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a / b ; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{2L, 1L, 3L};
        super.evaluateResult(lArray, lArray2, "int[] / int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a / b ; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{2.3529411764705883, 17.857142857142858, 2.34375};
        super.evaluateResult(dArray, dArray2, "int[] / float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a / b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{0.44000000000000006, 0.027999999999999997, 0.82};
        super.evaluateResult(dArray, dArray2, "float[] / int[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a / b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{0.5176470588235295, 0.5, 0.6406249999999999};
        super.evaluateResult(dArray, dArray2, "float[] / int[]", string);
    }

    private void testRemainders() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a % b ; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{0L, 0L, 0L};
        super.evaluateResult(lArray, lArray2, "int[] % int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a % b ; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{1.5, 2.400000000000003, 4.399999999999999};
        super.evaluateResult(dArray, dArray2, "int[] % float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a % b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{2.2, 1.4, 8.2};
        super.evaluateResult(dArray, dArray2, "float[] % int[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a % b ; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{2.2, 1.4, 8.2};
        super.evaluateResult(dArray, dArray2, "float[] % int[]", string);
    }

    private void testDualOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32;  a + b + c; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{17L, 120L, 72L};
        super.evaluateResult(lArray, lArray2, "int[] + int[] + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32;  a + b * c; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{20L, 1050L, 350L};
        super.evaluateResult(lArray, lArray2, "int[] + int[] * int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32;  a / b - c; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{0L, -19L, -29L};
        super.evaluateResult(lArray, lArray2, "int[] / int[] - int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32;  a * b % c; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{0L, 0L, 12L};
        super.evaluateResult(lArray, lArray2, "int[] * int[] % int[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8;  a + b + c; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{7.575, 36.599999999999994, 43.8};
        super.evaluateResult(dArray, dArray2, "float[] + float[] + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8;  a + b * c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{6.98125, 92.11999999999999, 300.04};
        super.evaluateResult(dArray, dArray2, "float[] + float[] * float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8;  a / b - c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{-0.6073529411764705, -31.9, -22.159375};
        super.evaluateResult(dArray, dArray2, "float[] / float[] - float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8;  a * b % c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{0.3500000000000014, 3.9199999999999995, 13.759999999999991};
        super.evaluateResult(dArray, dArray2, "float[] * float[] % float[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\";  a + b + c; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abcaiueoNaCl", "defkakikukekoH2O", "ghisasisusesoCaCO3"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string[] + string[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32;  a + b + c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{9.2, 71.4, 50.2};
        super.evaluateResult(dArray, dArray2, "float[] + int[] + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; int c[3]; c[0]=2; c[1]=20; c[2]=32;  a + b + c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{16.25, 72.8, 74.8};
        super.evaluateResult(dArray, dArray2, "int[] + float[] + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8;  a + b + c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{16.125, 132.4, 62.8};
        super.evaluateResult(dArray, dArray2, "int[] + int[] + float[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8;  a + b + c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{15.375, 85.19999999999999, 65.6};
        super.evaluateResult(dArray, dArray2, "int[] + float[] + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8;  a + b + c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{8.325, 83.8, 41.0};
        super.evaluateResult(dArray, dArray2, "float[] + int[] + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; int c[3]; c[0]=2; c[1]=20; c[2]=32;  a + b + c; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{8.45, 24.2, 53.0};
        super.evaluateResult(dArray, dArray2, "float[] + float[] + int[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; int b[3]; b[0]=5; b[1]=50; b[2]=10; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\";  a + b + c; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abc5NaCl", "def50H2O", "ghi10CaCO3"};
        super.evaluateResult(stringArray, stringArray2, "string[] + int[] + string[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\";  a + b + c; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abc4.25NaCl", "def2.8H2O", "ghi12.8CaCO3"};
        super.evaluateResult(stringArray, stringArray2, "string[] + float[] + string[]", string);
    }

    private void testTripleOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + b + c + d; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{18L, 122L, 75L};
        super.evaluateResult(lArray, lArray2, "int[] + int[] + int[] + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a * b - c / d; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{48L, 2490L, 290L};
        super.evaluateResult(lArray, lArray2, "int[] * int[] - int[] / int[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a + b + c + d; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{8.075, 100.8, 299.925};
        super.evaluateResult(dArray, dArray2, "float[] + float[] + float[] + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a * b - c / d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{7.100000000000001, 3.415327102803738, 104.87098096632504};
        super.evaluateResult(dArray, dArray2, "float[] * float[] - float[] / float[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  a + b + c + d; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abcaiueoNaClSi", "defkakikukekoH2ONi", "ghisasisusesoCaCO3Al"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string[] + string[] + string[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; int c[3]; c[0]=2; c[1]=20; c[2]=32; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a * b - c / d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{38.5, 139.68847352024923, 383.8750610053685};
        super.evaluateResult(dArray, dArray2, "int[] * float[] - int[] / float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + b + c + d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{9.325, 85.8, 44.0};
        super.evaluateResult(dArray, dArray2, "float[] + int[] + float[] + int[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; int b[3]; b[0]=5; b[1]=50; b[2]=10; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + b + c + d; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abc5NaCl1", "def50H2O2", "ghi10CaCO33"};
        super.evaluateResult(stringArray, stringArray2, "string[] + int[] + string[] + int[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a + b + c + d; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abc4.25NaCl0.5", "def2.8H2O64.2", "ghi12.8CaCO3256.125"};
        super.evaluateResult(stringArray, stringArray2, "string[] + float[] + string[] + float[]", string);
    }

    private void testVectorScalarMixedOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  123 + b + c + d; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{131L, 195L, 168L};
        super.evaluateResult(lArray, lArray2, "int + int[] + int[] + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + 123 + c + d; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{136L, 195L, 188L};
        super.evaluateResult(lArray, lArray2, "int[] + int + int[] + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + b + 123 + d; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{139L, 225L, 166L};
        super.evaluateResult(lArray, lArray2, "int[] + int[] + int + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + b + c + 123; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{140L, 243L, 195L};
        super.evaluateResult(lArray, lArray2, "int[] + int[] + int[] + int", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  123 + 456 + c + d; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{582L, 601L, 614L};
        super.evaluateResult(lArray, lArray2, "int + int + int[] + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  123 + b + 456 + d; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{585L, 631L, 592L};
        super.evaluateResult(lArray, lArray2, "int + int[] + int + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  123 + b + c + 456; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{586L, 649L, 621L};
        super.evaluateResult(lArray, lArray2, "int + int[] + int[] + int", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + 123 + 456 + d; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{590L, 631L, 612L};
        super.evaluateResult(lArray, lArray2, "int[] + int + int + int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + 123 + c + 456; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{591L, 649L, 641L};
        super.evaluateResult(lArray, lArray2, "int[] + int + int[] + int", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  a + 123 + 456 + 789; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{1378L, 1418L, 1398L};
        super.evaluateResult(lArray, lArray2, "int[] + int + int + int", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32; int d[3]; d[0]=1; d[1]=2; d[2]=3;  123 + 456 + 789 + d; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{1369L, 1370L, 1371L};
        super.evaluateResult(lArray, lArray2, "int + int + int + int[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  1.23 + b + c + d; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{7.105, 100.63, 292.955};
        super.evaluateResult(dArray, dArray2, "float + float[] + float[] + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a + 1.23 + c + d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{5.055, 99.23, 288.355};
        super.evaluateResult(dArray, dArray2, "float[] + float + float[] + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a + b + 1.23 + d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{8.18, 69.63, 278.355};
        super.evaluateResult(dArray, dArray2, "float[] + float[] + float + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a + b + c + 1.23; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{8.805, 37.82999999999999, 45.029999999999994};
        super.evaluateResult(dArray, dArray2, "float[] + float[] + float[] + float", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  1.23 + 4.56 + c + d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{7.414999999999999, 102.39, 284.715};
        super.evaluateResult(dArray, dArray2, "float + float + float[] + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  1.23 + b + 4.56 + d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{10.54, 72.79, 274.715};
        super.evaluateResult(dArray, dArray2, "float + float[] + float + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  1.23 + b + c + 4.56; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{11.165, 40.99, 41.39};
        super.evaluateResult(dArray, dArray2, "float + float[] + float[] + float", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a + 1.23 + 4.56 + d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{8.49, 71.39, 270.115};
        super.evaluateResult(dArray, dArray2, "float[] + float + float + float[]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a + 1.23 + c + 4.56; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{9.114999999999998, 39.59, 36.790000000000006};
        super.evaluateResult(dArray, dArray2, "float[] + float + float[] + float", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  a + 1.23 + 4.56 + 7.89; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{15.879999999999999, 15.079999999999998, 21.88};
        super.evaluateResult(dArray, dArray2, "float[] + float + float + float", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; float d[3]; d[0]=0.5; d[1]=64.2; d[2]=256.125;  1.23 + 4.56 + 7.89 + d; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{14.18, 77.88, 269.805};
        super.evaluateResult(dArray, dArray2, "float + float + float + float[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  \"x\" + b + c + d; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"xaiueoNaClSi", "xkakikukekoH2ONi", "xsasisusesoCaCO3Al"};
        super.evaluateResult(stringArray, stringArray2, "string + string[] + string[] + string[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  a + \"x\" + c + d; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abcxNaClSi", "defxH2ONi", "ghixCaCO3Al"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string + string[] + string[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  a + b + \"x\" + d; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abcaiueoxSi", "defkakikukekoxNi", "ghisasisusesoxAl"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string[] + string + string[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  a + b + c + \"x\"; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abcaiueoNaClx", "defkakikukekoH2Ox", "ghisasisusesoCaCO3x"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string[] + string[] + string", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  \"x\" + \"y\" + c + d; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"xyNaClSi", "xyH2ONi", "xyCaCO3Al"};
        super.evaluateResult(stringArray, stringArray2, "string + string + string[] + string[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  \"x\" + b + \"y\" + d; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"xaiueoySi", "xkakikukekoyNi", "xsasisusesoyAl"};
        super.evaluateResult(stringArray, stringArray2, "string + string[] + string + string[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  \"x\" + b + c + \"y\"; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"xaiueoNaCly", "xkakikukekoH2Oy", "xsasisusesoCaCO3y"};
        super.evaluateResult(stringArray, stringArray2, "string + string[] + string[] + string", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  a + \"x\" + \"y\" + d; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abcxySi", "defxyNi", "ghixyAl"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string + string + string[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  a + \"x\" + c + \"y\"; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abcxNaCly", "defxH2Oy", "ghixCaCO3y"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string + string[] + string", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  a + \"x\" + \"y\" + \"z\"; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"abcxyz", "defxyz", "ghixyz"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string + string + string", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; string d[3]; d[0]=\"Si\"; d[1]=\"Ni\"; d[2]=\"Al\";  \"x\" + \"y\" + \"z\" + d; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"xyzSi", "xyzNi", "xyzAl"};
        super.evaluateResult(stringArray, stringArray2, "string[] + string + string + string", string);
    }
}

