/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class VectorComparisonOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_INT_A = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; ";
    private static final String DECLVEC_INT_B = "int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200; ";
    private static final String DECLVEC_FLOAT_A = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; ";
    private static final String DECLVEC_FLOAT_B = "float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2; ";
    private static final String DECLVEC_BOOL_A = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; ";
    private static final String DECLVEC_BOOL_B = "bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true; ";
    private static final String DECLVEC_STRING_A = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; ";
    private static final String DECLVEC_STRING_B = "string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\"; ";

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testEqualOperations();
            this.testNotEqualOperations();
            this.testLessThanOperations();
            this.testLessEqualOperations();
            this.testGreaterThanOperations();
            this.testGreaterEqualOperations();
            this.testVectorScalarMixedOperations();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testEqualOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a == b ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "int[] == int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "float[] == float[]", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "int[] == float[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "float[] == int[]", string);
        string = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true;  a == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, true, true, false, true};
        super.evaluateResult(blArray, blArray2, "bool[] == bool[]", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, false, false, true};
        super.evaluateResult(blArray, blArray2, "string[] == string[]", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "string[] == int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "float[] == string[]", string);
    }

    private void testNotEqualOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a != b ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, true, false, true, true};
        super.evaluateResult(blArray, blArray2, "int[] != int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a != b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, true, true};
        super.evaluateResult(blArray, blArray2, "float[] != float[]", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a != b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, true, true};
        super.evaluateResult(blArray, blArray2, "int[] != float[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a != b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, true, true};
        super.evaluateResult(blArray, blArray2, "float[] != int[]", string);
        string = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true;  a != b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, false, true, false};
        super.evaluateResult(blArray, blArray2, "bool[] != bool[]", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a != b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, true, true, true, false};
        super.evaluateResult(blArray, blArray2, "string[] != string[]", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a != b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, true, true};
        super.evaluateResult(blArray, blArray2, "string[] != int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a != b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, true, true};
        super.evaluateResult(blArray, blArray2, "float[] != string[]", string);
    }

    private void testLessThanOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a < b ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{false, true, false, false, true};
        super.evaluateResult(blArray, blArray2, "int[] < int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a < b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, true, false, false, true};
        super.evaluateResult(blArray, blArray2, "float[] < float[]", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a < b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, true, false, false, true};
        super.evaluateResult(blArray, blArray2, "int[] < float[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a < b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, true, false, false, true};
        super.evaluateResult(blArray, blArray2, "float[] < int[]", string);
    }

    private void testLessEqualOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a <= b ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{false, true, true, false, true};
        super.evaluateResult(blArray, blArray2, "int[] <= int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a <= b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, true, true, false, true};
        super.evaluateResult(blArray, blArray2, "float[] <= float[]", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a <= b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, true, true, false, true};
        super.evaluateResult(blArray, blArray2, "int[] <= float[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a <= b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, true, true, false, true};
        super.evaluateResult(blArray, blArray2, "float[] <= int[]", string);
    }

    private void testGreaterThanOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a > b ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, false, true, false};
        super.evaluateResult(blArray, blArray2, "int[] > int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a > b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, false, true, false};
        super.evaluateResult(blArray, blArray2, "float[] > float[]", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a > b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, false, true, false};
        super.evaluateResult(blArray, blArray2, "int[] > float[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a > b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, false, true, false};
        super.evaluateResult(blArray, blArray2, "float[] > int[]", string);
    }

    private void testGreaterEqualOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a >= b ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, true, true, false};
        super.evaluateResult(blArray, blArray2, "int[] >= int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a >= b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, true, true, false};
        super.evaluateResult(blArray, blArray2, "float[] >= float[]", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a >= b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, true, true, false};
        super.evaluateResult(blArray, blArray2, "int[] >= float[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a >= b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, true, true, false};
        super.evaluateResult(blArray, blArray2, "float[] >= int[]", string);
    }

    private void testVectorScalarMixedOperations() throws VnanoException {
        String string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a == 1 ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "int[] == int", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  1 == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "int == int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a == 1.0 ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "float[] == float", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  1.0 == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "float == float[]", string);
        string = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a == true ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, true, false, true};
        super.evaluateResult(blArray, blArray2, "bool[] == bool", string);
        string = "bool a[5]; a[0]=true; a[1]=false; a[2]=true; a[3]=false; a[4]=true; bool b[5]; b[0]=false; b[1]=false; b[2]=true; b[3]=true; b[4]=true;  true == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, true, true};
        super.evaluateResult(blArray, blArray2, "bool == bool[]", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a == \"c\" ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, true, false};
        super.evaluateResult(blArray, blArray2, "string[] == string", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  \"u\" == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, true, false};
        super.evaluateResult(blArray, blArray2, "string == string[]", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  a == 1.0 ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "int[] == float", string);
        string = "int a[5]; a[0]=-100; a[1]=-10; a[2]=1; a[3]=10; a[4]=100; int b[5]; b[0]=-200; b[1]=-2; b[2]=1; b[3]=2; b[4]=200;  1.0 == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "float == int[]", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  a == 1 ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "float[] == int", string);
        string = "float a[5]; a[0]=-100.2; a[1]=-10.2; a[2]=1.0; a[3]=10.2; a[4]=100.2; float b[5]; b[0]=-200.2; b[1]=-2.2; b[2]=1.0; b[3]=2.2; b[4]=200.2;  1 == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "int == float[]", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  a == 1 ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "string[] == int", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  1 == a ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "int == string[]", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  b == 1.0 ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "string[] == float", string);
        string = "string a[5]; a[0]=\"a\"; a[1]=\"b\"; a[2]=\"1\"; a[3]=\"c\"; a[4]=\"d\"; string b[5]; b[0]=\"a\"; b[1]=\"i\"; b[2]=\"1.0\"; b[3]=\"u\"; b[4]=\"d\";  1.0 == b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, false, false};
        super.evaluateResult(blArray, blArray2, "float == string[]", string);
    }
}

