/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class VectorCompoundAssignmentOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_INT_A = "int a[3]; a[0]=10; a[1]=50; a[2]=30; ";
    private static final String DECLVEC_INT_B = "int b[3]; b[0]=5; b[1]=50; b[2]=10; ";
    private static final String DECLVEC_FLOAT_A = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; ";
    private static final String DECLVEC_FLOAT_B = "float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; ";
    private static final String DECLVEC_STRING_A = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; ";
    private static final String DECLVEC_STRING_B = "string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; ";

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAddAssignmentOperations();
            this.testSubAssignmentOperations();
            this.testMulAssignmentOperations();
            this.testDivAssignmentOperations();
            this.testRemAssignmentOperations();
            this.testVectorScalarMixedOperations();
            this.testCompoundAssignmentOperationsToConstants();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAddAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a += b; a; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{15L, 100L, 40L};
        super.evaluateResult(lArray, lArray2, "int[] += int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a += b; a; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{14L, 52L, 42L};
        super.evaluateResult(lArray, lArray2, "int[] += float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a += b; a; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{6.75, 3.75, 20.375};
        super.evaluateResult(dArray, dArray2, "float[] += float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a += b; a; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{7.5, 51.5, 18.25};
        super.evaluateResult(dArray, dArray2, "float[] += int[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; a += b; a; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abcaiueo", "defkakikukeko", "ghisasisuseso"};
        super.evaluateResult(stringArray, stringArray2, "string[] += string[]", string);
    }

    private void testSubAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a -= b; a; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{5L, 0L, 20L};
        super.evaluateResult(lArray, lArray2, "int[] -= int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a -= b; a; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{5L, 47L, 17L};
        super.evaluateResult(lArray, lArray2, "int[] -= float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a -= b; a; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{-1.75, -0.75, -3.875};
        super.evaluateResult(dArray, dArray2, "float[] -= float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a -= b; a; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{-2.5, -48.5, -1.75};
        super.evaluateResult(dArray, dArray2, "float[] -= int[]", string);
    }

    private void testMulAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a *= b; a; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{50L, 2500L, 300L};
        super.evaluateResult(lArray, lArray2, "int[] *= int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a *= b; a; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{42L, 112L, 363L};
        super.evaluateResult(lArray, lArray2, "int[] *= float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a *= b; a; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{10.625, 3.375, 100.03125};
        super.evaluateResult(dArray, dArray2, "float[] *= float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a *= b; a; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{12.5, 75.0, 82.5};
        super.evaluateResult(dArray, dArray2, "float[] *= int[]", string);
    }

    private void testDivAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a /= b; a; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{2L, 1L, 3L};
        super.evaluateResult(lArray, lArray2, "int[] /= int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a /= b; a; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{2L, 22L, 2L};
        super.evaluateResult(lArray, lArray2, "int[] /= float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a /= b; a; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{0.5882352941176471, 0.6666666666666666, 0.6804123711340206};
        super.evaluateResult(dArray, dArray2, "float[] /= float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a /= b; a; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{0.5, 0.03, 0.825};
        super.evaluateResult(dArray, dArray2, "float[] /= int[]", string);
    }

    private void testRemAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a %= b; a; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{0L, 0L, 0L};
        super.evaluateResult(lArray, lArray2, "int[] %= int[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a %= b; a; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{1L, 0L, 5L};
        super.evaluateResult(lArray, lArray2, "int[] %= float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a %= b; a; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{2.5, 1.5, 8.25};
        super.evaluateResult(dArray, dArray2, "float[] %= float[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a %= b; a; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{2.5, 1.5, 8.25};
        super.evaluateResult(dArray, dArray2, "float[] %= int[]", string);
    }

    private void testVectorScalarMixedOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; a += 123; a; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{133L, 173L, 153L};
        super.evaluateResult(lArray, lArray2, "int[] += int", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; a += 2.125; a; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{12L, 52L, 32L};
        super.evaluateResult(lArray, lArray2, "int[] += float", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; a += 2.125; a; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{4.625, 3.625, 10.375};
        super.evaluateResult(dArray, dArray2, "float[] += float", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; a += 123; a; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{125.5, 124.5, 131.25};
        super.evaluateResult(dArray, dArray2, "float[] += int", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; a += \"xyz\"; a; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abcxyz", "defxyz", "ghixyz"};
        super.evaluateResult(stringArray, stringArray2, "string[] += string", string);
    }

    private void testCompoundAssignmentOperationsToConstants() throws VnanoException {
        String string = "const int a[3]; int b[3]; a += b;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; int b[3]; a += b; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; int b[3]; a += b; (should be failed) ");
        }
        string = "const int a[3]; int b[3]; a -= b;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; int b[3]; a -= b; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; int b[3]; a -= b; (should be failed) ");
        }
        string = "const int a[3]; int b[3]; a *= b;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; int b[3]; a *= b; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; int b[3]; a *= b; (should be failed) ");
        }
        string = "const int a[3]; int b[3]=123; a /= b;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; int b[3]; a /= b; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; int b[3]; a /= b; (should be failed) ");
        }
        string = "const int a[3]; int b[3]=123; a %= b;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; int b[3]; a %= b; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; int b[3]; a %= b; (should be failed) ");
        }
    }
}

