/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.spec.AssemblyWord;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.IdentifierSyntax;
import org.vcssl.nano.spec.MetaInformationSyntax;
import org.vcssl.nano.spec.OperationCode;

public class CodeGenerator {
    private static final int RANK_OF_SCALAR = 0;
    private static final String LABEL_NAME = "LABEL";
    private final String IMMEDIATE_TRUE = "~bool:true";
    private final String PLACE_HOLDER = Character.toString('-');
    private int registerCounter = 0;
    private int labelCounter = 0;

    public String generate(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        AstNode astNode2 = astNode.clone();
        this.assignAssemblyValues(astNode2);
        this.assignLabels(astNode2);
        stringBuilder.append(this.generateLanguageInformationDirectives());
        stringBuilder.append(this.generateFunctionIdentifierDirectives(astNode2));
        stringBuilder.append(this.generateGlobalIdentifierDirectives(astNode2));
        stringBuilder.append(this.trackAllStatements(astNode2));
        stringBuilder.append(this.generateFinalizationCode(astNode2));
        String string = stringBuilder.toString();
        String string2 = this.realign(string);
        return string2;
    }

    private void assignAssemblyValues(AstNode astNode) {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            String string;
            String string2;
            AstNode.Type type = astNode2.getType();
            if (type == AstNode.Type.VARIABLE || type == AstNode.Type.LEAF) {
                String string3;
                boolean bl;
                boolean bl2 = type == AstNode.Type.VARIABLE;
                boolean bl3 = type == AstNode.Type.LEAF;
                string2 = astNode2.getAttribute(AttributeKey.LEAF_TYPE);
                boolean bl4 = bl = type == AstNode.Type.IMPORT || type == AstNode.Type.INCLUDE;
                if (bl3 && string2 == "functionIdentifier") {
                    AstNode astNode3 = astNode2.getParentNode();
                    string = astNode3.getAttribute(AttributeKey.CALLEE_SIGNATURE);
                    string3 = '_' + string;
                    astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string3);
                } else if (bl2 || bl3 && string2 == "variableIdentifier") {
                    String string4 = IdentifierSyntax.getAssemblyIdentifierOf(astNode2);
                    astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string4);
                } else if (bl3 && string2 == "literal") {
                    String string5 = astNode2.getAttribute(AttributeKey.DATA_TYPE);
                    string = astNode2.getAttribute(AttributeKey.LITERAL_VALUE);
                    string3 = AssemblyWord.getImmediateValueOf(string5, string);
                    astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string3);
                } else if (!(bl || bl3 && string2 == "dependencyIdentifier")) {
                    throw new VnanoFatalException("Unknown leaf type: " + string2);
                }
            }
            if (astNode2.getType() == AstNode.Type.OPERATOR) {
                String string6 = astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR);
                String string7 = astNode2.getAttribute(AttributeKey.OPERATOR_SYNTAX);
                string2 = astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL);
                switch (string6) {
                    case "assignment": {
                        string = astNode2.getChildNodes()[0].getAttribute(AttributeKey.ASSEMBLY_VALUE);
                        astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string);
                        break;
                    }
                    case "arithmeticCompoundAssignment": {
                        if (string2.equals("++") || string2.equals("--")) {
                            if (string7.equals("prefix")) {
                                string = astNode2.getChildNodes()[0].getAttribute(AttributeKey.ASSEMBLY_VALUE);
                                astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string);
                                break;
                            }
                            string = 'R' + Integer.toString(this.registerCounter);
                            ++this.registerCounter;
                            astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string);
                            astNode2.setAttribute(AttributeKey.NEW_REGISTER, string);
                            break;
                        }
                        string = astNode2.getChildNodes()[0].getAttribute(AttributeKey.ASSEMBLY_VALUE);
                        astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string);
                        break;
                    }
                    default: {
                        string = 'R' + Integer.toString(this.registerCounter);
                        ++this.registerCounter;
                        astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string);
                        astNode2.setAttribute(AttributeKey.NEW_REGISTER, string);
                        break;
                    }
                }
            }
            if (astNode2.getType() != AstNode.Type.EXPRESSION) continue;
            String string8 = astNode2.getChildNodes()[0].getAttribute(AttributeKey.ASSEMBLY_VALUE);
            astNode2.setAttribute(AttributeKey.ASSEMBLY_VALUE, string8);
        }
    }

    private void assignLabels(AstNode astNode) {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            String string;
            if (astNode2.getType() == AstNode.Type.IF) {
                astNode2.setAttribute(AttributeKey.END_LABEL, this.generateLabelOperandCode());
            }
            if (astNode2.getType() == AstNode.Type.ELSE) {
                astNode2.setAttribute(AttributeKey.END_LABEL, this.generateLabelOperandCode());
            }
            if (astNode2.getType() == AstNode.Type.FOR) {
                astNode2.setAttribute(AttributeKey.BEGIN_LABEL, this.generateLabelOperandCode());
                astNode2.setAttribute(AttributeKey.UPDATE_LABEL, this.generateLabelOperandCode());
                astNode2.setAttribute(AttributeKey.END_LABEL, this.generateLabelOperandCode());
            }
            if (astNode2.getType() == AstNode.Type.WHILE) {
                astNode2.setAttribute(AttributeKey.BEGIN_LABEL, this.generateLabelOperandCode());
                astNode2.setAttribute(AttributeKey.END_LABEL, this.generateLabelOperandCode());
            }
            if (astNode2.getType() == AstNode.Type.FUNCTION) {
                astNode2.setAttribute(AttributeKey.END_LABEL, this.generateLabelOperandCode());
            }
            if (astNode2.getType() != AstNode.Type.OPERATOR || !(string = astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL)).equals("&&") && !string.equals("||")) continue;
            astNode2.setAttribute(AttributeKey.END_LABEL, this.generateLabelOperandCode());
        }
    }

    private String trackAllStatements(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length;
        int n2 = 0;
        StatementTrackingContext statementTrackingContext = new StatementTrackingContext();
        ArrayDeque<StatementTrackingContext> arrayDeque = new ArrayDeque<StatementTrackingContext>();
        while (n2 < n) {
            Object object;
            AstNode astNode2 = astNodeArray[n2];
            AstNode.Type type = astNode2.getType();
            if (!type.equals((Object)AstNode.Type.BLOCK)) {
                object = this.generateMetaDirectiveCode(astNode2);
                stringBuilder.append((String)object);
            }
            switch (type) {
                case BLOCK: {
                    statementTrackingContext.setStatementIndex(n2);
                    statementTrackingContext.setStatementLength(n);
                    statementTrackingContext.setStatementNodes(astNodeArray);
                    arrayDeque.push(statementTrackingContext);
                    statementTrackingContext = new StatementTrackingContext();
                    object = (StatementTrackingContext)arrayDeque.peek();
                    statementTrackingContext.setLastLoopBeginPointLabel(((StatementTrackingContext)object).getLastLoopBeginPointLabel());
                    statementTrackingContext.setLastLoopUpdatePointLabel(((StatementTrackingContext)object).getLastLoopUpdatePointLabel());
                    statementTrackingContext.setLastLoopEndPointLabel(((StatementTrackingContext)object).getLastLoopEndPointLabel());
                    statementTrackingContext.setOuterLoopBeginPointLabel(((StatementTrackingContext)object).getOuterLoopBeginPointLabel());
                    statementTrackingContext.setOuterLoopUpdatePointLabel(((StatementTrackingContext)object).getOuterLoopUpdatePointLabel());
                    statementTrackingContext.setOuterLoopEndPointLabel(((StatementTrackingContext)object).getOuterLoopEndPointLabel());
                    statementTrackingContext.setLastFunctionLabel(((StatementTrackingContext)object).getLastFunctionLabel());
                    if (((StatementTrackingContext)object).isNextBlockLoop()) {
                        statementTrackingContext.setOuterLoopBeginPointLabel(((StatementTrackingContext)object).getLastLoopBeginPointLabel());
                        statementTrackingContext.setOuterLoopUpdatePointLabel(((StatementTrackingContext)object).getLastLoopUpdatePointLabel());
                        statementTrackingContext.setOuterLoopEndPointLabel(((StatementTrackingContext)object).getLastLoopEndPointLabel());
                    }
                    astNodeArray = astNode2.getChildNodes();
                    n = astNodeArray.length;
                    n2 = 0;
                    break;
                }
                case VARIABLE: 
                case FUNCTION: 
                case IF: 
                case ELSE: 
                case WHILE: 
                case FOR: 
                case BREAK: 
                case CONTINUE: 
                case RETURN: 
                case EXPRESSION: {
                    statementTrackingContext = this.generateStatementCode(astNode2, statementTrackingContext);
                    stringBuilder.append(statementTrackingContext.getLastStatementCode());
                    ++n2;
                    break;
                }
                default: {
                    ++n2;
                }
            }
            while (n2 == n && !arrayDeque.isEmpty()) {
                statementTrackingContext = (StatementTrackingContext)arrayDeque.pop();
                n2 = statementTrackingContext.getStatementIndex();
                n = statementTrackingContext.getStatementLength();
                astNodeArray = statementTrackingContext.getStatementNodes();
                ++n2;
                if (statementTrackingContext.hasUpdatePointLabel()) {
                    stringBuilder.append(this.generateLabelDirectiveCode(statementTrackingContext.getUpdatePointLabel()));
                    statementTrackingContext.clearUpdatePointLabel();
                }
                if (statementTrackingContext.hasUpdatePointStatement()) {
                    stringBuilder.append(statementTrackingContext.getUpdatePointStatement());
                    statementTrackingContext.clearUpdatePointStatement();
                }
                if (statementTrackingContext.hasBeginPointLabel()) {
                    object = this.generateInstruction(OperationCode.JMP.name(), "bool", this.PLACE_HOLDER, statementTrackingContext.getBeginPointLabel(), "~bool:true");
                    stringBuilder.append((String)object);
                    statementTrackingContext.clearBeginPointLabel();
                }
                if (statementTrackingContext.hasEndPointStatement()) {
                    stringBuilder.append(statementTrackingContext.getEndPointStatement());
                    statementTrackingContext.clearEndPointStatement();
                }
                if (!statementTrackingContext.hasEndPointLabel()) continue;
                object = statementTrackingContext.getEndPointLabels();
                for (String string : object) {
                    stringBuilder.append(this.generateLabelDirectiveCode(string));
                }
                statementTrackingContext.clearEndPointLabel();
            }
        }
        return stringBuilder.toString();
    }

    private StatementTrackingContext generateStatementCode(AstNode astNode, StatementTrackingContext statementTrackingContext) {
        statementTrackingContext = statementTrackingContext.clone();
        AstNode.Type type = astNode.getType();
        String string = null;
        switch (type) {
            case VARIABLE: {
                string = this.generateVariableDeclarationStatementCode(astNode);
                break;
            }
            case FUNCTION: {
                String string2 = IdentifierSyntax.getSignatureOf(astNode);
                String string3 = Character.toString('&') + Character.toString('_') + string2;
                string = this.generateFunctionDeclarationStatementCode(astNode, string3);
                String string4 = "~string:\"" + string2 + '\"';
                String string5 = this.generateInstruction(OperationCode.ENDFUN.name(), "string", string4);
                if (astNode.getDataTypeName().equals("void")) {
                    string5 = this.generateInstruction(OperationCode.RET.name(), "void", this.PLACE_HOLDER, string3) + string5;
                }
                statementTrackingContext.setEndPointStatement(string5);
                statementTrackingContext.setNextBlockLoop(false);
                statementTrackingContext.setLastFunctionLabel(string3);
                statementTrackingContext.addEndPointLabel(astNode.getAttribute(AttributeKey.END_LABEL));
                break;
            }
            case IF: {
                statementTrackingContext.addEndPointLabel(astNode.getAttribute(AttributeKey.END_LABEL));
                String string6 = null;
                boolean bl = false;
                if (statementTrackingContext.hasLastIfConditionRegister()) {
                    string6 = statementTrackingContext.getLastIfConditionRegister();
                } else {
                    string6 = this.generateRegisterOperandCode();
                    bl = true;
                }
                statementTrackingContext.setLastIfConditionValue(string6);
                statementTrackingContext.setNextBlockLoop(false);
                string = this.generateIfStatementCode(astNode, string6, bl);
                break;
            }
            case ELSE: {
                string = this.generateElseStatementCode(astNode, statementTrackingContext.getLastIfConditionRegister());
                statementTrackingContext.addEndPointLabel(astNode.getAttribute(AttributeKey.END_LABEL));
                statementTrackingContext.setNextBlockLoop(false);
                break;
            }
            case WHILE: {
                string = this.generateWhileStatementCode(astNode);
                statementTrackingContext.setBeginPointLabel(astNode.getAttribute(AttributeKey.BEGIN_LABEL));
                statementTrackingContext.addEndPointLabel(astNode.getAttribute(AttributeKey.END_LABEL));
                statementTrackingContext.setLastLoopBeginPointLabel(statementTrackingContext.getBeginPointLabel());
                statementTrackingContext.setLastLoopUpdatePointLabel(statementTrackingContext.getUpdatePointLabel());
                statementTrackingContext.setLastLoopEndPointLabel(statementTrackingContext.getEndPointLabels()[0]);
                statementTrackingContext.setNextBlockLoop(true);
                break;
            }
            case FOR: {
                string = this.generateForStatementCode(astNode);
                statementTrackingContext.setBeginPointLabel(astNode.getAttribute(AttributeKey.BEGIN_LABEL));
                statementTrackingContext.setUpdatePointLabel(astNode.getAttribute(AttributeKey.UPDATE_LABEL));
                statementTrackingContext.addEndPointLabel(astNode.getAttribute(AttributeKey.END_LABEL));
                if (astNode.getChildNodes()[2].getType() == AstNode.Type.EXPRESSION) {
                    statementTrackingContext.setUpdatePointStatement(this.generateExpressionCode(astNode.getChildNodes()[2]));
                }
                statementTrackingContext.setLastLoopBeginPointLabel(statementTrackingContext.getBeginPointLabel());
                statementTrackingContext.setLastLoopUpdatePointLabel(statementTrackingContext.getUpdatePointLabel());
                statementTrackingContext.setLastLoopEndPointLabel(statementTrackingContext.getEndPointLabels()[0]);
                statementTrackingContext.setNextBlockLoop(true);
                break;
            }
            case BREAK: {
                string = this.generateInstruction(OperationCode.JMP.name(), "bool", this.PLACE_HOLDER, statementTrackingContext.getOuterLoopEndPointLabel(), "~bool:true");
                break;
            }
            case CONTINUE: {
                String string7 = statementTrackingContext.getOuterLoopBeginPointLabel();
                if (statementTrackingContext.hasLastLoopUpdatePointLabel()) {
                    string7 = statementTrackingContext.getOuterLoopUpdatePointLabel();
                }
                string = this.generateInstruction(OperationCode.JMP.name(), "bool", this.PLACE_HOLDER, string7, "~bool:true");
                break;
            }
            case RETURN: {
                string = this.generateReturnStatementCode(astNode, statementTrackingContext.getLastFunctionLabel());
                break;
            }
            case EXPRESSION: {
                string = this.generateExpressionCode(astNode);
                break;
            }
        }
        statementTrackingContext.setLastStatementCode(string);
        return statementTrackingContext;
    }

    private String generateVariableDeclarationStatementCode(AstNode astNode) {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        String string = astNode.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        String string2 = astNode.getDataTypeName();
        stringBuilder.append("#LOCAL_VARIABLE");
        stringBuilder.append("\t");
        stringBuilder.append(string);
        stringBuilder.append(";");
        stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        int n = 0;
        String[] stringArray = null;
        if (astNode.hasChildNodes(AstNode.Type.LENGTHS)) {
            objectArray = astNode.getChildNodes(AstNode.Type.LENGTHS)[0].getChildNodes(AstNode.Type.EXPRESSION);
            n = objectArray.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((AstNode)objectArray[i]).getAttribute(AttributeKey.ASSEMBLY_VALUE);
                stringBuilder.append(this.generateExpressionCode((AstNode)objectArray[i]));
            }
        }
        if (n == 0) {
            stringBuilder.append(this.generateInstruction(OperationCode.ALLOC.name(), string2, string));
        } else {
            objectArray = new String[stringArray.length + 1];
            objectArray[0] = string;
            System.arraycopy(stringArray, 0, objectArray, 1, stringArray.length);
            stringBuilder.append(this.generateInstruction(OperationCode.ALLOC.name(), string2, (String[])objectArray));
        }
        objectArray = astNode.getChildNodes(AstNode.Type.EXPRESSION);
        if (objectArray.length == 1) {
            stringBuilder.append(this.generateExpressionCode((AstNode)objectArray[0]));
        } else {
            String string3 = this.generateDefaultValueImmediateOperandCode(string2);
            if (n == 0) {
                stringBuilder.append(this.generateInstruction(OperationCode.MOV.name(), string2, string, string3));
            } else {
                stringBuilder.append(this.generateInstruction(OperationCode.FILL.name(), string2, string, string3));
            }
        }
        return stringBuilder.toString();
    }

    private String generateFunctionDeclarationStatementCode(AstNode astNode, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = astNode.getAttribute(AttributeKey.END_LABEL);
        stringBuilder.append(this.generateInstruction(OperationCode.JMP.name(), "bool", this.PLACE_HOLDER, string2, "~bool:true"));
        stringBuilder.append(this.generateLabelDirectiveCode(string));
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length;
        for (int i = n - 1; 0 <= i; --i) {
            AstNode astNode2 = astNodeArray[i];
            String string3 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
            String string4 = astNode2.getAttribute(AttributeKey.DATA_TYPE);
            int n2 = astNode2.getArrayRank();
            Object[] objectArray = new String[n2 + 1];
            Arrays.fill(objectArray, this.generateImmediateOperandCode("int", "0"));
            objectArray[0] = string3;
            stringBuilder.append("#LOCAL_VARIABLE");
            stringBuilder.append("\t");
            stringBuilder.append(string3);
            stringBuilder.append(";");
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
            if (astNode2.hasAttribute(AttributeKey.MODIFIER) && astNode2.getAttribute(AttributeKey.MODIFIER).contains("&")) {
                stringBuilder.append(this.generateInstruction(OperationCode.ALLOCT.name(), string4, (String[])objectArray));
                stringBuilder.append(this.generateInstruction(OperationCode.REFPOP.name(), string4, string3));
                continue;
            }
            stringBuilder.append(this.generateInstruction(OperationCode.ALLOCT.name(), string4, (String[])objectArray));
            stringBuilder.append(this.generateInstruction(OperationCode.ALLOCP.name(), string4, string3));
            stringBuilder.append(this.generateInstruction(OperationCode.MOVPOP.name(), string4, string3));
        }
        String string5 = "~string:\"" + IdentifierSyntax.getSignatureOf(astNode) + '\"';
        stringBuilder.append(this.generateInstruction(OperationCode.ENDPRM.name(), "string", string5));
        return stringBuilder.toString();
    }

    private String generateReturnStatementCode(AstNode astNode, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        AstNode[] astNodeArray = astNode.getChildNodes();
        if (astNodeArray.length == 0) {
            stringBuilder.append(this.generateInstruction(OperationCode.RET.name(), "void", this.PLACE_HOLDER, string));
        } else {
            AstNode astNode2 = astNodeArray[0];
            String string2 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
            String string3 = this.generateExpressionCode(astNode2);
            stringBuilder.append(string3);
            stringBuilder.append(this.generateInstruction(OperationCode.RET.name(), "void", this.PLACE_HOLDER, string, string2));
        }
        return stringBuilder.toString();
    }

    private String generateIfStatementCode(AstNode astNode, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        AstNode astNode2 = astNode.getChildNodes(AstNode.Type.EXPRESSION)[0];
        stringBuilder.append(this.generateExpressionCode(astNode2));
        if (astNode2.getArrayRank() != 0) {
            return null;
        }
        if (bl) {
            stringBuilder.append(this.generateInstruction(OperationCode.ALLOC.name(), "bool", string));
        }
        String string2 = this.generateInstruction(OperationCode.MOV.name(), "bool", string, astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE));
        stringBuilder.append(string2);
        String string3 = astNode.getAttribute(AttributeKey.END_LABEL);
        String string4 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        stringBuilder.append(this.generateInstruction(OperationCode.JMPN.name(), "bool", this.PLACE_HOLDER, string3, string4));
        return stringBuilder.toString();
    }

    private String generateElseStatementCode(AstNode astNode, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = astNode.getAttribute(AttributeKey.END_LABEL);
        stringBuilder.append(this.generateInstruction(OperationCode.JMP.name(), "bool", this.PLACE_HOLDER, string2, string));
        return stringBuilder.toString();
    }

    private String generateWhileStatementCode(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = astNode.getAttribute(AttributeKey.BEGIN_LABEL);
        String string2 = astNode.getAttribute(AttributeKey.END_LABEL);
        stringBuilder.append(this.generateLabelDirectiveCode(string));
        AstNode astNode2 = astNode.getChildNodes(AstNode.Type.EXPRESSION)[0];
        stringBuilder.append(this.generateExpressionCode(astNode2));
        if (astNode2.getArrayRank() != 0) {
            return null;
        }
        String string3 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        stringBuilder.append(this.generateInstruction(OperationCode.JMPN.name(), "bool", this.PLACE_HOLDER, string2, string3));
        return stringBuilder.toString();
    }

    private String generateForStatementCode(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        AstNode[] astNodeArray = astNode.getChildNodes();
        String string = astNode.getAttribute(AttributeKey.BEGIN_LABEL);
        String string2 = astNode.getAttribute(AttributeKey.END_LABEL);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (astNodeArray[0].getType() == AstNode.Type.VARIABLE) {
            string3 = this.generateVariableDeclarationStatementCode(astNodeArray[0]);
        } else if (astNodeArray[0].getType() == AstNode.Type.EXPRESSION) {
            string3 = this.generateExpressionCode(astNodeArray[0]);
        } else if (astNodeArray[0].getType() == AstNode.Type.EMPTY) {
            string3 = "";
        }
        stringBuilder.append(string3);
        stringBuilder.append(this.generateLabelDirectiveCode(string));
        if (astNodeArray[1].getType() == AstNode.Type.EXPRESSION) {
            string4 = this.generateExpressionCode(astNodeArray[1]);
            string5 = astNodeArray[1].getAttribute(AttributeKey.ASSEMBLY_VALUE);
        } else if (astNodeArray[1].getType() == AstNode.Type.EMPTY) {
            string4 = "";
            string5 = "~bool:true";
        }
        stringBuilder.append(string4);
        stringBuilder.append(this.generateInstruction(OperationCode.JMPN.name(), "bool", this.PLACE_HOLDER, string2, string5));
        return stringBuilder.toString();
    }

    private String generateExpressionCode(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            String string;
            Object object;
            if (astNode2.getType() == AstNode.Type.OPERATOR) {
                object = astNode2.getAttribute(AttributeKey.OPERATOR_SYNTAX);
                block10 : switch (string = astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR)) {
                    case "call": {
                        stringBuilder.append(this.generateCallOperatorCode(astNode2));
                        break;
                    }
                    case "assignment": {
                        stringBuilder.append(this.generateAssignmentOperatorCode(astNode2));
                        break;
                    }
                    case "arithmetic": {
                        switch (object) {
                            case "binary": {
                                stringBuilder.append(this.generateArithmeticBinaryOperatorCode(astNode2));
                                break block10;
                            }
                            case "prefix": {
                                stringBuilder.append(this.generateArithmeticPrefixOperatorCode(astNode2));
                                break block10;
                            }
                        }
                        throw new VnanoFatalException("Invalid operator syntax for arithmetic operators: " + (String)object);
                    }
                    case "arithmeticCompoundAssignment": {
                        switch (object) {
                            case "binary": {
                                stringBuilder.append(this.generateArithmeticCompoundAssignmentBinaryOperatorCode(astNode2));
                                break block10;
                            }
                            case "prefix": {
                                stringBuilder.append(this.generateArithmeticCompoundPrefixOperatorCode(astNode2));
                                break block10;
                            }
                            case "postfix": {
                                stringBuilder.append(this.generateArithmeticCompoundPostfixOperatorCode(astNode2));
                                break block10;
                            }
                        }
                        throw new VnanoFatalException("Invalid operator syntax for arithmetic compound operators: " + (String)object);
                    }
                    case "comparison": {
                        stringBuilder.append(this.generateComparisonBinaryOperatorCode(astNode2));
                        break;
                    }
                    case "logical": {
                        switch (object) {
                            case "binary": {
                                stringBuilder.append(this.generateLogicalBinaryOperatorCode(astNode2));
                                break block10;
                            }
                            case "prefix": {
                                stringBuilder.append(this.generateLogicalPrefixOperatorCode(astNode2));
                                break block10;
                            }
                        }
                        throw new VnanoFatalException("Invalid operator syntax for logical operators: " + (String)object);
                    }
                    case "subscript": {
                        stringBuilder.append(this.generateIndexOperatorCode(astNode2));
                        break;
                    }
                    case "cast": {
                        stringBuilder.append(this.generateCastOperatorCode(astNode2));
                        break;
                    }
                    default: {
                        throw new VnanoFatalException("Unknown operator execution type: " + string);
                    }
                }
            }
            if (((AstNode)(object = astNode2.getParentNode())).getType() != AstNode.Type.OPERATOR || !(string = astNode2.getParentNode().getAttribute(AttributeKey.OPERATOR_SYMBOL)).equals("&&") && !string.equals("||")) continue;
            String string2 = ((AstNode)object).getAttribute(AttributeKey.END_LABEL);
            String string3 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
            Object object2 = OperationCode.JMP.name();
            if (string.equals("&&")) {
                object2 = OperationCode.JMPN.name();
            }
            if (astNode2 == ((AstNode)object).getChildNodes()[0]) {
                stringBuilder.append(this.generateInstruction((String)object2, "bool", this.PLACE_HOLDER, string2, string3));
                continue;
            }
            stringBuilder.append(this.generateLabelDirectiveCode(((AstNode)object).getAttribute(AttributeKey.END_LABEL)));
        }
        return stringBuilder.toString();
    }

    private String generateRegisterAllocationCode(String string, String string2, String string3, int n) {
        if (n == 0) {
            return this.generateInstruction(OperationCode.ALLOC.name(), string, string2);
        }
        return this.generateInstruction(OperationCode.ALLOCR.name(), string, string2, string3);
    }

    private String generateArithmeticBinaryOperatorCode(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.OPERATOR_SYMBOL);
        String string2 = null;
        if (string.equals("+")) {
            string2 = OperationCode.ADD.name();
        } else if (string.equals("-")) {
            string2 = OperationCode.SUB.name();
        } else if (string.equals("*")) {
            string2 = OperationCode.MUL.name();
        } else if (string.equals("/")) {
            string2 = OperationCode.DIV.name();
        } else if (string.equals("%")) {
            string2 = OperationCode.REM.name();
        } else {
            throw new VnanoFatalException("Invalid operator symbol for arithmetic binary operators: " + string);
        }
        return this.generateBinaryOperatorCode(astNode, string2, false, astNode.getChildNodes());
    }

    private String generateArithmeticPrefixOperatorCode(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.OPERATOR_SYMBOL);
        StringBuilder stringBuilder = new StringBuilder();
        AstNode astNode2 = astNode.getChildNodes()[0];
        String string2 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        String string3 = astNode.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        if (astNode.hasAttribute(AttributeKey.NEW_REGISTER)) {
            stringBuilder.append(this.generateRegisterAllocationCode(astNode.getDataTypeName(), astNode.getAttribute(AttributeKey.NEW_REGISTER), string2, astNode.getArrayRank()));
        }
        if (string.equals("+")) {
            stringBuilder.append(this.generateInstruction(OperationCode.MOV.name(), astNode2.getDataTypeName(), string3, string2));
            return stringBuilder.toString();
        }
        if (string.equals("-")) {
            stringBuilder.append(this.generateInstruction(OperationCode.NEG.name(), astNode2.getDataTypeName(), string3, string2));
            return stringBuilder.toString();
        }
        throw new VnanoFatalException("Unexpected arithmetic prefix operator detected.");
    }

    private String generateLogicalBinaryOperatorCode(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.OPERATOR_SYMBOL);
        String string2 = null;
        if (string.equals("&&")) {
            string2 = OperationCode.ANDM.name();
        } else if (string.equals("||")) {
            string2 = OperationCode.ORM.name();
        } else {
            throw new VnanoFatalException("Invalid operator symbol for logical binary operators: " + string);
        }
        return this.generateBinaryOperatorCode(astNode, string2, false, astNode.getChildNodes());
    }

    private String generateLogicalPrefixOperatorCode(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.OPERATOR_SYMBOL);
        if (!string.equals("!")) {
            throw new VnanoFatalException("Invalid operator symbol for logical prefix operators: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        AstNode astNode2 = astNode.getChildNodes()[0];
        String string2 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        String string3 = astNode.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        if (astNode.hasAttribute(AttributeKey.NEW_REGISTER)) {
            stringBuilder.append(this.generateRegisterAllocationCode("bool", astNode.getAttribute(AttributeKey.NEW_REGISTER), string2, astNode.getArrayRank()));
        }
        stringBuilder.append(this.generateInstruction(OperationCode.NOT.name(), "bool", string3, string2));
        return stringBuilder.toString();
    }

    private String generateComparisonBinaryOperatorCode(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.OPERATOR_SYMBOL);
        String string2 = null;
        if (string.equals("==")) {
            string2 = OperationCode.EQ.name();
        } else if (string.equals("!=")) {
            string2 = OperationCode.NEQ.name();
        } else if (string.equals("<")) {
            string2 = OperationCode.LT.name();
        } else if (string.equals("<=")) {
            string2 = OperationCode.LEQ.name();
        } else if (string.equals(">")) {
            string2 = OperationCode.GT.name();
        } else if (string.equals(">=")) {
            string2 = OperationCode.GEQ.name();
        } else {
            throw new VnanoFatalException("Invalid operator symbol for comparison binary operators: " + string);
        }
        return this.generateBinaryOperatorCode(astNode, string2, false, astNode.getChildNodes());
    }

    private String generateAssignmentOperatorCode(AstNode astNode) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = astNodeArray[i].getAttribute(AttributeKey.ASSEMBLY_VALUE);
        }
        String string2 = stringArray[1];
        String string3 = astNodeArray[0].getDataTypeName();
        if (!string3.equals(string = astNodeArray[1].getDataTypeName())) {
            String string4 = this.generateRegisterOperandCode();
            stringBuilder.append(this.generateRegisterAllocationCode(string3, string4, stringArray[1], astNode.getArrayRank()));
            String string5 = string3 + ":" + string;
            stringBuilder.append(this.generateInstruction(OperationCode.CAST.name(), string5, string4, stringArray[1]));
            string2 = string4;
        }
        if (astNodeArray[0].getArrayRank() == 0 && astNodeArray[1].getArrayRank() == 0) {
            stringBuilder.append(this.generateInstruction(OperationCode.MOV.name(), string3, stringArray[0], string2));
        } else if (astNodeArray[0].getArrayRank() != 0 && astNodeArray[1].getArrayRank() != 0) {
            stringBuilder.append(this.generateInstruction(OperationCode.ALLOCR.name(), string3, stringArray[0], string2));
            stringBuilder.append(this.generateInstruction(OperationCode.MOV.name(), string3, stringArray[0], string2));
        } else if (astNodeArray[0].getArrayRank() != 0 && astNodeArray[1].getArrayRank() == 0) {
            stringBuilder.append(this.generateInstruction(OperationCode.FILL.name(), string3, stringArray[0], string2));
        } else {
            stringBuilder.append(this.generateInstruction(OperationCode.MOV.name(), string3, stringArray[0], string2));
        }
        return stringBuilder.toString();
    }

    private String generateArithmeticCompoundAssignmentBinaryOperatorCode(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.OPERATOR_SYMBOL);
        String string2 = null;
        if (string.equals("+=")) {
            string2 = OperationCode.ADD.name();
        } else if (string.equals("-=")) {
            string2 = OperationCode.SUB.name();
        } else if (string.equals("*=")) {
            string2 = OperationCode.MUL.name();
        } else if (string.equals("/=")) {
            string2 = OperationCode.DIV.name();
        } else if (string.equals("%=")) {
            string2 = OperationCode.REM.name();
        } else {
            throw new VnanoFatalException("Invalid operator symbol for arithmetic compound assignment operators: " + string);
        }
        AstNode[] astNodeArray = astNode.getChildNodes();
        AstNode[] astNodeArray2 = new AstNode[]{astNodeArray[0], astNodeArray[1]};
        String string3 = astNode.getAttribute(AttributeKey.OPERATOR_EXECUTION_DATA_TYPE);
        String string4 = astNode.getAttribute(AttributeKey.DATA_TYPE);
        boolean bl = !string3.equals(string4);
        return this.generateBinaryOperatorCode(astNode, string2, bl, astNodeArray2);
    }

    private String generateArithmeticCompoundPostfixOperatorCode(AstNode astNode) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        String string = astNode.getAttribute(AttributeKey.OPERATOR_SYMBOL);
        String string2 = astNode.getAttribute(AttributeKey.OPERATOR_EXECUTION_DATA_TYPE);
        String string3 = null;
        if (string.equals("++")) {
            string3 = OperationCode.ADD.name();
        } else if (string.equals("--")) {
            string3 = OperationCode.SUB.name();
        } else {
            throw new VnanoFatalException("Invalid operator symbol for arithmetic compound prefix operators: " + string);
        }
        AstNode astNode2 = astNode.getChildNodes()[0];
        String string4 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        String string5 = astNode.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        stringBuilder.append(this.generateRegisterAllocationCode(string2, string5, string4, astNode.getArrayRank()));
        stringBuilder.append(this.generateInstruction(OperationCode.MOV.name(), string2, string5, string4));
        AstNode astNode3 = new AstNode(AstNode.Type.LEAF, astNode2.getLineNumber(), astNode2.getFileName());
        astNode3.setAttribute(AttributeKey.DATA_TYPE, string2);
        astNode3.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(0));
        if (string2.equals("int")) {
            object = this.generateImmediateOperandCode(string2, "1");
            astNode3.setAttribute(AttributeKey.ASSEMBLY_VALUE, (String)object);
        } else if (string2.equals("float")) {
            object = this.generateImmediateOperandCode(string2, "1.0");
            astNode3.setAttribute(AttributeKey.ASSEMBLY_VALUE, (String)object);
        }
        object = astNode.clone();
        ((AstNode)object).setAttribute(AttributeKey.ASSEMBLY_VALUE, string4);
        ((AstNode)object).removeAttribute(AttributeKey.NEW_REGISTER);
        String string6 = this.generateBinaryOperatorCode((AstNode)object, string3, false, astNode2, astNode3);
        stringBuilder.append(string6);
        return stringBuilder.toString();
    }

    private String generateArithmeticCompoundPrefixOperatorCode(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.OPERATOR_SYMBOL);
        String string2 = null;
        if (string.equals("++")) {
            string2 = OperationCode.ADD.name();
        } else if (string.equals("--")) {
            string2 = OperationCode.SUB.name();
        } else {
            throw new VnanoFatalException("Invalid operator symbol for arithmetic compound prefix operators: " + string);
        }
        AstNode astNode2 = astNode.getChildNodes()[0];
        AstNode astNode3 = new AstNode(AstNode.Type.LEAF, astNode2.getLineNumber(), astNode2.getFileName());
        String string3 = astNode.getAttribute(AttributeKey.OPERATOR_EXECUTION_DATA_TYPE);
        astNode3.setAttribute(AttributeKey.DATA_TYPE, string3);
        astNode3.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(0));
        if (string3.equals("int")) {
            String string4 = this.generateImmediateOperandCode(string3, "1");
            astNode3.setAttribute(AttributeKey.ASSEMBLY_VALUE, string4);
        } else if (string3.equals("float")) {
            String string5 = this.generateImmediateOperandCode(string3, "1.0");
            astNode3.setAttribute(AttributeKey.ASSEMBLY_VALUE, string5);
        }
        return this.generateBinaryOperatorCode(astNode, string2, false, astNode2, astNode3);
    }

    private String generateBinaryOperatorCode(AstNode astNode, String string, boolean bl, AstNode ... astNodeArray) {
        Object object;
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = astNode.getAttribute(AttributeKey.OPERATOR_EXECUTION_DATA_TYPE);
        String string3 = astNode.getAttribute(AttributeKey.DATA_TYPE);
        int n3 = astNode.getArrayRank();
        int n4 = astNodeArray.length;
        String[] stringArray = new String[n4];
        for (int i = 0; i < n4; ++i) {
            stringArray[i] = astNodeArray[i].getAttribute(AttributeKey.ASSEMBLY_VALUE);
        }
        String string4 = astNode.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        boolean bl2 = false;
        if (n3 != 0) {
            AstNode[] astNodeArray2 = astNodeArray;
            n2 = astNodeArray2.length;
            for (n = 0; n < n2; ++n) {
                object = astNodeArray2[n];
                if (((AstNode)object).getArrayRank() != 0) continue;
                bl2 = true;
                break;
            }
        }
        boolean bl3 = false;
        for (n2 = 0; n2 < n4; ++n2) {
            if (astNodeArray[n2].getDataTypeName().equals(string2)) continue;
            bl3 = true;
            break;
        }
        String string5 = stringArray[0];
        for (n = 0; n < n4; ++n) {
            if (astNodeArray[n].getArrayRank() == 0) continue;
            string5 = stringArray[n];
            break;
        }
        if (bl3) {
            for (n = 0; n < n4; ++n) {
                object = astNodeArray[n].getDataTypeName();
                if (((String)object).equals(string2)) continue;
                String string6 = stringArray[n];
                int n5 = astNodeArray[n].getArrayRank();
                String string7 = this.generateRegisterOperandCode();
                stringBuilder.append(this.generateRegisterAllocationCode(string2, string7, string6, n5));
                String string8 = string2 + ":" + (String)object;
                stringBuilder.append(this.generateInstruction(OperationCode.CAST.name(), string8, string7, string6));
                stringArray[n] = string7;
            }
        }
        if (bl2) {
            for (n = 0; n < n4; ++n) {
                if (astNodeArray[n].getArrayRank() != 0) continue;
                object = this.generateRegisterOperandCode();
                stringBuilder.append(this.generateRegisterAllocationCode(string2, (String)object, string5, n3));
                stringBuilder.append(this.generateInstruction(OperationCode.FILL.name(), string2, new String[]{object, stringArray[n]}));
                stringArray[n] = object;
            }
        }
        if (astNode.hasAttribute(AttributeKey.NEW_REGISTER)) {
            stringBuilder.append(this.generateRegisterAllocationCode(string3, astNode.getAttribute(AttributeKey.NEW_REGISTER), string5, n3));
        }
        if (bl) {
            String string9 = this.generateRegisterOperandCode();
            stringBuilder.append(this.generateRegisterAllocationCode(string2, string9, string5, n3));
            stringBuilder.append(this.generateInstruction(string, string2, string9, stringArray[0], stringArray[1]));
            object = string3 + ":" + string2;
            stringBuilder.append(this.generateInstruction(OperationCode.CAST.name(), (String)object, string4, string9));
        } else {
            stringBuilder.append(this.generateInstruction(string, string2, string4, stringArray[0], stringArray[1]));
        }
        return stringBuilder.toString();
    }

    private String generateCallOperatorCode(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = astNode.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        String string2 = astNode.getDataTypeName();
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length;
        String string3 = astNode.getAttribute(AttributeKey.SCOPE);
        int n2 = n + 1;
        String[] stringArray = new String[n2];
        for (int i = 1; i < n2; ++i) {
            stringArray[i] = astNodeArray[i - 1].getAttribute(AttributeKey.ASSEMBLY_VALUE);
        }
        if (string3.equals("global")) {
            stringArray[0] = string2.equals("void") ? this.PLACE_HOLDER : string;
            stringBuilder.append(this.generateInstruction(OperationCode.CALLX.name(), astNode.getDataTypeName(), stringArray));
        } else if (string3.equals("local")) {
            stringArray[0] = Character.toString('-');
            stringArray[1] = '&' + stringArray[1];
            stringBuilder.append(this.generateInstruction(OperationCode.CALL.name(), astNode.getDataTypeName(), stringArray));
            if (string2.equals("void")) {
                stringBuilder.append(this.generateInstruction(OperationCode.POP.name(), astNode.getDataTypeName(), this.PLACE_HOLDER));
            } else {
                if (astNode.getArrayRank() == 0) {
                    stringBuilder.append(this.generateInstruction(OperationCode.ALLOC.name(), astNode.getDataTypeName(), string));
                } else {
                    stringBuilder.append(this.generateInstruction(OperationCode.ALLOCP.name(), astNode.getDataTypeName(), string));
                }
                stringBuilder.append(this.generateInstruction(OperationCode.MOVPOP.name(), astNode.getDataTypeName(), string));
            }
        } else {
            throw new VnanoFatalException("Unknown function scope: " + string3);
        }
        return stringBuilder.toString();
    }

    private String generateIndexOperatorCode(AstNode astNode) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length - 1;
        String string = astNodeArray[0].getAttribute(AttributeKey.ASSEMBLY_VALUE);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = astNodeArray[i + 1].getAttribute(AttributeKey.ASSEMBLY_VALUE);
        }
        String string2 = astNode.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = string2;
        stringArray2[1] = string;
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        AstNode astNode2 = astNode.getParentNode();
        boolean bl2 = astNode2.getType() == AstNode.Type.OPERATOR && (astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("assignment") || astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("arithmeticCompoundAssignment"));
        boolean bl3 = astNode2.getType() == AstNode.Type.OPERATOR && astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("call");
        boolean bl4 = bl = bl2 && astNode.getSiblingIndex() == 0 || bl3;
        if (bl) {
            stringBuilder.append(this.generateInstruction(OperationCode.REFELM.name(), astNodeArray[0].getDataTypeName(), stringArray2));
        } else {
            stringBuilder.append(this.generateInstruction(OperationCode.ALLOC.name(), astNode.getDataTypeName(), string2));
            stringBuilder.append(this.generateInstruction(OperationCode.MOVELM.name(), astNodeArray[0].getDataTypeName(), stringArray2));
        }
        return stringBuilder.toString();
    }

    private String generateCastOperatorCode(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        AstNode astNode2 = astNode.getChildNodes()[0];
        String string = astNode2.getAttribute(AttributeKey.DATA_TYPE);
        String string2 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        int n = astNode2.getArrayRank();
        String string3 = astNode.getAttribute(AttributeKey.DATA_TYPE);
        String string4 = astNode.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        stringBuilder.append(this.generateRegisterAllocationCode(string3, string4, string2, n));
        String string5 = string3 + ":" + string;
        stringBuilder.append(this.generateInstruction(OperationCode.CAST.name(), string5, string4, string2));
        return stringBuilder.toString();
    }

    private String generateLanguageInformationDirectives() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#ASSEMBLY_LANGUAGE_IDENTIFIER");
        stringBuilder.append("\t");
        stringBuilder.append("\"");
        stringBuilder.append("Vector Register Intermediate Language (VRIL)");
        stringBuilder.append("\"");
        stringBuilder.append(";");
        stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        stringBuilder.append("#assemblyLanguageVersion");
        stringBuilder.append("\t");
        stringBuilder.append("\"");
        stringBuilder.append("0.0.1");
        stringBuilder.append("\"");
        stringBuilder.append(";");
        stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        stringBuilder.append("#SCRIPT_LANGUAGE_IDENTIFIER");
        stringBuilder.append("\t");
        stringBuilder.append("\"");
        stringBuilder.append("Vnano");
        stringBuilder.append("\"");
        stringBuilder.append(";");
        stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        stringBuilder.append("#scriptLanguageVersion");
        stringBuilder.append("\t");
        stringBuilder.append("\"");
        stringBuilder.append("1.1.4");
        stringBuilder.append("\"");
        stringBuilder.append(";");
        stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String generateFunctionIdentifierDirectives(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> hashSet = new HashSet<String>();
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            if (astNode2.getType() != AstNode.Type.OPERATOR || !astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("call")) continue;
            String string = astNode2.getAttribute(AttributeKey.CALLEE_SIGNATURE);
            String string2 = '_' + string;
            String string3 = astNode2.getAttribute(AttributeKey.SCOPE);
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            if (string3.equals("global")) {
                stringBuilder.append("#GLOBAL_FUNCTION");
            } else if (string3.equals("local")) {
                stringBuilder.append("#LOCAL_FUNCTION");
            } else {
                throw new VnanoFatalException("Unknown function scope: " + astNode2.getAttribute(AttributeKey.SCOPE));
            }
            stringBuilder.append("\t");
            stringBuilder.append(string2);
            stringBuilder.append(";");
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private String generateGlobalIdentifierDirectives(AstNode astNode) {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet hashSet = new HashSet();
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            String string;
            if (astNode2.getType() != AstNode.Type.LEAF || !astNode2.getAttribute(AttributeKey.LEAF_TYPE).equals("variableIdentifier") || !astNode2.getAttribute(AttributeKey.SCOPE).equals("global") || hashSet.contains(string = IdentifierSyntax.getAssemblyIdentifierOf(astNode2))) continue;
            stringBuilder.append("#GLOBAL_VARIABLE");
            stringBuilder.append("\t");
            stringBuilder.append(string);
            stringBuilder.append(";");
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private String generateMetaDirectiveCode(AstNode astNode) {
        String string = IdentifierSyntax.normalizeScriptIdentifier(astNode.getFileName());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#META");
        stringBuilder.append("\t");
        stringBuilder.append("\"");
        stringBuilder.append(MetaInformationSyntax.generateMetaInformation(astNode.getLineNumber(), string));
        stringBuilder.append("\"");
        stringBuilder.append(";");
        stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String generateLabelDirectiveCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#LABEL");
        stringBuilder.append("\t");
        stringBuilder.append(string);
        stringBuilder.append(";");
        stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String generateLabelOperandCode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('&');
        stringBuilder.append(LABEL_NAME);
        stringBuilder.append(Integer.toString(this.labelCounter));
        ++this.labelCounter;
        return stringBuilder.toString();
    }

    private String generateRegisterOperandCode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('R');
        stringBuilder.append(this.registerCounter);
        ++this.registerCounter;
        return stringBuilder.toString();
    }

    private String generateImmediateOperandCode(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('~');
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private String generateDefaultValueImmediateOperandCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('~');
        stringBuilder.append(string);
        stringBuilder.append(":");
        DataType dataType = null;
        try {
            dataType = DataTypeName.getDataTypeOf(string);
        }
        catch (VnanoException vnanoException) {
            throw new VnanoFatalException("Unexpected data type: " + string);
        }
        String string2 = "";
        switch (dataType) {
            case INT64: {
                string2 = "0";
                break;
            }
            case FLOAT64: {
                string2 = "0.0";
                break;
            }
            case BOOL: {
                string2 = "false";
                break;
            }
            case STRING: {
                String string3 = Character.toString('\"');
                string2 = string3 + string3;
                break;
            }
            default: {
                throw new VnanoFatalException("Unexpected data type: " + string);
            }
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private String generateInstruction(String string, String string2, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t");
        stringBuilder.append(string);
        stringBuilder.append("\t");
        stringBuilder.append(string2);
        for (String string3 : stringArray) {
            stringBuilder.append("\t");
            stringBuilder.append(string3);
        }
        stringBuilder.append(";");
        stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String realign(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\\r\\n|\\r|\\n");
        int n6 = stringArray.length;
        boolean bl = false;
        for (n5 = 0; n5 < n6; ++n5) {
            if (!stringArray[n5].startsWith("#ASSEMBLY_LANGUAGE_IDENTIFIER") && !stringArray[n5].startsWith("#assemblyLanguageVersion") && !stringArray[n5].startsWith("#SCRIPT_LANGUAGE_IDENTIFIER") && !stringArray[n5].startsWith("#scriptLanguageVersion")) continue;
            bl = true;
            stringBuilder.append(stringArray[n5]);
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
            stringArray[n5] = "";
        }
        if (bl) {
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        }
        n5 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            if (!stringArray[n4].startsWith("#GLOBAL_FUNCTION")) continue;
            n5 = 1;
            stringBuilder.append(stringArray[n4]);
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
            stringArray[n4] = "";
        }
        if (n5 != 0) {
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        }
        n4 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            if (!stringArray[n3].startsWith("#LOCAL_FUNCTION")) continue;
            n4 = 1;
            stringBuilder.append(stringArray[n3]);
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
            stringArray[n3] = "";
        }
        if (n4 != 0) {
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        }
        n3 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            if (!stringArray[n2].startsWith("#GLOBAL_VARIABLE")) continue;
            n3 = 1;
            stringBuilder.append(stringArray[n2]);
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
            stringArray[n2] = "";
        }
        if (n3 != 0) {
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
        }
        n2 = 0;
        for (n = 0; n < n6; ++n) {
            if (!stringArray[n].startsWith("#LOCAL_VARIABLE")) continue;
            n2 = 1;
            stringBuilder.append(stringArray[n]);
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
            stringArray[n] = "";
        }
        for (n = 0; n < n6; ++n) {
            if (stringArray[n].length() == 0) continue;
            if (stringArray[n].startsWith("#META")) {
                stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
            }
            stringBuilder.append(stringArray[n]);
            stringBuilder.append(AssemblyWord.LINE_SEPARATOR);
            stringArray[n] = "";
        }
        return stringBuilder.toString();
    }

    private String generateFinalizationCode(AstNode astNode) {
        AstNode astNode2;
        StringBuilder stringBuilder = new StringBuilder();
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length;
        String string = null;
        String string2 = null;
        if (n != 0 && (astNode2 = astNodeArray[n - 1]).getType() == AstNode.Type.EXPRESSION) {
            string = astNode2.getAttribute(AttributeKey.DATA_TYPE);
            string2 = astNode2.getAttribute(AttributeKey.ASSEMBLY_VALUE);
        }
        if (string == null || string.equals("void")) {
            stringBuilder.append(this.generateInstruction(OperationCode.END.name(), "void", this.PLACE_HOLDER));
        } else {
            stringBuilder.append(this.generateInstruction(OperationCode.END.name(), string, this.PLACE_HOLDER, string2));
        }
        return stringBuilder.toString();
    }

    private class StatementTrackingContext
    implements Cloneable {
        private String beginPointLabel = null;
        private String updatePointLabel = null;
        private String updatePointStatement = null;
        private ArrayList<String> endPointLabelList = new ArrayList();
        private String endPointStatement = null;
        private String lastIfConditionRegister = null;
        private String lastLoopBeginPointLabel = null;
        private String lastLoopUpdatePointLabel = null;
        private String lastLoopEndPointLabel = null;
        private String lastFunctionLabel = null;
        private String outerLoopBeginPointLabel = null;
        private String outerLoopUpdatePointLabel = null;
        private String outerLoopEndPointLabel = null;
        private boolean isNextBlockLoop = false;
        private AstNode[] statementNodes = null;
        private int statementLength = -1;
        private int statementIndex = -1;
        private String lastStatementCode = null;

        public StatementTrackingContext clone() {
            StatementTrackingContext statementTrackingContext = new StatementTrackingContext();
            statementTrackingContext.beginPointLabel = this.beginPointLabel;
            statementTrackingContext.updatePointLabel = this.updatePointLabel;
            statementTrackingContext.updatePointStatement = this.updatePointStatement;
            statementTrackingContext.endPointStatement = this.endPointStatement;
            statementTrackingContext.endPointLabelList = new ArrayList();
            for (String string : this.endPointLabelList) {
                statementTrackingContext.endPointLabelList.add(string);
            }
            statementTrackingContext.lastIfConditionRegister = this.lastIfConditionRegister;
            statementTrackingContext.lastLoopBeginPointLabel = this.lastLoopBeginPointLabel;
            statementTrackingContext.lastLoopUpdatePointLabel = this.lastLoopUpdatePointLabel;
            statementTrackingContext.lastLoopEndPointLabel = this.lastLoopEndPointLabel;
            statementTrackingContext.lastFunctionLabel = this.lastFunctionLabel;
            statementTrackingContext.outerLoopBeginPointLabel = this.outerLoopBeginPointLabel;
            statementTrackingContext.outerLoopUpdatePointLabel = this.outerLoopUpdatePointLabel;
            statementTrackingContext.outerLoopEndPointLabel = this.outerLoopEndPointLabel;
            statementTrackingContext.isNextBlockLoop = this.isNextBlockLoop;
            statementTrackingContext.statementNodes = this.statementNodes;
            statementTrackingContext.statementIndex = this.statementIndex;
            statementTrackingContext.statementLength = this.statementLength;
            statementTrackingContext.lastStatementCode = this.lastStatementCode;
            return statementTrackingContext;
        }

        public String getBeginPointLabel() {
            return this.beginPointLabel;
        }

        public void setBeginPointLabel(String string) {
            this.beginPointLabel = string;
        }

        public boolean hasBeginPointLabel() {
            return this.beginPointLabel != null;
        }

        public void clearBeginPointLabel() {
            this.beginPointLabel = null;
        }

        public String getUpdatePointLabel() {
            return this.updatePointLabel;
        }

        public void setUpdatePointLabel(String string) {
            this.updatePointLabel = string;
        }

        public boolean hasUpdatePointLabel() {
            return this.updatePointLabel != null;
        }

        public void clearUpdatePointLabel() {
            this.updatePointLabel = null;
        }

        public String[] getEndPointLabels() {
            return this.endPointLabelList.toArray(new String[0]);
        }

        public void addEndPointLabel(String string) {
            this.endPointLabelList.add(string);
        }

        public boolean hasEndPointLabel() {
            return !this.endPointLabelList.isEmpty();
        }

        public void clearEndPointLabel() {
            this.endPointLabelList.clear();
        }

        public boolean hasEndPointStatement() {
            return this.endPointStatement != null;
        }

        public void setEndPointStatement(String string) {
            this.endPointStatement = string;
        }

        public String getEndPointStatement() {
            return this.endPointStatement;
        }

        public void clearEndPointStatement() {
            this.endPointStatement = null;
        }

        public String getUpdatePointStatement() {
            return this.updatePointStatement;
        }

        public void setUpdatePointStatement(String string) {
            this.updatePointStatement = string;
        }

        public boolean hasUpdatePointStatement() {
            return this.updatePointStatement != null;
        }

        public void clearUpdatePointStatement() {
            this.updatePointStatement = null;
        }

        public boolean hasLastIfConditionRegister() {
            return this.lastIfConditionRegister != null;
        }

        public String getLastIfConditionRegister() {
            return this.lastIfConditionRegister;
        }

        public void setLastIfConditionValue(String string) {
            this.lastIfConditionRegister = string;
        }

        public String getLastLoopBeginPointLabel() {
            return this.lastLoopBeginPointLabel;
        }

        public void setLastLoopBeginPointLabel(String string) {
            this.lastLoopBeginPointLabel = string;
        }

        public boolean hasLastLoopUpdatePointLabel() {
            return this.lastLoopUpdatePointLabel != null;
        }

        public String getLastLoopUpdatePointLabel() {
            return this.lastLoopUpdatePointLabel;
        }

        public void setLastLoopUpdatePointLabel(String string) {
            this.lastLoopUpdatePointLabel = string;
        }

        public String getLastLoopEndPointLabel() {
            return this.lastLoopEndPointLabel;
        }

        public void setLastLoopEndPointLabel(String string) {
            this.lastLoopEndPointLabel = string;
        }

        public String getOuterLoopBeginPointLabel() {
            return this.outerLoopBeginPointLabel;
        }

        public void setOuterLoopBeginPointLabel(String string) {
            this.outerLoopBeginPointLabel = string;
        }

        public String getOuterLoopEndPointLabel() {
            return this.outerLoopEndPointLabel;
        }

        public void setOuterLoopEndPointLabel(String string) {
            this.outerLoopEndPointLabel = string;
        }

        public String getOuterLoopUpdatePointLabel() {
            return this.outerLoopUpdatePointLabel;
        }

        public void setOuterLoopUpdatePointLabel(String string) {
            this.outerLoopUpdatePointLabel = string;
        }

        public String getLastFunctionLabel() {
            return this.lastFunctionLabel;
        }

        public void setLastFunctionLabel(String string) {
            this.lastFunctionLabel = string;
        }

        public void setNextBlockLoop(boolean bl) {
            this.isNextBlockLoop = bl;
        }

        public boolean isNextBlockLoop() {
            return this.isNextBlockLoop;
        }

        public AstNode[] getStatementNodes() {
            return this.statementNodes;
        }

        public void setStatementNodes(AstNode[] astNodeArray) {
            this.statementNodes = astNodeArray;
        }

        public int getStatementLength() {
            return this.statementLength;
        }

        public void setStatementLength(int n) {
            this.statementLength = n;
        }

        public int getStatementIndex() {
            return this.statementIndex;
        }

        public void setStatementIndex(int n) {
            this.statementIndex = n;
        }

        public String getLastStatementCode() {
            return this.lastStatementCode;
        }

        public void setLastStatementCode(String string) {
            this.lastStatementCode = string;
        }
    }
}

