/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.compiler.Token;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.LiteralSyntax;
import org.vcssl.nano.spec.ScriptWord;

public class LexicalAnalyzer {
    public Token[] analyze(String string, String string2) throws VnanoException {
        String[] stringArray = LiteralSyntax.extractStringLiterals(string);
        String string3 = stringArray[0];
        Token[] tokenArray = this.tokenize(string3, string2);
        this.analyzeTokenTypes(tokenArray);
        this.analyzePrecedences(tokenArray);
        this.analyzeAssociativities(tokenArray);
        this.analyzeLiteralAttributes(tokenArray);
        this.embedStringLiterals(tokenArray, stringArray);
        return tokenArray;
    }

    private Token[] tokenize(String string, String string2) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 1;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        while (n2 < n) {
            string3 = Character.toString(cArray[n2]);
            string4 = n2 < n - 1 ? new String(new char[]{cArray[n2], cArray[n2 + 1]}) : null;
            string5 = n2 < n - 2 ? new String(new char[]{cArray[n2], cArray[n2 + 1], cArray[n2 + 2]}) : null;
            if (0 < n2 && bl && Character.toString(cArray[n2 - 1]).matches("e|E")) {
                string3 = null;
            }
            if ((Character.toString(cArray[n2]).matches("( |\u3000|\t|\n|\r|\r\n|\n\r)") || ScriptWord.SYMBOL_SET.contains(string3) || ScriptWord.SYMBOL_SET.contains(string4) || ScriptWord.SYMBOL_SET.contains(string5)) && stringBuilder.length() != 0) {
                arrayList.add(new Token(new String(stringBuilder.toString()), n3, string2));
                stringBuilder = new StringBuilder();
                stringBuilder.delete(0, stringBuilder.length());
                bl = false;
            }
            if (ScriptWord.SYMBOL_SET.contains(string5)) {
                arrayList.add(new Token(string5, n3, string2));
                n2 += 3;
                continue;
            }
            if (ScriptWord.SYMBOL_SET.contains(string4)) {
                arrayList.add(new Token(string4, n3, string2));
                n2 += 2;
                continue;
            }
            if (ScriptWord.SYMBOL_SET.contains(string3)) {
                arrayList.add(new Token(string3, n3, string2));
                ++n2;
                continue;
            }
            if (cArray[n2] == ' ' || cArray[n2] == '\n' || cArray[n2] == '\t') {
                if (cArray[n2] == '\n') {
                    ++n3;
                }
                ++n2;
                continue;
            }
            if (stringBuilder.length() == 0 && Character.toString(cArray[n2]).matches("^[0-9]$")) {
                bl = true;
            }
            stringBuilder.append(cArray[n2]);
            ++n2;
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(new Token(new String(stringBuilder.toString()), n3, string2));
        }
        Token[] tokenArray = arrayList.toArray(new Token[arrayList.size()]);
        return tokenArray;
    }

    private void analyzeTokenTypes(Token[] tokenArray) {
        int n = tokenArray.length;
        Token token = null;
        String string = null;
        int n2 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string2 = tokenArray[i].getValue();
            if (string2.equals("{") || string2.equals("}")) {
                tokenArray[i].setType(Token.Type.BLOCK);
            } else if (string2.equals("(")) {
                ++n2;
                if (i < n - 1 && DataTypeName.isDataTypeName(tokenArray[i + 1].getValue())) {
                    tokenArray[i].setType(Token.Type.OPERATOR);
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "cast");
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "prefix");
                    bl = true;
                } else if (token != null && token.getType() == Token.Type.LEAF && token.getAttribute(AttributeKey.LEAF_TYPE).equals("functionIdentifier") && !ScriptWord.STATEMENT_NAME_SET.contains(string)) {
                    hashSet.add(n2);
                    tokenArray[i].setType(Token.Type.OPERATOR);
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "call");
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "multiary");
                } else {
                    tokenArray[i].setType(Token.Type.PARENTHESIS);
                }
            } else if (string2.equals(")")) {
                if (bl) {
                    tokenArray[i].setType(Token.Type.OPERATOR);
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "cast");
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "prefix");
                    bl = false;
                } else if (hashSet.contains(n2)) {
                    hashSet.remove(n2);
                    tokenArray[i].setType(Token.Type.OPERATOR);
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "call");
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "multialyEnd");
                } else {
                    tokenArray[i].setType(Token.Type.PARENTHESIS);
                }
                --n2;
            } else if (string2.equals(",")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "call");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "multialySeparator");
            } else if (string2.equals("[")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "subscript");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "multiary");
            } else if (string2.equals("][")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "subscript");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "multialySeparator");
            } else if (string2.equals("]")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "subscript");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "multialyEnd");
            } else if (string2.equals(";")) {
                tokenArray[i].setType(Token.Type.END_OF_STATEMENT);
            } else if (ScriptWord.MODIFIER_SET.contains(string2)) {
                tokenArray[i].setType(Token.Type.MODIFIER);
            } else if (string2.equals("=")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "assignment");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "binary");
            } else if (string2.equals("+") || string2.equals("-")) {
                if (token != null && (token.getType() == Token.Type.LEAF || token.getValue().equals(")") || token.getValue().equals("]"))) {
                    tokenArray[i].setType(Token.Type.OPERATOR);
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "arithmetic");
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "binary");
                } else {
                    tokenArray[i].setType(Token.Type.OPERATOR);
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "arithmetic");
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "prefix");
                }
            } else if (string2.equals("*") || string2.equals("/") || string2.equals("%")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "arithmetic");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "binary");
            } else if (string2.equals("+=") || string2.equals("-=") || string2.equals("*=") || string2.equals("/=") || string2.equals("%=")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "arithmeticCompoundAssignment");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "binary");
            } else if (string2.equals("==") || string2.equals("!=") || string2.equals(">") || string2.equals(">=") || string2.equals("<") || string2.equals("<=")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "comparison");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "binary");
            } else if (string2.equals("&&") || string2.equals("||")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "logical");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "binary");
            } else if (string2.equals("!")) {
                tokenArray[i].setType(Token.Type.OPERATOR);
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "logical");
                tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "prefix");
            } else if (string2.equals("++") || string2.equals("--")) {
                if (token != null && (token.getType() == Token.Type.LEAF || token.getType() == Token.Type.OPERATOR && token.getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("postfix"))) {
                    tokenArray[i].setType(Token.Type.OPERATOR);
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "arithmeticCompoundAssignment");
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "postfix");
                } else {
                    tokenArray[i].setType(Token.Type.OPERATOR);
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_EXECUTOR, "arithmeticCompoundAssignment");
                    tokenArray[i].setAttribute(AttributeKey.OPERATOR_SYNTAX, "prefix");
                }
            } else if (string2.equals("if") || string2.equals("else") || string2.equals("for") || string2.equals("while") || string2.equals("return") || string2.equals("break") || string2.equals("continue")) {
                tokenArray[i].setType(Token.Type.CONTROL);
            } else if (string2.equals("import") || string2.equals("include")) {
                tokenArray[i].setType(Token.Type.DEPENDENCY_DECLARATOR);
            } else if (DataTypeName.isDataTypeName(string2)) {
                tokenArray[i].setType(Token.Type.DATA_TYPE);
            } else {
                tokenArray[i].setType(Token.Type.LEAF);
                if (LiteralSyntax.isValidLiteral(string2)) {
                    tokenArray[i].setAttribute(AttributeKey.LEAF_TYPE, "literal");
                } else if (0 < i && tokenArray[i - 1].getType() == Token.Type.DEPENDENCY_DECLARATOR) {
                    tokenArray[i].setAttribute(AttributeKey.LEAF_TYPE, "dependencyIdentifier");
                } else if (i < n - 1 && tokenArray[i + 1].getValue().equals("(")) {
                    tokenArray[i].setAttribute(AttributeKey.LEAF_TYPE, "functionIdentifier");
                } else {
                    tokenArray[i].setAttribute(AttributeKey.LEAF_TYPE, "variableIdentifier");
                }
            }
            token = tokenArray[i];
            string = string2;
        }
    }

    private void analyzePrecedences(Token[] tokenArray) {
        int n = tokenArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = tokenArray[i].getValue();
            if (string2.equals("(")) {
                if (tokenArray[i].getType() == Token.Type.OPERATOR) {
                    string = tokenArray[i].getAttribute(AttributeKey.OPERATOR_EXECUTOR);
                    if (string.equals("cast")) {
                        tokenArray[i].setPrecedence(2000);
                        continue;
                    }
                    if (!string.equals("call")) continue;
                    tokenArray[i].setPrecedence(1000);
                    continue;
                }
                tokenArray[i].setPrecedence(-1);
                continue;
            }
            if (string2.equals(")")) {
                if (tokenArray[i].getType() == Token.Type.OPERATOR) {
                    string = tokenArray[i].getAttribute(AttributeKey.OPERATOR_EXECUTOR);
                    if (string.equals("cast")) {
                        tokenArray[i].setPrecedence(10000000);
                        continue;
                    }
                    if (!string.equals("call")) continue;
                    tokenArray[i].setPrecedence(10000000);
                    continue;
                }
                tokenArray[i].setPrecedence(10000000);
                continue;
            }
            if (string2.equals(",")) {
                tokenArray[i].setPrecedence(10000000);
                continue;
            }
            if (string2.equals("[")) {
                tokenArray[i].setPrecedence(1000);
                continue;
            }
            if (string2.equals("]")) {
                tokenArray[i].setPrecedence(10000000);
                continue;
            }
            if (string2.equals("][")) {
                tokenArray[i].setPrecedence(10000000);
                continue;
            }
            if (string2.equals("++")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix")) {
                    tokenArray[i].setPrecedence(2000);
                    continue;
                }
                tokenArray[i].setPrecedence(1000);
                continue;
            }
            if (string2.equals("--")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix")) {
                    tokenArray[i].setPrecedence(2000);
                    continue;
                }
                tokenArray[i].setPrecedence(1000);
                continue;
            }
            if (string2.equals("!")) {
                tokenArray[i].setPrecedence(2000);
                continue;
            }
            if (string2.equals("+")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix")) {
                    tokenArray[i].setPrecedence(2000);
                    continue;
                }
                tokenArray[i].setPrecedence(3100);
                continue;
            }
            if (string2.equals("-")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix")) {
                    tokenArray[i].setPrecedence(2000);
                    continue;
                }
                tokenArray[i].setPrecedence(3100);
                continue;
            }
            if (string2.equals("*")) {
                tokenArray[i].setPrecedence(3000);
                continue;
            }
            if (string2.equals("/")) {
                tokenArray[i].setPrecedence(3000);
                continue;
            }
            if (string2.equals("%")) {
                tokenArray[i].setPrecedence(3000);
                continue;
            }
            if (string2.equals("<")) {
                tokenArray[i].setPrecedence(4000);
                continue;
            }
            if (string2.equals("<=")) {
                tokenArray[i].setPrecedence(4000);
                continue;
            }
            if (string2.equals(">")) {
                tokenArray[i].setPrecedence(4000);
                continue;
            }
            if (string2.equals(">=")) {
                tokenArray[i].setPrecedence(4000);
                continue;
            }
            if (string2.equals("==")) {
                tokenArray[i].setPrecedence(4100);
                continue;
            }
            if (string2.equals("!=")) {
                tokenArray[i].setPrecedence(4100);
                continue;
            }
            if (string2.equals("&&")) {
                tokenArray[i].setPrecedence(5000);
                continue;
            }
            if (string2.equals("||")) {
                tokenArray[i].setPrecedence(5100);
                continue;
            }
            if (string2.equals("=")) {
                tokenArray[i].setPrecedence(6000);
                continue;
            }
            if (string2.equals("+=")) {
                tokenArray[i].setPrecedence(6000);
                continue;
            }
            if (string2.equals("-=")) {
                tokenArray[i].setPrecedence(6000);
                continue;
            }
            if (string2.equals("*=")) {
                tokenArray[i].setPrecedence(6000);
                continue;
            }
            if (string2.equals("/=")) {
                tokenArray[i].setPrecedence(6000);
                continue;
            }
            if (!string2.equals("%=")) continue;
            tokenArray[i].setPrecedence(6000);
        }
    }

    private void analyzeAssociativities(Token[] tokenArray) {
        int n = tokenArray.length;
        for (int i = 0; i < n; ++i) {
            if (tokenArray[i].getType() != Token.Type.OPERATOR) continue;
            String string = "left";
            String string2 = tokenArray[i].getValue();
            if (string2.equals("(")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("cast")) {
                    string = "right";
                }
            } else if (string2.equals(")")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("cast")) {
                    string = "right";
                }
            } else if (string2.equals("++")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix")) {
                    string = "right";
                }
            } else if (string2.equals("--")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix")) {
                    string = "right";
                }
            } else if (string2.equals("!")) {
                string = "right";
            } else if (string2.equals("+")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix")) {
                    string = "right";
                }
            } else if (string2.equals("-")) {
                if (tokenArray[i].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix")) {
                    string = "right";
                }
            } else if (string2.equals("=")) {
                string = "right";
            } else if (string2.equals("+=")) {
                string = "right";
            } else if (string2.equals("-=")) {
                string = "right";
            } else if (string2.equals("*=")) {
                string = "right";
            } else if (string2.equals("/=")) {
                string = "right";
            } else if (string2.equals("%=")) {
                string = "right";
            }
            tokenArray[i].setAttribute(AttributeKey.OPERATOR_ASSOCIATIVITY, string);
        }
    }

    private void analyzeLiteralAttributes(Token[] tokenArray) {
        for (Token token : tokenArray) {
            if (token.getType() != Token.Type.LEAF || !token.getAttribute(AttributeKey.LEAF_TYPE).equals("literal")) continue;
            String string = token.getValue();
            String string2 = LiteralSyntax.getDataTypeNameOfLiteral(string);
            token.setAttribute(AttributeKey.DATA_TYPE, string2);
            token.setAttribute(AttributeKey.ARRAY_RANK, "0");
        }
    }

    private void embedStringLiterals(Token[] tokenArray, String[] stringArray) {
        for (Token token : tokenArray) {
            String string = token.getValue();
            if (token.getType() != Token.Type.LEAF || !token.getAttribute(AttributeKey.LEAF_TYPE).equals("literal") || !LiteralSyntax.getDataTypeNameOfLiteral(string).equals("string")) continue;
            int n = LiteralSyntax.getIndexOfNumberedStringLiteral(string);
            token.setValue(stringArray[n]);
        }
    }
}

