/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.compiler.LexicalChecker;
import org.vcssl.nano.compiler.Token;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.ScriptWord;

public class Parser {
    private static final int RANK_OF_SCALAR = 0;

    public AstNode parse(Token[] tokenArray) throws VnanoException {
        int n;
        LexicalChecker lexicalChecker = new LexicalChecker();
        ArrayDeque<AstNode> arrayDeque = new ArrayDeque<AstNode>();
        int n2 = tokenArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Token[] tokenArray2;
            Object object;
            int n4 = Token.getIndexOf(tokenArray, ";", n3);
            n = Token.getIndexOf(tokenArray, "{", n3);
            int n5 = Token.getIndexOf(tokenArray, "}", n3);
            Token token = tokenArray[n3];
            if (n4 < 0 && n < 0 && n3 != n5) {
                throw new VnanoException(ErrorType.STATEMENT_END_IS_NOT_FOUND, token.getFileName(), token.getLineNumber());
            }
            if (n3 == n4) {
                object = new AstNode(AstNode.Type.EMPTY, tokenArray[n3].getLineNumber(), token.getFileName());
                arrayDeque.push((AstNode)object);
                ++n3;
                continue;
            }
            if (token.getType() == Token.Type.BLOCK) {
                if (token.getValue().equals("{")) {
                    this.pushLid(arrayDeque);
                    ++n3;
                    continue;
                }
                object = this.popStatementNodes(arrayDeque);
                tokenArray2 = new AstNode(AstNode.Type.BLOCK, token.getLineNumber(), token.getFileName());
                for (Cloneable cloneable : object) {
                    tokenArray2.addChildNode((AstNode)cloneable);
                }
                arrayDeque.push((AstNode)tokenArray2);
                ++n3;
                continue;
            }
            if (token.getType() == Token.Type.CONTROL) {
                object = token.getValue();
                if (object.equals("if") || object.equals("for") || object.equals("while")) {
                    boolean bl = object.equals("for");
                    lexicalChecker.checkTokensAfterControlStatement(tokenArray, n3, bl);
                    Cloneable[] cloneableArray = Arrays.copyOfRange(tokenArray, n3, n);
                    arrayDeque.push(this.parseControlStatement((Token[])cloneableArray));
                    n3 = n;
                    continue;
                }
                if (token.getValue().equals("else")) {
                    lexicalChecker.checkTokensAfterControlStatement(tokenArray, n3, false);
                    tokenArray2 = Arrays.copyOfRange(tokenArray, n3, n3 + 1);
                    arrayDeque.push(this.parseControlStatement(tokenArray2));
                    ++n3;
                    continue;
                }
                tokenArray2 = Arrays.copyOfRange(tokenArray, n3, n4);
                arrayDeque.push(this.parseControlStatement(tokenArray2));
                n3 = n4 + 1;
                continue;
            }
            if (token.getType() == Token.Type.DEPENDENCY_DECLARATOR) {
                object = Arrays.copyOfRange(tokenArray, n3, n4);
                arrayDeque.push(this.parseDependencyDeclarationStatement((Token[])object));
                n3 = n4 + 1;
                continue;
            }
            if (this.startsWithFunctionDeclarationTokens(tokenArray, n3)) {
                object = Arrays.copyOfRange(tokenArray, n3, n);
                arrayDeque.push(this.parseFunctionDeclarationStatement((Token[])object));
                n3 = n;
                continue;
            }
            if (token.getType() == Token.Type.DATA_TYPE || token.getType() == Token.Type.MODIFIER) {
                object = Arrays.copyOfRange(tokenArray, n3, n4);
                arrayDeque.push(this.parseVariableDeclarationStatement((Token[])object, true));
                n3 = n4 + 1;
                continue;
            }
            object = Arrays.copyOfRange(tokenArray, n3, n4);
            arrayDeque.push(this.parseExpression((Token[])object));
            n3 = n4 + 1;
        }
        String string = null;
        n = -1;
        if (tokenArray.length != 0) {
            string = tokenArray[0].getFileName();
            n = tokenArray[0].getLineNumber();
        }
        AstNode astNode = new AstNode(AstNode.Type.ROOT, n, string);
        while (arrayDeque.size() != 0) {
            astNode.addChildNode((AstNode)arrayDeque.pollLast());
        }
        astNode.updateDepths();
        return astNode;
    }

    private AstNode parseExpression(Token[] tokenArray) throws VnanoException {
        Cloneable cloneable;
        AstNode astNode;
        new LexicalChecker().checkTokensInExpression(tokenArray);
        tokenArray = this.preprocessCastSequentialTokens(tokenArray);
        int n = tokenArray.length;
        int n2 = 0;
        int n3 = tokenArray[0].getLineNumber();
        String string = tokenArray[0].getFileName();
        ArrayDeque<AstNode> arrayDeque = new ArrayDeque<AstNode>();
        int[] nArray = this.getNextOperatorPrecedence(tokenArray);
        block16: do {
            block24: {
                block25: {
                    String string2;
                    int n4;
                    int n5;
                    block23: {
                        astNode = null;
                        cloneable = tokenArray[n2];
                        n5 = ((Token)cloneable).getPrecedence();
                        n4 = nArray[n2];
                        string2 = ((Token)cloneable).getAttribute(AttributeKey.OPERATOR_ASSOCIATIVITY);
                        if (((Token)cloneable).getType() == Token.Type.LEAF) {
                            arrayDeque.push(this.createLeafNode((Token)cloneable));
                            ++n2;
                            continue;
                        }
                        if (((Token)cloneable).getType() != Token.Type.PARENTHESIS) break block23;
                        if (((Token)cloneable).getValue().equals("(")) {
                            this.pushLid(arrayDeque, "partialExpression");
                            ++n2;
                            continue;
                        }
                        astNode = this.popPartialExpressionNodes(arrayDeque, "partialExpression", string, n3)[0];
                        break block24;
                    }
                    if (((Token)cloneable).getType() != Token.Type.OPERATOR) break block25;
                    astNode = this.createOperatorNode((Token)cloneable);
                    switch (((Token)cloneable).getAttribute(AttributeKey.OPERATOR_SYNTAX)) {
                        case "postfix": {
                            astNode.addChildNode(this.popNode(arrayDeque, string, n3, AstNode.Type.LEAF, AstNode.Type.OPERATOR));
                            break;
                        }
                        case "prefix": {
                            if (this.shouldAddRightOperand(string2, n5, n4)) {
                                astNode.addChildNode(this.createLeafNode(tokenArray[n2 + 1]));
                                ++n2;
                                break;
                            }
                            break block24;
                        }
                        case "binary": {
                            astNode.addChildNode((AstNode)arrayDeque.pop());
                            if (this.shouldAddRightOperand(string2, n5, n4)) {
                                astNode.addChildNode(this.createLeafNode(tokenArray[n2 + 1]));
                                ++n2;
                                break;
                            }
                            break block24;
                        }
                        case "multiary": {
                            astNode.addChildNode(this.popNode(arrayDeque, string, n3, AstNode.Type.LEAF));
                            arrayDeque.push(astNode);
                            this.pushLid(arrayDeque, ((Token)cloneable).getAttribute(AttributeKey.OPERATOR_EXECUTOR));
                            ++n2;
                            continue block16;
                        }
                        case "multialySeparator": {
                            this.pushLid(arrayDeque);
                            ++n2;
                            continue block16;
                        }
                        case "multialyEnd": {
                            AstNode[] astNodeArray = this.popPartialExpressionNodes(arrayDeque, ((Token)cloneable).getAttribute(AttributeKey.OPERATOR_EXECUTOR), string, n3);
                            astNode = this.popNode(arrayDeque, string, n3, AstNode.Type.OPERATOR);
                            astNode.addChildNodes(astNodeArray);
                            break;
                        }
                        default: {
                            throw new VnanoFatalException("Unknown operator syntax");
                        }
                    }
                    break block24;
                }
                throw new VnanoFatalException("Unknown token type");
            }
            while (this.shouldAddRightOperandToStackedOperator(arrayDeque, nArray[n2])) {
                Object object = astNode;
                astNode = this.popNode(arrayDeque, string, n3, AstNode.Type.OPERATOR);
                astNode.addChildNode((AstNode)object);
            }
            arrayDeque.push(astNode);
            ++n2;
        } while (n2 < n);
        if (arrayDeque.size() != 1) {
            throw new VnanoException(ErrorType.INVALID_EXPRESSION_SYNTAX, string, n3);
        }
        astNode = this.popNode(arrayDeque, string, n3, AstNode.Type.LEAF, AstNode.Type.OPERATOR);
        cloneable = new AstNode(AstNode.Type.EXPRESSION, n3, string);
        ((AstNode)cloneable).addChildNode(astNode);
        return cloneable;
    }

    private boolean shouldAddRightOperand(String string, int n, int n2) {
        boolean bl = n < n2;
        boolean bl2 = n == n2;
        boolean bl3 = string.equals("left");
        return bl || bl2 && bl3;
    }

    private boolean shouldAddRightOperandToStackedOperator(Deque<AstNode> deque, int n) {
        if (deque.size() == 0) {
            return false;
        }
        if (deque.peek().getType() != AstNode.Type.OPERATOR) {
            return false;
        }
        int n2 = Integer.parseInt(deque.peek().getAttribute(AttributeKey.OPERATOR_PRECEDENCE));
        String string = deque.peek().getAttribute(AttributeKey.OPERATOR_ASSOCIATIVITY);
        return this.shouldAddRightOperand(string, n2, n);
    }

    private int[] getNextOperatorPrecedence(Token[] tokenArray) {
        int n = tokenArray.length;
        int[] nArray = new int[n];
        int n2 = 10000000;
        for (int i = n - 1; 0 <= i; --i) {
            nArray[i] = n2;
            if (tokenArray[i].getType() == Token.Type.OPERATOR) {
                n2 = tokenArray[i].getPrecedence();
            }
            if (tokenArray[i].getType() != Token.Type.PARENTHESIS) continue;
            n2 = tokenArray[i].getValue().equals("(") ? -1 : 10000000;
        }
        return nArray;
    }

    private AstNode parseVariableDeclarationStatement(Token[] tokenArray, boolean bl) throws VnanoException {
        int n;
        Cloneable cloneable22;
        AstNode astNode = new AstNode(AstNode.Type.VARIABLE, tokenArray[0].getLineNumber(), tokenArray[0].getFileName());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Token> arrayList2 = new ArrayList<Token>();
        for (Cloneable cloneable22 : tokenArray) {
            arrayList2.add((Token)cloneable22);
        }
        int n2 = 0;
        if (tokenArray[n2].getType() == Token.Type.MODIFIER) {
            if (ScriptWord.PREFIX_MODIFIER_SET.contains(tokenArray[n2].getValue())) {
                arrayList.add(tokenArray[n2].getValue());
                ++n2;
            } else {
                throw new VnanoException(ErrorType.POSTFIX_MODIFIER_BEFORE_TYPE_NAME, new String[]{tokenArray[n2].getValue()}, tokenArray[n2].getFileName(), tokenArray[n2].getLineNumber());
            }
        }
        if (n2 >= tokenArray.length) {
            throw new VnanoException(ErrorType.NO_DATA_TYPE_IN_VARIABLE_DECLARATION, tokenArray[n2 - 1].getFileName(), tokenArray[n2 - 1].getLineNumber());
        }
        Token token = tokenArray[n2];
        astNode.setAttribute(AttributeKey.DATA_TYPE, token.getValue());
        if (++n2 < tokenArray.length && tokenArray[n2].getType() == Token.Type.MODIFIER) {
            if (ScriptWord.POSTFIX_MODIFIER_SET.contains(tokenArray[n2].getValue())) {
                arrayList.add(tokenArray[n2].getValue());
                ++n2;
            } else {
                throw new VnanoException(ErrorType.PREFIX_MODIFIER_AFTER_TYPE_NAME, new String[]{tokenArray[n2].getValue()}, tokenArray[n2].getFileName(), tokenArray[n2].getLineNumber());
            }
        }
        token = null;
        if (tokenArray.length <= n2) {
            if (bl) {
                throw new VnanoException(ErrorType.NO_IDENTIFIER_IN_VARIABLE_DECLARATION, tokenArray[n2 - 1].getFileName(), tokenArray[n2 - 1].getLineNumber());
            }
        } else if (tokenArray[n2].getType() != Token.Type.LEAF || !tokenArray[n2].getAttribute(AttributeKey.LEAF_TYPE).equals("variableIdentifier")) {
            if (bl) {
                throw new VnanoException(ErrorType.INVALID_IDENTIFIER_TYPE, new String[]{tokenArray[n2].getValue()}, tokenArray[n2 - 1].getFileName(), tokenArray[n2 - 1].getLineNumber());
            }
        } else {
            token = tokenArray[n2];
            astNode.setAttribute(AttributeKey.IDENTIFIER_VALUE, token.getValue());
            ++n2;
        }
        int n3 = 0;
        cloneable22 = null;
        if (n2 < tokenArray.length - 1 && tokenArray[n2].getValue().equals("[")) {
            n = this.getLengthEndIndex(tokenArray, n2);
            Token[] tokenArray22 = Arrays.copyOfRange(tokenArray, n2, n + 1);
            n3 = this.parseVariableDeclarationArrayRank(tokenArray22);
            if (0 < n3) {
                cloneable22 = this.parseVariableDeclarationArrayLengths(tokenArray22);
            }
            n2 = n + 1;
        }
        astNode.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(n3));
        if (cloneable22 != null) {
            n3 = ((AstNode)cloneable22).getChildNodes(AstNode.Type.EXPRESSION).length;
            astNode.addChildNode((AstNode)cloneable22);
        }
        if (!bl && n2 < tokenArray.length) {
            throw new VnanoException(ErrorType.TOO_MANY_TOKENS_FOR_VARIABLE_DECLARATION, tokenArray[n2 - 1].getFileName(), tokenArray[n2 - 1].getLineNumber());
        }
        if (n2 < tokenArray.length - 1 && tokenArray[n2].getValue().equals("=")) {
            n = tokenArray.length - n2 + 1;
            Token[] tokenArray2 = new Token[n];
            tokenArray2[0] = token;
            for (int i = 1; i < n; ++i) {
                tokenArray2[i] = tokenArray[n2];
                ++n2;
            }
            astNode.addChildNode(this.parseExpression(tokenArray2));
        }
        if (n2 < tokenArray.length) {
            throw new VnanoException(ErrorType.TOO_MANY_TOKENS_FOR_VARIABLE_DECLARATION, tokenArray[n2 - 1].getFileName(), tokenArray[n2 - 1].getLineNumber());
        }
        for (String string : arrayList) {
            astNode.addModifier(string);
        }
        return astNode;
    }

    private int parseVariableDeclarationArrayRank(Token[] tokenArray) throws VnanoException {
        int n;
        int n2 = tokenArray.length;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            if (!tokenArray[n].getValue().equals("...")) continue;
            bl = true;
        }
        if (bl) {
            if (n2 == 3 && tokenArray[0].getValue().equals("[") && tokenArray[1].getValue().equals("...") && tokenArray[2].getValue().equals("]")) {
                return -1;
            }
            String string = "";
            for (int i = 0; i < n2; ++i) {
                string = string + tokenArray[i].getValue();
            }
            throw new VnanoException(ErrorType.INVALID_ARBITRARY_RANK_SYNTAX, string, tokenArray[0].getFileName(), tokenArray[0].getLineNumber());
        }
        n = 0;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string = tokenArray[i].getValue();
            if (string.equals("[")) {
                if (n3 == 0) {
                    ++n;
                }
                ++n3;
                continue;
            }
            if (string.equals("][")) {
                if (n3 != 1) continue;
                ++n;
                continue;
            }
            if (!string.equals("]")) continue;
            --n3;
        }
        return n;
    }

    private AstNode parseVariableDeclarationArrayLengths(Token[] tokenArray) throws VnanoException {
        AstNode astNode = new AstNode(AstNode.Type.LENGTHS, tokenArray[0].getLineNumber(), tokenArray[0].getFileName());
        int n = -1;
        int n2 = tokenArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string = tokenArray[i].getValue();
            if (string.equals("[")) {
                if (n3 == 0) {
                    n = i + 1;
                }
                ++n3;
                continue;
            }
            if (!string.equals("]") && !string.equals("][")) continue;
            if (n3 == 1) {
                Token[] tokenArray2 = Arrays.copyOfRange(tokenArray, n, i);
                if (tokenArray2.length == 0) {
                    AstNode astNode2 = new AstNode(AstNode.Type.EXPRESSION, tokenArray[i].getLineNumber(), tokenArray[i].getFileName());
                    AstNode astNode3 = this.createLeafNode("0", "literal", "int", tokenArray[i].getFileName(), tokenArray[i].getLineNumber());
                    astNode2.addChildNode(astNode3);
                    astNode.addChildNode(astNode2);
                } else {
                    astNode.addChildNode(this.parseExpression(tokenArray2));
                }
            }
            if (string.equals("]")) {
                --n3;
                continue;
            }
            n = i + 1;
        }
        return astNode;
    }

    private AstNode parseFunctionDeclarationStatement(Token[] tokenArray) throws VnanoException {
        Token[] tokenArray2;
        int n;
        int n2 = tokenArray.length;
        int n3 = tokenArray[0].getLineNumber();
        String string = tokenArray[0].getFileName();
        int n4 = 0;
        Token token = null;
        Token token2 = tokenArray[0];
        for (n = 1; n < n2; ++n) {
            if (tokenArray[n].getType() == Token.Type.LEAF && tokenArray[n].getAttribute(AttributeKey.LEAF_TYPE).equals("functionIdentifier")) {
                token = tokenArray[n];
                ++n;
                break;
            }
            String string2 = tokenArray[n].getAttribute(AttributeKey.OPERATOR_SYNTAX);
            if (!string2.equals("multiary") && !string2.equals("multialySeparator")) continue;
            ++n4;
        }
        int n5 = ++n;
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        while (n < n2) {
            if ((tokenArray[n].getValue().equals(",") || tokenArray[n].getValue().equals(")")) && 0 < (tokenArray2 = Arrays.copyOfRange(tokenArray, n5, n)).length) {
                boolean bl = false;
                AstNode astNode = this.parseVariableDeclarationStatement(tokenArray2, bl);
                arrayList.add(astNode);
                n5 = n + 1;
            }
            ++n;
        }
        tokenArray2 = new AstNode(AstNode.Type.FUNCTION, n3, string);
        tokenArray2.setAttribute(AttributeKey.IDENTIFIER_VALUE, token.getValue());
        tokenArray2.setAttribute(AttributeKey.DATA_TYPE, token2.getValue());
        tokenArray2.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(n4));
        for (AstNode astNode : arrayList) {
            tokenArray2.addChildNode(astNode);
        }
        return tokenArray2;
    }

    private boolean startsWithFunctionDeclarationTokens(Token[] tokenArray, int n) {
        int n2 = tokenArray.length;
        if (tokenArray[n].getType() != Token.Type.DATA_TYPE) {
            return false;
        }
        for (int i = n + 1; i < n2; ++i) {
            boolean bl;
            Token token = tokenArray[i];
            boolean bl2 = token.getType() == Token.Type.LEAF && token.getAttribute(AttributeKey.LEAF_TYPE).equals("functionIdentifier");
            boolean bl3 = bl = token.getType() == Token.Type.OPERATOR && token.getAttribute(AttributeKey.OPERATOR_EXECUTOR) == "subscript";
            if (bl2) {
                return true;
            }
            if (bl) continue;
            return false;
        }
        return false;
    }

    private AstNode parseControlStatement(Token[] tokenArray) throws VnanoException {
        new LexicalChecker().checkControlStatementTokens(tokenArray);
        Token token = tokenArray[0];
        int n = token.getLineNumber();
        String string = token.getFileName();
        if (token.getValue().equals("if")) {
            AstNode astNode = new AstNode(AstNode.Type.IF, n, string);
            astNode.addChildNode(this.parseExpression(Arrays.copyOfRange(tokenArray, 2, tokenArray.length - 1)));
            return astNode;
        }
        if (token.getValue().equals("else")) {
            AstNode astNode = new AstNode(AstNode.Type.ELSE, n, string);
            return astNode;
        }
        if (token.getValue().equals("while")) {
            AstNode astNode = new AstNode(AstNode.Type.WHILE, n, string);
            astNode.addChildNode(this.parseExpression(Arrays.copyOfRange(tokenArray, 2, tokenArray.length - 1)));
            return astNode;
        }
        if (token.getValue().equals("for")) {
            AstNode astNode = new AstNode(AstNode.Type.FOR, n, string);
            int n2 = Token.getIndexOf(tokenArray, ";", 0);
            int n3 = Token.getIndexOf(tokenArray, ";", n2 + 1);
            if (DataTypeName.isDataTypeName(tokenArray[2].getValue())) {
                astNode.addChildNode(this.parseVariableDeclarationStatement(Arrays.copyOfRange(tokenArray, 2, n2), true));
            } else if (n2 == 2) {
                astNode.addChildNode(new AstNode(AstNode.Type.EMPTY, tokenArray[0].getLineNumber(), tokenArray[0].getFileName()));
            } else {
                astNode.addChildNode(this.parseExpression(Arrays.copyOfRange(tokenArray, 2, n2)));
            }
            if (n2 + 1 == n3) {
                astNode.addChildNode(new AstNode(AstNode.Type.EMPTY, tokenArray[0].getLineNumber(), tokenArray[0].getFileName()));
            } else {
                astNode.addChildNode(this.parseExpression(Arrays.copyOfRange(tokenArray, n2 + 1, n3)));
            }
            if (n3 + 1 == tokenArray.length - 1) {
                astNode.addChildNode(new AstNode(AstNode.Type.EMPTY, tokenArray[0].getLineNumber(), tokenArray[0].getFileName()));
            } else {
                astNode.addChildNode(this.parseExpression(Arrays.copyOfRange(tokenArray, n3 + 1, tokenArray.length - 1)));
            }
            return astNode;
        }
        if (token.getValue().equals("return")) {
            AstNode astNode = new AstNode(AstNode.Type.RETURN, n, string);
            if (2 <= tokenArray.length) {
                astNode.addChildNode(this.parseExpression(Arrays.copyOfRange(tokenArray, 1, tokenArray.length)));
            }
            return astNode;
        }
        if (token.getValue().equals("break")) {
            AstNode astNode = new AstNode(AstNode.Type.BREAK, n, string);
            return astNode;
        }
        if (token.getValue().equals("continue")) {
            AstNode astNode = new AstNode(AstNode.Type.CONTINUE, n, string);
            return astNode;
        }
        throw new VnanoFatalException("Unknown controll statement: " + token.getValue());
    }

    private AstNode parseDependencyDeclarationStatement(Token[] tokenArray) throws VnanoException {
        Token token = tokenArray[0];
        int n = token.getLineNumber();
        String string = token.getFileName();
        if (tokenArray.length != 2) {
            throw new VnanoException(ErrorType.INVALID_DEPENDENCY_DECLARATION_SYNTAX, string, n);
        }
        AstNode astNode = null;
        if (token.getValue().equals("import")) {
            astNode = new AstNode(AstNode.Type.IMPORT, n, string);
        } else if (token.getValue().equals("include")) {
            astNode = new AstNode(AstNode.Type.INCLUDE, n, string);
        } else {
            throw new VnanoFatalException("Unknown dependency declarator: " + token.getValue());
        }
        astNode.addChildNode(this.createLeafNode(tokenArray[1]));
        return astNode;
    }

    private AstNode createOperatorNode(Token token) {
        AstNode astNode = new AstNode(AstNode.Type.OPERATOR, token.getLineNumber(), token.getFileName());
        astNode.setAttribute(AttributeKey.OPERATOR_ASSOCIATIVITY, token.getAttribute(AttributeKey.OPERATOR_ASSOCIATIVITY));
        astNode.setAttribute(AttributeKey.OPERATOR_SYNTAX, token.getAttribute(AttributeKey.OPERATOR_SYNTAX));
        astNode.setAttribute(AttributeKey.OPERATOR_EXECUTOR, token.getAttribute(AttributeKey.OPERATOR_EXECUTOR));
        astNode.setAttribute(AttributeKey.OPERATOR_SYMBOL, token.getValue());
        astNode.setAttribute(AttributeKey.OPERATOR_PRECEDENCE, Integer.toString(token.getPrecedence()));
        if (token.hasAttribute(AttributeKey.DATA_TYPE)) {
            astNode.setAttribute(AttributeKey.DATA_TYPE, token.getAttribute(AttributeKey.DATA_TYPE));
        }
        if (token.hasAttribute(AttributeKey.ARRAY_RANK)) {
            astNode.setAttribute(AttributeKey.ARRAY_RANK, token.getAttribute(AttributeKey.ARRAY_RANK));
        }
        return astNode;
    }

    private AstNode createLeafNode(Token token) {
        AstNode astNode = new AstNode(AstNode.Type.LEAF, token.getLineNumber(), token.getFileName());
        astNode.setAttribute(AttributeKey.LEAF_TYPE, token.getAttribute(AttributeKey.LEAF_TYPE));
        if (token.getAttribute(AttributeKey.LEAF_TYPE).equals("literal")) {
            astNode.setAttribute(AttributeKey.LITERAL_VALUE, token.getValue());
            astNode.setAttribute(AttributeKey.DATA_TYPE, token.getAttribute(AttributeKey.DATA_TYPE));
        } else {
            astNode.setAttribute(AttributeKey.IDENTIFIER_VALUE, token.getValue());
        }
        return astNode;
    }

    private AstNode createLeafNode(String string, String string2, String string3, String string4, int n) {
        Token token = new Token(string, n, string4);
        token.setType(Token.Type.LEAF);
        token.setAttribute(AttributeKey.LEAF_TYPE, string2);
        token.setAttribute(AttributeKey.DATA_TYPE, string3);
        return this.createLeafNode(token);
    }

    private void pushLid(Deque<AstNode> deque) {
        AstNode astNode = new AstNode(AstNode.Type.STACK_LID, 0, "");
        astNode.setAttribute(AttributeKey.OPERATOR_PRECEDENCE, Integer.toString(10000000));
        deque.push(astNode);
    }

    private void pushLid(Deque<AstNode> deque, String string) {
        AstNode astNode = new AstNode(AstNode.Type.STACK_LID, 0, "");
        astNode.setAttribute(AttributeKey.OPERATOR_PRECEDENCE, Integer.toString(10000000));
        astNode.setAttribute(AttributeKey.LID_MARKER, string);
        deque.push(astNode);
    }

    private AstNode popNode(Deque<AstNode> deque, String string, int n, AstNode.Type ... typeArray) throws VnanoException {
        if (deque.size() == 0) {
            throw new VnanoException(ErrorType.INVALID_EXPRESSION_SYNTAX, string, n);
        }
        if (typeArray.length != 0) {
            boolean bl = false;
            AstNode.Type type = deque.peek().getType();
            for (AstNode.Type type2 : typeArray) {
                if (type != type2) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new VnanoException(ErrorType.INVALID_EXPRESSION_SYNTAX, string, n);
            }
        }
        return deque.pop();
    }

    private AstNode[] popStatementNodes(Deque<AstNode> deque) {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        while (deque.size() != 0) {
            if (deque.peek().getType() == AstNode.Type.STACK_LID) {
                deque.pop();
                break;
            }
            AstNode astNode = deque.pop();
            arrayList.add(astNode);
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new AstNode[0]);
    }

    private AstNode[] popPartialExpressionNodes(Deque<AstNode> deque, String string, String string2, int n) throws VnanoException {
        if (deque.size() == 0) {
            throw new VnanoException(ErrorType.INVALID_EXPRESSION_SYNTAX, string2, n);
        }
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        while (deque.size() != 0) {
            AstNode astNode;
            if (deque.peek().getType() != AstNode.Type.STACK_LID) {
                arrayList.add(deque.pop());
            }
            if (deque.size() == 0) {
                throw new VnanoException(ErrorType.INVALID_EXPRESSION_SYNTAX, string2, n);
            }
            if (deque.peek().getType() != AstNode.Type.STACK_LID || !(astNode = deque.pop()).hasAttribute(AttributeKey.LID_MARKER) || !astNode.getAttribute(AttributeKey.LID_MARKER).equals(string)) continue;
            break;
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new AstNode[0]);
    }

    private Token[] preprocessCastSequentialTokens(Token[] tokenArray) throws VnanoException {
        Token[] tokenArray2;
        int n = tokenArray.length;
        int n2 = 0;
        ArrayList<Token[]> arrayList = new ArrayList<Token[]>();
        while (n2 < n) {
            boolean bl;
            tokenArray2 = tokenArray[n2];
            boolean bl2 = bl = n2 < n - 2 && tokenArray2.getType() == Token.Type.OPERATOR && tokenArray2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("cast");
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(tokenArray[n2].getValue());
                String string = tokenArray[n2 + 1].getValue();
                tokenArray2.setAttribute(AttributeKey.DATA_TYPE, string);
                stringBuilder.append(tokenArray[n2 + 1].getValue());
                int n3 = this.getLengthEndIndex(tokenArray, ++n2 + 1);
                if (n3 == -1) {
                    tokenArray2.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(0));
                } else {
                    Token[] tokenArray3 = Arrays.copyOfRange(tokenArray, n2 + 1, n3 + 1);
                    int n4 = this.parseVariableDeclarationArrayRank(tokenArray3);
                    tokenArray2.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(n4));
                    for (Token token : tokenArray3) {
                        stringBuilder.append(token.getValue());
                    }
                    n2 = n3;
                }
                stringBuilder.append(")");
                tokenArray2.setValue(stringBuilder.toString());
                n2 += 2;
                arrayList.add(tokenArray2);
                continue;
            }
            arrayList.add(tokenArray2);
            ++n2;
        }
        tokenArray2 = arrayList.toArray(new Token[0]);
        return tokenArray2;
    }

    private int getLengthEndIndex(Token[] tokenArray, int n) {
        int n2 = tokenArray.length;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            String string = tokenArray[i].getValue();
            if (n3 == 0 && string.equals("=")) {
                return -1;
            }
            if (n3 == 0 && string.equals(")")) {
                return -1;
            }
            if (string.equals("[")) {
                ++n3;
                continue;
            }
            if (!string.equals("]") || --n3 != 0) continue;
            return i;
        }
        return -1;
    }
}

