/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.util.Locale;
import java.util.Map;
import org.vcssl.connect.ConnectorException;
import org.vcssl.connect.EngineConnectorInterface1;
import org.vcssl.connect.PermissionAuthorizerConnectorInterface1;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.spec.ErrorMessage;
import org.vcssl.nano.spec.ErrorType;

public final class EngineConnector
implements EngineConnectorInterface1 {
    private final Map<String, Object> optionMap;
    private final Map<String, String> permissionMap;
    private final PermissionAuthorizerConnectorInterface1 permissionAuthorizer;

    public EngineConnector() {
        this.optionMap = null;
        this.permissionMap = null;
        this.permissionAuthorizer = null;
    }

    private EngineConnector(Map<String, Object> map, Map<String, String> map2, PermissionAuthorizerConnectorInterface1 permissionAuthorizerConnectorInterface1) {
        this.optionMap = map;
        this.permissionMap = map2;
        this.permissionAuthorizer = permissionAuthorizerConnectorInterface1;
    }

    public final EngineConnector createOptionMapUpdatedInstance(Map<String, Object> map) {
        return new EngineConnector(map, this.permissionMap, this.permissionAuthorizer);
    }

    public final EngineConnector createPermissionMapUpdatedInstance(Map<String, String> map) throws VnanoException {
        EngineConnector engineConnector = new EngineConnector(this.optionMap, map, this.permissionAuthorizer);
        engineConnector.reflectPermissionSettings();
        return engineConnector;
    }

    public final EngineConnector createPermissionAuthorizerUpdatedInstance(PermissionAuthorizerConnectorInterface1 permissionAuthorizerConnectorInterface1) throws VnanoException {
        EngineConnector engineConnector = new EngineConnector(this.optionMap, this.permissionMap, permissionAuthorizerConnectorInterface1);
        engineConnector.reflectPermissionSettings();
        return engineConnector;
    }

    private final void reflectPermissionSettings() throws VnanoException {
        if (this.permissionAuthorizer != null) {
            try {
                this.permissionAuthorizer.setPermissionMap(this.permissionMap, true);
            }
            catch (ConnectorException connectorException) {
                throw new VnanoException(ErrorType.PERMISSION_AUTHORIZER_PLUGIN_CRASHED, new String[]{this.permissionAuthorizer.getClass().getCanonicalName(), connectorException.getMessage()}, (Throwable)connectorException);
            }
        }
    }

    @Override
    public final boolean hasOptionValue(String string) {
        return this.optionMap.containsKey(string);
    }

    @Override
    public final Object getOptionValue(String string) {
        return this.optionMap.get(string);
    }

    @Override
    public final void requestPermission(String string, Object object, Object object2) throws ConnectorException {
        if (this.permissionAuthorizer == null) {
            String string2 = ErrorMessage.generateErrorMessage(ErrorType.NO_PERMISSION_AUTHORIZER_IS_CONNECTED, (Locale)this.optionMap.get("LOCALE"));
            throw new ConnectorException(string2);
        }
        this.permissionAuthorizer.requestPermission(string, object, object2);
    }

    @Override
    public boolean isOtherEngineConnectorAvailable(Class<?> clazz) {
        return clazz == this.getClass() || clazz == EngineConnectorInterface1.class;
    }

    @Override
    public <T> T getOtherEngineConnector(Class<T> clazz) {
        if (this.isOtherEngineConnectorAvailable(clazz)) {
            return clazz.cast(this);
        }
        return null;
    }
}

