/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.interconnect.AbstractFunction;
import org.vcssl.nano.interconnect.IdentifierMapManager;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.IdentifierSyntax;

public class FunctionTable {
    List<AbstractFunction> functionList = new ArrayList<AbstractFunction>();
    Map<String, LinkedList<AbstractFunction>> signatureFunctionMap = new LinkedHashMap<String, LinkedList<AbstractFunction>>();
    Map<String, LinkedList<AbstractFunction>> nameFunctionMap = new LinkedHashMap<String, LinkedList<AbstractFunction>>();
    Map<String, LinkedList<AbstractFunction>> fullSignatureFunctionMap = new LinkedHashMap<String, LinkedList<AbstractFunction>>();
    Map<String, LinkedList<AbstractFunction>> fullNameFunctionMap = new LinkedHashMap<String, LinkedList<AbstractFunction>>();
    Map<Integer, AbstractFunction> indexFunctionMap = new LinkedHashMap<Integer, AbstractFunction>();
    Map<String, LinkedList<Integer>> signatureIndexMap = new LinkedHashMap<String, LinkedList<Integer>>();
    Map<String, LinkedList<Integer>> fullSignatureIndexMap = new LinkedHashMap<String, LinkedList<Integer>>();
    int size = 0;

    public void addFunction(AbstractFunction abstractFunction) {
        int n = this.size++;
        String string = abstractFunction.hasNamespaceName() ? abstractFunction.getNamespaceName() + "." : "";
        String string2 = abstractFunction.getFunctionName();
        String string3 = string + string2;
        String string4 = IdentifierSyntax.getSignatureOf(abstractFunction);
        String string5 = IdentifierSyntax.getSignatureOf(abstractFunction, string);
        this.functionList.add(abstractFunction);
        IdentifierMapManager.putToMap(this.signatureFunctionMap, string4, abstractFunction);
        IdentifierMapManager.putToMap(this.nameFunctionMap, string2, abstractFunction);
        IdentifierMapManager.putToMap(this.fullSignatureFunctionMap, string5, abstractFunction);
        IdentifierMapManager.putToMap(this.fullNameFunctionMap, string3, abstractFunction);
        this.indexFunctionMap.put(n, abstractFunction);
        IdentifierMapManager.putToMap(this.signatureIndexMap, string4, n);
        IdentifierMapManager.putToMap(this.fullSignatureIndexMap, string5, n);
    }

    public AbstractFunction[] getFunctions() {
        return this.functionList.toArray(new AbstractFunction[0]);
    }

    public AbstractFunction getFunctionByIndex(int n) {
        return this.functionList.get(n);
    }

    public int getIndexOf(AbstractFunction abstractFunction) {
        String string = abstractFunction.hasNamespaceName() ? abstractFunction.getNamespaceName() + "." : "";
        String string2 = IdentifierSyntax.getSignatureOf(abstractFunction);
        String string3 = IdentifierSyntax.getSignatureOf(abstractFunction, string);
        if (this.signatureIndexMap.containsKey(string2)) {
            return IdentifierMapManager.getLastFromMap(this.signatureIndexMap, string2);
        }
        if (this.fullSignatureIndexMap.containsKey(string3)) {
            return IdentifierMapManager.getLastFromMap(this.fullSignatureIndexMap, string3);
        }
        throw new VnanoFatalException("Function index not found: " + string3);
    }

    public AbstractFunction getFunctionBySignature(String string, DataType[] dataTypeArray, int[] nArray, boolean[] blArray, boolean[] blArray2, boolean bl, boolean bl2) {
        String[] stringArray = DataTypeName.getDataTypeNamesOf(dataTypeArray);
        String string2 = IdentifierSyntax.getSignatureOf(string, stringArray, nArray, blArray, blArray2, bl, bl2);
        return this.getFunctionBySignature(string2);
    }

    public AbstractFunction getFunctionBySignature(String string) {
        if (this.signatureFunctionMap.containsKey(string)) {
            return IdentifierMapManager.getLastFromMap(this.signatureFunctionMap, string);
        }
        if (this.fullSignatureFunctionMap.containsKey(string)) {
            return IdentifierMapManager.getLastFromMap(this.fullSignatureFunctionMap, string);
        }
        throw new VnanoFatalException("Function not found: " + string);
    }

    public boolean hasFunctionWithSignature(String string) {
        return this.signatureFunctionMap.containsKey(string) || this.fullSignatureFunctionMap.containsKey(string);
    }

    public boolean hasCalleeFunctionOf(AstNode astNode) {
        return this.getCalleeFunctionOf(astNode) != null;
    }

    public AbstractFunction getCalleeFunctionOf(AstNode astNode) {
        int n;
        String string = IdentifierSyntax.getSignatureOfCalleeFunctionOf(astNode);
        if (this.hasFunctionWithSignature(string)) {
            return this.getFunctionBySignature(string);
        }
        String string2 = astNode.getChildNodes()[0].getAttribute(AttributeKey.IDENTIFIER_VALUE);
        List<AbstractFunction> list = null;
        if (this.nameFunctionMap.containsKey(string2)) {
            list = IdentifierMapManager.getAllFromMap(this.nameFunctionMap, string2);
        } else if (this.fullNameFunctionMap.containsKey(string2)) {
            list = IdentifierMapManager.getAllFromMap(this.fullNameFunctionMap, string2);
        }
        if (list == null) {
            return null;
        }
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n2 = astNodeArray.length - 1;
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = astNodeArray[n + 1].getArrayRank();
            stringArray[n] = astNodeArray[n + 1].getDataTypeName();
        }
        n = list.size();
        for (int i = n - 1; 0 <= i; --i) {
            int n3;
            AbstractFunction abstractFunction = list.get(i);
            int[] nArray2 = abstractFunction.getParameterArrayRanks();
            Object[] objectArray = abstractFunction.getParameterDataTypeNames();
            boolean[] blArray = abstractFunction.getParameterDataTypeArbitrarinesses();
            boolean[] blArray2 = abstractFunction.getParameterArrayRankArbitrarinesses();
            int n4 = nArray2.length;
            if (abstractFunction.isParameterCountArbitrary()) {
                n3 = n4;
                n4 = n2;
                nArray2 = Arrays.copyOf(nArray2, n4);
                objectArray = Arrays.copyOf(objectArray, n4);
                blArray = Arrays.copyOf(blArray, n4);
                blArray2 = Arrays.copyOf(blArray2, n4);
                if (n3 - 1 < n4) {
                    Arrays.fill(nArray2, n3 - 1, n4, nArray2[n3 - 1]);
                    Arrays.fill(objectArray, n3 - 1, n4, objectArray[n3 - 1]);
                    Arrays.fill(blArray, n3 - 1, n4, blArray[n3 - 1]);
                    Arrays.fill(blArray2, n3 - 1, n4, blArray2[n3 - 1]);
                }
            }
            if (n4 != n2) continue;
            n3 = 1;
            for (int j = 0; j < n4; ++j) {
                boolean bl;
                String string3 = objectArray[j];
                String string4 = stringArray[j];
                int n5 = nArray2[j];
                int n6 = nArray[j];
                boolean bl2 = blArray[j];
                boolean bl3 = blArray2[j];
                boolean bl4 = string3.equals(string4);
                boolean bl5 = bl = n5 == n6;
                if (bl4 && bl || bl2 && bl3 || bl2 && !bl3 && bl || bl3 && !bl2 && bl4) continue;
                n3 = 0;
                break;
            }
            if (n3 == 0) continue;
            return abstractFunction;
        }
        return null;
    }

    public String[] presumeCalleeFunctionSignaturesOf(AstNode astNode) {
        String string = astNode.getChildNodes()[0].getAttribute(AttributeKey.IDENTIFIER_VALUE);
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedList<AbstractFunction> linkedList = this.nameFunctionMap.get(string);
        if (linkedList == null) {
            return new String[0];
        }
        for (AbstractFunction abstractFunction : linkedList) {
            String string2 = IdentifierSyntax.getSignatureOf(abstractFunction);
            arrayList.add(string2);
        }
        String[] stringArray = new String[linkedList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }
}

