/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vcssl.connect.ClassToXnci1Adapter;
import org.vcssl.connect.ConnectorException;
import org.vcssl.connect.ExternalFunctionConnectorInterface1;
import org.vcssl.connect.ExternalNamespaceConnectorInterface1;
import org.vcssl.connect.ExternalVariableConnectorInterface1;
import org.vcssl.connect.FieldToXvci1Adapter;
import org.vcssl.connect.MethodToXfci1Adapter;
import org.vcssl.connect.PermissionAuthorizerConnectorInterface1;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.AbstractFunction;
import org.vcssl.nano.interconnect.AbstractVariable;
import org.vcssl.nano.interconnect.EngineConnector;
import org.vcssl.nano.interconnect.FunctionTable;
import org.vcssl.nano.interconnect.VariableTable;
import org.vcssl.nano.interconnect.Xfci1ToFunctionAdapter;
import org.vcssl.nano.interconnect.Xvci1ToVariableAdapter;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.IdentifierSyntax;
import org.vcssl.nano.spec.OptionValue;
import org.vcssl.nano.vm.VirtualMachineObjectCode;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;

public class Interconnect {
    private FunctionTable externalFunctionTable = null;
    private VariableTable externalVariableTable = null;
    private EngineConnector engineConnector = new EngineConnector();
    private PermissionAuthorizerConnectorInterface1 permissionAuthorizer = null;
    private List<ExternalNamespaceConnectorInterface1> xnci1PluginList = null;
    private List<ExternalFunctionConnectorInterface1> xfci1PluginList = null;
    private List<ExternalVariableConnectorInterface1> xvci1PluginList = null;
    private Map<String, Object> optionMap = null;
    private Map<String, String> permissionMap = null;
    private Map<String, String> libraryFilePathContentMap = null;
    private String mainScriptName = null;
    private String mainScriptContent = null;
    private Set<String> libraryImportPathSet;
    private Set<String> pluginImportPathSet;

    public Interconnect() {
        this.externalFunctionTable = new FunctionTable();
        this.externalVariableTable = new VariableTable();
        this.xnci1PluginList = new ArrayList<ExternalNamespaceConnectorInterface1>();
        this.xfci1PluginList = new ArrayList<ExternalFunctionConnectorInterface1>();
        this.xvci1PluginList = new ArrayList<ExternalVariableConnectorInterface1>();
        this.libraryFilePathContentMap = new LinkedHashMap<String, String>();
        this.libraryImportPathSet = new HashSet<String>();
        this.pluginImportPathSet = new HashSet<String>();
        this.optionMap = new LinkedHashMap<String, Object>();
        this.optionMap = OptionValue.normalizeValuesOf(this.optionMap);
        this.engineConnector = this.engineConnector.createOptionMapUpdatedInstance(this.optionMap);
        this.permissionMap = new LinkedHashMap<String, String>();
        this.permissionMap.put("DEFAULT", "DENY");
        try {
            this.engineConnector = this.engineConnector.createPermissionMapUpdatedInstance(this.permissionMap);
        }
        catch (VnanoException vnanoException) {
            throw new VnanoFatalException("Unexpected exception occurred", vnanoException);
        }
    }

    public void activate() throws VnanoException {
        this.initializeAllPluginsForExecution();
    }

    public void deactivate() throws VnanoException {
        this.finalizeAllPluginsForTermination();
    }

    public void setOptionMap(Map<String, Object> map) throws VnanoException {
        this.optionMap = OptionValue.normalizeValuesOf(map);
        OptionValue.checkContentsOf(this.optionMap);
        this.engineConnector = this.engineConnector.createOptionMapUpdatedInstance(this.optionMap);
    }

    public Map<String, Object> getOptionMap() {
        return this.optionMap;
    }

    public void setPermissionMap(Map<String, String> map) throws VnanoException {
        this.permissionMap = map;
        this.engineConnector = this.engineConnector.createPermissionMapUpdatedInstance(map);
    }

    public Map<String, String> getPermissionMap() {
        return this.permissionMap;
    }

    public FunctionTable getExternalFunctionTable() {
        return this.externalFunctionTable;
    }

    public VariableTable getExternalVariableTable() {
        return this.externalVariableTable;
    }

    public void callExternalFunction(int n, DataContainer<?> dataContainer, DataContainer<?>[] dataContainerArray) throws VnanoException {
        this.externalFunctionTable.getFunctionByIndex(n).invoke(dataContainer, dataContainerArray);
    }

    public void writebackExternalVariables(Memory memory, VirtualMachineObjectCode virtualMachineObjectCode) throws VnanoException {
        int n;
        int n2 = virtualMachineObjectCode.getMaximumGlobalAddress();
        for (int i = n = virtualMachineObjectCode.getMinimumGlobalAddress(); i <= n2; ++i) {
            if (!virtualMachineObjectCode.hasGlobalVariableRegisteredAt(i)) continue;
            DataContainer<?> dataContainer = memory.getDataContainer(Memory.Partition.GLOBAL, i);
            String string = virtualMachineObjectCode.getGlobalVariableUniqueIdentifier(i);
            AbstractVariable abstractVariable = this.externalVariableTable.getVariableByAssemblyIdentifier(string);
            if (abstractVariable.isConstant()) continue;
            abstractVariable.setDataContainer(dataContainer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectPlugin(String string, Object object) throws VnanoException {
        String string2 = string;
        try {
            if (string.equals("___VNANO_AUTO_KEY")) {
                string2 = string = this.generateBindingNameOf(object);
            }
            string = string.split("\\s|\\(")[0];
            if (object instanceof PermissionAuthorizerConnectorInterface1) {
                string2 = object.getClass().getName();
                this.connectPaci1Plugin((PermissionAuthorizerConnectorInterface1)object);
                return;
            } else if (object instanceof ExternalVariableConnectorInterface1) {
                string2 = object.getClass().getName();
                this.connectXvci1Plugin((ExternalVariableConnectorInterface1)object, true, string, false, null);
                return;
            } else if (object instanceof ExternalFunctionConnectorInterface1) {
                string2 = object.getClass().getName();
                this.connectXfci1Plugin((ExternalFunctionConnectorInterface1)object, true, string, false, null);
                return;
            } else if (object instanceof ExternalNamespaceConnectorInterface1) {
                string2 = object.getClass().getName();
                this.connectXnci1Plugin((ExternalNamespaceConnectorInterface1)object, true, string, false);
                return;
            } else if (object instanceof Field) {
                this.connectFieldAsPlugin((Field)object, null, true, string);
                return;
            } else if (object instanceof Method) {
                this.connectMethodAsPlugin((Method)object, null, true, string);
                return;
            } else if (object instanceof Class) {
                this.connectClassAsPlugin((Class)object, null, true, string);
                return;
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (objectArray.length == 2 && objectArray[0] instanceof Field) {
                    Field field = (Field)objectArray[0];
                    Object object2 = objectArray[1];
                    this.connectFieldAsPlugin(field, object2, true, string);
                    return;
                } else if (objectArray.length == 2 && objectArray[0] instanceof Method) {
                    Method method = (Method)objectArray[0];
                    Object object3 = objectArray[1];
                    this.connectMethodAsPlugin(method, object3, true, string);
                    return;
                } else {
                    if (objectArray.length != 2 || !(objectArray[0] instanceof Class)) throw new VnanoException(ErrorType.UNSUPPORTED_PLUGIN, new String[]{objectArray[0].getClass().getCanonicalName()});
                    Class clazz = (Class)objectArray[0];
                    Object object4 = objectArray[1];
                    this.connectClassAsPlugin(clazz, object4, true, string);
                }
                return;
            } else {
                Class<?> clazz = object.getClass();
                this.connectClassAsPlugin(clazz, object, true, string);
            }
            return;
        }
        catch (VnanoException vnanoException) {
            throw new VnanoException(ErrorType.PLUGIN_CONNECTION_FAILED, string2, (Throwable)vnanoException);
        }
    }

    public void disconnectAllPlugins() throws VnanoException {
        this.finalizeAllPluginsForDisconnection();
        this.externalFunctionTable = new FunctionTable();
        this.externalVariableTable = new VariableTable();
        this.xnci1PluginList = new ArrayList<ExternalNamespaceConnectorInterface1>();
        this.xfci1PluginList = new ArrayList<ExternalFunctionConnectorInterface1>();
        this.xvci1PluginList = new ArrayList<ExternalVariableConnectorInterface1>();
        this.pluginImportPathSet = new HashSet<String>();
        this.permissionAuthorizer = null;
    }

    private String generateBindingNameOf(Object object) throws VnanoException {
        if (object instanceof AbstractVariable) {
            return ((AbstractVariable)object).getVariableName();
        }
        if (object instanceof AbstractFunction) {
            return IdentifierSyntax.getSignatureOf((AbstractFunction)object);
        }
        if (object instanceof ExternalVariableConnectorInterface1) {
            return ((ExternalVariableConnectorInterface1)object).getVariableName();
        }
        if (object instanceof ExternalFunctionConnectorInterface1) {
            Xfci1ToFunctionAdapter xfci1ToFunctionAdapter = new Xfci1ToFunctionAdapter((ExternalFunctionConnectorInterface1)object);
            return IdentifierSyntax.getSignatureOf(xfci1ToFunctionAdapter);
        }
        if (object instanceof ExternalNamespaceConnectorInterface1) {
            return ((ExternalNamespaceConnectorInterface1)object).getNamespaceName();
        }
        if (object instanceof Field) {
            return ((Field)object).getName();
        }
        if (object instanceof Method) {
            MethodToXfci1Adapter methodToXfci1Adapter = new MethodToXfci1Adapter((Method)object);
            Xfci1ToFunctionAdapter xfci1ToFunctionAdapter = new Xfci1ToFunctionAdapter(methodToXfci1Adapter);
            return IdentifierSyntax.getSignatureOf(xfci1ToFunctionAdapter);
        }
        if (object instanceof Class) {
            return ((Class)object).getCanonicalName();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 2 && objectArray[0] instanceof Field) {
                Field field = (Field)objectArray[0];
                return this.generateBindingNameOf(field);
            }
            if (objectArray.length == 2 && objectArray[0] instanceof Method) {
                Method method = (Method)objectArray[0];
                return this.generateBindingNameOf(method);
            }
            if (objectArray.length == 2 && objectArray[0] instanceof Class) {
                Class clazz = (Class)objectArray[0];
                return this.generateBindingNameOf(clazz);
            }
            throw new VnanoException(ErrorType.UNSUPPORTED_PLUGIN, new String[]{objectArray[0].getClass().getCanonicalName()});
        }
        Class<?> clazz = object.getClass();
        return this.generateBindingNameOf(clazz);
    }

    private void connectFieldAsPlugin(Field field, Object object, boolean bl, String string) throws VnanoException {
        FieldToXvci1Adapter fieldToXvci1Adapter = new FieldToXvci1Adapter(field, object);
        this.connectXvci1Plugin(fieldToXvci1Adapter, bl, string, false, null);
    }

    private void connectMethodAsPlugin(Method method, Object object, boolean bl, String string) throws VnanoException {
        MethodToXfci1Adapter methodToXfci1Adapter = new MethodToXfci1Adapter(method, object);
        this.connectXfci1Plugin(methodToXfci1Adapter, bl, string, false, null);
    }

    private void connectClassAsPlugin(Class<?> clazz, Object object, boolean bl, String string) throws VnanoException {
        ClassToXnci1Adapter classToXnci1Adapter = new ClassToXnci1Adapter(clazz, object);
        this.connectXnci1Plugin(classToXnci1Adapter, bl, string, true);
    }

    private void connectPaci1Plugin(PermissionAuthorizerConnectorInterface1 permissionAuthorizerConnectorInterface1) throws VnanoException {
        if (this.permissionAuthorizer != null) {
            throw new VnanoException(ErrorType.MULTIPLE_PERMISSION_AUTHORIZERS_ARE_CONNECTED, new String[]{permissionAuthorizerConnectorInterface1.getClass().getCanonicalName(), this.permissionAuthorizer.getClass().getCanonicalName()});
        }
        try {
            permissionAuthorizerConnectorInterface1.initializeForConnection(this.engineConnector);
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.PLUGIN_INITIALIZATION_FAILED, permissionAuthorizerConnectorInterface1.getClass().getCanonicalName(), (Throwable)connectorException);
        }
        this.permissionAuthorizer = permissionAuthorizerConnectorInterface1;
        this.engineConnector = this.engineConnector.createPermissionAuthorizerUpdatedInstance(this.permissionAuthorizer);
    }

    private void connectXvci1Plugin(ExternalVariableConnectorInterface1 externalVariableConnectorInterface1, boolean bl, String string, boolean bl2, String string2) throws VnanoException {
        try {
            externalVariableConnectorInterface1.initializeForConnection(this.engineConnector);
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.PLUGIN_INITIALIZATION_FAILED, externalVariableConnectorInterface1.getClass().getCanonicalName(), (Throwable)connectorException);
        }
        this.xvci1PluginList.add(externalVariableConnectorInterface1);
        Xvci1ToVariableAdapter xvci1ToVariableAdapter = new Xvci1ToVariableAdapter(externalVariableConnectorInterface1);
        if (bl2) {
            ((AbstractVariable)xvci1ToVariableAdapter).setNamespaceName(string2);
        }
        if (bl) {
            ((AbstractVariable)xvci1ToVariableAdapter).setVariableName(string);
        }
        this.connectVariable(xvci1ToVariableAdapter);
    }

    private void connectXfci1Plugin(ExternalFunctionConnectorInterface1 externalFunctionConnectorInterface1, boolean bl, String string, boolean bl2, String string2) throws VnanoException {
        try {
            externalFunctionConnectorInterface1.initializeForConnection(this.engineConnector);
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.PLUGIN_INITIALIZATION_FAILED, externalFunctionConnectorInterface1.getClass().getCanonicalName(), (Throwable)connectorException);
        }
        this.xfci1PluginList.add(externalFunctionConnectorInterface1);
        Xfci1ToFunctionAdapter xfci1ToFunctionAdapter = new Xfci1ToFunctionAdapter(externalFunctionConnectorInterface1);
        if (bl2) {
            ((AbstractFunction)xfci1ToFunctionAdapter).setNamespaceName(string2);
        }
        if (bl) {
            ((AbstractFunction)xfci1ToFunctionAdapter).setFunctionName(string);
        }
        this.connectFunction(xfci1ToFunctionAdapter);
    }

    private void connectXnci1Plugin(ExternalNamespaceConnectorInterface1 externalNamespaceConnectorInterface1, boolean bl, String string, boolean bl2) throws VnanoException {
        try {
            externalNamespaceConnectorInterface1.preInitializeForConnection(this.engineConnector);
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.PLUGIN_INITIALIZATION_FAILED, externalNamespaceConnectorInterface1.getClass().getCanonicalName(), (Throwable)connectorException);
        }
        String string2 = externalNamespaceConnectorInterface1.getNamespaceName();
        if (bl) {
            string2 = string;
        }
        this.pluginImportPathSet.add(string2);
        ExternalFunctionConnectorInterface1[] externalFunctionConnectorInterface1Array = externalNamespaceConnectorInterface1.getFunctions();
        Object[] objectArray = externalFunctionConnectorInterface1Array;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            ExternalFunctionConnectorInterface1 externalFunctionConnectorInterface1 = objectArray[i];
            try {
                this.connectXfci1Plugin(externalFunctionConnectorInterface1, false, null, true, string2);
                continue;
            }
            catch (VnanoException vnanoException) {
                if (bl2) continue;
                throw vnanoException;
            }
        }
        for (Object object : objectArray = externalNamespaceConnectorInterface1.getVariables()) {
            try {
                this.connectXvci1Plugin((ExternalVariableConnectorInterface1)object, false, null, true, string2);
            }
            catch (VnanoException vnanoException) {
                if (bl2) continue;
                throw vnanoException;
            }
        }
        try {
            externalNamespaceConnectorInterface1.postInitializeForConnection(this.engineConnector);
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.PLUGIN_INITIALIZATION_FAILED, externalNamespaceConnectorInterface1.getClass().getCanonicalName(), (Throwable)connectorException);
        }
        this.xnci1PluginList.add(externalNamespaceConnectorInterface1);
    }

    private void connectVariable(AbstractVariable abstractVariable) {
        this.externalVariableTable.addVariable(abstractVariable);
    }

    private void connectFunction(AbstractFunction abstractFunction) {
        this.externalFunctionTable.addFunction(abstractFunction);
    }

    private void initializeAllPluginsForExecution() throws VnanoException {
        Object object = null;
        try {
            Object object2;
            if (this.permissionAuthorizer != null) {
                this.permissionAuthorizer.initializeForExecution(this.engineConnector);
            }
            Iterator<Object> iterator = this.xnci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = iterator.next();
                object2.preInitializeForExecution(this.engineConnector);
            }
            iterator = this.xfci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalFunctionConnectorInterface1)iterator.next();
                object2.initializeForExecution(this.engineConnector);
            }
            iterator = this.xvci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalVariableConnectorInterface1)iterator.next();
                object2.initializeForExecution(this.engineConnector);
            }
            iterator = this.xnci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalNamespaceConnectorInterface1)iterator.next();
                object2.postInitializeForExecution(this.engineConnector);
            }
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.PLUGIN_INITIALIZATION_FAILED, object.getClass().getCanonicalName(), (Throwable)connectorException);
        }
    }

    private void finalizeAllPluginsForTermination() throws VnanoException {
        Object object = null;
        try {
            Object object2;
            Iterator<Object> iterator = this.xnci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = iterator.next();
                object2.preFinalizeForTermination(this.engineConnector);
            }
            iterator = this.xfci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalFunctionConnectorInterface1)iterator.next();
                object2.finalizeForTermination(this.engineConnector);
            }
            iterator = this.xvci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalVariableConnectorInterface1)iterator.next();
                object2.finalizeForTermination(this.engineConnector);
            }
            iterator = this.xnci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalNamespaceConnectorInterface1)iterator.next();
                object2.postFinalizeForTermination(this.engineConnector);
            }
            if (this.permissionAuthorizer != null) {
                this.permissionAuthorizer.finalizeForTermination(this.engineConnector);
            }
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.PLUGIN_FINALIZATION_FAILED, object.getClass().getCanonicalName(), (Throwable)connectorException);
        }
    }

    private void finalizeAllPluginsForDisconnection() throws VnanoException {
        Object object = null;
        try {
            Object object2;
            Iterator<Object> iterator = this.xnci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = iterator.next();
                object2.preFinalizeForDisconnection(this.engineConnector);
            }
            iterator = this.xfci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalFunctionConnectorInterface1)iterator.next();
                object2.finalizeForDisconnection(this.engineConnector);
            }
            iterator = this.xvci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalVariableConnectorInterface1)iterator.next();
                object2.finalizeForDisconnection(this.engineConnector);
            }
            iterator = this.xnci1PluginList.iterator();
            while (iterator.hasNext()) {
                object = object2 = (ExternalNamespaceConnectorInterface1)iterator.next();
                object2.postFinalizeForDisconnection(this.engineConnector);
            }
            if (this.permissionAuthorizer != null) {
                this.permissionAuthorizer.finalizeForDisconnection(this.engineConnector);
            }
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.PLUGIN_FINALIZATION_FAILED, object.getClass().getCanonicalName(), (Throwable)connectorException);
        }
    }

    public void addLibraryScript(String string, String string2) throws VnanoException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (this.libraryFilePathContentMap.containsKey(string)) {
            throw new VnanoException(ErrorType.LIBRARY_IS_ALREADY_INCLUDED, string);
        }
        String string3 = IdentifierSyntax.normalizeScriptIdentifier(string);
        this.libraryFilePathContentMap.put(string3, string2);
        String string4 = this.getImportPathOf(string3);
        this.libraryImportPathSet.add(string4);
    }

    public void removeAllLibraryScripts() {
        this.libraryFilePathContentMap = new LinkedHashMap<String, String>();
        this.libraryImportPathSet = new HashSet<String>();
    }

    public void setMainScript(String string, String string2) {
        this.mainScriptName = string;
        this.mainScriptContent = string2;
    }

    public void removeMainScript() {
        this.mainScriptName = null;
        this.mainScriptContent = null;
    }

    public int getLibraryScriptCount() {
        return this.libraryFilePathContentMap.size();
    }

    public String[] getScriptPaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.libraryFilePathContentMap.entrySet()) {
            String string = entry.getKey();
            arrayList.add(string);
        }
        arrayList.add(this.mainScriptName);
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getScriptContents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.libraryFilePathContentMap.entrySet()) {
            String string = entry.getValue();
            arrayList.add(string);
        }
        arrayList.add(this.mainScriptContent);
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private String getImportPathOf(String string) {
        String string2 = string;
        if (string2.toLowerCase().endsWith(".vnano")) {
            string2 = string2.substring(0, string2.length() - ".vnano".length());
        }
        string2 = string2.replace('/', '.');
        string2 = string2.replace('\\', '.');
        string2 = string2.replace(':', '.');
        string2 = string2.replaceAll("\\.+", ".");
        string2 = string2.replaceAll("^\\.", "");
        return string2;
    }

    public boolean hasDependentLibraryOrPlugin(String string) {
        if (this.libraryImportPathSet.contains(string)) {
            return true;
        }
        return this.pluginImportPathSet.contains(string);
    }
}

