/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import org.vcssl.connect.ArrayDataAccessorInterface1;
import org.vcssl.connect.BoolScalarDataAccessorInterface1;
import org.vcssl.connect.ConnectorException;
import org.vcssl.connect.EngineConnectorInterface1;
import org.vcssl.connect.ExternalVariableConnectorInterface1;
import org.vcssl.connect.Float64ScalarDataAccessorInterface1;
import org.vcssl.connect.Int64ScalarDataAccessorInterface1;
import org.vcssl.connect.StringScalarDataAccessorInterface1;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.interconnect.AbstractVariable;
import org.vcssl.nano.interconnect.DataConverter;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.vm.memory.DataContainer;

public class Xvci1ToVariableAdapter
extends AbstractVariable {
    private ExternalVariableConnectorInterface1 xvciPlugin = null;
    private String variableName = null;
    private DataConverter dataConverter = null;
    private String namespaceName = null;

    public Xvci1ToVariableAdapter(ExternalVariableConnectorInterface1 externalVariableConnectorInterface1) throws VnanoException {
        Class<DataContainer> clazz;
        this.validate(externalVariableConnectorInterface1);
        this.xvciPlugin = externalVariableConnectorInterface1;
        this.variableName = externalVariableConnectorInterface1.getVariableName();
        this.dataConverter = new DataConverter(this.xvciPlugin.getDataClass());
        if (!this.xvciPlugin.isDataConversionNecessary() && !(clazz = this.xvciPlugin.getDataUnconvertedClass()).isAssignableFrom(DataContainer.class)) {
            String[] stringArray = new String[]{clazz.getCanonicalName(), this.xvciPlugin.getClass().getCanonicalName()};
            throw new VnanoException(ErrorType.INCOMPATIBLE_DATA_ACCESSOR_INTERFACE, stringArray);
        }
    }

    public ExternalVariableConnectorInterface1 getXvci1Plugin() {
        return this.xvciPlugin;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public void setVariableName(String string) {
        this.variableName = string;
    }

    @Override
    public boolean hasNamespaceName() {
        return this.namespaceName != null;
    }

    @Override
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @Override
    public void setNamespaceName(String string) {
        this.namespaceName = string;
    }

    @Override
    public String getDataTypeName() {
        return DataTypeName.getDataTypeNameOf(this.dataConverter.getDataType());
    }

    @Override
    public int getArrayRank() {
        return this.dataConverter.getArrayRank();
    }

    @Override
    public DataContainer<?> getDataContainer() throws VnanoException {
        try {
            if (this.xvciPlugin.isDataConversionNecessary()) {
                Object object = null;
                object = this.xvciPlugin.getData();
                return this.dataConverter.convertToDataContainer(object);
            }
            DataContainer dataContainer = new DataContainer();
            this.xvciPlugin.getData(dataContainer);
            return dataContainer;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{this.xvciPlugin.getVariableName(), null};
            if (exception instanceof ConnectorException) {
                stringArray[1] = exception.getMessage();
            }
            throw new VnanoException(ErrorType.EXTERNAL_VARIABLE_PLUGIN_CRASHED, stringArray, (Throwable)exception);
        }
    }

    @Override
    public void setDataContainer(DataContainer<?> dataContainer) throws VnanoException {
        if (this.xvciPlugin.isDataConversionNecessary()) {
            Object object = null;
            try {
                object = this.dataConverter.convertToExternalObject(dataContainer);
            }
            catch (VnanoException vnanoException) {
                throw new VnanoException(ErrorType.EXTERNAL_VARIABLE_PLUGIN_CRASHED, new String[]{this.xvciPlugin.getVariableName(), vnanoException.getMessage()}, (Throwable)vnanoException);
            }
            try {
                this.xvciPlugin.setData(object);
            }
            catch (ConnectorException connectorException) {
                throw new VnanoException(ErrorType.EXTERNAL_VARIABLE_PLUGIN_CRASHED, new String[]{this.xvciPlugin.getVariableName(), connectorException.getMessage()}, (Throwable)connectorException);
            }
        }
        try {
            this.xvciPlugin.setData(dataContainer);
        }
        catch (ConnectorException connectorException) {
            throw new VnanoException(ErrorType.EXTERNAL_VARIABLE_PLUGIN_CRASHED, new String[]{this.xvciPlugin.getVariableName(), connectorException.getMessage()}, (Throwable)connectorException);
        }
    }

    @Override
    public boolean isConstant() {
        return this.xvciPlugin.isConstant();
    }

    @Override
    public boolean hasSerialNumber() {
        return false;
    }

    @Override
    public int getSerialNumber() {
        return -1;
    }

    private void validate(ExternalVariableConnectorInterface1 externalVariableConnectorInterface1) throws VnanoException {
        Class<?> clazz;
        if (externalVariableConnectorInterface1.getVariableName() == null) {
            String string = "getVariableName(): The returned value is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalVariableConnectorInterface1.getClass().getName(), string});
        }
        if (externalVariableConnectorInterface1.getDataClass() == null) {
            String string = "getDataClass(): The returned value is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalVariableConnectorInterface1.getClass().getName(), string});
        }
        if (!externalVariableConnectorInterface1.isDataConversionNecessary()) {
            if (externalVariableConnectorInterface1.getDataUnconvertedClass() == null) {
                String string = "getDataUnconvertedClasses(): The returned value is null.";
                throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalVariableConnectorInterface1.getClass().getName(), string});
            }
            clazz = externalVariableConnectorInterface1.getDataUnconvertedClass();
            if (!(clazz.equals(ArrayDataAccessorInterface1.class) || clazz.equals(Int64ScalarDataAccessorInterface1.class) || clazz.equals(Float64ScalarDataAccessorInterface1.class) || clazz.equals(BoolScalarDataAccessorInterface1.class) || clazz.equals(StringScalarDataAccessorInterface1.class) || clazz.equals(DataContainer.class))) {
                String string = "getParameterUnconvertedClasses(): The returned class/interface \"" + clazz.getName() + "\"is not supported on the current version of Vnano Engine.";
                throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalVariableConnectorInterface1.getClass().getName(), string});
            }
        }
        if (externalVariableConnectorInterface1.isDataTypeArbitrary()) {
            clazz = "isDataTypeArbitrary(): Returned true, but this feature has not been supported yet on the current version of Vnano Engine.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalVariableConnectorInterface1.getClass().getName(), clazz});
        }
        if (externalVariableConnectorInterface1.isArrayRankArbitrary()) {
            clazz = "isArrayRankArbitrary(): Returned true, but this feature has not been supported yet on the current version of Vnano Engine.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalVariableConnectorInterface1.getClass().getName(), clazz});
        }
        if (externalVariableConnectorInterface1.getEngineConnectorClass() == null) {
            clazz = "getEngineConnectorClass(...): The returned value is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalVariableConnectorInterface1.getClass().getName(), clazz});
        }
        if (!externalVariableConnectorInterface1.getEngineConnectorClass().equals(EngineConnectorInterface1.class)) {
            clazz = "getEngineConnectorClass(...): The specified engine connector \"" + externalVariableConnectorInterface1.getEngineConnectorClass().getName() + "\"is not suppoted on the current version of Vnano Engine.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalVariableConnectorInterface1.getClass().getName(), clazz});
        }
    }
}

