/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.main;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.VirtualMachine;

public class PerformanceValuePrinter
implements Runnable {
    private static final int PROC_CNT_GETS_PER_SEC = 100;
    private static final int PROC_CNT_INTERVAL_WAIT = 10;
    private double procIpsSum = 0.0;
    private long operationCodeCountTotal;
    private HashMap<String, Double> operationCodeCountMap;
    private boolean printsVmSpeed = false;
    private boolean printsRamUsage = false;
    private boolean printsInstructionFrequency = false;
    private volatile boolean continuable = true;
    private VnanoEngine vnanoEngine = null;
    private VirtualMachine virtualMachine = null;

    public PerformanceValuePrinter(VnanoEngine vnanoEngine, boolean bl, boolean bl2, boolean bl3) {
        this.printsVmSpeed = bl;
        this.printsRamUsage = bl2;
        this.printsInstructionFrequency = bl3;
        this.operationCodeCountMap = new HashMap();
        this.operationCodeCountTotal = 0L;
        this.vnanoEngine = vnanoEngine;
    }

    public PerformanceValuePrinter(VirtualMachine virtualMachine, boolean bl, boolean bl2, boolean bl3) {
        this.printsVmSpeed = bl;
        this.printsRamUsage = bl2;
        this.printsInstructionFrequency = bl3;
        this.operationCodeCountMap = new HashMap();
        this.operationCodeCountTotal = 0L;
        this.virtualMachine = virtualMachine;
    }

    public void terminate() {
        this.continuable = false;
    }

    @Override
    public void run() {
        int n = 0;
        int n2 = 0;
        long l = System.nanoTime();
        while (this.continuable) {
            OperationCode[] operationCodeArray;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                break;
            }
            int n3 = 0;
            String[] stringArray = new String[]{};
            if (this.vnanoEngine != null && this.vnanoEngine.hasPerformanceMap()) {
                operationCodeArray = this.vnanoEngine.getPerformanceMap();
                if (operationCodeArray.containsKey("EXECUTED_INSTRUCTION_COUNT_INT_VALUE")) {
                    n3 = (Integer)operationCodeArray.get("EXECUTED_INSTRUCTION_COUNT_INT_VALUE");
                }
                if (operationCodeArray.containsKey("CURRENTLY_EXECUTED_OPERATION_CODE")) {
                    stringArray = (String[])operationCodeArray.get("CURRENTLY_EXECUTED_OPERATION_CODE");
                }
            }
            if (this.virtualMachine != null) {
                n3 = this.virtualMachine.getExecutedInstructionCountIntValue();
                operationCodeArray = this.virtualMachine.getCurrentlyExecutedOperationCodes();
                stringArray = new String[operationCodeArray.length];
                for (int i = 0; i < operationCodeArray.length; ++i) {
                    stringArray[i] = operationCodeArray[i].toString();
                }
            }
            if (stringArray.length != 0) {
                double d = 1.0 / (double)stringArray.length;
                for (String string : stringArray) {
                    double d2 = this.operationCodeCountMap.containsKey(string) ? this.operationCodeCountMap.get(string) : 0.0;
                    double d3 = d2 + d;
                    this.operationCodeCountMap.put(string, d3);
                }
            }
            this.operationCodeCountTotal += (long)stringArray.length;
            long l2 = System.nanoTime();
            double d = (double)(l2 - l) * 1.0E-9;
            double d4 = (double)(n3 - n2) / d;
            this.procIpsSum += d4;
            n2 = n3;
            l = l2;
            if (++n != 100) continue;
            System.out.println("================================================================================");
            String string = new Timestamp(System.currentTimeMillis()).toString();
            System.out.println("= Performance Monitor (" + string + ")");
            if (this.printsVmSpeed) {
                double d5 = this.procIpsSum / 100.0;
                String string2 = this.formatIpsValue(d5);
                System.out.println("= - VM Speed  = " + string2);
            }
            if (this.printsRamUsage) {
                long l3 = Runtime.getRuntime().totalMemory();
                long l4 = Runtime.getRuntime().freeMemory();
                long l5 = Runtime.getRuntime().maxMemory();
                String string3 = this.formatRamBytes(l3 - l4);
                String string4 = this.formatRamBytes(l5);
                System.out.println("= - RAM Usage = " + string3 + " (Max " + string4 + " Available)");
            }
            if (this.printsInstructionFrequency) {
                String string5 = this.formatInstructionFrequency(this.operationCodeCountMap);
                System.out.println("= - Instruction Execution Frequency :");
                System.out.print(string5);
                System.out.println("    (Total " + this.operationCodeCountTotal + " Samples)");
            }
            this.procIpsSum = 0.0;
            n = 0;
            System.out.println("================================================================================");
        }
    }

    private String formatIpsValue(double d) {
        double d2 = d;
        String string = "";
        if (d2 > 1.0E9) {
            string = "G";
            d2 /= 1.0E9;
        } else if (d2 > 1000000.0) {
            string = "M";
            d2 /= 1000000.0;
        } else if (d2 > 1000.0) {
            string = "K";
            d2 /= 1000.0;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        String string2 = decimalFormat.format(d2) + " " + string + "Hz (VRIL Instructions / sec)";
        return string2;
    }

    private String formatRamBytes(long l) {
        double d = l;
        String string = "";
        if (d > 1.073741824E9) {
            string = "Gi";
            d /= 1.073741824E9;
        } else if (d > 1048576.0) {
            string = "Mi";
            d /= 1048576.0;
        } else if (d > 1024.0) {
            string = "Ki";
            d /= 1024.0;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        String string2 = decimalFormat.format(d) + " " + string + "B";
        return string2;
    }

    private String formatInstructionFrequency(HashMap<String, Double> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.entrySet();
        ArrayList arrayList = new ArrayList(set);
        Collections.sort(arrayList, new CountEntryComparator());
        double d = 0.0;
        for (Map.Entry object2 : arrayList) {
            d += ((Double)object2.getValue()).doubleValue();
        }
        for (Map.Entry entry : arrayList) {
            entry.setValue((Double)entry.getValue() / d);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.#");
        for (Map.Entry entry : arrayList) {
            String string2 = String.format("%7s", ((String)entry.getKey()).toString());
            String string3 = decimalFormat.format((Double)entry.getValue() * 100.0);
            string3 = String.format("%6s", string3);
            String string4 = decimalFormat2.format(hashMap.get(entry.getKey()));
            stringBuilder.append("    - " + string2 + " : " + string3 + " %   (" + string4 + " count)" + string);
        }
        return stringBuilder.toString();
    }

    class CountEntryComparator
    implements Comparator<Map.Entry<String, Double>> {
        CountEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Double> entry, Map.Entry<String, Double> entry2) {
            double d = entry2.getValue() - entry.getValue();
            return (int)Math.signum(d);
        }
    }
}

