/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import java.util.HashMap;
import java.util.Map;
import org.vcssl.nano.vm.memory.Memory;

public final class AssemblyWord {
    public static final String ASSEMBLY_LANGUAGE_NAME = "Vector Register Intermediate Language (VRIL)";
    public static final String ASSEMBLY_LANGUAGE_VERSION = "0.0.1";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String INSTRUCTION_SEPARATOR = ";";
    public static final String WORD_SEPARATOR = "\t";
    public static final String VALUE_SEPARATOR = ":";
    public static final String IDENTIFIER_SERIAL_NUMBER_SEPARATOR = "@";
    public static final String INDENT = "\t";
    public static final String LINE_SEPARATOR_REGEX = "\\r\\n|\\r|\\n";
    public static final String INSTRUCTION_SEPARATOR_REGEX = ";";
    public static final String WORD_SEPARATOR_REGEX = "\t| ";
    public static final String VALUE_SEPARATOR_REGEX = ":";
    public static final String IDENTIFIER_SERIAL_NUMBER_REGEX = "@";
    public static final String INDENT_REGEX = "\t| ";
    public static final char DIRECTIVE_PREFIX = '#';
    public static final String ASSEMBLY_LANGUAGE_IDENTIFIER_DIRECTIVE = "#ASSEMBLY_LANGUAGE_IDENTIFIER";
    public static final String ASSEMBLY_LANGUAGE_VERSION_DIRECTIVE = "#assemblyLanguageVersion";
    public static final String SCRIPT_LANGUAGE_IDENTIFIER_DIRECTIVE = "#SCRIPT_LANGUAGE_IDENTIFIER";
    public static final String SCRIPT_LANGUAGE_VERSION_DIRECTIVE = "#scriptLanguageVersion";
    public static final String LOCAL_VARIABLE_DIRECTIVE = "#LOCAL_VARIABLE";
    public static final String GLOBAL_VARIABLE_DIRECTIVE = "#GLOBAL_VARIABLE";
    public static final String LOCAL_FUNCTION_DIRECTIVE = "#LOCAL_FUNCTION";
    public static final String GLOBAL_FUNCTION_DIRECTIVE = "#GLOBAL_FUNCTION";
    public static final String META_DIRECTIVE = "#META";
    public static final String LABEL_DIRECTIVE = "#LABEL";
    public static final String COMMENT_DIRECTIVE = "#COMMENT";
    public static final char GLOBAL_OPERAND_PREFIX = 'G';
    public static final char LOCAL_OPERAND_PREFIX = 'L';
    public static final char CONSTANT_OPERAND_PREFIX = 'C';
    public static final char REGISTER_OPERAND_PREFIX = 'R';
    public static final char IDENTIFIER_OPERAND_PREFIX = '_';
    public static final char IMMEDIATE_OPERAND_PREFIX = '~';
    public static final char LABEL_OPERAND_PREFIX = '&';
    public static final char PLACEHOLDER_OPERAND_PREFIX = '-';
    public static final Map<Character, Memory.Partition> OPERAND_PREFIX_PARTITION_MAP = new HashMap<Character, Memory.Partition>(){
        {
            this.put(Character.valueOf('G'), Memory.Partition.GLOBAL);
            this.put(Character.valueOf('L'), Memory.Partition.LOCAL);
            this.put(Character.valueOf('R'), Memory.Partition.REGISTER);
            this.put(Character.valueOf('C'), Memory.Partition.CONSTANT);
        }
    };

    public static final String getImmediateValueOf(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('~');
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }
}

