/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.ConfirmationType;

public class ConfirmationMessage {
    private static final Map<String, String> PERMISSION_JAJP_NAME_MAP = new HashMap<String, String>();
    private static final Map<String, String> PERMISSION_ENUS_NAME_MAP;

    public static String generateConfirmationMessage(ConfirmationType confirmationType) {
        return ConfirmationMessage.generateConfirmationMessage(confirmationType, null, Locale.getDefault());
    }

    public static String generateConfirmationMessage(ConfirmationType confirmationType, String[] stringArray) {
        return ConfirmationMessage.generateConfirmationMessage(confirmationType, stringArray, Locale.getDefault());
    }

    public static String generateConfirmationMessage(ConfirmationType confirmationType, String[] stringArray, Locale locale) {
        if (locale.getLanguage() != null && locale.getLanguage().equals("ja") || locale.getCountry() != null && locale.getCountry().equals("JP")) {
            return ConfirmationMessage.generateConfirmationMessageJaJP(confirmationType, stringArray);
        }
        return ConfirmationMessage.generateConfirmationMessageEnUS(confirmationType, stringArray);
    }

    public static String generateConfirmationMessageJaJP(ConfirmationType confirmationType, String[] stringArray) {
        switch (confirmationType) {
            case PERMISSION_REQUESTED: {
                String string = PERMISSION_JAJP_NAME_MAP.containsKey(stringArray[0]) ? PERMISSION_JAJP_NAME_MAP.get(stringArray[0]) : stringArray[0];
                String string2 = "\u73fe\u5728\u5b9f\u884c\u4e2d\u306e\u51e6\u7406\u304c\u3001\u300c " + string + " \u300d\u306e\u8a31\u53ef\u3092\u6c42\u3081\u3066\u3044\u307e\u3059\u3002\u8a31\u53ef\u3057\u307e\u3059\u304b ?\n( \u8981\u6c42\u5143\u30d7\u30e9\u30b0\u30a4\u30f3\uff1a " + stringArray[1] + " )";
                if (3 <= stringArray.length) {
                    string2 = string2 + "\n\n\u5bfe\u8c61\uff1a " + stringArray[2];
                }
                return string2;
            }
            case ALLOW_SAME_PERMISSION_AUTOMATICALLY: {
                String string = PERMISSION_JAJP_NAME_MAP.containsKey(stringArray[0]) ? PERMISSION_JAJP_NAME_MAP.get(stringArray[0]) : stringArray[0];
                return "\u73fe\u5728\u5b9f\u884c\u4e2d\u306e\u51e6\u7406\u306e\u9593\u3001\u540c\u3058\u7a2e\u985e\u306e\u8981\u6c42\uff08 " + string + " \uff09\u3092\u81ea\u52d5\u7684\u306b\u8a31\u53ef\u3057\u307e\u3059\u304b ?";
            }
        }
        throw new VnanoFatalException("\u4e88\u671f\u3057\u306a\u3044\u30e1\u30c3\u30bb\u30fc\u30b8\u30bf\u30a4\u30d7: " + (Object)((Object)confirmationType));
    }

    public static String generateConfirmationMessageEnUS(ConfirmationType confirmationType, String[] stringArray) {
        switch (confirmationType) {
            case PERMISSION_REQUESTED: {
                String string = PERMISSION_ENUS_NAME_MAP.containsKey(stringArray[0]) ? PERMISSION_ENUS_NAME_MAP.get(stringArray[0]) : stringArray[0];
                String string2 = "The permission for \"" + string + "\" has been requested. Do you allow it?\n( Requesting Plug-in\uff1a " + stringArray[1] + " )";
                if (3 <= stringArray.length) {
                    string2 = string2 + "\n\nTarget\uff1a " + stringArray[2];
                }
                return string2;
            }
            case ALLOW_SAME_PERMISSION_AUTOMATICALLY: {
                String string = PERMISSION_ENUS_NAME_MAP.containsKey(stringArray[0]) ? PERMISSION_ENUS_NAME_MAP.get(stringArray[0]) : stringArray[0];
                String string3 = "Do you want to allow the same type request ( " + string + " ) automatically during the current processing ?";
                return string3;
            }
        }
        throw new VnanoFatalException("Unexpected confirmation message type: " + (Object)((Object)confirmationType));
    }

    static {
        PERMISSION_JAJP_NAME_MAP.put("FILE_CREATE", "\u30d5\u30a1\u30a4\u30eb\u306e\u65b0\u898f\u4f5c\u6210");
        PERMISSION_JAJP_NAME_MAP.put("FILE_WRITE", "\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u8fbc\u307f");
        PERMISSION_JAJP_NAME_MAP.put("FILE_READ", "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f");
        PERMISSION_JAJP_NAME_MAP.put("FILE_OVERWRITE", "\u30d5\u30a1\u30a4\u30eb\u306e\u4e0a\u66f8\u304d");
        PERMISSION_JAJP_NAME_MAP.put("FILE_DELETE", "\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664");
        PERMISSION_JAJP_NAME_MAP.put("FILE_INFORMATION_CHANGE", "\u30d5\u30a1\u30a4\u30eb\u306e\u60c5\u5831\u5909\u66f4");
        PERMISSION_JAJP_NAME_MAP.put("DIRECTORY_CREATE", "\u30d5\u30a9\u30eb\u30c0\u306e\u65b0\u898f\u4f5c\u6210");
        PERMISSION_JAJP_NAME_MAP.put("DIRECTORY_LIST", "\u30d5\u30a9\u30eb\u30c0\u5185\u306e\u4e00\u89a7\u53d6\u5f97");
        PERMISSION_JAJP_NAME_MAP.put("DIRECTORY_DELETE", "\u30d5\u30a9\u30eb\u30c0\u306e\u524a\u9664");
        PERMISSION_ENUS_NAME_MAP = new HashMap<String, String>();
        PERMISSION_ENUS_NAME_MAP.put("FILE_CREATE", "Creating a File");
        PERMISSION_ENUS_NAME_MAP.put("FILE_WRITE", "Writing to a File");
        PERMISSION_ENUS_NAME_MAP.put("FILE_READ", "Reading from a File");
        PERMISSION_ENUS_NAME_MAP.put("FILE_OVERWRITE", "Overwriting to a File");
        PERMISSION_ENUS_NAME_MAP.put("FILE_DELETE", "Deleting a File");
        PERMISSION_ENUS_NAME_MAP.put("FILE_INFORMATION_CHANGE", "Changing of Information of a File");
        PERMISSION_JAJP_NAME_MAP.put("DIRECTORY_CREATE", "Creating a directory");
        PERMISSION_JAJP_NAME_MAP.put("DIRECTORY_LIST", "Listing-up Files in a Directory");
        PERMISSION_JAJP_NAME_MAP.put("DIRECTORY_DELETE", "Deliting a directory");
    }
}

