/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import java.util.Arrays;
import java.util.HashSet;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.interconnect.AbstractFunction;
import org.vcssl.nano.interconnect.AbstractVariable;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.DataTypeName;

public final class IdentifierSyntax {
    public static final boolean isValidSyntaxIdentifier(String string) {
        if (string.matches("^[0-9].*$")) {
            return false;
        }
        char[] cArray = new char[]{'#', '$', '%', '&', '~', '@', ':', '`', '^', '.', '?', '\"', '\'', '\\'};
        HashSet<Character> hashSet = new HashSet<Character>();
        for (char c : cArray) {
            hashSet.add(Character.valueOf(c));
        }
        for (char c : string.toCharArray()) {
            if (!hashSet.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static final String getSignatureOf(String string, String[] stringArray, int[] nArray, boolean[] blArray, boolean[] blArray2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("(");
        if (bl) {
            stringBuilder.append("...");
            if (blArray[0]) {
                stringBuilder.append("any");
            } else {
                stringBuilder.append(stringArray[0]);
            }
            if (blArray2[0]) {
                stringBuilder.append("[]...[])");
            } else {
                stringBuilder.append("[])");
            }
            return stringBuilder.toString();
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (blArray[i]) {
                stringBuilder.append("any");
            } else {
                stringBuilder.append(stringArray[i]);
            }
            if (blArray2[i]) {
                stringBuilder.append("[]...[]");
            } else {
                int n2 = nArray[i];
                for (int j = 0; j < n2; ++j) {
                    stringBuilder.append("[]");
                }
            }
            if (i == n - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static final String getSignatureOf(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.IDENTIFIER_VALUE);
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length;
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n];
        Arrays.fill(blArray, false);
        Arrays.fill(blArray2, false);
        for (int i = 0; i < n; ++i) {
            String string2 = astNodeArray[i].getAttribute(AttributeKey.DATA_TYPE);
            try {
                DataType dataType = DataTypeName.getDataTypeOf(string2);
                string2 = DataTypeName.getDataTypeNameOf(dataType);
            }
            catch (VnanoException vnanoException) {
                // empty catch block
            }
            stringArray[i] = string2;
            nArray[i] = astNodeArray[i].getArrayRank();
        }
        String string3 = IdentifierSyntax.getSignatureOf(string, stringArray, nArray, blArray, blArray2, false, false);
        return string3;
    }

    public static final String getSignatureOfCalleeFunctionOf(AstNode astNode) {
        AstNode[] astNodeArray = astNode.getChildNodes();
        String string = astNodeArray[0].getAttribute(AttributeKey.IDENTIFIER_VALUE);
        int n = astNodeArray.length - 1;
        AstNode[] astNodeArray2 = new AstNode[n];
        System.arraycopy(astNodeArray, 1, astNodeArray2, 0, n);
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n];
        Arrays.fill(blArray, false);
        Arrays.fill(blArray2, false);
        for (int i = 0; i < n; ++i) {
            String string2 = astNodeArray2[i].getAttribute(AttributeKey.DATA_TYPE);
            try {
                DataType dataType = DataTypeName.getDataTypeOf(string2);
                string2 = DataTypeName.getDataTypeNameOf(dataType);
            }
            catch (VnanoException vnanoException) {
                // empty catch block
            }
            stringArray[i] = string2;
            nArray[i] = astNodeArray2[i].getArrayRank();
        }
        String string3 = IdentifierSyntax.getSignatureOf(string, stringArray, nArray, blArray, blArray2, false, false);
        return string3;
    }

    public static final String getSignatureOf(AbstractFunction abstractFunction) {
        return IdentifierSyntax.getSignatureOf(abstractFunction, "");
    }

    public static final String getSignatureOf(AbstractFunction abstractFunction, String string) {
        String[] stringArray = abstractFunction.getParameterDataTypeNames();
        int[] nArray = abstractFunction.getParameterArrayRanks();
        boolean[] blArray = abstractFunction.getParameterDataTypeArbitrarinesses();
        boolean[] blArray2 = abstractFunction.getParameterArrayRankArbitrarinesses();
        String string2 = string + abstractFunction.getFunctionName();
        String string3 = IdentifierSyntax.getSignatureOf(string2, stringArray, nArray, blArray, blArray2, abstractFunction.isParameterCountArbitrary(), abstractFunction.hasVariadicParameters());
        return string3;
    }

    public static final String getAssemblyIdentifierOf(AstNode astNode) {
        String string = astNode.getAttribute(AttributeKey.IDENTIFIER_VALUE);
        String string2 = '_' + string;
        if (astNode.hasAttribute(AttributeKey.IDENTIFIER_SERIAL_NUMBER)) {
            String string3 = astNode.getAttribute(AttributeKey.IDENTIFIER_SERIAL_NUMBER);
            string2 = string2 + "@" + string3;
        }
        return string2;
    }

    public static final String getAssemblyIdentifierOf(AbstractVariable abstractVariable) {
        return IdentifierSyntax.getAssemblyIdentifierOf(abstractVariable, "");
    }

    public static final String getAssemblyIdentifierOf(AbstractVariable abstractVariable, String string) {
        String string2 = abstractVariable.getVariableName();
        if (abstractVariable.hasSerialNumber()) {
            string2 = string2 + "@" + abstractVariable.getSerialNumber();
        }
        return '_' + string + string2;
    }

    public static final String normalizeScriptIdentifier(String string) {
        String string2 = string;
        String string3 = "_";
        string2 = string2.replaceAll("\"", string3);
        string2 = string2.replaceAll("=", string3);
        string2 = string2.replaceAll(",", string3);
        string2 = string2.replaceAll(";", string3);
        string2 = string2.replaceAll("\t", string3);
        string2 = string2.replaceAll("\r", string3);
        string2 = string2.replaceAll("\n", string3);
        if ((string2 = string2.replace("\\", "/")).startsWith("./")) {
            string2 = string2.substring(2);
        }
        if (!string2.equals("main script")) {
            string2 = string2.replaceAll(" ", string3);
        }
        return string2;
    }
}

