/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import java.util.ArrayList;
import java.util.Iterator;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.ErrorType;

public class LiteralSyntax {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String INT_LITERAL_HEX_PREFIX = "0x";
    public static final String INT_LITERAL_OCT_PREFIX = "0o";
    public static final String INT_LITERAL_BIN_PREFIX = "0b";
    public static final String FLOAT_LITERAL_EXPONENT_PREFIX = "e|E";
    protected static final String INT_LITERAL_REGEX = "^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$";
    protected static final String FLOAT_LITERAL_REGEX = "^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$";
    protected static final String BOOL_LITERAL_REGEX = "^true|false$";
    private static final char STEING_LITERAL_ESCAPE = '\\';
    public static final char STRING_LITERAL_QUOT = '\"';
    public static final char CHAR_LITERAL_QUOT = '\'';

    public static final boolean isValidLiteral(String string) {
        try {
            LiteralSyntax.getDataTypeNameOfLiteral(string);
            return true;
        }
        catch (VnanoFatalException vnanoFatalException) {
            return false;
        }
    }

    public static final String getDataTypeNameOfLiteral(String string) throws VnanoFatalException {
        int n = string.length();
        if (string.matches(INT_LITERAL_REGEX)) {
            return "int";
        }
        if (string.matches(FLOAT_LITERAL_REGEX)) {
            return "float";
        }
        if (string.matches(BOOL_LITERAL_REGEX)) {
            return "bool";
        }
        if (string.charAt(0) == '\"' && string.charAt(n - 1) == '\"' && string.length() >= 2) {
            return "string";
        }
        throw new VnanoFatalException("Invalid literal: " + string);
    }

    public static final String decodeEscapeSequences(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                switch (cArray[i]) {
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        break;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    default: {
                        throw new VnanoFatalException("Unknown escape sequence: " + cArray[i]);
                    }
                }
                bl = false;
                continue;
            }
            if (cArray[i] == '\\' && !bl) {
                bl = true;
                continue;
            }
            bl = false;
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    public static final String[] extractStringLiterals(String string) throws VnanoException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuilder stringBuilder = new StringBuilder(n);
        StringBuilder stringBuilder2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 1;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '\"' && !bl) {
                if (bl2) {
                    bl2 = false;
                    stringBuilder2.append('\"');
                    String string2 = stringBuilder2.toString();
                    stringBuilder2 = null;
                    arrayList.add(string2);
                    stringBuilder.append('\"');
                    stringBuilder.append(n2);
                    stringBuilder.append('\"');
                    ++n2;
                    continue;
                }
                bl2 = true;
                stringBuilder2 = new StringBuilder();
                stringBuilder2.append('\"');
                continue;
            }
            if (bl2 && cArray[i] == '\\' && !bl) {
                stringBuilder2.append('\\');
                bl = true;
                continue;
            }
            bl = false;
            if (bl2) {
                stringBuilder2.append(cArray[i]);
                continue;
            }
            stringBuilder.append(cArray[i]);
        }
        if (bl2) {
            throw new VnanoException(ErrorType.STRING_LITERAL_IS_NOT_CLOSED);
        }
        String[] stringArray = new String[arrayList.size() + 1];
        stringArray[0] = stringBuilder.toString();
        int n3 = 1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3;
            stringArray[n3] = string3 = (String)iterator.next();
            ++n3;
        }
        return stringArray;
    }

    public static final int getIndexOfNumberedStringLiteral(String string) {
        string = string.substring(1, string.length() - 1);
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VnanoFatalException("Invalid numbered string literal: " + string, numberFormatException);
        }
        return n;
    }
}

