/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm;

import java.io.PrintStream;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.DataConverter;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.ReexecutionCache;
import org.vcssl.nano.vm.VirtualMachineObjectCode;
import org.vcssl.nano.vm.accelerator.Accelerator;
import org.vcssl.nano.vm.assembler.Assembler;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;
import org.vcssl.nano.vm.processor.Processor;

public class VirtualMachine {
    private Processor processor = new Processor();
    private Accelerator accelerator = new Accelerator();
    private ReexecutionCache reexecutionCache = null;
    private int vmProcessedInstructionCount = 0;
    private int processorLastProcCount = 0;
    private int acceleratorLastProcCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeAssemblyCode(String string, Interconnect interconnect) throws VnanoException {
        boolean bl;
        String string2;
        boolean bl2;
        boolean bl3;
        Object object;
        PrintStream printStream = null;
        Object object2 = this;
        synchronized (object2) {
            object = interconnect.getOptionMap();
            bl3 = (Boolean)object.get("ACCELERATOR_ENABLED");
            bl2 = (Boolean)object.get("DUMPER_ENABLED");
            string2 = (String)object.get("DUMPER_TARGET");
            bl = string2.equals("ALL");
            printStream = (PrintStream)object.get("DUMPER_OUTPUT_STREAM");
        }
        object2 = new Assembler();
        object = ((Assembler)object2).assemble(string, interconnect);
        if (bl2 && (bl || string2.equals("OBJECT_CODE"))) {
            if (bl) {
                printStream.println("================================================================================");
                printStream.println("= VM Object Code");
                printStream.println("= - Output of: org.vcssl.nano.vm.assembler.Assembler");
                printStream.println("= - Input  of: org.vcssl.nano.vm.processor.Processor");
                printStream.println("= -        or: org.vcssl.nano.vm.accelerator.Accelerator");
                printStream.println("================================================================================");
            }
            printStream.print(((VirtualMachineObjectCode)object).dump());
            if (bl) {
                printStream.println("");
            }
        }
        Memory memory = new Memory();
        memory.allocate((VirtualMachineObjectCode)object, interconnect.getExternalVariableTable());
        Instruction[] instructionArray = ((VirtualMachineObjectCode)object).getInstructions();
        if (bl3) {
            this.accelerator.process(instructionArray, memory, interconnect, this.processor);
        } else {
            this.processor.process(instructionArray, memory, interconnect);
        }
        interconnect.writebackExternalVariables(memory, (VirtualMachineObjectCode)object);
        this.reexecutionCache = new ReexecutionCache();
        this.reexecutionCache.setLastObjectCode((VirtualMachineObjectCode)object);
        this.reexecutionCache.setMemory(memory);
        this.reexecutionCache.setAcceleratorEnabled(bl3);
        Object object3 = null;
        if (memory.hasResultDataContainer()) {
            DataContainer<?> dataContainer = memory.getResultDataContainer();
            DataConverter dataConverter = new DataConverter(dataContainer.getDataType(), dataContainer.getArrayRank());
            object3 = dataConverter.convertToExternalObject(dataContainer);
            this.reexecutionCache.setResultDataResources(dataContainer, dataConverter);
        }
        return object3;
    }

    public Object reexecuteLastAssemblyCode(Interconnect interconnect) throws VnanoException {
        if (this.reexecutionCache == null) {
            throw new VnanoException(ErrorType.INVALID_REEXECUTION_REQUEST);
        }
        VirtualMachineObjectCode virtualMachineObjectCode = this.reexecutionCache.getLastObjectCode();
        Instruction[] instructionArray = virtualMachineObjectCode.getInstructions();
        Memory memory = this.reexecutionCache.getMemory();
        memory.updateGlobalPartitionData(virtualMachineObjectCode, interconnect.getExternalVariableTable());
        if (this.reexecutionCache.isAcceleratorEnabled()) {
            this.accelerator.reprocess(instructionArray, memory, interconnect, this.processor);
        } else {
            this.processor.process(instructionArray, memory, interconnect);
        }
        interconnect.writebackExternalVariables(memory, virtualMachineObjectCode);
        Object object = null;
        if (this.reexecutionCache.hasResultDataResources()) {
            DataContainer<?> dataContainer = this.reexecutionCache.getResultDataContainer();
            DataConverter dataConverter = this.reexecutionCache.getResultDataConverter();
            object = dataConverter.convertToExternalObject(dataContainer);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        VirtualMachine virtualMachine = this;
        synchronized (virtualMachine) {
            if (this.accelerator != null) {
                this.accelerator.terminate();
            }
            if (this.processor != null) {
                this.processor.terminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTerminator() {
        VirtualMachine virtualMachine = this;
        synchronized (virtualMachine) {
            if (this.accelerator != null) {
                this.accelerator.resetTerminator();
            }
            if (this.processor != null) {
                this.processor.resetTerminator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExecutedInstructionCountIntValue() {
        VirtualMachine virtualMachine = this;
        synchronized (virtualMachine) {
            int n;
            if (this.processor != null) {
                n = this.processor.getExecutedInstructionCountIntValue();
                this.vmProcessedInstructionCount += n - this.processorLastProcCount;
                this.processorLastProcCount = n;
            }
            if (this.accelerator != null) {
                n = this.accelerator.getExecutedInstructionCountIntValue();
                this.vmProcessedInstructionCount += n - this.acceleratorLastProcCount;
                this.acceleratorLastProcCount = n;
            }
            return this.vmProcessedInstructionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationCode[] getCurrentlyExecutedOperationCodes() {
        VirtualMachine virtualMachine = this;
        synchronized (virtualMachine) {
            if (this.processor == null || this.accelerator == null) {
                throw new VnanoFatalException("The processor/accelerator have not initialized yet.");
            }
            OperationCode[] operationCodeArray = this.accelerator.getCurrentlyExecutedOperationCodes();
            OperationCode[] operationCodeArray2 = this.processor.getCurrentlyExecutedOperationCodes();
            if (operationCodeArray.length != 0) {
                return operationCodeArray;
            }
            if (operationCodeArray2.length != 0) {
                return operationCodeArray2;
            }
            return new OperationCode[0];
        }
    }
}

