/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;

public class VirtualMachineObjectCode
implements Cloneable {
    private List<Instruction> instructionList = new ArrayList<Instruction>();
    private List<Integer> registerAddressList = new ArrayList<Integer>();
    private List<Integer> constantDataAddressList = new ArrayList<Integer>();
    private List<Integer> localVariableAddressList = new ArrayList<Integer>();
    private List<Integer> globalVariableAddressList = new ArrayList<Integer>();
    private List<Integer> functionAddressList = new ArrayList<Integer>();
    private List<Integer> labelAddressList = new ArrayList<Integer>();
    private List<String> constantDataImmediateValueList = new ArrayList<String>();
    private List<DataContainer<?>> constantDataContainerList = new ArrayList();
    private List<String> localVariableIdentifierList = new ArrayList<String>();
    private List<String> globalVariableIdentifierList = new ArrayList<String>();
    private List<String> functionIdentifierList = new ArrayList<String>();
    private List<String> labelIdentifierList = new ArrayList<String>();
    private Map<Integer, String> constantDataAddressImmediateValueMap = new HashMap<Integer, String>();
    private Map<Integer, DataContainer<?>> constantDataAddressContainerMap = new HashMap();
    private Map<Integer, String> localVariableAddressIdentifierMap = new HashMap<Integer, String>();
    private Map<Integer, String> globalVariableAddressIdentifierMap = new HashMap<Integer, String>();
    private Map<Integer, String> functionAddressIdentifierMap = new HashMap<Integer, String>();
    private Map<Integer, String> labelAddressIdentifierMap = new HashMap<Integer, String>();
    private int evalValueAddress = -1;

    public boolean hasEvalValue() {
        return 0 <= this.evalValueAddress;
    }

    public void setEvalValueAddress(int n) {
        this.evalValueAddress = n;
    }

    public int getEvalValueAddress() {
        return this.evalValueAddress;
    }

    public void addInstruction(Instruction instruction) {
        this.instructionList.add(instruction);
    }

    public Instruction[] getInstructions() {
        return this.instructionList.toArray(new Instruction[0]);
    }

    public String[] getConstantImmediateValues() {
        return this.constantDataImmediateValueList.toArray(new String[0]);
    }

    public DataContainer<?>[] getConstantDataContainers() {
        return this.constantDataContainerList.toArray(new DataContainer[0]);
    }

    public String[] getGlobalAssemblyIdentifiers() {
        return this.globalVariableIdentifierList.toArray(new String[0]);
    }

    public String[] getFunctionAssemblyIdentifiers() {
        return this.functionIdentifierList.toArray(new String[0]);
    }

    public void addRegister(int n) {
        this.registerAddressList.add(n);
    }

    public void addConstantData(String string, DataContainer<?> dataContainer, int n) {
        this.constantDataImmediateValueList.add(string);
        this.constantDataContainerList.add(dataContainer);
        this.constantDataAddressList.add(n);
        this.constantDataAddressImmediateValueMap.put(n, string);
        this.constantDataAddressContainerMap.put(n, dataContainer);
    }

    public void addLocalVariable(String string, int n) {
        this.localVariableIdentifierList.add(string);
        this.localVariableAddressList.add(n);
        this.localVariableAddressIdentifierMap.put(n, string);
    }

    public void addGlobalVariable(String string, int n) {
        this.globalVariableIdentifierList.add(string);
        this.globalVariableAddressList.add(n);
        this.globalVariableAddressIdentifierMap.put(n, string);
    }

    public void addFunction(String string, int n) {
        this.functionIdentifierList.add(string);
        this.functionAddressList.add(n);
        this.functionAddressIdentifierMap.put(n, string);
    }

    public void addLabel(String string, int n) {
        this.labelIdentifierList.add(string);
        this.labelAddressList.add(n);
        this.labelAddressIdentifierMap.put(n, string);
    }

    public boolean hasGlobalVariableRegisteredAt(int n) {
        return this.globalVariableAddressIdentifierMap.containsKey(n);
    }

    public int getLocalVariableAddress(String string) {
        int n = this.localVariableIdentifierList.indexOf(string);
        return this.localVariableAddressList.get(n);
    }

    public int getGlobalVariableAddress(String string) {
        int n = this.globalVariableIdentifierList.indexOf(string);
        return this.globalVariableAddressList.get(n);
    }

    public int getConstantDataAddress(String string) {
        int n = this.constantDataImmediateValueList.indexOf(string);
        return this.constantDataAddressList.get(n);
    }

    public int getLabelAddress(String string) {
        int n = this.labelIdentifierList.indexOf(string);
        return this.labelAddressList.get(n);
    }

    public int getFunctionAddress(String string) {
        int n = this.functionIdentifierList.indexOf(string);
        return this.functionAddressList.get(n);
    }

    public String getLocalVariableUniqueIdentifier(int n) {
        return this.localVariableAddressIdentifierMap.get(n);
    }

    public String getGlobalVariableUniqueIdentifier(int n) {
        return this.globalVariableAddressIdentifierMap.get(n);
    }

    public String getConstantDataImmediateValue(int n) {
        return this.constantDataAddressImmediateValueMap.get(n);
    }

    public String getFunctionUniqueIdentifier(int n) {
        return this.functionAddressIdentifierMap.get(n);
    }

    public boolean containsRegister(int n) {
        return this.registerAddressList.contains(n);
    }

    public boolean containsConstantData(String string) {
        return this.constantDataImmediateValueList.contains(string);
    }

    public boolean containsGlobalVariable(String string) {
        return this.globalVariableIdentifierList.contains(string);
    }

    public boolean containsLocalVariable(String string) {
        return this.localVariableIdentifierList.contains(string);
    }

    public boolean containsFunction(String string) {
        return this.functionIdentifierList.contains(string);
    }

    private int getMaxAddressOf(List<Integer> list) {
        int n = -1;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = list.get(i);
            if (n >= n3) continue;
            n = n3;
        }
        return n;
    }

    public int getMinimumRegisterAddress() {
        return 0;
    }

    public int getMaximumRegisterAddress() {
        return this.getMaxAddressOf(this.registerAddressList);
    }

    public int getMinimumLocalAddress() {
        return 0;
    }

    public int getMaximumLocalAddress() {
        return this.getMaxAddressOf(this.localVariableAddressList);
    }

    public int getMinimumGlobalAddress() {
        return 0;
    }

    public int getMaximumGlobalAddress() {
        return this.getMaxAddressOf(this.globalVariableAddressList);
    }

    public int getMinimumConstantAddress() {
        return 0;
    }

    public int getMaximumConstantAddress() {
        return this.getMaxAddressOf(this.constantDataAddressList);
    }

    public int getMinimumFunctionAddress() {
        return 0;
    }

    public int getMaximumFunctionAddress() {
        return this.getMaxAddressOf(this.functionAddressList);
    }

    public String dump() {
        int n;
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#INSTRUCTION");
        stringBuilder.append(string);
        int n2 = this.instructionList.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            Instruction instruction = this.instructionList.get(n);
            stringBuilder.append("\t");
            stringBuilder.append(n);
            stringBuilder.append("\t");
            stringBuilder.append((Object)instruction.getOperationCode());
            stringBuilder.append("\t");
            int n4 = instruction.getDataTypes().length;
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuilder.append((Object)instruction.getDataTypes()[n3]);
                if (n3 == n4 - 1) continue;
                stringBuilder.append(":");
            }
            if (n4 == 1) {
                stringBuilder.append("\t");
            }
            stringBuilder.append("\t");
            n3 = instruction.getOperandAddresses().length;
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(instruction.getOperandPartitions()[i].toString().charAt(0));
                stringBuilder.append(instruction.getOperandAddresses()[i]);
                stringBuilder.append("\t");
            }
            stringBuilder.append(instruction.getMetaPartition().toString().charAt(0));
            stringBuilder.append(instruction.getMetaAddress());
            stringBuilder.append(string);
        }
        stringBuilder.append(string);
        stringBuilder.append("#LABEL" + string);
        for (n = 0; n < this.labelIdentifierList.size(); ++n) {
            stringBuilder.append("\t" + this.labelAddressList.get(n) + "\t" + this.labelIdentifierList.get(n) + string);
        }
        stringBuilder.append(string);
        stringBuilder.append("#FUNCTION" + string);
        for (n = 0; n < this.functionIdentifierList.size(); ++n) {
            int n5 = this.functionAddressList.get(n);
            String string2 = this.functionIdentifierList.get(n);
            stringBuilder.append("\t" + n5 + "\t" + string2 + string);
        }
        stringBuilder.append(string);
        stringBuilder.append("#GLOBAL_DATA" + string);
        for (n = 0; n < this.globalVariableIdentifierList.size(); ++n) {
            int n6 = this.globalVariableAddressList.get(n);
            String string3 = this.globalVariableIdentifierList.get(n);
            stringBuilder.append("\t" + Memory.Partition.GLOBAL.toString().charAt(0) + n6 + "\t" + string3 + string);
        }
        stringBuilder.append(string);
        stringBuilder.append("#LOCAL_DATA" + string);
        for (n = 0; n < this.localVariableIdentifierList.size(); ++n) {
            int n7 = this.localVariableAddressList.get(n);
            String string4 = this.localVariableIdentifierList.get(n);
            stringBuilder.append("\t" + Memory.Partition.LOCAL.toString().charAt(0) + n7 + "\t" + string4 + string);
        }
        stringBuilder.append(string);
        stringBuilder.append("#CONSTANT_DATA" + string);
        for (n = 0; n < this.constantDataImmediateValueList.size(); ++n) {
            int n8 = this.constantDataAddressList.get(n);
            String string5 = this.constantDataImmediateValueList.get(n);
            stringBuilder.append("\t" + Memory.Partition.CONSTANT.toString().charAt(0) + n8 + "\t" + string5 + string);
        }
        stringBuilder.append(string);
        stringBuilder.append("#REGISTER" + string);
        n = this.getMinimumRegisterAddress();
        int n9 = this.getMaximumRegisterAddress();
        for (int i = n; i <= n9; ++i) {
            if (i == n || i == n9) {
                stringBuilder.append("\t" + Memory.Partition.REGISTER.toString().charAt(0) + i + string);
                continue;
            }
            if (i != n + 1) continue;
            stringBuilder.append("\t..." + string);
        }
        return stringBuilder.toString();
    }
}

