/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.AbstractFunction;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.BoolScalarCache;
import org.vcssl.nano.vm.accelerator.CacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.accelerator.GeneralScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.accelerator.NoneCache;
import org.vcssl.nano.vm.accelerator.ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;

public final class AcceleratorDataManagementUnit {
    private static final int REGISTER_PARTITION_ORDINAL = Memory.Partition.REGISTER.ordinal();
    private static final int LOCAL_PARTITION_ORDINAL = Memory.Partition.LOCAL.ordinal();
    private static final int GLOBAL_PARTITION_ORDINAL = Memory.Partition.GLOBAL.ordinal();
    private static final int CONSTANT_PARTITION_ORDINAL = Memory.Partition.CONSTANT.ordinal();
    private static final int STACK_PARTITION_ORDINAL = Memory.Partition.STACK.ordinal();
    private static final int NONE_PARTITION_ORDINAL = Memory.Partition.NONE.ordinal();
    private static final int PARTITION_LENGTH = Memory.Partition.values().length;
    private ScalarCache[][] caches = null;
    private boolean[][] cachingEnabled = null;
    private boolean[][] scalar = null;
    CacheSynchronizer[] synchronizers;
    private Map<Integer, boolean[]> internalFunctionAddrParamRefsMap = null;
    private int registerSize = -1;
    private int localSize = -1;
    private int globalSize = -1;
    private int constantSize = -1;
    private int stackSize = -1;
    private int noneSize = -1;

    public boolean isCachingEnabled(Memory.Partition partition, int n) {
        return this.cachingEnabled[partition.ordinal()][n];
    }

    public boolean[] getCachedFlags(Memory.Partition partition) {
        return this.cachingEnabled[partition.ordinal()];
    }

    public ScalarCache getCache(Memory.Partition partition, int n) {
        return this.caches[partition.ordinal()][n];
    }

    public ScalarCache[] getCaches(Memory.Partition partition) {
        return this.caches[partition.ordinal()];
    }

    public boolean isScalar(Memory.Partition partition, int n) {
        return this.scalar[partition.ordinal()][n];
    }

    public CacheSynchronizer getCacheSynchronizers(Memory.Partition partition) {
        return this.synchronizers[partition.ordinal()];
    }

    public void allocate(Instruction[] instructionArray, Memory memory, Interconnect interconnect, int n) {
        this.initializeFields(memory);
        this.analyzeInternalFunctionInformation(instructionArray, memory);
        this.detectScalarFromMemory(memory, Memory.Partition.CONSTANT);
        this.detectScalarFromMemory(memory, Memory.Partition.GLOBAL);
        this.detectScalarFromInstructions(instructionArray, memory, interconnect);
        if (n <= 0) {
            this.disableAllCaches();
        }
        this.initializeCacheSynchronizers(memory);
    }

    private void initializeFields(Memory memory) {
        this.registerSize = memory.getSize(Memory.Partition.REGISTER);
        this.localSize = memory.getSize(Memory.Partition.LOCAL);
        this.globalSize = memory.getSize(Memory.Partition.GLOBAL);
        this.constantSize = memory.getSize(Memory.Partition.CONSTANT);
        this.stackSize = 0;
        this.noneSize = 1;
        this.internalFunctionAddrParamRefsMap = new HashMap<Integer, boolean[]>();
        this.caches = new ScalarCache[PARTITION_LENGTH][];
        this.cachingEnabled = new boolean[PARTITION_LENGTH][];
        this.scalar = new boolean[PARTITION_LENGTH][];
        this.scalar[AcceleratorDataManagementUnit.REGISTER_PARTITION_ORDINAL] = new boolean[this.registerSize];
        this.cachingEnabled[AcceleratorDataManagementUnit.REGISTER_PARTITION_ORDINAL] = new boolean[this.registerSize];
        this.caches[AcceleratorDataManagementUnit.REGISTER_PARTITION_ORDINAL] = new ScalarCache[this.registerSize];
        this.scalar[AcceleratorDataManagementUnit.LOCAL_PARTITION_ORDINAL] = new boolean[this.localSize];
        this.cachingEnabled[AcceleratorDataManagementUnit.LOCAL_PARTITION_ORDINAL] = new boolean[this.localSize];
        this.caches[AcceleratorDataManagementUnit.LOCAL_PARTITION_ORDINAL] = new ScalarCache[this.localSize];
        this.scalar[AcceleratorDataManagementUnit.GLOBAL_PARTITION_ORDINAL] = new boolean[this.globalSize];
        this.cachingEnabled[AcceleratorDataManagementUnit.GLOBAL_PARTITION_ORDINAL] = new boolean[this.globalSize];
        this.caches[AcceleratorDataManagementUnit.GLOBAL_PARTITION_ORDINAL] = new ScalarCache[this.globalSize];
        this.scalar[AcceleratorDataManagementUnit.CONSTANT_PARTITION_ORDINAL] = new boolean[this.constantSize];
        this.cachingEnabled[AcceleratorDataManagementUnit.CONSTANT_PARTITION_ORDINAL] = new boolean[this.constantSize];
        this.caches[AcceleratorDataManagementUnit.CONSTANT_PARTITION_ORDINAL] = new ScalarCache[this.constantSize];
        this.scalar[AcceleratorDataManagementUnit.STACK_PARTITION_ORDINAL] = new boolean[this.stackSize];
        this.cachingEnabled[AcceleratorDataManagementUnit.STACK_PARTITION_ORDINAL] = new boolean[this.stackSize];
        this.caches[AcceleratorDataManagementUnit.STACK_PARTITION_ORDINAL] = new ScalarCache[this.stackSize];
        this.scalar[AcceleratorDataManagementUnit.NONE_PARTITION_ORDINAL] = new boolean[this.noneSize];
        this.cachingEnabled[AcceleratorDataManagementUnit.NONE_PARTITION_ORDINAL] = new boolean[this.noneSize];
        this.caches[AcceleratorDataManagementUnit.NONE_PARTITION_ORDINAL] = new ScalarCache[this.noneSize];
        for (int i = 0; i < PARTITION_LENGTH; ++i) {
            Arrays.fill(this.scalar[i], false);
            Arrays.fill(this.cachingEnabled[i], false);
            Arrays.fill(this.caches[i], null);
        }
        Arrays.fill(this.scalar[NONE_PARTITION_ORDINAL], true);
        Arrays.fill(this.cachingEnabled[NONE_PARTITION_ORDINAL], true);
        Arrays.fill(this.caches[NONE_PARTITION_ORDINAL], new NoneCache());
    }

    private void disableAllCaches() {
        for (int i = 0; i < PARTITION_LENGTH; ++i) {
            Arrays.fill(this.cachingEnabled[i], false);
            Arrays.fill(this.caches[i], null);
        }
    }

    private void detectScalarFromMemory(Memory memory, Memory.Partition partition) {
        int n = partition.ordinal();
        int n2 = memory.getSize(partition);
        block7: for (int i = 0; i < n2; ++i) {
            DataContainer<?> dataContainer = null;
            try {
                dataContainer = memory.getDataContainer(partition, i);
            }
            catch (VnanoFatalException vnanoFatalException) {
                throw new VnanoFatalException(vnanoFatalException);
            }
            boolean bl = this.scalar[n][i] = dataContainer.getArrayRank() == 0;
            if (!this.scalar[n][i]) continue;
            switch (dataContainer.getDataType()) {
                case INT64: {
                    this.caches[n][i] = new Int64ScalarCache();
                    this.cachingEnabled[n][i] = true;
                    continue block7;
                }
                case FLOAT64: {
                    this.caches[n][i] = new Float64ScalarCache();
                    this.cachingEnabled[n][i] = true;
                    continue block7;
                }
                case BOOL: {
                    this.caches[n][i] = new BoolScalarCache();
                    this.cachingEnabled[n][i] = true;
                    continue block7;
                }
            }
        }
    }

    private boolean isCacheableDatatype(DataType dataType) {
        return dataType == DataType.INT64 || dataType == DataType.FLOAT64 || dataType == DataType.BOOL;
    }

    private ScalarCache generateScalarCache(DataType dataType) {
        switch (dataType) {
            case INT64: {
                return new Int64ScalarCache();
            }
            case FLOAT64: {
                return new Float64ScalarCache();
            }
            case BOOL: {
                return new BoolScalarCache();
            }
        }
        throw new VnanoFatalException("Uncacheable data type: " + (Object)((Object)dataType));
    }

    private void detectScalarFromInstructions(Instruction[] instructionArray, Memory memory, Interconnect interconnect) {
        Object object;
        int[] nArray;
        Memory.Partition[] partitionArray;
        for (Instruction instruction : instructionArray) {
            partitionArray = instruction.getOperandPartitions();
            nArray = instruction.getOperandAddresses();
            if (partitionArray[0] != Memory.Partition.LOCAL && partitionArray[0] != Memory.Partition.REGISTER || instruction.getOperationCode() != OperationCode.ALLOC && instruction.getOperationCode() != OperationCode.ALLOCT || nArray.length != 1) continue;
            this.scalar[partitionArray[0].ordinal()][nArray[0]] = true;
            if (!this.isCacheableDatatype(instruction.getDataTypes()[0])) continue;
            this.cachingEnabled[partitionArray[0].ordinal()][nArray[0]] = true;
            this.caches[partitionArray[0].ordinal()][nArray[0]] = this.generateScalarCache(instruction.getDataTypes()[0]);
        }
        for (Instruction instruction : instructionArray) {
            partitionArray = instruction.getOperandPartitions();
            nArray = instruction.getOperandAddresses();
            if (partitionArray[0] != Memory.Partition.LOCAL && partitionArray[0] != Memory.Partition.REGISTER || instruction.getOperationCode() != OperationCode.ALLOCR || !this.scalar[partitionArray[1].ordinal()][nArray[1]]) continue;
            this.scalar[partitionArray[0].ordinal()][nArray[0]] = true;
            if (!this.isCacheableDatatype(instruction.getDataTypes()[0])) continue;
            this.cachingEnabled[partitionArray[0].ordinal()][nArray[0]] = true;
            this.caches[partitionArray[0].ordinal()][nArray[0]] = this.generateScalarCache(instruction.getDataTypes()[0]);
        }
        for (Instruction instruction : instructionArray) {
            partitionArray = instruction.getOperandPartitions();
            nArray = instruction.getOperandAddresses();
            if (partitionArray[0] != Memory.Partition.LOCAL && partitionArray[0] != Memory.Partition.REGISTER || instruction.getOperationCode() != OperationCode.MOVELM && instruction.getOperationCode() != OperationCode.REFELM) continue;
            this.scalar[partitionArray[0].ordinal()][nArray[0]] = true;
            if (instruction.getOperationCode() == OperationCode.REFELM) {
                this.cachingEnabled[partitionArray[0].ordinal()][nArray[0]] = false;
                continue;
            }
            if (!this.isCacheableDatatype(instruction.getDataTypes()[0])) continue;
            this.cachingEnabled[partitionArray[0].ordinal()][nArray[0]] = true;
            this.caches[partitionArray[0].ordinal()][nArray[0]] = this.generateScalarCache(instruction.getDataTypes()[0]);
        }
        for (Instruction instruction : instructionArray) {
            partitionArray = instruction.getOperandPartitions();
            nArray = instruction.getOperandAddresses();
            if (partitionArray[0] != Memory.Partition.LOCAL && partitionArray[0] != Memory.Partition.REGISTER || instruction.getOperationCode() != OperationCode.CALLX) continue;
            object = memory.getDataContainer(partitionArray[1], nArray[1]);
            int n = (int)((long[])((DataContainer)object).getArrayData())[0];
            AbstractFunction abstractFunction = interconnect.getExternalFunctionTable().getFunctionByIndex(n);
            if (abstractFunction.isReturnArrayRankArbitrary() || abstractFunction.getReturnArrayRank(new String[0], new int[0]) != 0) continue;
            this.scalar[partitionArray[0].ordinal()][nArray[0]] = true;
            if (!this.isCacheableDatatype(instruction.getDataTypes()[0])) continue;
            this.cachingEnabled[partitionArray[0].ordinal()][nArray[0]] = true;
            this.caches[partitionArray[0].ordinal()][nArray[0]] = this.generateScalarCache(instruction.getDataTypes()[0]);
        }
        block8: for (Instruction instruction : instructionArray) {
            partitionArray = instruction.getOperandPartitions();
            nArray = instruction.getOperandAddresses();
            object = instruction.getOperationCode();
            switch (1.$SwitchMap$org$vcssl$nano$spec$OperationCode[((Enum)object).ordinal()]) {
                case 1: 
                case 2: {
                    this.caches[partitionArray[0].ordinal()][nArray[0]] = null;
                    this.cachingEnabled[partitionArray[0].ordinal()][nArray[0]] = false;
                    continue block8;
                }
                case 3: 
                case 4: {
                    DataContainer<?> dataContainer = memory.getDataContainer(partitionArray[1], nArray[1]);
                    int n = (int)((long[])dataContainer.getArrayData())[0];
                    int n2 = partitionArray.length - 2;
                    boolean[] blArray = null;
                    boolean[] blArray2 = null;
                    boolean bl = false;
                    if (object == OperationCode.CALL) {
                        blArray = this.internalFunctionAddrParamRefsMap.get(n);
                        blArray2 = new boolean[n2];
                        bl = false;
                        Arrays.fill(blArray2, false);
                    } else if (object == OperationCode.CALLX) {
                        AbstractFunction abstractFunction = interconnect.getExternalFunctionTable().getFunctionByIndex(n);
                        blArray = abstractFunction.getParameterReferencenesses();
                        blArray2 = abstractFunction.getParameterConstantnesses();
                        bl = abstractFunction.isParameterCountArbitrary();
                    } else {
                        throw new VnanoFatalException("Unexpected operaton code: " + object);
                    }
                    for (int i = 0; i < n2; ++i) {
                        boolean bl2;
                        boolean bl3 = bl ? blArray[0] : blArray[i];
                        boolean bl4 = bl2 = bl ? blArray2[0] : blArray2[i];
                        if (!bl3 || bl2) continue;
                        int n3 = i + 2;
                        this.caches[partitionArray[n3].ordinal()][nArray[n3]] = null;
                        this.cachingEnabled[partitionArray[n3].ordinal()][nArray[n3]] = false;
                    }
                    continue block8;
                }
            }
        }
    }

    private void analyzeInternalFunctionInformation(Instruction[] instructionArray, Memory memory) {
        block3: for (Instruction instruction : instructionArray) {
            Memory.Partition[] partitionArray = instruction.getOperandPartitions();
            int[] nArray = instruction.getOperandAddresses();
            switch (instruction.getOperationCode()) {
                case CALL: {
                    DataContainer<?> dataContainer = memory.getDataContainer(partitionArray[1], nArray[1]);
                    int n = (int)((long[])dataContainer.getArrayData())[0];
                    int n2 = partitionArray.length - 2;
                    if (this.internalFunctionAddrParamRefsMap.containsKey(n)) continue block3;
                    List<Boolean> list = this.getInternalFunctionParameterReferencenesses(instructionArray, n, n2);
                    boolean[] blArray = new boolean[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        blArray[i] = list.get(i);
                    }
                    this.internalFunctionAddrParamRefsMap.put(n, blArray);
                    continue block3;
                }
            }
        }
    }

    private List<Boolean> getInternalFunctionParameterReferencenesses(Instruction[] instructionArray, int n, int n2) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        if (n2 == 0) {
            return arrayList;
        }
        int n3 = instructionArray.length;
        block5: for (int i = n; i < n3; ++i) {
            switch (instructionArray[i].getOperationCode()) {
                case POP: 
                case MOVPOP: {
                    arrayList.add(Boolean.FALSE);
                    if (arrayList.size() != n2) continue block5;
                    return arrayList;
                }
                case REFPOP: {
                    arrayList.add(Boolean.TRUE);
                    if (arrayList.size() != n2) continue block5;
                    return arrayList;
                }
                case ENDFUN: {
                    throw new VnanoFatalException("Number of parameters is deficient.");
                }
            }
        }
        throw new VnanoFatalException("No ENDFUN instruction found for the function beginning from the instruction address: " + n);
    }

    private void initializeCacheSynchronizers(Memory memory) {
        DataContainer<?>[] dataContainerArray = memory.getDataContainers(Memory.Partition.REGISTER);
        DataContainer<?>[] dataContainerArray2 = memory.getDataContainers(Memory.Partition.LOCAL);
        DataContainer<?>[] dataContainerArray3 = memory.getDataContainers(Memory.Partition.GLOBAL);
        DataContainer<?>[] dataContainerArray4 = memory.getDataContainers(Memory.Partition.CONSTANT);
        this.synchronizers = new CacheSynchronizer[PARTITION_LENGTH];
        this.synchronizers[AcceleratorDataManagementUnit.REGISTER_PARTITION_ORDINAL] = new GeneralScalarCacheSynchronizer(dataContainerArray, this.getCaches(Memory.Partition.REGISTER), this.getCachedFlags(Memory.Partition.REGISTER));
        this.synchronizers[AcceleratorDataManagementUnit.LOCAL_PARTITION_ORDINAL] = new GeneralScalarCacheSynchronizer(dataContainerArray2, this.getCaches(Memory.Partition.LOCAL), this.getCachedFlags(Memory.Partition.LOCAL));
        this.synchronizers[AcceleratorDataManagementUnit.GLOBAL_PARTITION_ORDINAL] = new GeneralScalarCacheSynchronizer(dataContainerArray3, this.getCaches(Memory.Partition.GLOBAL), this.getCachedFlags(Memory.Partition.GLOBAL));
        this.synchronizers[AcceleratorDataManagementUnit.CONSTANT_PARTITION_ORDINAL] = new GeneralScalarCacheSynchronizer(dataContainerArray4, this.getCaches(Memory.Partition.CONSTANT), this.getCachedFlags(Memory.Partition.CONSTANT));
    }
}

