/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.ArrayList;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.MetaInformationSyntax;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorDataManagementUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionType;
import org.vcssl.nano.vm.accelerator.AcceleratorExtendedOperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.BoolCachedScalarBranchUnit;
import org.vcssl.nano.vm.accelerator.BoolCachedScalarLogicalUnit;
import org.vcssl.nano.vm.accelerator.BoolCachedScalarMultipleTransferUnit;
import org.vcssl.nano.vm.accelerator.BoolCachedScalarSubscriptUnit;
import org.vcssl.nano.vm.accelerator.BoolCachedScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.BoolMemoryAllocationUnit;
import org.vcssl.nano.vm.accelerator.BoolScalarBranchUnit;
import org.vcssl.nano.vm.accelerator.BoolScalarLogicalUnit;
import org.vcssl.nano.vm.accelerator.BoolScalarSubscriptUnit;
import org.vcssl.nano.vm.accelerator.BoolScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.BoolScalarVectorTransferUnit;
import org.vcssl.nano.vm.accelerator.BoolVectorBranchUnit;
import org.vcssl.nano.vm.accelerator.BoolVectorLogicalUnit;
import org.vcssl.nano.vm.accelerator.BoolVectorScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.BoolVectorTransferUnit;
import org.vcssl.nano.vm.accelerator.BypassUnit;
import org.vcssl.nano.vm.accelerator.ExternalFunctionControlUnit;
import org.vcssl.nano.vm.accelerator.Float64CachedScalarArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Float64CachedScalarComparisonUnit;
import org.vcssl.nano.vm.accelerator.Float64CachedScalarDualArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Float64CachedScalarMultipleTransferUnit;
import org.vcssl.nano.vm.accelerator.Float64CachedScalarSubscriptUnit;
import org.vcssl.nano.vm.accelerator.Float64CachedScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.Float64MemoryAllocationUnit;
import org.vcssl.nano.vm.accelerator.Float64ScalarArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Float64ScalarComparisonUnit;
import org.vcssl.nano.vm.accelerator.Float64ScalarSubscriptUnit;
import org.vcssl.nano.vm.accelerator.Float64ScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.Float64ScalarVectorTransferUnit;
import org.vcssl.nano.vm.accelerator.Float64VectorArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Float64VectorComparisonUnit;
import org.vcssl.nano.vm.accelerator.Float64VectorDualArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Float64VectorScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.Float64VectorTransferUnit;
import org.vcssl.nano.vm.accelerator.Int64CachedScalarArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Int64CachedScalarComparisonUnit;
import org.vcssl.nano.vm.accelerator.Int64CachedScalarDualArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Int64CachedScalarMultipleTransferUnit;
import org.vcssl.nano.vm.accelerator.Int64CachedScalarSubscriptUnit;
import org.vcssl.nano.vm.accelerator.Int64CachedScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.Int64MemoryAllocationUnit;
import org.vcssl.nano.vm.accelerator.Int64ScalarArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Int64ScalarComparisonUnit;
import org.vcssl.nano.vm.accelerator.Int64ScalarSubscriptUnit;
import org.vcssl.nano.vm.accelerator.Int64ScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.Int64ScalarVectorTransferUnit;
import org.vcssl.nano.vm.accelerator.Int64VectorArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Int64VectorComparisonUnit;
import org.vcssl.nano.vm.accelerator.Int64VectorDualArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Int64VectorScalarTransferUnit;
import org.vcssl.nano.vm.accelerator.Int64VectorTransferUnit;
import org.vcssl.nano.vm.accelerator.InternalFunctionControlUnit;
import org.vcssl.nano.vm.accelerator.NopUnit;
import org.vcssl.nano.vm.accelerator.ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Processor;

public class AcceleratorDispatchUnit {
    public AcceleratorExecutionNode[] dispatch(Processor processor, Memory memory, Interconnect interconnect, AcceleratorInstruction[] acceleratorInstructionArray, AcceleratorDataManagementUnit acceleratorDataManagementUnit, BypassUnit bypassUnit, InternalFunctionControlUnit internalFunctionControlUnit, ExternalFunctionControlUnit externalFunctionControlUnit) throws VnanoException {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        AcceleratorInstruction acceleratorInstruction;
        int n2;
        int n3 = acceleratorInstructionArray.length;
        AcceleratorExecutionNode[] acceleratorExecutionNodeArray = new AcceleratorExecutionNode[n3];
        AcceleratorExecutionNode acceleratorExecutionNode = null;
        for (n2 = n3 - 1; 0 <= n2; --n2) {
            Object object5;
            acceleratorInstruction = acceleratorInstructionArray[n2];
            try {
                object4 = acceleratorInstructionArray[n2].getOperandPartitions();
                object3 = acceleratorInstructionArray[n2].getOperandAddresses();
                n = ((int[])object3).length;
                DataContainer[] dataContainerArray = new DataContainer[n];
                for (int i = 0; i < n; ++i) {
                    dataContainerArray[i] = memory.getDataContainer(object4[i], object3[i]);
                }
                object5 = new boolean[n];
                object2 = new boolean[n];
                object = new boolean[n];
                ScalarCache[] scalarCacheArray = new ScalarCache[n];
                for (int i = 0; i < n; ++i) {
                    object2[i] = acceleratorDataManagementUnit.isScalar(object4[i], (int)object3[i]);
                    object[i] = acceleratorDataManagementUnit.isCachingEnabled(object4[i], (int)object3[i]);
                    if (object[i]) {
                        scalarCacheArray[i] = acceleratorDataManagementUnit.getCache(object4[i], (int)object3[i]);
                    }
                    if (object4[i] != Memory.Partition.CONSTANT) continue;
                    object5[i] = true;
                }
                AcceleratorExecutionNode acceleratorExecutionNode2 = null;
                acceleratorExecutionNode2 = this.dispatchToAcceleratorExecutionUnit(acceleratorInstruction, dataContainerArray, scalarCacheArray, (boolean[])object, (boolean[])object2, (boolean[])object5, bypassUnit, internalFunctionControlUnit, externalFunctionControlUnit, acceleratorExecutionNode);
                acceleratorExecutionNode2.setSourceInstruction(acceleratorInstruction);
                acceleratorExecutionNodeArray[n2] = acceleratorExecutionNode2;
                acceleratorExecutionNode = acceleratorExecutionNode2;
                continue;
            }
            catch (Exception exception) {
                int n4 = acceleratorInstruction.getUnreorderedAddress();
                n = acceleratorInstruction.getReorderedAddress();
                int n5 = MetaInformationSyntax.extractLineNumber(acceleratorInstruction, memory);
                object5 = MetaInformationSyntax.extractFileName(acceleratorInstruction, memory);
                object2 = new String[]{Integer.toString(n4), Integer.toString(n), acceleratorInstruction.toString()};
                throw new VnanoException(ErrorType.UNEXPECTED_ACCELERATOR_CRASH, (String[])object2, exception, (String)object5, n5);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl;
            acceleratorInstruction = acceleratorInstructionArray[n2];
            object4 = acceleratorInstruction.getOperationCode();
            object3 = acceleratorInstruction.isFused() ? acceleratorInstruction.getFusedOperationCodes() : null;
            n = object4 == OperationCode.JMP || object4 == OperationCode.JMPN || object4 == OperationCode.CALL || object4 == OperationCode.RET ? 1 : 0;
            boolean bl2 = bl = acceleratorInstruction.isFused() && (object3[1] == OperationCode.JMP || object3[1] == OperationCode.JMPN);
            if (n == 0 && !bl) continue;
            int n6 = acceleratorInstruction.getReorderedLabelAddress();
            acceleratorExecutionNodeArray[n2].setLaundingPointNodes(acceleratorExecutionNodeArray[n6]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            acceleratorInstruction = acceleratorInstructionArray[n2];
            object4 = acceleratorInstruction.getOperationCode();
            if (object4 != OperationCode.JMP && object4 != OperationCode.JMPN || n2 == 0 || n2 == n3 - 1 || acceleratorInstruction.getOperandPartitions()[2] != Memory.Partition.CONSTANT) continue;
            object3 = memory.getDataContainer(acceleratorInstruction.getOperandPartitions()[2], acceleratorInstruction.getOperandAddresses()[2]);
            n = ((boolean[])((DataContainer)object3).getArrayData())[((DataContainer)object3).getArrayOffset()];
            AcceleratorExecutionNode acceleratorExecutionNode3 = acceleratorExecutionNodeArray[n2 - 1];
            AcceleratorExecutionNode acceleratorExecutionNode4 = acceleratorExecutionNodeArray[n2 + 1];
            object2 = acceleratorExecutionNodeArray[n2];
            object = ((AcceleratorExecutionNode)object2).getLaundingPointNodes()[0];
            if (object4 == OperationCode.JMP && n == 1) {
                acceleratorExecutionNode3.setNextNode((AcceleratorExecutionNode)object);
                continue;
            }
            if (object4 == OperationCode.JMP && n == 0) {
                acceleratorExecutionNode3.setNextNode(acceleratorExecutionNode4);
                continue;
            }
            if (object4 == OperationCode.JMPN && n == 0) {
                acceleratorExecutionNode3.setNextNode((AcceleratorExecutionNode)object);
                continue;
            }
            if (object4 == OperationCode.JMPN && n == 1) {
                acceleratorExecutionNode3.setNextNode(acceleratorExecutionNode4);
                continue;
            }
            throw new VnanoFatalException("Unexpected case detected.");
        }
        return acceleratorExecutionNodeArray;
    }

    private AcceleratorExecutionNode dispatchToAcceleratorExecutionUnit(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, ScalarCache[] scalarCacheArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, BypassUnit bypassUnit, InternalFunctionControlUnit internalFunctionControlUnit, ExternalFunctionControlUnit externalFunctionControlUnit, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionType acceleratorExecutionType = acceleratorInstruction.getAccelerationType();
        switch (acceleratorExecutionType) {
            case I64_ALLOC: {
                return new Int64MemoryAllocationUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64_ALLOC: {
                return new Float64MemoryAllocationUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case B_ALLOC: {
                return new BoolMemoryAllocationUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64V_ARITHMETIC: {
                return new Int64VectorArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64S_ARITHMETIC: {
                return new Int64ScalarArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64CS_ARITHMETIC: {
                return new Int64CachedScalarArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64V_DUAL_ARITHMETIC: {
                return new Int64VectorDualArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64CS_DUAL_ARITHMETIC: {
                return new Int64CachedScalarDualArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64V_ARITHMETIC: {
                return new Float64VectorArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64S_ARITHMETIC: {
                return new Float64ScalarArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64CS_ARITHMETIC: {
                return new Float64CachedScalarArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64V_DUAL_ARITHMETIC: {
                return new Float64VectorDualArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64CS_DUAL_ARITHMETIC: {
                return new Float64CachedScalarDualArithmeticUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64V_COMPARISON: {
                return new Int64VectorComparisonUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64S_COMPARISON: {
                return new Int64ScalarComparisonUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64CS_COMPARISON: {
                return new Int64CachedScalarComparisonUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64V_COMPARISON: {
                return new Float64VectorComparisonUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64S_COMPARISON: {
                return new Float64ScalarComparisonUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64CS_COMPARISON: {
                return new Float64CachedScalarComparisonUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BV_LOGICAL: {
                return new BoolVectorLogicalUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BS_LOGICAL: {
                return new BoolScalarLogicalUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BCS_LOGICAL: {
                return new BoolCachedScalarLogicalUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64V_TRANSFER: {
                return new Int64VectorTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64S_TRANSFER: {
                return new Int64ScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64CS_TRANSFER: {
                return new Int64CachedScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64VS_TRANSFER: {
                return new Int64VectorScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64SV_TRANSFER: {
                return new Int64ScalarVectorTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64CS_MULTIPLE_TRANSFER: {
                return new Int64CachedScalarMultipleTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64V_TRANSFER: {
                return new Float64VectorTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64S_TRANSFER: {
                return new Float64ScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64CS_TRANSFER: {
                return new Float64CachedScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64VS_TRANSFER: {
                return new Float64VectorScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64SV_TRANSFER: {
                return new Float64ScalarVectorTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64CS_MULTIPLE_TRANSFER: {
                return new Float64CachedScalarMultipleTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BV_TRANSFER: {
                return new BoolVectorTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BS_TRANSFER: {
                return new BoolScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BCS_TRANSFER: {
                return new BoolCachedScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BVS_TRANSFER: {
                return new BoolVectorScalarTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BSV_TRANSFER: {
                return new BoolScalarVectorTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BCS_MULTIPLE_TRANSFER: {
                return new BoolCachedScalarMultipleTransferUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64S_SUBSCRIPT: {
                return new Int64ScalarSubscriptUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case I64CS_SUBSCRIPT: {
                return new Int64CachedScalarSubscriptUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64S_SUBSCRIPT: {
                return new Float64ScalarSubscriptUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case F64CS_SUBSCRIPT: {
                return new Float64CachedScalarSubscriptUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BS_SUBSCRIPT: {
                return new BoolScalarSubscriptUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BCS_SUBSCRIPT: {
                return new BoolCachedScalarSubscriptUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BV_BRANCH: {
                return new BoolVectorBranchUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BS_BRANCH: {
                return new BoolScalarBranchUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BCS_BRANCH: {
                return new BoolCachedScalarBranchUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case NOP: {
                return new NopUnit().generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case INTERNAL_FUNCTION_CONTROL: {
                return internalFunctionControlUnit.generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case EXTERNAL_FUNCTION_CONTROL: {
                return externalFunctionControlUnit.generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
            case BYPASS: {
                return bypassUnit.generateNode(acceleratorInstruction, dataContainerArray, scalarCacheArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
            }
        }
        throw new VnanoFatalException("Unknown acceleration type detected: " + (Object)((Object)acceleratorExecutionType));
    }

    private boolean isAllCached(boolean[] blArray) {
        for (boolean bl : blArray) {
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean isAllScalar(boolean[] blArray) {
        for (boolean bl : blArray) {
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean isAllVector(boolean[] blArray) {
        for (boolean bl : blArray) {
            if (!bl) continue;
            return false;
        }
        return true;
    }

    public AcceleratorInstruction[] preDispatch(AcceleratorInstruction[] acceleratorInstructionArray, Memory memory, AcceleratorDataManagementUnit acceleratorDataManagementUnit) {
        ArrayList<AcceleratorInstruction> arrayList = new ArrayList<AcceleratorInstruction>();
        block14: for (AcceleratorInstruction acceleratorInstruction : acceleratorInstructionArray) {
            int n;
            acceleratorInstruction = acceleratorInstruction.clone();
            arrayList.add(acceleratorInstruction);
            DataType[] dataTypeArray = acceleratorInstruction.getDataTypes();
            OperationCode operationCode = acceleratorInstruction.getOperationCode();
            Memory.Partition[] partitionArray = acceleratorInstruction.getOperandPartitions();
            int[] nArray = acceleratorInstruction.getOperandAddresses();
            int n2 = acceleratorInstruction.getOperandLength();
            DataContainer[] dataContainerArray = new DataContainer[n2];
            for (int i = 0; i < n2; ++i) {
                dataContainerArray[i] = memory.getDataContainer(partitionArray[i], nArray[i]);
            }
            boolean[] blArray = new boolean[n2];
            boolean[] blArray2 = new boolean[n2];
            boolean[] blArray3 = new boolean[n2];
            ScalarCache[] scalarCacheArray = new ScalarCache[n2];
            for (n = 0; n < n2; ++n) {
                blArray2[n] = acceleratorDataManagementUnit.isScalar(partitionArray[n], nArray[n]);
                blArray3[n] = acceleratorDataManagementUnit.isCachingEnabled(partitionArray[n], nArray[n]);
                if (blArray3[n]) {
                    scalarCacheArray[n] = acceleratorDataManagementUnit.getCache(partitionArray[n], nArray[n]);
                }
                if (partitionArray[n] != Memory.Partition.CONSTANT) continue;
                blArray[n] = true;
            }
            switch (operationCode) {
                case ALLOC: 
                case ALLOCR: {
                    if (dataTypeArray[0] == DataType.INT64) {
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64_ALLOC);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.FLOAT64) {
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64_ALLOC);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.BOOL) {
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.B_ALLOC);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case REM: 
                case NEG: {
                    if (dataTypeArray[0] == DataType.INT64) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64V_ARITHMETIC);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64CS_ARITHMETIC);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64S_ARITHMETIC);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.FLOAT64) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64V_ARITHMETIC);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64CS_ARITHMETIC);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64S_ARITHMETIC);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case LT: 
                case GT: 
                case LEQ: 
                case GEQ: 
                case EQ: 
                case NEQ: {
                    if (dataTypeArray[0] == DataType.INT64) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64V_COMPARISON);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64CS_COMPARISON);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64S_COMPARISON);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.FLOAT64) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64V_COMPARISON);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64CS_COMPARISON);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64S_COMPARISON);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case ANDM: 
                case ORM: 
                case NOT: {
                    if (dataTypeArray[0] == DataType.BOOL) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BV_LOGICAL);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BCS_LOGICAL);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BS_LOGICAL);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case MOV: 
                case FILL: {
                    if (dataTypeArray[0] == DataType.INT64) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64V_TRANSFER);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64CS_TRANSFER);
                            continue block14;
                        }
                        if (!blArray2[0] && blArray2[1]) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64VS_TRANSFER);
                            continue block14;
                        }
                        if (blArray2[0] && !blArray2[1]) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64SV_TRANSFER);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64S_TRANSFER);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.FLOAT64) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64V_TRANSFER);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64CS_TRANSFER);
                            continue block14;
                        }
                        if (!blArray2[0] && blArray2[1]) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64VS_TRANSFER);
                            continue block14;
                        }
                        if (blArray2[0] && !blArray2[1]) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64SV_TRANSFER);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64S_TRANSFER);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.BOOL) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BV_TRANSFER);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BCS_TRANSFER);
                            continue block14;
                        }
                        if (!blArray2[0] && blArray2[1]) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BVS_TRANSFER);
                            continue block14;
                        }
                        if (blArray2[0] && !blArray2[1]) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BSV_TRANSFER);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BS_TRANSFER);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case MOVELM: 
                case REFELM: {
                    n = n2 - 2;
                    boolean bl = true;
                    for (int i = 0; i < n; ++i) {
                        bl &= blArray3[i + 2];
                    }
                    if (dataTypeArray[0] == DataType.INT64) {
                        if (bl && n <= 3) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64CS_SUBSCRIPT);
                            continue block14;
                        }
                        if (n <= 3) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64S_SUBSCRIPT);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.FLOAT64) {
                        if (bl && n <= 3) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64CS_SUBSCRIPT);
                            continue block14;
                        }
                        if (n <= 3) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64S_SUBSCRIPT);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.BOOL) {
                        if (bl && n <= 3) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BCS_SUBSCRIPT);
                            continue block14;
                        }
                        if (n <= 3) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BS_SUBSCRIPT);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case CAST: {
                    if (dataTypeArray[0] == DataType.INT64 && (dataTypeArray[1] == DataType.INT64 || dataTypeArray[1] == DataType.FLOAT64)) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64V_TRANSFER);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64CS_TRANSFER);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.I64S_TRANSFER);
                        continue block14;
                    }
                    if (dataTypeArray[0] == DataType.FLOAT64 && (dataTypeArray[1] == DataType.INT64 || dataTypeArray[1] == DataType.FLOAT64)) {
                        if (this.isAllVector(blArray2)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64V_TRANSFER);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64CS_TRANSFER);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.F64S_TRANSFER);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case JMP: 
                case JMPN: {
                    if (dataTypeArray[0] == DataType.BOOL) {
                        if (!blArray2[2]) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BV_BRANCH);
                            continue block14;
                        }
                        if (this.isAllScalar(blArray2) && this.isAllCached(blArray3)) {
                            acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BCS_BRANCH);
                            continue block14;
                        }
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BS_BRANCH);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case CALL: 
                case RET: 
                case POP: 
                case MOVPOP: 
                case REFPOP: 
                case ALLOCP: {
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.INTERNAL_FUNCTION_CONTROL);
                    continue block14;
                }
                case EX: {
                    if (acceleratorInstruction.getAccelerationType() != null) continue block14;
                    if (acceleratorInstruction.getExtendedOperationCode() == AcceleratorExtendedOperationCode.RETURNED) {
                        acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.INTERNAL_FUNCTION_CONTROL);
                        continue block14;
                    }
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                    continue block14;
                }
                case CALLX: {
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.EXTERNAL_FUNCTION_CONTROL);
                    continue block14;
                }
                case NOP: 
                case LABEL: 
                case ALLOCT: {
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.NOP);
                    continue block14;
                }
                default: {
                    acceleratorInstruction.setAccelerationType(AcceleratorExecutionType.BYPASS);
                }
            }
        }
        return arrayList.toArray(new AcceleratorInstruction[0]);
    }
}

