/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionType;
import org.vcssl.nano.vm.accelerator.AcceleratorExtendedOperationCode;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;

public class AcceleratorInstruction
extends Instruction
implements Cloneable {
    private AcceleratorExecutionType acceleratorExecutionType = null;
    private int reorderedAddress = -1;
    private int unreorderedAddress = -1;
    private int reorderedLabelAddress = -1;
    private int expandedAddress = -1;
    private int expandedLabelAddress = -1;
    private OperationCode[] fusedOperationCodes = null;
    private int[] fusedInputOperandIndices = null;
    private AcceleratorExtendedOperationCode extendedOperationCode = null;

    @Override
    public AcceleratorInstruction clone() {
        int n;
        Instruction instruction = super.clone();
        AcceleratorInstruction acceleratorInstruction = new AcceleratorInstruction(instruction);
        acceleratorInstruction.acceleratorExecutionType = this.acceleratorExecutionType;
        acceleratorInstruction.reorderedAddress = this.reorderedAddress;
        acceleratorInstruction.unreorderedAddress = this.unreorderedAddress;
        acceleratorInstruction.expandedAddress = this.expandedAddress;
        acceleratorInstruction.reorderedLabelAddress = this.reorderedLabelAddress;
        acceleratorInstruction.expandedLabelAddress = this.expandedLabelAddress;
        acceleratorInstruction.extendedOperationCode = this.extendedOperationCode;
        if (this.fusedOperationCodes != null) {
            n = this.fusedOperationCodes.length;
            acceleratorInstruction.fusedOperationCodes = new OperationCode[n];
            System.arraycopy(this.fusedOperationCodes, 0, acceleratorInstruction.fusedOperationCodes, 0, n);
        }
        if (this.fusedInputOperandIndices != null) {
            n = this.fusedInputOperandIndices.length;
            acceleratorInstruction.fusedInputOperandIndices = new int[n];
            System.arraycopy(this.fusedInputOperandIndices, 0, acceleratorInstruction.fusedInputOperandIndices, 0, n);
        }
        return acceleratorInstruction;
    }

    public AcceleratorInstruction(Instruction instruction) {
        super(instruction.getOperationCode(), instruction.getDataTypes(), instruction.getOperandPartitions(), instruction.getOperandAddresses(), instruction.getMetaPartition(), instruction.getMetaAddress());
    }

    public AcceleratorInstruction(Instruction instruction, int n) {
        this(instruction);
        this.unreorderedAddress = n;
    }

    public AcceleratorInstruction(AcceleratorInstruction acceleratorInstruction, Memory.Partition[] partitionArray, int[] nArray) {
        super(acceleratorInstruction.getOperationCode(), acceleratorInstruction.getDataTypes(), partitionArray, nArray, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress());
        this.acceleratorExecutionType = acceleratorInstruction.acceleratorExecutionType;
        this.fusedOperationCodes = acceleratorInstruction.fusedOperationCodes;
        this.reorderedAddress = acceleratorInstruction.reorderedAddress;
        this.unreorderedAddress = acceleratorInstruction.unreorderedAddress;
        this.expandedAddress = acceleratorInstruction.expandedAddress;
        this.reorderedLabelAddress = acceleratorInstruction.reorderedLabelAddress;
        this.expandedLabelAddress = acceleratorInstruction.expandedLabelAddress;
    }

    public AcceleratorInstruction(AcceleratorInstruction acceleratorInstruction, OperationCode operationCode, Memory.Partition[] partitionArray, int[] nArray) {
        super(operationCode, acceleratorInstruction.getDataTypes(), partitionArray, nArray, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress());
        this.acceleratorExecutionType = acceleratorInstruction.acceleratorExecutionType;
        this.fusedOperationCodes = acceleratorInstruction.fusedOperationCodes;
        this.reorderedAddress = acceleratorInstruction.reorderedAddress;
        this.unreorderedAddress = acceleratorInstruction.unreorderedAddress;
        this.expandedAddress = acceleratorInstruction.expandedAddress;
        this.reorderedLabelAddress = acceleratorInstruction.reorderedLabelAddress;
        this.expandedLabelAddress = acceleratorInstruction.expandedLabelAddress;
    }

    public AcceleratorInstruction fuse(AcceleratorInstruction acceleratorInstruction, AcceleratorExecutionType acceleratorExecutionType) {
        int n = this.getOperandLength();
        int n2 = acceleratorInstruction.getOperandLength();
        Memory.Partition[] partitionArray = this.getOperandPartitions();
        Memory.Partition[] partitionArray2 = acceleratorInstruction.getOperandPartitions();
        int[] nArray = this.getOperandAddresses();
        int[] nArray2 = acceleratorInstruction.getOperandAddresses();
        int n3 = n + n2;
        Memory.Partition[] partitionArray3 = new Memory.Partition[n3];
        System.arraycopy(partitionArray, 0, partitionArray3, 0, n);
        System.arraycopy(partitionArray2, 0, partitionArray3, n, n2);
        int[] nArray3 = new int[n3];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray3, n, n2);
        OperationCode[] operationCodeArray = null;
        if (this.fusedOperationCodes == null) {
            operationCodeArray = new OperationCode[]{this.getOperationCode(), acceleratorInstruction.getOperationCode()};
        } else {
            int n4 = this.fusedOperationCodes.length;
            OperationCode[] operationCodeArray2 = new OperationCode[n4];
            System.arraycopy(this.fusedOperationCodes, 0, operationCodeArray2, 0, n4);
            operationCodeArray = new OperationCode[n4 + 1];
            System.arraycopy(operationCodeArray2, 0, operationCodeArray, 0, n4);
            operationCodeArray[n4] = acceleratorInstruction.getOperationCode();
        }
        AcceleratorInstruction acceleratorInstruction2 = new AcceleratorInstruction(this, OperationCode.EX, partitionArray3, nArray3);
        acceleratorInstruction2.setFusedOperationCodes(operationCodeArray);
        acceleratorInstruction2.setAccelerationType(acceleratorExecutionType);
        acceleratorInstruction2.reorderedAddress = this.reorderedAddress;
        acceleratorInstruction2.unreorderedAddress = this.unreorderedAddress;
        acceleratorInstruction2.reorderedLabelAddress = this.reorderedLabelAddress;
        acceleratorInstruction2.expandedAddress = this.reorderedLabelAddress;
        acceleratorInstruction2.expandedLabelAddress = this.expandedLabelAddress;
        return acceleratorInstruction2;
    }

    public boolean isFused() {
        return this.fusedOperationCodes != null;
    }

    public void setFusedOperationCodes(OperationCode operationCode) {
        this.fusedOperationCodes = new OperationCode[]{operationCode};
    }

    public void setFusedOperationCodes(OperationCode[] operationCodeArray) {
        this.fusedOperationCodes = operationCodeArray;
    }

    public OperationCode[] getFusedOperationCodes() {
        return this.fusedOperationCodes;
    }

    public void setFusedInputOperandIndices(int[] nArray) {
        this.fusedInputOperandIndices = nArray;
    }

    public int[] getFusedInputOperandIndices() {
        return this.fusedInputOperandIndices;
    }

    public void setAccelerationType(AcceleratorExecutionType acceleratorExecutionType) {
        this.acceleratorExecutionType = acceleratorExecutionType;
    }

    public AcceleratorExecutionType getAccelerationType() {
        return this.acceleratorExecutionType;
    }

    public void setExtendedOperationCode(AcceleratorExtendedOperationCode acceleratorExtendedOperationCode) {
        this.extendedOperationCode = acceleratorExtendedOperationCode;
    }

    public AcceleratorExtendedOperationCode getExtendedOperationCode() {
        return this.extendedOperationCode;
    }

    public void setReorderedAddress(int n) {
        this.reorderedAddress = n;
    }

    public int getReorderedAddress() {
        return this.reorderedAddress;
    }

    public void setUnreorderedAddress(int n) {
        this.unreorderedAddress = n;
    }

    public int getUnreorderedAddress() {
        return this.unreorderedAddress;
    }

    public void setExpandedAddress(int n) {
        this.expandedAddress = n;
    }

    public int getExpandedAddress() {
        return this.expandedAddress;
    }

    public boolean isExpanded() {
        return this.expandedAddress != -1;
    }

    public void setReorderedLabelAddress(int n) {
        this.reorderedLabelAddress = n;
    }

    public int getReorderedLabelAddress() {
        return this.reorderedLabelAddress;
    }

    public boolean isLabelAddressReordered() {
        return this.reorderedLabelAddress != -1;
    }

    public void setExpandedLabelAddress(int n) {
        this.expandedLabelAddress = n;
    }

    public int getExpandedLabelAddress() {
        return this.expandedLabelAddress;
    }

    public boolean isLabelAddressExpanded() {
        return this.expandedLabelAddress != -1;
    }

    @Override
    public String toString() {
        boolean bl;
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        stringBuilder.append((Object)this.getOperationCode());
        stringBuilder.append("\t");
        int n3 = this.getDataTypes().length;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append((Object)this.getDataTypes()[n2]);
            if (n2 == n3 - 1) continue;
            stringBuilder.append(":");
        }
        stringBuilder.append("\t");
        n2 = this.getOperandAddresses().length;
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(this.getOperandPartitions()[n].toString().charAt(0));
            stringBuilder.append(this.getOperandAddresses()[n]);
            stringBuilder.append("\t");
        }
        stringBuilder.append(this.getMetaPartition().toString().charAt(0));
        stringBuilder.append(this.getMetaAddress());
        if (this.acceleratorExecutionType != null) {
            stringBuilder.append("\t");
            stringBuilder.append((Object)this.getAccelerationType());
            if (this.isFused()) {
                stringBuilder.append("(");
                for (n = 0; n < this.fusedOperationCodes.length; ++n) {
                    stringBuilder.append((Object)this.fusedOperationCodes[n]);
                    if (n == this.fusedOperationCodes.length - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(")");
            }
        }
        n = this.getOperationCode() == OperationCode.JMP || this.getOperationCode() == OperationCode.JMPN ? 1 : 0;
        boolean bl2 = bl = this.isFused() && (this.fusedOperationCodes[1] == OperationCode.JMP || this.fusedOperationCodes[1] == OperationCode.JMPN);
        if (n != 0 || bl) {
            stringBuilder.append(" (reorderedLabelAddress=" + this.reorderedLabelAddress + ")");
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

