/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.BoolScalarCache;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolCachedScalarBranchUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        switch (acceleratorInstruction.getOperationCode()) {
            case JMP: {
                if (blArray3[2]) {
                    boolean bl = ((boolean[])dataContainerArray[2].getArrayData())[0];
                    if (bl) {
                        return new CachedScalarUnconditionalJmpNode(acceleratorExecutionNode);
                    }
                    return new CachedScalarUnconditionalNeverJmpNode(acceleratorExecutionNode);
                }
                return new CachedScalarJmpNode((BoolScalarCache)objectArray[2], acceleratorExecutionNode);
            }
            case JMPN: {
                if (blArray3[2]) {
                    boolean bl = ((boolean[])dataContainerArray[2].getArrayData())[0];
                    if (bl) {
                        return new CachedScalarUnconditionalNeverJmpNode(acceleratorExecutionNode);
                    }
                    return new CachedScalarUnconditionalJmpNode(acceleratorExecutionNode);
                }
                return new CachedScalarJmpnNode((BoolScalarCache)objectArray[2], acceleratorExecutionNode);
            }
            case EX: {
                DataType dataType = acceleratorInstruction.getDataTypes()[0];
                OperationCode operationCode = acceleratorInstruction.getFusedOperationCodes()[0];
                OperationCode operationCode2 = acceleratorInstruction.getFusedOperationCodes()[1];
                if (operationCode2 == OperationCode.JMP) {
                    if (dataType == DataType.INT64) {
                        return this.generateInt64CachedScalarComparisonJmpNode(operationCode, (BoolScalarCache)objectArray[0], (Int64ScalarCache)objectArray[1], (Int64ScalarCache)objectArray[2], acceleratorExecutionNode);
                    }
                    if (dataType == DataType.FLOAT64) {
                        return this.generateFloat64CachedScalarComparisonJmpNode(operationCode, (BoolScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], acceleratorExecutionNode);
                    }
                    throw new VnanoFatalException("Invalid data type for fused comparison-branch operation: " + (Object)((Object)dataType));
                }
                if (operationCode2 == OperationCode.JMPN) {
                    if (dataType == DataType.INT64) {
                        return this.generateInt64CachedScalarComparisonJmpnNode(operationCode, (BoolScalarCache)objectArray[0], (Int64ScalarCache)objectArray[1], (Int64ScalarCache)objectArray[2], acceleratorExecutionNode);
                    }
                    if (dataType == DataType.FLOAT64) {
                        return this.generateFloat64CachedScalarComparisonJmpnNode(operationCode, (BoolScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], acceleratorExecutionNode);
                    }
                    throw new VnanoFatalException("Invalid data type for fused comparison-branch operation: " + (Object)((Object)dataType));
                }
                throw new VnanoFatalException("Invalid fused branch operation code: " + (Object)((Object)operationCode2));
            }
        }
        throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
    }

    private AcceleratorExecutionNode generateInt64CachedScalarComparisonJmpNode(OperationCode operationCode, BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
        switch (operationCode) {
            case LT: {
                return new Int64CachedScalarLtJmpNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case LEQ: {
                return new Int64CachedScalarLeqJmpNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case GT: {
                return new Int64CachedScalarGtJmpNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case GEQ: {
                return new Int64CachedScalarGeqJmpNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case EQ: {
                return new Int64CachedScalarEqJmpNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case NEQ: {
                return new Int64CachedScalarNeqJmpNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
        }
        throw new VnanoFatalException("Unexpected comparison operation code: " + (Object)((Object)operationCode));
    }

    private AcceleratorExecutionNode generateFloat64CachedScalarComparisonJmpNode(OperationCode operationCode, BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
        switch (operationCode) {
            case LT: {
                return new Float64CachedScalarLtJmpNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case LEQ: {
                return new Float64CachedScalarLeqJmpNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case GT: {
                return new Float64CachedScalarGtJmpNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case GEQ: {
                return new Float64CachedScalarGeqJmpNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case EQ: {
                return new Float64CachedScalarEqJmpNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case NEQ: {
                return new Float64CachedScalarNeqJmpNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
        }
        throw new VnanoFatalException("Unexpected comparison operation code: " + (Object)((Object)operationCode));
    }

    private AcceleratorExecutionNode generateInt64CachedScalarComparisonJmpnNode(OperationCode operationCode, BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
        switch (operationCode) {
            case LT: {
                return new Int64CachedScalarLtJmpnNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case LEQ: {
                return new Int64CachedScalarLeqJmpnNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case GT: {
                return new Int64CachedScalarGtJmpnNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case GEQ: {
                return new Int64CachedScalarGeqJmpnNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case EQ: {
                return new Int64CachedScalarEqJmpnNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
            case NEQ: {
                return new Int64CachedScalarNeqJmpnNode(boolScalarCache, int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
            }
        }
        throw new VnanoFatalException("Unexpected comparison operation code: " + (Object)((Object)operationCode));
    }

    private AcceleratorExecutionNode generateFloat64CachedScalarComparisonJmpnNode(OperationCode operationCode, BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
        switch (operationCode) {
            case LT: {
                return new Float64CachedScalarLtJmpnNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case LEQ: {
                return new Float64CachedScalarLeqJmpnNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case GT: {
                return new Float64CachedScalarGtJmpnNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case GEQ: {
                return new Float64CachedScalarGeqJmpnNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case EQ: {
                return new Float64CachedScalarEqJmpnNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
            case NEQ: {
                return new Float64CachedScalarNeqJmpnNode(boolScalarCache, float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
            }
        }
        throw new VnanoFatalException("Unexpected comparison operation code: " + (Object)((Object)operationCode));
    }

    private final class CachedScalarUnconditionalJmpNode
    extends AcceleratorExecutionNode {
        private AcceleratorExecutionNode branchedNode;

        public CachedScalarUnconditionalJmpNode(AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.branchedNode = null;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            return this.branchedNode;
        }
    }

    private final class CachedScalarUnconditionalNeverJmpNode
    extends AcceleratorExecutionNode {
        private AcceleratorExecutionNode branchedNode;

        public CachedScalarUnconditionalNeverJmpNode(AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.branchedNode = null;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            return this.nextNode;
        }
    }

    private final class CachedScalarJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache conditionCache;
        private AcceleratorExecutionNode branchedNode;

        public CachedScalarJmpNode(BoolScalarCache boolScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.branchedNode = null;
            this.conditionCache = boolScalarCache;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            if (this.conditionCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class CachedScalarJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache conditionCache;
        private AcceleratorExecutionNode branchedNode;

        public CachedScalarJmpnNode(BoolScalarCache boolScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.branchedNode = null;
            this.conditionCache = boolScalarCache;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            if (this.conditionCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Int64CachedScalarLtJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarLtJmpNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data < this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarLeqJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarLeqJmpNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data <= this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarGtJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarGtJmpNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data > this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarGeqJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarGeqJmpNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data >= this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarEqJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarEqJmpNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data == this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarNeqJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarNeqJmpNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data != this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarLtJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarLtJmpNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data < this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarLeqJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarLeqJmpNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data <= this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarGtJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarGtJmpNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data > this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarGeqJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarGeqJmpNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data >= this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarEqJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarEqJmpNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data == this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarNeqJmpNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarNeqJmpNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data != this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.branchedNode;
            }
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarLtJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarLtJmpnNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data < this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Int64CachedScalarLeqJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarLeqJmpnNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data <= this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Int64CachedScalarGtJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarGtJmpnNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data > this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Int64CachedScalarGeqJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarGeqJmpnNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data >= this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Int64CachedScalarEqJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarEqJmpnNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data == this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Int64CachedScalarNeqJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Int64ScalarCache comparisonLeftCache;
        private final Int64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Int64CachedScalarNeqJmpnNode(BoolScalarCache boolScalarCache, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = int64ScalarCache;
            this.comparisonRightCache = int64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data != this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Float64CachedScalarLtJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarLtJmpnNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data < this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Float64CachedScalarLeqJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarLeqJmpnNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data <= this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Float64CachedScalarGtJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarGtJmpnNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data > this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Float64CachedScalarGeqJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarGeqJmpnNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data >= this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Float64CachedScalarEqJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarEqJmpnNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data == this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }

    private final class Float64CachedScalarNeqJmpnNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache comparisonDestCache;
        private final Float64ScalarCache comparisonLeftCache;
        private final Float64ScalarCache comparisonRightCache;
        private AcceleratorExecutionNode branchedNode;

        public Float64CachedScalarNeqJmpnNode(BoolScalarCache boolScalarCache, Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.branchedNode = null;
            this.comparisonDestCache = boolScalarCache;
            this.comparisonLeftCache = float64ScalarCache;
            this.comparisonRightCache = float64ScalarCache2;
        }

        @Override
        public void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.branchedNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.branchedNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.comparisonDestCache.data = this.comparisonLeftCache.data != this.comparisonRightCache.data;
            if (this.comparisonDestCache.data) {
                return this.nextNode;
            }
            return this.branchedNode;
        }
    }
}

