/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.BoolScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolCachedScalarTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        BoolCachedScalarMovNode boolCachedScalarMovNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case FILL: 
            case MOV: {
                boolCachedScalarMovNode = new BoolCachedScalarMovNode((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], acceleratorExecutionNode);
                break;
            }
            case CAST: {
                if (acceleratorInstruction.getDataTypes()[1] == DataType.BOOL) {
                    boolCachedScalarMovNode = new BoolCachedScalarMovNode((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException((Object)((Object)acceleratorInstruction.getDataTypes()[1]) + "-type operand of " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " instruction is invalid for " + this.getClass().getCanonicalName());
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return boolCachedScalarMovNode;
    }

    private class BoolCachedScalarMovNode
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache cache0;
        protected final BoolScalarCache cache1;

        public BoolCachedScalarMovNode(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = boolScalarCache;
            this.cache1 = boolScalarCache2;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data;
            return this.nextNode;
        }
    }
}

