/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Boolx2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Boolx3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.CacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolScalarLogicalUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<?>[] dataContainerArray2 = dataContainerArray;
        BoolScalarLogicalNode boolScalarLogicalNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ANDM: {
                Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer = new Boolx3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                boolScalarLogicalNode = new BoolScalarAndNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], boolx3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case ORM: {
                Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer = new Boolx3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                boolScalarLogicalNode = new BoolScalarOrNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], boolx3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case NOT: {
                Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer = new Boolx2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                boolScalarLogicalNode = new BoolScalarNotNode(dataContainerArray2[0], dataContainerArray2[1], boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return boolScalarLogicalNode;
    }

    private final class BoolScalarAndNode
    extends BoolScalarLogicalNode {
        public BoolScalarAndNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, DataContainer<boolean[]> dataContainer3, Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, boolx3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            ((boolean[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((boolean[])this.container1.getArrayData())[this.container1.getArrayOffset()] && ((boolean[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class BoolScalarOrNode
    extends BoolScalarLogicalNode {
        public BoolScalarOrNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, DataContainer<boolean[]> dataContainer3, Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, boolx3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            ((boolean[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((boolean[])this.container1.getArrayData())[this.container1.getArrayOffset()] || ((boolean[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class BoolScalarNotNode
    extends BoolScalarLogicalNode {
        public BoolScalarNotNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            ((boolean[])this.container0.getArrayData())[this.container0.getArrayOffset()] = !((boolean[])this.container1.getArrayData())[this.container1.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private abstract class BoolScalarLogicalNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<boolean[]> container1;
        protected final DataContainer<boolean[]> container2;
        protected final CacheSynchronizer synchronizer;

        public BoolScalarLogicalNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, DataContainer<boolean[]> dataContainer3, Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = dataContainer3;
            this.synchronizer = boolx3ScalarCacheSynchronizer;
        }

        public BoolScalarLogicalNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = null;
            this.synchronizer = boolx2ScalarCacheSynchronizer;
        }
    }
}

