/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Boolx2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolScalarTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        BoolScalarMovNode boolScalarMovNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: 
            case FILL: {
                Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer = new Boolx2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                boolScalarMovNode = new BoolScalarMovNode(dataContainerArray[0], dataContainerArray[1], boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case CAST: {
                if (acceleratorInstruction.getDataTypes()[1] == DataType.BOOL) {
                    Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer = new Boolx2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                    boolScalarMovNode = new BoolScalarMovNode(dataContainerArray[0], dataContainerArray[1], boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException((Object)((Object)acceleratorInstruction.getDataTypes()[1]) + "-type operand of " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " instruction is invalid for " + this.getClass().getCanonicalName());
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return boolScalarMovNode;
    }

    private final class BoolScalarMovNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<boolean[]> container1;
        protected final Boolx2ScalarCacheSynchronizer synchronizer;

        public BoolScalarMovNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = boolx2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            this.container0.getArrayData()[this.container0.getArrayOffset()] = this.container1.getArrayData()[this.container1.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

