/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Boolx2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Boolx3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.CacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolVectorLogicalUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<?>[] dataContainerArray2 = dataContainerArray;
        BoolVectorLogicalNode boolVectorLogicalNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ANDM: {
                Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer = new Boolx3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                boolVectorLogicalNode = new BoolVectorAndNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], boolx3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case ORM: {
                Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer = new Boolx3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                boolVectorLogicalNode = new BoolVectorOrNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], boolx3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case NOT: {
                Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer = new Boolx2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                boolVectorLogicalNode = new BoolVectorNotNode(dataContainerArray2[0], dataContainerArray2[1], boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return boolVectorLogicalNode;
    }

    private final class BoolVectorAndNode
    extends BoolVectorLogicalNode {
        public BoolVectorAndNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, DataContainer<boolean[]> dataContainer3, Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, boolx3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            boolean[] blArray2 = (boolean[])this.container1.getArrayData();
            boolean[] blArray3 = (boolean[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            if (blArray3 == null) {
                for (int i = 0; i < n; ++i) {
                    blArray[i] = false;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    blArray[i] = blArray2[i] & blArray3[i];
                }
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class BoolVectorOrNode
    extends BoolVectorLogicalNode {
        public BoolVectorOrNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, DataContainer<boolean[]> dataContainer3, Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, boolx3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            boolean[] blArray2 = (boolean[])this.container1.getArrayData();
            boolean[] blArray3 = (boolean[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            if (blArray3 == null) {
                for (int i = 0; i < n; ++i) {
                    blArray[i] = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    blArray[i] = blArray2[i] | blArray3[i];
                }
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class BoolVectorNotNode
    extends BoolVectorLogicalNode {
        public BoolVectorNotNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            boolean[] blArray2 = (boolean[])this.container1.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = !blArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private abstract class BoolVectorLogicalNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<boolean[]> container1;
        protected final DataContainer<boolean[]> container2;
        protected final CacheSynchronizer synchronizer;

        public BoolVectorLogicalNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, DataContainer<boolean[]> dataContainer3, Boolx3ScalarCacheSynchronizer boolx3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = dataContainer3;
            this.synchronizer = boolx3ScalarCacheSynchronizer;
        }

        public BoolVectorLogicalNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = null;
            this.synchronizer = boolx2ScalarCacheSynchronizer;
        }
    }
}

