/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.CacheSynchronizer;
import org.vcssl.nano.vm.accelerator.GeneralScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;
import org.vcssl.nano.vm.processor.Processor;

public class BypassUnit
extends AcceleratorExecutionUnit {
    Processor processor = null;
    Memory memory = null;
    Interconnect interconnect = null;

    public BypassUnit(Processor processor, Memory memory, Interconnect interconnect) {
        this.processor = processor;
        this.memory = memory;
        this.interconnect = interconnect;
    }

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        int n = dataContainerArray.length;
        OperationCode operationCode = acceleratorInstruction.getOperationCode();
        switch (operationCode) {
            case ALLOC: 
            case ALLOCR: {
                boolean[] blArray4 = new boolean[n];
                System.arraycopy(blArray, 0, blArray4, 0, n);
                blArray4[0] = false;
                GeneralScalarCacheSynchronizer generalScalarCacheSynchronizer = new GeneralScalarCacheSynchronizer(dataContainerArray, objectArray, blArray4);
                GeneralScalarCacheSynchronizer generalScalarCacheSynchronizer2 = new GeneralScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                return new ProcessorCallNode(acceleratorInstruction, this.memory, this.interconnect, this.processor, generalScalarCacheSynchronizer, generalScalarCacheSynchronizer2, acceleratorExecutionNode);
            }
        }
        GeneralScalarCacheSynchronizer generalScalarCacheSynchronizer = new GeneralScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        return new ProcessorCallNode(acceleratorInstruction, this.memory, this.interconnect, this.processor, generalScalarCacheSynchronizer, generalScalarCacheSynchronizer, acceleratorExecutionNode);
    }

    private final class ProcessorCallNode
    extends AcceleratorExecutionNode {
        private final Instruction instruction;
        private final Interconnect interconnect;
        private final Processor processor;
        private final Memory memory;
        private final CacheSynchronizer preSynchronizer;
        private final CacheSynchronizer postSynchronizer;

        public ProcessorCallNode(Instruction instruction, Memory memory, Interconnect interconnect, Processor processor, CacheSynchronizer cacheSynchronizer, CacheSynchronizer cacheSynchronizer2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.instruction = instruction;
            this.interconnect = interconnect;
            this.processor = processor;
            this.memory = memory;
            this.preSynchronizer = cacheSynchronizer;
            this.postSynchronizer = cacheSynchronizer2;
        }

        @Override
        public final AcceleratorExecutionNode execute() throws VnanoException {
            try {
                this.preSynchronizer.synchronizeFromCacheToMemory();
                int n = 0;
                this.processor.process(this.instruction, this.memory, this.interconnect, n);
                this.postSynchronizer.synchronizeFromMemoryToCache();
                return this.nextNode;
            }
            catch (VnanoException vnanoException) {
                throw vnanoException;
            }
            catch (Exception exception) {
                throw new VnanoFatalException(exception);
            }
        }
    }
}

