/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64CachedScalarArithmeticUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        int n = objectArray.length;
        Float64ScalarCache[] float64ScalarCacheArray = new Float64ScalarCache[n];
        for (int i = 0; i < n; ++i) {
            float64ScalarCacheArray[i] = (Float64ScalarCache)objectArray[i];
        }
        Float64CachedScalarArithmeticNode float64CachedScalarArithmeticNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ADD: {
                float64CachedScalarArithmeticNode = new Float64CachedScalarAddNode(float64ScalarCacheArray[0], float64ScalarCacheArray[1], float64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case SUB: {
                float64CachedScalarArithmeticNode = new Float64CachedScalarSubNode(float64ScalarCacheArray[0], float64ScalarCacheArray[1], float64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case MUL: {
                float64CachedScalarArithmeticNode = new Float64CachedScalarMulNode(float64ScalarCacheArray[0], float64ScalarCacheArray[1], float64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case DIV: {
                float64CachedScalarArithmeticNode = new Float64CachedScalarDivNode(float64ScalarCacheArray[0], float64ScalarCacheArray[1], float64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case REM: {
                float64CachedScalarArithmeticNode = new Float64CachedScalarRemNode(float64ScalarCacheArray[0], float64ScalarCacheArray[1], float64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case NEG: {
                float64CachedScalarArithmeticNode = new Float64CachedScalarNegNode(float64ScalarCacheArray[0], float64ScalarCacheArray[1], acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return float64CachedScalarArithmeticNode;
    }

    private final class Float64CachedScalarAddNode
    extends Float64CachedScalarArithmeticNode {
        public Float64CachedScalarAddNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCache, float64ScalarCache2, float64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data + this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubNode
    extends Float64CachedScalarArithmeticNode {
        public Float64CachedScalarSubNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCache, float64ScalarCache2, float64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data - this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulNode
    extends Float64CachedScalarArithmeticNode {
        public Float64CachedScalarMulNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCache, float64ScalarCache2, float64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data * this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivNode
    extends Float64CachedScalarArithmeticNode {
        public Float64CachedScalarDivNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCache, float64ScalarCache2, float64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data / this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemNode
    extends Float64CachedScalarArithmeticNode {
        public Float64CachedScalarRemNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCache, float64ScalarCache2, float64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data % this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarNegNode
    extends Float64CachedScalarArithmeticNode {
        public Float64CachedScalarNegNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCache, float64ScalarCache2, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = -this.cache1.data;
            return this.nextNode;
        }
    }

    private abstract class Float64CachedScalarArithmeticNode
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache cache0;
        protected final Float64ScalarCache cache1;
        protected final Float64ScalarCache cache2;

        public Float64CachedScalarArithmeticNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = float64ScalarCache;
            this.cache1 = float64ScalarCache2;
            this.cache2 = float64ScalarCache3;
        }

        public Float64CachedScalarArithmeticNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = float64ScalarCache;
            this.cache1 = float64ScalarCache2;
            this.cache2 = null;
        }
    }
}

